

#include "image.h"
#include "pstring.h"

#include "pixcon.h"


#define RENDERFLAG_PSOLID  0
#define RENDERFLAG_PTRANS  1
#define RENDERFLAG_PSHADOW 2
#define RENDERFLAG_SOLID   3
#define RENDERFLAG_TRANS   4
#define RENDERFLAG_SPOT    5
#define RENDERFLAG_SHADOW  6


/* *************************************************************
************************************************************* */
void rengine::render_list(pc *ptr, light *lctr, pc **shadptr, int transflag) {

   pc *qtr;

   switch (transflag) {
   
      // scan/render objects
      case RENDERFLAG_PSOLID:
      
         while (ptr) {
            ptr->begin_scan();
            ptr->datacopy();
            ptr->scan(frame.camdtr, frame.lightdtr, this);

            if (ptr->shadptr) {           // build shadow list
               for (qtr=ptr->shadptr; qtr->next; qtr=(pc *)qtr->next);
               qtr->next = *shadptr;
               *shadptr = ptr->shadptr;
            }

            if (ptr->renderflag)
               ptr->prender(this);

            ptr->end_scan();

            qtr = ptr;
            ptr = (pc *)ptr->next;
            delete qtr;
         }

         return;
    
      // scan/render transparent objects
      case RENDERFLAG_PTRANS:

         while (ptr) {
            ptr->begin_scan();
            ptr->datacopy();

            if (ptr->scan(frame.camdtr, frame.lightdtr, this))
               ptr->prender(this);

            ptr->end_scan();

            qtr = ptr;
            ptr = (pc *)ptr->next;
            delete qtr;
         }
   
         return;

      // scan/render shadow list
      case RENDERFLAG_PSHADOW:

         while (ptr) {
            if (ptr->scan(frame.camdtr, frame.lightdtr, this))
               ptr->prender(this);

            ptr->end_scan();
            qtr = ptr;
            ptr = (pc *)ptr->next;
            delete qtr;
         }
	 
	 return;
	 
      case RENDERFLAG_SPOT:

         while (ptr) {
            ptr->begin_scan();
            ptr->datacopy();

            if (ptr->beamscan((spotlight *)lctr, this))
               ptr->beamrender((spotlight *)lctr, this);

            ptr->end_scan();
            ptr = (pc *)ptr->next;
         }

         return;   

      // render "solids"
      case RENDERFLAG_SOLID:

         while (ptr) {
            ptr->begin_scan();
            ptr->datacopy();

            ptr->scan(frame.camdtr, frame.lightdtr, this);

            if (ptr->shadptr) {
               for (qtr=ptr->shadptr; qtr->next; qtr=(pc *)qtr->next);
               qtr->next = *shadptr;
               *shadptr = ptr->shadptr;
            }

            if (ptr->renderflag)
               ptr->render(frame.camdtr, frame.lightdtr, frame.beamdtr, this);

            ptr->end_scan();

            qtr = ptr;
            ptr = (pc *)ptr->next;
            delete qtr;
         }

         return;   

      // render "transparents"
      case RENDERFLAG_TRANS:
      
         while (ptr) {
            ptr->begin_scan();
            ptr->datacopy();

            if (ptr->scan(frame.camdtr, frame.lightdtr, this))
               ptr->render(frame.camdtr, frame.lightdtr, frame.beamdtr, this);

            ptr->end_scan();

            qtr = ptr;
            ptr = (pc *)ptr->next;
            delete qtr;
         }
	 
         return;

      // scan/render shadow list
      case RENDERFLAG_SHADOW:
      	 
         while (ptr) {
            if (ptr->scan(frame.camdtr, frame.lightdtr, this))
               ptr->render(frame.camdtr, (light *)NULL, (light *)NULL, this);

            ptr->end_scan();

            qtr = ptr;
            ptr = (pc *)ptr->next;
            delete qtr;
         }

         return;

      default:
         return;
   }

}


/* *************************************************************
************************************************************* */
void rengine::penciltest() {

   pc *ptr, *qtr;
   light *lctr;
   camera *ctr;
   pc *shadptr = (pc *)NULL;
   int i;
   
   frame.camdtr->calc_clip_plane();

   for (i=0; i<MAXGROUND; i++) {
      // sort and cull objects
      cull(frame.camdtr, frame.solidtr[i], &ptr, &frame.solidtr[i]);

      while (frame.solidtr[i] && frame.solidtr[i] != ptr) {
         qtr = frame.solidtr[i];
         frame.solidtr[i] = (pc *)frame.solidtr[i]->next;
         delete qtr;
      }

      frame.solidtr[i] = NULL;
      render_list(ptr, NULL, &shadptr, RENDERFLAG_PSOLID);

      // sort and cull inviso objects
      cull(frame.camdtr, frame.invisotr[i], &ptr, &frame.invisotr[i]);

      while (frame.invisotr[i] && frame.invisotr[i] != ptr) {
         qtr = frame.invisotr[i];
         frame.invisotr[i] = (pc *)frame.invisotr[i]->next;
         delete qtr;
      }

      frame.invisotr[i] = NULL;
      render_list(ptr, NULL, &shadptr, RENDERFLAG_PSOLID);
      
      // cull transparent objects
      cull(frame.camdtr, frame.transtr[i], &ptr, &frame.transtr[i]);

      while (frame.transtr[i] != ptr) {
         qtr = frame.transtr[i];
         frame.transtr[i]=(pc *)frame.transtr[i]->next;
         delete qtr;
      }

      frame.transtr[i] = NULL;
      render_list(ptr, NULL, NULL, RENDERFLAG_PTRANS);

      // scan/render shadow list - no cull cause dont have bound spheres
      render_list(shadptr, NULL, NULL, RENDERFLAG_PSHADOW);
      shadptr = NULL;
   }

   for (; frame.camdtr; ctr=frame.camdtr, frame.camdtr=(camera *)frame.camdtr->next, delete ctr);
   for (; frame.lightdtr; lctr=frame.lightdtr, frame.lightdtr=(light *)frame.lightdtr->next, delete lctr);
   for (; frame.beamdtr; lctr=frame.beamdtr, frame.beamdtr=(light *)frame.beamdtr->next, delete lctr);
}


/* *************************************************************
************************************************************* */
void rengine::colorize(int frame_id, mapul *mapbuffer) {

   light  *lctr;
   camera *ctr;
   pc     *ptr, *qtr;
   pc     *shadptr = (pc *)NULL;
   int    i;
   bmp    bmp_coder;
   rgb    rgb_coder;
   char buffer[MAXSTRLEN];
   
   zbuff.initbuff(mapbuffer->data, mapbuffer->pdata, adata.data, zdata.data, mapbuffer->maxx, mapbuffer->maxy, back);

   // render shadow maps
   for (lctr=frame.beamdtr; lctr!=(light *)NULL; lctr=(light *)lctr->next) {

      ((spotlight *)lctr)->lbuff = (lightbufftype *)control->pop(MM_LIGHTBUFF);
      ((spotlight *)lctr)->init_buff(control);

      lctr->calc_clip_plane();

      for (i=0; i<MAXGROUND; i++) {
         cullnsort(lctr, frame.solidtr[i], &ptr, &frame.solidtr[i]);
         render_list(ptr, lctr, NULL, RENDERFLAG_SPOT);

         cullnsort(lctr, frame.invisotr[i], &ptr, &frame.invisotr[i]);
         render_list(ptr, lctr, NULL, RENDERFLAG_SPOT);
      }

      lctr->xform(frame.camdtr);
   }

   frame.camdtr->calc_clip_plane();

   for (i=0; i<MAXGROUND; i++) {

      // sort and cull objects
      cullnsort(frame.camdtr, frame.solidtr[i], &ptr, &frame.solidtr[i]);

      while (frame.solidtr[i] != ptr) {
         qtr = frame.solidtr[i];
         frame.solidtr[i] = (pc *)frame.solidtr[i]->next;
         delete qtr;
      }
      
      frame.solidtr[i] = NULL;
      render_list(ptr, NULL, &shadptr, RENDERFLAG_SOLID);

      // sort and cull objects
      cullnsort(frame.camdtr, frame.invisotr[i], &ptr, &frame.invisotr[i]);

      while (frame.invisotr[i] != ptr) {
         qtr = frame.invisotr[i];
         frame.invisotr[i] = (pc *)frame.invisotr[i]->next;
         delete qtr;
      }
      
      frame.invisotr[i] = NULL;
      render_list(ptr, NULL, &shadptr, RENDERFLAG_SOLID);

      // cull transparent objects
      cull(frame.camdtr, frame.transtr[i], &ptr, &frame.transtr[i]);

      while (frame.transtr[i] != ptr) {
         qtr = frame.transtr[i];
         frame.transtr[i]=(pc *)frame.transtr[i]->next;
         delete qtr;
      }

      frame.transtr[i] = NULL;
      render_list(ptr, NULL, NULL, RENDERFLAG_TRANS);

      render_list(shadptr, NULL, NULL, RENDERFLAG_SHADOW);
      shadptr = NULL;
   }

   switch (ANTIALIAS) {
      case 1:
         zbuff.antialias(SANTIALIAS.string);
         break;

      case 2:
         zbuff.antialias_edge(SANTIALIAS.string);
         break;

      default: // 0
         break;
   }

   if (GAMMA)
      zbuff.gammabuff(PGAMMA);

   switch (RGBFILE) {
      case IMAGE_RGB:
         sprintf(buffer, "%s%04d.rgb", SRGBFILE.string, frame_id);
         zbuff.save_image(buffer, &rgb_coder);
         break;

      case IMAGE_BMP:
         sprintf(buffer, "%s%04d.bmp", SRGBFILE.string, frame_id);
         zbuff.save_image(buffer, &bmp_coder);
         break;

      default:
         break;
   }
   
   for (; frame.camdtr; ctr=frame.camdtr, frame.camdtr=(camera *)frame.camdtr->next, delete ctr);
   for (; frame.lightdtr; lctr=frame.lightdtr, frame.lightdtr=(light *)frame.lightdtr->next, delete lctr);

   for (; frame.beamdtr; lctr=frame.beamdtr, frame.beamdtr=(light *)frame.beamdtr->next, delete lctr) {
      control->push(MM_LIGHTBUFF, ((spotlight *)frame.beamdtr)->lbuff);
      ((spotlight *)frame.beamdtr)->lbuff = (lightbufftype *)NULL;
   }

   zbuff.pdata = NULL;
   zbuff.data = NULL;
   zbuff.adata = NULL;
   zbuff.zdata = NULL;
}


/* *************************************************************
************************************************************* */
void rengine::spawn(int frame_id, mapul *mapbuffer) {

   light *lctr;

   if (!frame.camdtr) {
      frame.camdtr = new camera();
      frame.camdtr->set_dim(mapbuffer->maxx, mapbuffer->maxy);
      frame.camdtr->preprocess(NULL);
   }

   if (!frame.lightdtr && !frame.beamdtr) {
      frame.lightdtr = new far_light;
      frame.lightdtr->preprocess(NULL);
   }

   for (lctr=frame.lightdtr; lctr; lctr=(light *)lctr->next)
      lctr->xform(frame.camdtr);

   if (PENCILTEST)
      penciltest();
   else
      colorize(frame_id, mapbuffer);
}

