

#include <stdlib.h>
#include <time.h>

#include "pixcon.h"


#ifdef WIN32

#include "WIN_WOGL.h"

#define WINDOW_TYPE WOGLwindow

#else

#include "WIN_XOGL.h"

#ifdef __FreeBSD__
#include <floatingpoint.h>
#endif

#define WINDOW_TYPE XOGLwindow

#endif


int RGBFILE = IMAGE_NULL;
string_type SRGBFILE;

int winx = 640;
int winy = 480;


/* **************************************************
************************************************** */
void init_graph() {

   init_noise();
   init_lut();              // init math lookup tables
}


/* **************************************************
   main: program controller
************************************************** */
int main (int argc, char *argv[]) {

   rengine proc;
   int i;
   int mapcount;               // # of pixmaps
   int flagscreengl;
   clock_t oldtime, newtime;
   frameclass *ptr, *qtr;
   frame_data *frame;
   WINDOW_TYPE   win;

   int attribs[] = {
      OGLFLAG_BPP, 16,
      OGLFLAG_DOUBLEBUFFER,
      OGLFLAG_DEPTH_SIZE, 1,
      OGLFLAG_RGBA,
      OGLFLAG_MAPBUFFER,
      OGLFLAG_NULL
   };

#ifdef __FreeBSD__
   fpsetmask(0);
#endif

   printf("Preprocessing...\n");

   init_graph();

   parseinput(argc, argv);                      // parse command line

   flagscreengl = (!(NOSCREEN || PENCILTEST));

   printf("Parsing script file...\n");

   if (!DEFLST)
      SDEFLST.stringcpy("object.list");

   if (!parse_list(SDEFLST.string, &mapcount))
      exit(0);

   if (!NOSCREEN) {
      if (!win.VIRTUALreset(argc, argv, winx, winy, "Pixcon", attribs))
         exit(0);
   }

   else
      win.mapbuffer.init_map(winx, winy);

   if (PENCILTEST)
      proc.wireframe.build(mapcount);
   else {
      proc.adata.init_map(winx, winy);
      proc.adata.zero();

      proc.zdata.init_map(winx, winy);
      proc.zdata.zero();
   }

   if (!SILENT)
      printf("Start Rendering...\n");

   oldtime = clock();

   frame = (frame_data *)global_resource_manager->get_resource_object(RESOURCE_FRAME_OBJECT);
   
   for (i=0; i<mapcount; i++) {
      proc.engine_init();

      if (frame[i].camdtr) {
         for (ptr=frame[i].camdtr->next; ptr; qtr = ptr, ptr=ptr->next, delete qtr);
         frame[i].camdtr->set_dim(winx, winy);
         proc.engine_submit(frame[i].camdtr);
      }

      if (frame[i].lightdtr) {
         for (ptr=frame[i].lightdtr->next; ptr; qtr = ptr, ptr=ptr->next, delete qtr);
         proc.engine_submit(frame[i].lightdtr);
      }

      ptr = frame[i].beamdtr;
      while (ptr) {
         qtr = ptr;
         ptr = ptr->next;
         proc.engine_submit(qtr);
      }

      ptr = frame[i].solidtr[0];
      while (ptr) {
         qtr = ptr;
         ptr = ptr->next;
         proc.engine_submit(qtr);
      }

      proc.spawn(i, &win.mapbuffer);

      if (mapcount > 1)
         if (PENCILTEST)
            win.BLTbitmap(i, &proc.wireframe);
         else if (flagscreengl)
            win.BLTbitmap(&win.mapbuffer);

      if (!SILENT)
         printf("FINISHED %d :)\n", i);
   }

   newtime = clock();

   if (!SILENT) {
      printf("######  ####### #     # #######\n");
      printf("#     # #     # ##    # #\n");
      printf("#     # #     # # #   # #\n");
      printf("#     # #     # #  #  # #####\n");
      printf("#     # #     # #   # # #\n");
      printf("#     # #     # #    ## #\n");
      printf("######  ####### #     # #######\n");
   }

   printf("Average rendering time = %f\n", (newtime - oldtime)/(float)(mapcount*CLOCKS_PER_SEC));
   printf("Have a nice day :)\n");

   if (mapcount == 1)
       if (PENCILTEST)
         win.BLTbitblt(0, &proc.wireframe);
      else if (flagscreengl)
         win.BLTbitblt(&win.mapbuffer);

   if (!NOSCREEN)
      win.VIRTUALcancel();         // independent of OGL/X

#ifdef __FreeBSD__
   fpresetsticky(FP_X_INV|FP_X_OFL|FP_X_UFL|FP_X_DZ|FP_X_IMP|FP_X_DNML);
#endif

   return 1;
}

