

#if !defined __PIXCON_H
#define __PIXCON_H

#define IMAGE_NULL  0
#define IMAGE_RGB   1
#define IMAGE_BMP   2

#include "base.h"


/* *************************************************************
************************************************************* */
class render_manager : public frame_manager {

   protected:
      // render_manager
      frame_data *frame;    // ptr to frame data

   public:
      // resource_manager
      void init(int x);

      void register_resource_object(int type, void *data);
      void *get_resource_object(int type);

      // render_manager
      render_manager();
      virtual ~render_manager();
};


/* *************************************************************
************************************************************* */
class rengine : public engine {

   protected:
      void render_list(pc *ptr, light *lctr, pc **shadptr, int transflag);
      void penciltest();
      void colorize(int frame_id, mapul *mapbuffer);

   public:
      rengine() { control = new memman(MAXLISTS, MAXBUFFERS); }
      void spawn(int frame_id, mapul *mapbuffer);
};


// init.c

void parseinput(int argc, char *argv[]);
int  parse_list(char *filename, int *mapcount);

extern int RGBFILE;
extern string_type SRGBFILE;

extern int winx, winy;

#endif

