

#include <stdlib.h>
#include <time.h>


#ifdef WIN32
#include "WIN_WOGL.h"
#include <GL/gl.h>

#define WINDOWTYPE WOGLwindow
#else
#include "WIN_XOGL.h"

#define WINDOWTYPE XOGLwindow
#endif

#include "datatype.h"
#include "global.h"

void init_coder();


/* **************************************************
   main: program controller
************************************************** */
int main (int argc, char *argv[]) {

   mapul tob;
   int WINX, WINY;
   int i, j;
   unsigned int currtime, newtime;
   float fps;
   dbl_llist_manager *images;
   image_coder *ptr;
   WINDOWTYPE  gwindow;
   int *maxx, *maxy;
   sfile sinfile;

#ifdef WIN32
   MSG message;
#else
   XEvent mevent;
#endif

   if (argc < 3) {
      printf("usage: mflip sec/frame frame1 frame2 ...\n");
      exit(0);
   }

   j = argc-2;
   fps = (float)(atof(argv[1]) * CLOCKS_PER_SEC);

   if (j<=0)
      exit(0);

   init_coder();
   ((frame_manager *)global_resource_manager)->set_palette_support(0);

   images = (dbl_llist_manager *)global_resource_manager->get_resource_object(RESOURCE_IMAGE_LOADER);

   if (!images->head)
      exit(0);

   maxx = new int[j];
   maxy = new int[j];

   WINX = WINY = 0;

   for (i=0; i<j; i++) {
      maxx[i] = maxy[i] = 0;
      if (!sinfile.scan_data(argv[i+2], TEXTURE_PATH.string, PLATFORM_SLASH))
         continue;

      ptr = (image_coder *)((image_coder *)images->head)->find_loader(&sinfile);

      if (!ptr)
         continue;

      if (ptr->skim_data(&maxx[i], &maxy[i], CBYTE_ORDER_RGBA)) {
         if (WINX < maxx[i])
            WINX = maxx[i];

         if (WINY < maxy[i])
            WINY = maxy[i];
      }

      ptr->cleanup();
   }

   for (i=0; i<j; i++) {
      if (WINX > maxx[i])
         maxx[i] = (WINX-maxx[i])>>1;
      else
         maxx[i] = 0;

      if (WINY > maxy[i])
         maxy[i] = (WINY-maxy[i])>>1;
      else
         maxy[i] = 0;
   }

   if (!gwindow.VIRTUALreset(argc, argv, WINX, WINY, "Movie Viewer", NULL)) {
      delete [] maxx;
      delete [] maxy;
      return 0;
   }

   i=0;
   while(i > -1) {
      if (sinfile.scan_data(argv[i+2], TEXTURE_PATH.string, PLATFORM_SLASH)) {
         ptr = (image_coder *)((image_coder *)images->head)->find_loader(&sinfile);

         if (ptr)
            ptr->scan_data(&tob, CBYTE_ORDER_RGBA);
      }

      currtime = clock();

      glRasterPos2i(maxx[i], maxy[i]);
      glClear(GL_COLOR_BUFFER_BIT);
      gwindow.BLTbitmap(&tob);

      i++;

      if (i==j)
         i=0;

      do {

#ifdef WIN32
         if (PeekMessage(&message, NULL, 0, 0, PM_REMOVE))
            switch (message.message) {
               case WM_KEYUP:
               case WM_LBUTTONUP:
               case WM_RBUTTONUP:
               case WM_MBUTTONUP:
               case WM_DESTROY:
               case WM_QUIT:
                  i = -1;
                  break;

               default:
                  DispatchMessage(&message);
            }

#else
         XCheckMaskEvent (gwindow.mdisplay, KeyPressMask | ButtonPressMask, &mevent);
         if (mevent.type == KeyPress || mevent.type == ButtonPress) {
            i = -1;
            break;
         }

#endif

      } while((newtime = clock()) >= currtime && newtime-currtime < fps);

   }

   gwindow.VIRTUALcancel();
   delete [] maxx;
   delete [] maxy;
   return 1;
}

