

#include "image.h"
#include "global.h"

#include "polyops.h"
#include "gamegine.h"

#ifdef WIN32
#include <io.h>
#endif

int aggressive_flag = 1;
int spike_flag = 1;
int optimize_flag = 1;


/* ********************************************************************
******************************************************************** */
int main(int argc, char **argv) {

   SPXobject spxobject;
   string_type buffer;
   int i, j;
   
#ifdef WIN32
   struct _finddata_t fptr;
   long handle;
#endif

  if (argc < 2)
      return 0;

   DYNAMIC_LOADER = 1;
   
   init_lut();
   global_resource_manager = new game_manager;

   logfile = fopen("logfile", "w");

   global_resource_manager->register_resource_object(RESOURCE_IMAGE_LOADER, new tiff);
   global_resource_manager->register_resource_object(RESOURCE_IMAGE_LOADER, new ppm);
   global_resource_manager->register_resource_object(RESOURCE_IMAGE_LOADER, new ilbm);
   global_resource_manager->register_resource_object(RESOURCE_IMAGE_LOADER, new bmp);
   global_resource_manager->register_resource_object(RESOURCE_IMAGE_LOADER, new jpeg);
   global_resource_manager->register_resource_object(RESOURCE_IMAGE_LOADER, new gif);
   global_resource_manager->register_resource_object(RESOURCE_IMAGE_LOADER, new rgb);
   global_resource_manager->register_resource_object(RESOURCE_IMAGE_LOADER, new rtf);
   ((frame_manager *)global_resource_manager)->set_palette_support(0);

#ifdef WIN32

   int k;

   for (k=1; k<argc; k++) {
      for (i = handle = _findfirst(argv[k], &fptr); i != -1; i = _findnext(handle, &fptr)) {
         buffer.stringcpy(fptr.name);

#else
   for (i=1; i<argc; i++) {
      buffer.stringcpy(argv[i]);
      {
#endif

         printf("Processing \"%s\"...\n", buffer.string);

         for (j=buffer.stringlen()-1; j > -1; j--)
            if (buffer.string[j] == '.') {
               buffer.string[j] = 0;
               buffer.recalc();
               break;
            }
    
         if (read_spb(buffer.string, &spxobject)) {
            printf("\tBefore: vertex count = %d face count = %d\n", spxobject.optimize->vertexcount, spxobject.optimize->final_face_data.count);
            spxobject.optimize->optimize_geometry(spxobject.shade, aggressive_flag, spike_flag, optimize_flag);
            printf("\tAfter:  vertex count = %d face count = %d\n", spxobject.optimize->vertexcount, spxobject.optimize->final_face_data.count);
            write_spb(buffer.string, &spxobject);
            printf("Processed \"%s\"\n", buffer.string);
            continue;
         }
   
         if (!read_spg(buffer.string, &spxobject)) {
            printf("Cannot process \"%s\"...\n", buffer.string);
            continue;
         }
      
         printf("\tBefore: vertex count = %d face count = %d\n", spxobject.optimize->vertexcount, spxobject.optimize->final_face_data.count);
         spxobject.optimize->optimize_geometry(spxobject.shade, aggressive_flag, spike_flag, optimize_flag);
         printf("\tAfter:  vertex count = %d face count = %d\n", spxobject.optimize->vertexcount, spxobject.optimize->final_face_data.count);
         write_spg(buffer.string, &spxobject);
         printf("Processed \"%s\"\n", buffer.string);
      }

#ifdef WIN32
      if (handle != -1)
         _findclose( handle );
#endif

   }

   fclose(logfile);
   return 1;
}
