

#include <stdlib.h>

#include "texture.h"
#include "image.h"
#include "imgman.h"


void init_coder();


/* **************************************************
************************************************** */
texture *read_tex(char *filename) {

   texture *tob;
   
   tob = (texture *)((frame_manager *)global_resource_manager)->read_tex(filename);

   if (!tob) {
      printf("Bad image %s... Aborting\n", filename);
      exit(0);
   }
   
   return tob;
}


/* **************************************************
************************************************** */
int main (int argc, char *argv[]) {

   texture *source;
   texture *palette;
   mapul tex_result;
   rtf rtf_coder;

   if (argc < 4) {
      printf("usage: iswap <palette imagename> <target imagename> <out imagename>\n");
      exit(0);
   }

   init_lut();
   init_coder();
   ((frame_manager *)global_resource_manager)->set_palette_support(0);

   printf("Processing image \"%s\"...\n", argv[1]);
   source = read_tex(argv[1]);     

   printf("Processing palette \"%s\"...\n", argv[2]);
   palette = read_tex(argv[2]);     

   imgman_swap_palettes(&((texture_block *)source->query_data())->tob, &((texture_block *)palette->query_data())->tob, &tex_result, ((frame_manager *)global_resource_manager)->query_color_byte_order());
   
   printf("Transfering to \"%s\"...\n", argv[3]);
   if (!rtf_coder.write_data(argv[3], &tex_result, CBYTE_ORDER_RGBA))
      printf("Error: cannot create %s...\n", argv[3]);

   return 1;
}
