

#include <stdlib.h>
#include <string.h>

#include "texture.h"
#include "image.h"


#define ORDER_ROW    0
#define ORDER_COLUMN 1


/* *************************************************************
************************************************************* */
class mapnode : public dbl_llist {

   public:
      mapul tob;
      
      virtual ~mapnode() {}
};
      

/* *************************************************************
************************************************************* */
class texnode : public dbl_llist {

   protected:
      mapnode *create_slice(mapul *tob, int start, int end, int slice_order);

   public:
      texture *tob;
      int count;
      
      virtual ~texnode() {}

      void slice(int slice_order, dbl_llist_manager *outman);
};
      

void init_coder();


int slice_order = ORDER_ROW;
dbl_llist_manager texman;
dbl_llist_manager outman;


/* *************************************************************
************************************************************* */
mapnode *texnode::create_slice(mapul *tob, int start, int end, int slice_order) {

   mapnode *ptr = new mapnode;
   int i, j;
   
   if (slice_order == ORDER_ROW) {
      ptr->tob.init_map(tob->maxx, end-start);

      for (i=0; i < end-start; i++)
         for (j=0; j<(int)tob->maxx; j++)
            ptr->tob.pdata[i][j] = tob->pdata[i+start][j];
   }
   
   else {
      ptr->tob.init_map(end-start, tob->maxy);

      for (i=0; i < (int)tob->maxy; i++)
         for (j=0; j<end-start; j++)
            ptr->tob.pdata[i][j] = tob->pdata[i][j+start];
   }

   return ptr;
}


/* *************************************************************
************************************************************* */
void texnode::slice(int slice_order, dbl_llist_manager *outman) {

   mapnode *ptr, *qtr;
   int i, j;
   texture_block *tblock;

   tblock = (texture_block *)tob->query_data();
   
   if (slice_order == ORDER_ROW)
      for (i=0; i<tob->maxy; i+=count) {
         ptr = create_slice(&tblock->tob, i, i+count <= tob->maxy ? i+count : tob->maxy, slice_order);
   
         if (!outman->head)
            outman->append(ptr, NULL);
         else {
            j = rand() % (outman->count+1);

            if (j == outman->count)
               outman->append(ptr, NULL);
            else {
               for (qtr = (mapnode *)outman->head; qtr && j; qtr = (mapnode *)qtr->next, j--);
               outman->insert(ptr, qtr);
            }

         }

      }

   else
      for (i=0; i<tob->maxx; i+=count) {
         ptr = create_slice(&tblock->tob, i, i+count <= tob->maxx ? i+count : tob->maxx, slice_order);
   
         if (!outman->head)
            outman->append(ptr, NULL);
         else {
            j = rand() % (outman->count+1);

            if (j == outman->count)
               outman->append(ptr, NULL);
            else {
               for (qtr = (mapnode *)outman->head; qtr && j; qtr = (mapnode *)qtr->next, j--);
               outman->insert(ptr, qtr);
            }

         }

      }

}


/* **************************************************
************************************************** */
texture *read_tex(char *filename) {

   texture *tob;
   
   tob = (texture *)((frame_manager *)global_resource_manager)->read_tex(filename);

   if (!tob) {
      printf("Bad image %s... Aborting\n", filename);
      exit(0);
   }
   
   return tob;
}


/* *************************************************************
************************************************************* */
void init(int argc, char **argv) {

   init_lut();
   init_coder();
   ((frame_manager *)global_resource_manager)->set_palette_support(0);
}


/* *************************************************************
************************************************************* */
void parse_args(int argc, char **argv) {

   int i, j;
   texnode *ptr;
   texture *tob;
   
   for (i=1; i<argc; i++) {

      if (!strcmp(argv[i], "-order")) {
         i++;

         if (i == argc)
            break;

         slice_order = !strcmp(argv[i], "row") ? ORDER_ROW : ORDER_COLUMN;
         continue;
      }

      tob = read_tex(argv[i]);

      if (tob) {
         i++;
 
         if (i >= argc || atoi(argv[i]) < 1)
            printf("Warning: Invalid arguments....\n");
         else {
            texman.append(ptr = new texnode, NULL);
            ptr->tob = tob;
            j = atoi(argv[i]);
            if (slice_order == ORDER_COLUMN)
               ptr->count = (tob->maxx < j) ? 1 : (tob->maxx + j-1) / j;
            else
               ptr->count = (tob->maxy < j) ? 1 : (tob->maxy + j-1) / j;
         }

      }
      
      else
         printf("Warning: Unable to access \"%s\"...\n", argv[i]);      
   }

}


/* *************************************************************
************************************************************* */
int main(int argc, char **argv) {

   bmp bmpcoder;
   union { texnode *ttr; mapnode *ptr; };
   int i;
   char filename[16];

   init(argc, argv);
    
   parse_args(argc, argv);

   for (ttr = (texnode *)texman.head; ttr; ttr = (texnode *)ttr->next)
      ttr->slice(slice_order, &outman);

   for (i=0, ptr = (mapnode *)outman.head; ptr; i++, ptr = (mapnode *)ptr->next) {
      sprintf(filename, "%04d.bmp", i);
      bmpcoder.write_data(filename, &ptr->tob, ((frame_manager *)global_resource_manager)->query_color_byte_order());
   }
   
   return 1;
}
