

#include <string.h>

#include "global.h"
#include "image.h"
#include "texture.h"
#include "pstring.h"

#include "imgman.h"

void init_coder();


/* **************************************************
************************************************** */
void init() {

   init_lut();
   init_coder();
}


/* **************************************************
************************************************** */
void build_name(char *in, string_type *out) {

   int j;
   
   out->stringcpy(in);
   for (j=out->stringlen()-1; j > -1 && out->string[j] != '.'; j--);
	 
   if (j != -1) {
      out->string[j] = 0;
      out->recalc(); 
   }

   out->stringcat(".rtf");
}


/* **************************************************
************************************************** */
int process(char *filename) {

   rtf rtf_coder;
   texbase *tex;
   string_type buffer;
   union { texture_block256 *tblock256; texture_block *tblock; };
   unsigned int palette[256];
   mapuc cob;

   global_resource_manager->reset();

   tex = (texbase *)((frame_manager *)global_resource_manager)->read_tex(filename);

   if (!tex)
      return 0;

   build_name(filename, &buffer);

   if (tex->query_whatami() == TEXTURE256) {

      tblock256 = (texture_block256 *)tex->query_data();

      printf("Convert %dx%d 8-bit %s->%s\n", tex->maxx, tex->maxy, filename, buffer.string);

      if (!rtf_coder.write_compress256(buffer.string, &tblock256->tob, tblock256->ipalette, CBYTE_ORDER_RGBA))
         printf("Error: cannot create %s...\n", buffer.string);

      return 1;      
   }
      
   printf("Convert %dx%d 32-bit %s->%s\n", tex->maxx, tex->maxy, filename, buffer.string);

   tblock = (texture_block *)tex->query_data();
   imgman_convert_2428(&tblock->tob, palette, &cob, CBYTE_ORDER_RGBA);

   if (!rtf_coder.write_compress256(buffer.string, &cob, palette, CBYTE_ORDER_RGBA))
      printf("Error: cannot create %s...\n", buffer.string);

   return 1;
}

/* **************************************************
************************************************** */
int main(int argc, char **argv) {

   int i;
   char buffer[MAXSTRLEN];
   sfile sinfile;
      
   if (argc < 2) {
      printf("usage: img2rtf256 <imagename1> .. <imagenamen>\n");
      printf("or:    img2rtf256 -f <listname>\n");
      return 1;
   }
   
   init();

   if (argc > 2 && !strcmp(argv[1], "-f")) {
      if (!sinfile.scan_data(argv[2], NULL, PLATFORM_SLASH))
         return 0;
	 
      while (!sinfile.seof()) {
         sinfile.scan_token(buffer, MAXSTRLEN);
         process(buffer);
      }
      
      return 1;
   }

   for (i=1; i<argc; i++)
      process(argv[i]);
   
   return 1;
}
