

/* *************************************************************
- glasners may/june 2002 idea for unscrambling "shredded" images

- first prototype  - just grab one, and work from there - problem - borders
- second prototype - greedy method
- third prototype - remove outliers - upper 5% of spikes
- 4th prototype - store separate images
- 5th prototype - minor code fixes and tweaks
- 5.1 prototype - mark borders at begining so dont attach any "inbetweens"
   - ../idscram5.1 -order row -icount 4 -extract 1 *.bmp -nixlum
- 5.2 prototype - replace "10 clamp" w/ a high color clamp
- 5.3 prototype -  use "mean" and stddev to influence selections
- 5.4 prototype -  replace "weight" calculations w/ edge detection + hicolor, no outlier culling
                   warning: crashes if slices are less than 2 pixels thick
- 6th rotate 180 slice (left/right, up/down doesnt matter)
************************************************************* */


#include <stdlib.h>
#include <string.h>

#include "texture.h"
#include "image.h"


void init_coder();

#define ORDER_ROW    0
#define ORDER_COLUMN 1

class slice_llist;

/* *************************************************************
************************************************************* */
class double_llist_type : public dbl_llist {

   public:
      double d;

      virtual ~double_llist_type() {}
};


/* *************************************************************
************************************************************* */
class slice_type {

   public:
      slice_llist *parent;

      slice_llist *target;
      double weight;

      int recalc;
      
      slice_type(slice_llist *p) { target = NULL; recalc = 0; parent = p; }

      int compare(double *w);
      int compare(slice_type *x) {  return compare(&x->weight); }

      void calc_append_key(slice_type *ptarget, int order);
};


/* *************************************************************
************************************************************* */
class slice_llist : public dbl_llist {

   public:
      texture *slice;
     
      slice_type left_slice, right_slice;
     
      slice_llist() : left_slice(this), right_slice(this) { slice = NULL; }
      virtual ~slice_llist() {}

      void append_merge(slice_llist *ptarget, int order);
};


dbl_llist_manager slice_man;
int slice_order = ORDER_ROW;
int extract_count = 1;
vector3d luminance = { 0.30, 0.59, 0.11 };

inline double NR(double xxx) { return xxx * xxx; }
inline double NG(double xxx) { return xxx * xxx; }
inline double NB(double xxx) { return xxx * xxx; }

inline double TR(double xxx) { return xxx < 10 ? 0 : xxx; }
inline double TG(double xxx) { return xxx < 10 ? 0 : xxx; }
inline double TB(double xxx) { return xxx < 10 ? 0 : xxx; }


/* *************************************************************
************************************************************* */
int slice_type::compare(double *w) {

   return (weight < *w) ? -1 : (weight > *w);
}


/* *************************************************************

D = NR(0.3*TR(dr)) + NG(0.59*TG(dg)) + NB(0.11*TB(db))

   - where TR()/TG()/TB are clamping functions
      (use 10 to clamp to zero for all 3)
   - dr/dg/db are the absolute differences between r, g, b texels on the
      edges compared
   - NR()/NG()/NB() are powers functions (use pow(x,2) or SQR() for all 3)

************************************************************* */
void slice_type::calc_append_key(slice_type *ptarget, int order) {

   int i;
   int start, end;
   vector3d v;
   double score;
   mapul *bsource, *btarget;
   int limit;
   dbl_llist_manager vman;
   double_llist_type *vtr, *ptr;
   
   start = 0;
   bsource = &((texture_block *)parent->slice->query_data())->tob;
   btarget = &((texture_block *)ptarget->parent->slice->query_data())->tob;
   
   switch (order) {
      case ORDER_ROW:
         end = parent->slice->maxy-1;
         limit = parent->slice->maxx/20;

         for (i=0; i<parent->slice->maxx; i++) {
            v[0] = abs(((char *)&bsource->pdata[end][i])[0] - ((char *)&btarget->pdata[start][i])[0]);
            v[1] = abs(((char *)&bsource->pdata[end][i])[1] - ((char *)&btarget->pdata[start][i])[1]);
            v[2] = abs(((char *)&bsource->pdata[end][i])[2] - ((char *)&btarget->pdata[start][i])[2]);

            v[0] = luminance[0]*TR(v[0]);
            v[1] = luminance[1]*TG(v[1]);
            v[2] = luminance[2]*TB(v[2]);

            vtr = new double_llist_type;
            vtr->d = NR(v[0]) + NG(v[1]) + NB(v[2]);

            if (!vman.head || ((double_llist_type *)vman.tail)->d < vtr->d)
               vman.append(vtr, NULL);
            else {
               for (ptr = (double_llist_type *)vman.head; ptr && ptr->d < vtr->d; ptr = (double_llist_type *)ptr->next);
               vman.insert(vtr, ptr);
            }

         }

         break;

//      case ORDER_COLUMN:
      default:
         end = parent->slice->maxx-1;
         limit = parent->slice->maxy/20;
 
         for (i=0; i<parent->slice->maxy; i++) {
            v[0] = abs(((char *)&bsource->pdata[i][end])[0] - ((char *)&btarget->pdata[i][start])[0]);
            v[1] = abs(((char *)&bsource->pdata[i][end])[1] - ((char *)&btarget->pdata[i][start])[1]);
            v[2] = abs(((char *)&bsource->pdata[i][end])[2] - ((char *)&btarget->pdata[i][start])[2]);

            v[0] = luminance[0]*TR(v[0]);
            v[1] = luminance[1]*TG(v[1]);
            v[2] = luminance[2]*TB(v[2]);

            vtr = new double_llist_type;
            vtr->d = NR(v[0]) + NG(v[1]) + NB(v[2]);

            if (!vman.head || ((double_llist_type *)vman.tail)->d < vtr->d)
               vman.append(vtr, NULL);
            else {
               for (ptr = (double_llist_type *)vman.head; ptr && ptr->d < vtr->d; ptr = (double_llist_type *)ptr->next);
               vman.insert(vtr, ptr);
            }

         }

         break;
   }

   // eliminate the upper 5% of the spikes
   for (; limit; limit--) {
      vman.remove(vtr = (double_llist_type *)vman.tail);
      delete vtr;
   }

   score = 0;
   for (ptr = (double_llist_type *)vman.head; ptr; ptr = (double_llist_type *)ptr->next)
      score += ptr->d;

   if (!target || compare(&score) == 1) {  
      target = ptarget->parent;
      weight = score;
   }

   if (!ptarget->target || ptarget->compare(&score) == 1) {  
      ptarget->target = parent;
      ptarget->weight = score;
   }

}


/* *************************************************************
************************************************************* */
void slice_llist::append_merge(slice_llist *ptarget, int order) {

   texture_block *tblock, *sblock, *pblock;
   int i, j;
      
   sblock = (texture_block *)slice->query_data();
   tblock = (texture_block *)ptarget->slice->query_data();
   pblock = new texture_block;

   if (order == ORDER_ROW) {
      pblock->tob.init_map(slice->maxx, slice->maxy + ptarget->slice->maxy);
      
      for (i=0; i<slice->maxy; i++)
         for (j=0; j<slice->maxx; j++)
            pblock->tob.pdata[i][j] = sblock->tob.pdata[i][j];
      for (i=0; i<ptarget->slice->maxy; i++)
         for (j=0; j<ptarget->slice->maxx; j++)
            pblock->tob.pdata[i+slice->maxy][j] = tblock->tob.pdata[i][j];
   }
  
   else { 
      pblock->tob.init_map(slice->maxx + ptarget->slice->maxx, slice->maxy);
      
      for (i=0; i<slice->maxy; i++) {
         for (j=0; j<slice->maxx; j++)
            pblock->tob.pdata[i][j] = sblock->tob.pdata[i][j];
         for (j=0; j<ptarget->slice->maxx; j++)
            pblock->tob.pdata[i][j+slice->maxx] = tblock->tob.pdata[i][j];
      }
   
   }

   if (ptarget->right_slice.target == this) {
      right_slice.target = NULL;
      right_slice.recalc = 1;
   }
   
   else {
      right_slice.target = ptarget->right_slice.target;
      right_slice.weight = ptarget->right_slice.weight;
   } 

   if (left_slice.target == ptarget) {
      left_slice.target = NULL;
      left_slice.recalc = 1;
   }
   
   slice->replace_data(pblock);
 
   slice->maxx = pblock->tob.maxx;
   slice->maxy = pblock->tob.maxy;
   slice->statusflag &= ~STATUSFLAG_LOADABLE;
   slice->statusflag |= STATUSFLAG_LOADED;
}


/* **************************************************
************************************************** */
texture *read_tex(char *filename) {

   texture *tob;
   
   tob = (texture *)((frame_manager *)global_resource_manager)->read_tex(filename);

   if (!tob) {
      printf("ERROR: Bad image \"%s\"... Aborting\n", filename);
      exit(0);
   }
   
   return tob;
}


/* *************************************************************
************************************************************* */
void parse_args(int argc, char **argv) {

   int i;
   slice_llist *ptr;
   texture *tob;
   
   for (i=1; i<argc; i++) {

      if (!strcmp(argv[i], "-nixlum")) {
         luminance[0] = luminance[1] = luminance[2] = 1.0;
         continue;
      }

      if (!strcmp(argv[i], "-order")) {
         i++;

         if (i == argc)
            break;

         slice_order = !strcmp(argv[i], "row") ? ORDER_ROW : ORDER_COLUMN;
         continue;
      }

      if (!strcmp(argv[i], "-extract")) {
         i++;

         if (i == argc)
            break;

         extract_count = atoi(argv[i]);
         continue;
      }

      tob = read_tex(argv[i]);

      if (tob) {
         slice_man.append(ptr = new slice_llist, NULL);
         ptr->slice = tob;
      }
      
      else
         printf("Warning: Unable to access \"%s\"...\n", argv[i]);      
   }

}


/* *************************************************************
************************************************************* */
int main(int argc, char **argv) {

   slice_llist *ptr, *qtr, *temp;
   rtf rtfcoder;
   texture_block *tblock;
   slice_llist *out;
   double t;
   char buffer[16];
   int i;
   
   init_lut();
   init_coder();
   ((frame_manager *)global_resource_manager)->set_palette_support(0);

   parse_args(argc, argv);

   if (!slice_man.head)
      return 0;

   for (ptr = (slice_llist *)slice_man.head; ptr; ptr = (slice_llist *)ptr->next)
      for (qtr = (slice_llist *)ptr->next; qtr; qtr = (slice_llist *)qtr->next) {
         ptr->right_slice.calc_append_key(&qtr->left_slice, slice_order);
         qtr->right_slice.calc_append_key(&ptr->left_slice, slice_order);
      }

   while (slice_man.count > extract_count) {

      out = NULL;

      for (qtr = (slice_llist *)slice_man.head; qtr; qtr = (slice_llist *)qtr->next)
         if (!out) {
            out = qtr;
            if (qtr->left_slice.compare(&qtr->right_slice) == -1) {
               t = qtr->left_slice.weight;
            }

            else {
               t = qtr->right_slice.weight;
            }

         }
 
         else if (qtr->left_slice.compare(&qtr->right_slice) == -1) {
            if (qtr->left_slice.compare(&t) == -1) {
               out = qtr;
               t = qtr->left_slice.weight;
            }

         }

         else if (qtr->right_slice.compare(&t) == -1) {
            out = qtr;
            t = qtr->right_slice.weight;
         }

      slice_man.remove(out);
   
      if (out->left_slice.compare(&out->right_slice) == -1) {
         temp = out;
         slice_man.remove(out = out->left_slice.target);
      }
      
      else
         slice_man.remove(temp = out->right_slice.target);

      out->append_merge(temp, slice_order);
      delete temp;

      for (qtr = (slice_llist *)slice_man.head; qtr; qtr = (slice_llist *)qtr->next) {
         if (qtr->left_slice.target == out) {
            qtr->left_slice.target = NULL;
            qtr->left_slice.recalc = 1;
         }
 
         else if (qtr->left_slice.target == temp)
            qtr->left_slice.target = out;
 
         if (qtr->right_slice.target == temp) {
            qtr->right_slice.target = NULL;
            qtr->right_slice.recalc = 1;
         }
 
      }
      
      slice_man.insert(out, NULL);
      
      for (ptr = (slice_llist *)slice_man.head; ptr; ptr = (slice_llist *)ptr->next)
         for (qtr = (slice_llist *)ptr->next; qtr; qtr = (slice_llist *)qtr->next) {
            if (ptr->right_slice.recalc || qtr->left_slice.recalc)
               ptr->right_slice.calc_append_key(&qtr->left_slice, slice_order);
            if (ptr->left_slice.recalc || qtr->right_slice.recalc)
               qtr->right_slice.calc_append_key(&ptr->left_slice, slice_order);
         }

      for (qtr = (slice_llist *)slice_man.head; qtr; qtr = (slice_llist *)qtr->next)
         qtr->left_slice.recalc = qtr->right_slice.recalc = 0;

   }
 
   for (ptr = (slice_llist *)slice_man.head, i=0; ptr; ptr = (slice_llist *)ptr->next, i++) {
      tblock = (texture_block *)ptr->slice->query_data();
      sprintf(buffer, "out%04d.rtf", i);
      rtfcoder.write_data(buffer, &tblock->tob, ((frame_manager *)global_resource_manager)->query_color_byte_order());
   }

   return 1;
}
