

#include <stdlib.h>
#include <time.h>

#ifdef WIN32
#include "WIN_WOGL.h"
#include <GL/gl.h>

#define WINDOWTYPE WOGLwindow
#else
#include "WIN_XOGL.h"

#define WINDOWTYPE XOGLwindow
#endif

#include "datatype.h"
#include "texture.h"
#include "global.h"

void init_coder();


/* **************************************************
   main: program controller
************************************************** */
int main (int argc, char *argv[]) {

   texture **tex;
   int WINX, WINY;
   int  i, j, k;
   unsigned int currtime, newtime;
   float fps;
   int *maxx, *maxy;
   WINDOWTYPE  gwindow;

#ifdef WIN32
   MSG message;
#else
   XEvent mevent;
#endif

   if (argc < 3) {
      printf("usage: flip sec/frame frame1 frame2 ...\n");
      exit(0);
   }

   j = argc-2;
   fps = (float)(atof(argv[1]) * CLOCKS_PER_SEC);

   if (j<=0)
      exit(0);

   init_coder();
   ((frame_manager *)global_resource_manager)->set_palette_support(0);

   tex = new texture *[j];

   for (i=0; i<j; i++) {
      tex[i] = (texture *)((frame_manager *)global_resource_manager)->read_tex(argv[i+2]);
      if (!tex[i]) {
         printf("Bad image %s... Aborting\n", argv[i+2]);
         exit(0);
      }

   }

   maxx = new int[j];
   maxy = new int[j];

   WINX = WINY = 0;
   for (i=0; i<j; i++) {
      k = tex[i]->maxx;
      if (k > WINX)
         WINX = k;

      k = tex[i]->maxy;
      if (k > WINY)
         WINY = k;
   }

   for (i=0; i<j; i++) {
      k = tex[i]->maxx;

      if (WINX > k)
         maxx[i] = (WINX-k)>>1;
      else
         maxx[i] = 0;

      k = tex[i]->maxy;

      if (WINY > k)
         maxy[i] = (WINY-k)>>1;
      else
         maxy[i] = 0;
   }

   if (!gwindow.VIRTUALreset(argc, argv, WINX, WINY, "Flip", NULL))
      return 0;

   i=0;

   currtime = clock();
   while (i > -1) {

      glRasterPos2i(maxx[i], maxy[i]);
      glClear(GL_COLOR_BUFFER_BIT);
      gwindow.BLTbitmap(&((texture_block *)tex[i]->query_data())->tob);

      i++;
      if (i==j)
         i=0;

      do {

#ifdef WIN32
         if (PeekMessage(&message, NULL, 0, 0, PM_REMOVE))
            switch (message.message) {
               case WM_KEYUP:
               case WM_LBUTTONUP:
               case WM_RBUTTONUP:
               case WM_MBUTTONUP:
               case WM_DESTROY:
               case WM_QUIT:
                  i = -1;
                  break;

               default:
                  DispatchMessage(&message);
            }

#else
         XCheckMaskEvent (gwindow.mdisplay, KeyPressMask | ButtonPressMask, &mevent);
         if (mevent.type == KeyPress || mevent.type == ButtonPress) {
            i = -1;
            break;
         }

#endif

      } while((newtime = clock()) >= currtime && newtime-currtime < fps);

      currtime = newtime;
   }

   delete [] maxx;
   delete [] maxy;
   delete [] tex;

   gwindow.VIRTUALcancel();
   return 1;
}

