

#include "darkgine.h"
#include "cam_ai.h"
#include "sfx.h"
#include "pstring.h"


#define MAX_LENS_CORONA 9

vfx_lens_corona lens_glare;
vfx_lens_corona *lens_flare = NULL;
float vfx_timer = 0;
quark *sol_parent = NULL;
atom_list_type *sol_tree = NULL;


/* **************************************************************
************************************************************** */
int vfx_lens_flare(dbl_llist_manager *hiearchy_manager, mapul *mapbuffer, camera *cparm, quark *sol, atom_list_type *solsys) {

   vector2f axis;
   float t, dot;
   vector4f pos, center;
   vector3f ray;
   vector3f normal;
   int i;
   atom_list_type *atr, *ctr;
   quark *obstacle;

   if (cparm->query_frustum_clip(sol->old_state.bradius, sol->old_state.bcenter, &t, ~FRUSTUM_CLIP_BACK))
      return 0;

   subeqarray3(ray, sol->old_state.center, cparm->location);
   
   // dont do los calc w/ atom if camera is inside
   for (ctr=NULL, atr=(atom_list_type *)hiearchy_manager->head; atr; atr=(atom_list_type *)atr->next) {
      if (!atr->htree->query_whatwasi(OBJECT_CAMERA_CONTROL))
         continue;

      if (((camera_control *)atr->htree)->query_view_type() != VIEW_CHASE)
         ctr = ((camera_control *)atr->htree)->query_target()->object;

      break;
   }

   // put light in screen space
   matvecmulto(cparm->transform, sol->old_state.center, center);
   cparm->map2screen(center);

   // calc axis (X) of the lens flare
   axis[0] = mapbuffer->maxx*0.5f - center[0];
   axis[1] = mapbuffer->maxy*0.5f - center[1];

   t = (float)(1.0 - 2.0*SQRT( dotproduct2(axis, axis)/(mapbuffer->maxx*mapbuffer->maxx + mapbuffer->maxy*mapbuffer->maxy)));

   if (t > 0) {
      dot = t*t;
      t = (float)(0.1 + 0.9 * t);
      dot *= t;
   }
   
   else {
      dot = 0;
      t = 0.1f;
   }

   // line intersect all for something in the way....
   // asdf - note: this code causes lensflare to appear in rear-view through ship
   for (atr=(atom_list_type *)hiearchy_manager->head; atr; atr=(atom_list_type *)atr->next)
      if (atr != ctr && atr != solsys && !query_clear_los(NULL, atr->htree, NULL, cparm->location, ray, &obstacle, pos, normal, COL_POLYGON))
         return 0;

   // glare   
   lens_glare.render(mapbuffer, (int)vfx_timer, center, axis, dot);
   
   // flare
   for (i = 0; i < MAX_LENS_CORONA; i++)
      lens_flare[i].render(mapbuffer, (int)vfx_timer, center, axis, t);

   return 1;
}


/* **************************************************************
************************************************************** */
void vfx_init(dbl_llist_manager *hiearchy_manager, int winx, int winy) {

   vector4uc red = { 255, 0, 0, 0 };
   vector4uc yellow = { 255, 255, 0, 0 };
   vector4uc white = { 255, 255, 255, 0 };
   char buffer[MAXSTRLEN];
   quark *sol;

   vfx_dest();

   vfx_timer = 0;

   sprintf(buffer, "%s%s.rtf", FILENAME_PRETEX, FILENAME_FLARE);
   lens_glare.init(buffer, 0.0f, 0.33f*winx, white, 1.0f, 0.33f);

   // read in lens flare vf/x

   lens_flare = new vfx_lens_corona[MAX_LENS_CORONA];

   sprintf(buffer, "%s%s.rtf", FILENAME_PRETEX, FILENAME_FLARE3);
   lens_flare[0].init(buffer, 0.2f, 0.04f*winx, red, 1.0f, 0.6f);
   sprintf(buffer, "%s%s.rtf", FILENAME_PRETEX, FILENAME_FLARE4);
   lens_flare[1].init(buffer, 0.4f, 0.1f*winx, red, 1.0f, 0.4f);
   sprintf(buffer, "%s%s.rtf", FILENAME_PRETEX, FILENAME_FLARE2);
   lens_flare[2].init(buffer, 0.6f, 0.2f*winx, yellow, 1.0f, 0.3f);
   sprintf(buffer, "%s%s.rtf", FILENAME_PRETEX, FILENAME_FLARE5);
   lens_flare[3].init(buffer, 0.8f, 0.05f*winx, red, 1.0f, 0.3f);
   sprintf(buffer, "%s%s.rtf", FILENAME_PRETEX, FILENAME_FLARE1);
   lens_flare[4].init(buffer, 1.0f, 0.04f*winx, red, 1.0f, 0.3f);
   sprintf(buffer, "%s%s.rtf", FILENAME_PRETEX, FILENAME_FLARE6);
   lens_flare[5].init(buffer, 1.25f, 0.07f*winx, red, 1.0f, 0.5f);
   lens_flare[6].init(buffer, 1.4f, 0.02f*winx, yellow, 1.0f, 0.3f);
   lens_flare[7].init(buffer, 1.6f, 0.04f*winx, red, 1.0f, 0.4f);
   lens_flare[8].init(buffer, 2.0f, 0.03f*winx, yellow, 1.0f, 0.3f);

   for (sol=NULL, sol_tree=(atom_list_type *)hiearchy_manager->head; sol_tree && !sol; sol_tree=(atom_list_type *)sol_tree->next)
      sol = sol_tree->htree->find(NULL, OBJECT_PHOTON, NULL, &sol_parent);

   if (!sol || !sol_parent || (sol_parent->old_state.state_flags & STATE_MASK_BOUND) != STATE_FLAG_BSPHERE)
      sol_parent = NULL;
}


/* **************************************************************
************************************************************** */
void vfx_dest() {

   if (lens_flare) {
      delete [] lens_flare;
      lens_flare = NULL;
   }
   
   sol_parent = NULL;
}


/* **************************************************************
************************************************************** */
void vfx_dazzle_the_crowd(dbl_llist_manager *hiearchy_manager, mapul *mapbuffer, camera *cparm) {

   if (!cparm || !sol_parent)
      return;
      
   vfx_timer += complex->timer.speedscale;
   if (vfx_timer > 256)
      vfx_timer -= 256;

   vfx_lens_flare(hiearchy_manager, mapbuffer, cparm, sol_parent, sol_tree);
}
