

#if !defined __TURRENT_H
#define __TURRENT_H

#include "darkbrai.h"
#include "darktron.h"

typedef struct {

   float pitch, yaw;
   float pitch_range[2], yaw_range[2];
   float pitch_velocity, yaw_velocity;
   float pitch_default, yaw_default;
   float pitch_work, yaw_work;
   int   pitch_flag, yaw_flag;
} fov_type;


/* ****************************************************************
**************************************************************** */
class turrent : public darkneutron {

   protected:
      // target data
      target_type target;
      float dist2target;                    // calculated in select_target()
      vector3f target_dir;                  // calculated in select_target()
      smart_targeting_pathway brain;

      // orientation data
      fov_type fov;

      // weapon data
      int   speed, damage, max_range;
      vector3f offset;
      float offset_length;
      float recharge_rate;
      float countdown;
      string_type weapon_deathname;
      unsigned int ammo_id;
      texbase *weapon_death_tob;

      sound_id_type sndfx_id;      
      sound_type *sndfx;

      // gun barrel data
      quark *barrel_obj;
      vector4f barrel_mx[4];

      void process_intel(dbl_llist_manager *hiearchy_manager);
      void process_fire_control(dbl_llist_manager *hiearchy_manager);
      int  calc_targeting_data();
      int  select_target(dbl_llist_manager *hiearchy_manager);

   public:
      // superclass
      int  query_whatami() { return OBJECT_TURRENT; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);

      // quark
      void begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);

      // turrent
      turrent();
      virtual ~turrent();
};


/* ****************************************************************
**************************************************************** */
class turrent_loader : public quark_loader {

   protected:
      superclass *make_object() { return new turrent; }

   public:
      turrent_loader() { alias_name = object_name = TOKEN_TURRENT_STR; }
      virtual ~turrent_loader() {}
};


/* ****************************************************************
**************************************************************** */
class barrel : public gamequark {

   public:
      // superclass
      int  query_whatami() { return OBJECT_BARREL; }
      virtual ~barrel() {}
};

/* ****************************************************************
**************************************************************** */
class barrel_loader : public quark_loader {

   protected:
      superclass *make_object() { return new barrel; }

   public:
      barrel_loader() { alias_name = object_name = TOKEN_BARREL_STR; }
      virtual ~barrel_loader() {}
};





#endif

