

#include <stdlib.h>
#include <string.h>

#include "pstring.h"

#include "darkgine.h"
#include "darkfx.h"
#include "turrent.h"


#define FIVE_DEGREE      0.08726

#define TURRENT_STATUS() (hp > 0 && (!barrel_obj || ((gamequark *)barrel_obj)->total_hp))


/* *************************************************************
************************************************************* */
int turrent::query_whatwasi(int type) {

   return (turrent::query_whatami() == type) ? 1 : darkneutron::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
turrent::turrent() {

   fov.pitch_range[0] = -HALFPI;
   fov.pitch_range[1] = HALFPI;

   fov.yaw_range[0] = 0;
   fov.yaw_range[1] = TWOPI;

   fov.pitch_default = fov.yaw_default = fov.pitch = fov.yaw = 0;
   fov.pitch_velocity = fov.yaw_velocity = HALFPI;

   barrel_obj = NULL;

   recharge_rate = 0;
   countdown = 0;

   speed = damage = max_range = 0;
   offset[0] = offset[1] = offset[2] = 0;
   offset_length = 0;

   sndfx = NULL;
   weapon_death_tob = NULL;
   ammo_id = OBJECT_LAZER;
}


/* *************************************************************
************************************************************* */
turrent::~turrent() {

   if (sndfx)
      sndfx->flags &= ~(FLAG_SOUND_LOCK | FLAG_SOUND_PLAYING);
}


/* *************************************************************
************************************************************* */
int turrent::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_OFFSET_STR)) {
      get_token(infile, token);
      offset[0] = (float)atof(token);
      get_token(infile, token);
      offset[1] = (float)atof(token);
      get_token(infile, token);
      offset[2] = (float)atof(token);
      offset_length = dotproduct3(offset, offset);
      offset_length = (offset_length > CORRECT) ? (float)sqrt(offset_length) : 0;
      return 1;
   }

   if (!strcmp(token, TOKEN_YAW_DEFAULT_STR)) {
      get_token(infile, token);
      fov.yaw_default = (float)atof(token);
      fov.yaw_default = (float)deg2rad(fov.yaw_default);
      return 1;
   }

   if (!strcmp(token, TOKEN_YAW_VELOCITY_STR)) {
      get_token(infile, token);
      fov.yaw_velocity = (float)atof(token);
      fov.yaw_velocity = (float)deg2rad(fov.yaw_velocity);
      return 1;
   }

   if (!strcmp(token, TOKEN_YAW_RANGE_STR)) {
      get_token(infile, token);
      fov.yaw_range[0] = (float)atof(token);
      fov.yaw_range[0] = (float)deg2rad(fov.yaw_range[0]);

      get_token(infile, token);
      fov.yaw_range[1] = (float)atof(token);
      fov.yaw_range[1] = (float)deg2rad(fov.yaw_range[1]);
      return 1;
   }

   if (!strcmp(token, TOKEN_PITCH_DEFAULT_STR)) {
      get_token(infile, token);
      fov.pitch_default = (float)atof(token);
      fov.pitch_default = (float)deg2rad(fov.pitch_default);
      return 1;
   }

   if (!strcmp(token, TOKEN_PITCH_VELOCITY_STR)) {
      get_token(infile, token);
      fov.pitch_velocity = (float)atof(token);
      fov.pitch_velocity = (float)deg2rad(fov.pitch_velocity);
      return 1;
   }

   if (!strcmp(token, TOKEN_PITCH_RANGE_STR)) {
      get_token(infile, token);
      fov.pitch_range[0] = (float)atof(token);
      fov.pitch_range[0] = (float)deg2rad(fov.pitch_range[0]);

      get_token(infile, token);
      fov.pitch_range[1] = (float)atof(token);
      fov.pitch_range[1] = (float)deg2rad(fov.pitch_range[1]);
      return 1;
   }

   if (!strcmp(token, TOKEN_RECHARGE_STR)) {
      get_token(infile, token);
      recharge_rate = (float)atof(token);
      return 1;
   }

   if (!strcmp(token, TOKEN_SPEED_STR)) {
      get_token(infile, token);
      speed = atoi(token);
      return 1;
   }

   if (!strcmp(token, TOKEN_DAMAGE_STR)) {
      get_token(infile, token);
      damage = atoi(token);
      return 1;
   }

   if (!strcmp(token, TOKEN_MAX_RANGE_STR)) {
      get_token(infile, token);
      max_range = atoi(token);
      return 1;
   }

   if (!strcmp(token, TOKEN_SFX_STR)) {
      get_token(infile, token);
      sndfx_id.name.stringcpy(token);
      sndfx_id.flags = FLAG_SOUND_WAV | FLAG_SOUND_3D;
      return 1;
   }

   if (!strcmp(token, TOKEN_SFX_VOLUME_STR)) {
      get_token(infile, token);
      sndfx_id.volume(atoi(token));
      return 1;
   }

   if (!strcmp(token, TOKEN_WEAPON_DEATHNAME_STR)) {
      get_token(infile, token);
      weapon_deathname.stringcpy(token);
      return 1;
   }

   if (!strcmp(token, TOKEN_AMMO_STR)) {
      get_token(infile, token);
	  lower_case(token);

      ammo_id = complex->teacher.identify(token);
      if (!ammo_id)
         ammo_id = OBJECT_LAZER;

      return 1;
   }

   if (brain.parse(infile, token))
      return 1;

   return darkneutron::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void turrent::preprocess(void *data) {

   linktype *ptr;

   darkneutron::preprocess(data);

   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link->query_whatami() == OBJECT_BARREL) {
         barrel_obj = ptr->link;
         break;
      }

   fov.pitch = fov.pitch_default;
   fov.yaw   = fov.yaw_default;

   brain.set_source((gameatom *)((geneological_type *)data)->tree->htree);
   brain.set_target_alliance(calc_enemy(flags));
   brain.set_range((float)max_range);

   weapon_death_tob = (texbase *)((frame_manager *)global_resource_manager)->read_tex(weapon_deathname.string);

   if (atomparent->htree == global_player)
      complex->soundmanager->find(&sndfx_id);
}


/* *************************************************************
      // distance check done in calc_targeting_data()
************************************************************* */
int turrent::calc_targeting_data() {

   vector4f v;
   float dist;

   vector3f target_center;
   intercept_pathway intercept;

   if (!GQUARK_STATUS(target.specific, (gameatom *)target.object->htree))
      return 0;

   if (!intercept.intercept_prediction(target.specific, old_state.center, (float)speed, target_center, &dist)) {
      target.specific = NULL;
      target.specific_parent = NULL;
      target.object = NULL;
      return 0;
   }

   // calc distance data
   subeqarray3(target_dir, target_center, old_state.center);
   dist2target = speed*dist;

   if (dist2target < CORRECT)
      dist2target = 0;
   else {
      dist = 1.0f/dist2target;
      smultarray3(target_dir, dist);
   }

   if (dist2target > 0) {
      dist2target -= offset_length;

      if ((target.specific->old_state.state_flags & STATE_MASK_BOUND) == STATE_FLAG_BSPHERE)
         dist2target -= target.specific->old_state.bradius;

      if (dist2target < 1)
         dist2target = 1;
   }
   
   if (dist2target > max_range) {
      target.specific = NULL;
      target.specific_parent = NULL;
      target.object = NULL;
      return 0;
   }

   // calculate pitch/yaw
   if (!(state.state_flags & STATE_FLAG_INVERSE)) {
      inversemx(state.xmx, state.ixmx);
      state.state_flags |= STATE_FLAG_INVERSE;
   }
   
   matvecmultv(state.ixmx, target_dir, v);
   v[3] = 0;

   dist = dotproduct3(v, v);

   if (dist > CORRECT) {
      fov.pitch_work = (float)(v[1]/sqrt(dist));
      if (fov.pitch_work > ICORRECT)
         fov.pitch_work = -HALFPI - fov.pitch;
      else if (fov.pitch_work < -ICORRECT)
         fov.pitch_work = HALFPI - fov.pitch;
      else
         fov.pitch_work = (float)(-asin(fov.pitch_work) - fov.pitch);

      fov.pitch_flag = fabs(fov.pitch_work) > CORRECT;
   }

   else
      fov.pitch_flag = 0;

   dist = v[0]*v[0] + v[2]*v[2];

   if (dist > CORRECT) {
      fov.yaw_work = (float)(v[2]/sqrt(dist));
      if (fov.yaw_work > ICORRECT)
         fov.yaw_work = 0;
      else if (fov.yaw_work < -ICORRECT)
         fov.yaw_work = PI;
      else
         fov.yaw_work = (float)(acos(fov.yaw_work));

      if (v[0] < 0)
         fov.yaw_work = -fov.yaw_work;

     dist = fov.yaw + fov.yaw_work;
     if (dist < 0)
        dist += TWOPI;

      if (fov.yaw_range[0] < fov.yaw_range[1]) {
         if (dist < fov.yaw_range[0]-FIVE_DEGREE || dist > fov.yaw_range[1]+FIVE_DEGREE) {
            target.specific = NULL;
            target.specific_parent = NULL;
            target.object = NULL;
            return 0;
         }

      }

      else if (dist > fov.yaw_range[1]+FIVE_DEGREE && dist < fov.yaw_range[0]-FIVE_DEGREE) {
         target.specific = NULL;
         target.specific_parent = NULL;
         target.object = NULL;
         return 0;
      }

      fov.yaw_flag = fabs(fov.yaw_work) > CORRECT;
   }

   else
      fov.yaw_flag = 0;

   return 1;

}


/* *************************************************************
************************************************************* */
int turrent::select_target(dbl_llist_manager *hiearchy_manager) {

   // check if have valid target
   if (calc_targeting_data())
      return 1;

   brain.get_next_target(hiearchy_manager, &complex->teacher, &target);
   return calc_targeting_data();
}


/* *************************************************************
************************************************************* */
void turrent::process_intel(dbl_llist_manager *hiearchy_manager) {

   float midpt, work_velocity;

   if (!select_target(hiearchy_manager)) {
      fov.pitch_work = fov.pitch_default - fov.pitch;
      fov.pitch_flag = fabs(fov.pitch_work) > CORRECT;

      fov.yaw_work = fov.yaw_default - fov.yaw;
      fov.yaw_flag = fabs(fov.yaw_work) > CORRECT;
   }

   if (fov.pitch_flag) {
      work_velocity = fov.pitch_velocity*complex->timer.speedscale;

      if (fov.pitch_work > 0)
         fov.pitch += (work_velocity > fov.pitch_work) ? fov.pitch_work : work_velocity;
      else
         fov.pitch += (-work_velocity < fov.pitch_work) ? fov.pitch_work : -work_velocity;

      if (fov.pitch < fov.pitch_range[0])
         fov.pitch = fov.pitch_range[0];
      else if (fov.pitch > fov.pitch_range[1])
         fov.pitch = fov.pitch_range[1];
   }

   if (fov.yaw_flag) {
      work_velocity = fov.yaw_velocity*complex->timer.speedscale;

      if (fov.yaw_work > 0) {
         fov.yaw += (work_velocity > fov.yaw_work) ? fov.yaw_work : work_velocity;
         if (fov.yaw > TWOPI)
            fov.yaw -= TWOPI;
      }

      else {
         fov.yaw += (-work_velocity < fov.yaw_work) ? fov.yaw_work : -work_velocity;
         if (fov.yaw < 0)
            fov.yaw += TWOPI;
      }

      if (fov.yaw_range[0] < fov.yaw_range[1]) {
         if (fov.yaw < fov.yaw_range[0])
            fov.yaw = fov.yaw_range[0];
         else if (fov.yaw > fov.yaw_range[1])
            fov.yaw = fov.yaw_range[1];
      }

      else if (fov.yaw > fov.yaw_range[1] && fov.yaw < fov.yaw_range[0]) {
         midpt = (float)((fov.yaw_range[0]+fov.yaw_range[1]) * 0.5);
         fov.yaw = (fov.yaw > midpt) ? fov.yaw_range[0] : fov.yaw_range[1];
      }

   }

}


/* *************************************************************
************************************************************* */
void turrent::process_fire_control(dbl_llist_manager *hiearchy_manager) {

   lazer *ammo;
   vector3f dir;

   countdown -= complex->timer.speedscale;

   // check weapon and target status
   if (!GQUARK_STATUS(target.specific, (gameatom *)target.object->htree) || countdown > 0)
      return;

   dir[0] = barrel_mx[0][2];
   dir[1] = barrel_mx[1][2];
   dir[2] = barrel_mx[2][2];
   normalize3(dir);

   // decide to fire
   if (dist2target < CORRECT || !query_fire_primary((gameatom *)atomparent->htree, flags, hiearchy_manager, state.center, dir, (float)max_range, target.specific, target_dir, dist2target, target.specific->old_state.bcenter, target.specific->old_state.bradius))
      return;

   ammo = (lazer *)complex->teacher.issue(ammo_id);
   ammo->init(atomparent, (float)max_range, (float)speed, damage, dir, offset, barrel_mx, weapon_death_tob, &target);

   countdown = recharge_rate;

   if (sndfx)
      sndfx->stop();

   sndfx = complex->soundmanager->play(&sndfx_id);
   if (sndfx) {
      sndfx->flags |= FLAG_SOUND_LOCK;
      ((sound_wav3d_type *)sndfx)->location(ammo->end);
   }

}


/* *************************************************************
************************************************************* */
void turrent::begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   linktype *ptr;
   vector4f r[4];
   
   copymx4x4o(r, initxform);
   arotate_mx_y(r, fov.yaw);
   matmatmulto(mx, r, state.xmx);

   copymx4x4o(state.node, state.xmx);

   copymx4x4o(barrel_mx, state.xmx);
   arotate_mx_x(barrel_mx, fov.pitch);

   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent)                      
         ptr->link->begin(hiearchy_manager, this, (ptr->link == barrel_obj) ? barrel_mx : state.node);

   state.center[0] = state.xmx[0][3];
   state.center[1] = state.xmx[1][3];
   state.center[2] = state.xmx[2][3];

   if (flags & QUARK_FLAG_ACTIVE)
      setup();
}


/* *************************************************************
************************************************************* */
void turrent::whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   linktype *ptr;
   vector4f r[4];
   int turrent_status = TURRENT_STATUS();

   matmatmulto(mx, initxform, r);
   
   // check if destroyed
   if (turrent_status) {
      copymx4x4o(state.xmx, r);
      arotate_mx_y(state.xmx, fov.yaw);

      process_intel(hiearchy_manager);
   }

   copymx4x4o(state.xmx, r);
   arotate_mx_y(state.xmx, fov.yaw);

   copymx4x4o(state.node, state.xmx);

   copymx4x4o(barrel_mx, state.xmx);
   arotate_mx_x(barrel_mx, fov.pitch);

   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent)                          
         ptr->link->whereami(hiearchy_manager, this, (ptr->link == barrel_obj) ? barrel_mx : state.node);

   state.center[0] = state.xmx[0][3];
   state.center[1] = state.xmx[1][3];
   state.center[2] = state.xmx[2][3];

   if (flags & QUARK_FLAG_ACTIVE)
      setup();

   if (turrent_status)
      process_fire_control(hiearchy_manager);
}

