

#if !defined __THRUSTER_H
#define __THRUSTER_H


#include "anineutr.h"
#include "darkqurk.h"


#define THRUSTERFLAG_NULL            0x00
#define THRUSTERFLAG_PITCH_UP        0x01
#define THRUSTERFLAG_PITCH_DOWN      0x02
#define THRUSTERFLAG_YAW_LEFT        0x04
#define THRUSTERFLAG_YAW_RIGHT       0x08
#define THRUSTERFLAG_ROLL_CLOCK      0x10
#define THRUSTERFLAG_ROLL_CCLOCK     0x20
#define THRUSTERFLAG_ENGINE_FORWARD  0x40
#define THRUSTERFLAG_ENGINE_BACKWARD 0x80


/* *************************************************************
************************************************************* */
class thruster : public antineutron {

   protected:

      gameatom *source;
      int query_thruster_use(float *ratio);

   public:
      // superclass
      int  query_whatami() { return OBJECT_THRUSTER; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);

      // quark
      void begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);

      // thruster
      unsigned int type;
      float accel, thruster_scale, thruster_scale_limit;

      thruster() { type = THRUSTERFLAG_NULL; accel = thruster_scale = 0; thruster_scale_limit = 1; }
      virtual ~thruster() {}
};


/* ****************************************************************
**************************************************************** */
class thruster_loader : public quark_loader {

   public:
      superclass *make_object() { return new thruster; }

      thruster_loader();
      virtual ~thruster_loader() {}
};



#endif
