

#include <stdlib.h>
#include <string.h>

#include "polygon.h"
#include "pstring.h"

#include "darkgine.h"
#include "thruster.h"


/* *************************************************************
************************************************************* */
thruster_loader::thruster_loader() {

   object_name = alias_name = TOKEN_THRUSTER_STR;
}


/* *************************************************************
************************************************************* */
int thruster::query_whatwasi(int type) {

   return (thruster::query_whatami() == type) ? 1 : antineutron::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
int thruster::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_ACCEL_STR)) {
      get_token(infile, token);
      accel = (float)atof(token);
      return 1;
   }

   if (!strcmp(token, TOKEN_ENGINE_THRUST_STR)) {
      type |= THRUSTERFLAG_ENGINE_FORWARD;
      return 1;
   }

   if (!strcmp(token, TOKEN_ENGINE_BREAK_STR)) {
      type |= THRUSTERFLAG_ENGINE_BACKWARD;
      return 1;
   }

   if (!strcmp(token, TOKEN_PITCH_UP_STR)) {
      type |= THRUSTERFLAG_PITCH_UP;
      return 1;
   }

   if (!strcmp(token, TOKEN_PITCH_DOWN_STR)) {
      type |= THRUSTERFLAG_PITCH_DOWN;
      return 1;
   }

   if (!strcmp(token, TOKEN_ROLL_CLOCK_STR)) {
      type |= THRUSTERFLAG_ROLL_CLOCK;
      return 1;
   }

   if (!strcmp(token, TOKEN_ROLL_CCLOCK_STR)) {
      type |= THRUSTERFLAG_ROLL_CCLOCK;
      return 1;
   }

   if (!strcmp(token, TOKEN_YAW_LEFT_STR)) {
      type |= THRUSTERFLAG_YAW_LEFT;
      return 1;
   }

   if (!strcmp(token, TOKEN_YAW_RIGHT_STR)) {
      type |= THRUSTERFLAG_YAW_RIGHT;
      return 1;
   }

   if (!strcmp(token, TOKEN_LIMIT_STR)) {
      get_token(infile, token);
      thruster_scale_limit = (float)atof(token);
      return 1;
   }

   return antineutron::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void thruster::preprocess(void *data) {

   thruster_scale = 0;
   flags &= ~QUARK_FLAG_ACTIVE;
   source = (gameatom *)((geneological_type *)data)->tree->htree;
   antineutron::preprocess(data);
}


/* *************************************************************
************************************************************* */
int thruster::query_thruster_use(float *ratio) {

   object_desc *od;
   equipment *device;
   unsigned int thruster_use;

   if (!source->query_specific_data(DATAFLAG_EQUIPMENT, &od) ||
       !source->query_specific_data(DATAFLAG_THRUSTER_USE, &thruster_use))
      return 0;

   if ((type & THRUSTERFLAG_ENGINE_FORWARD & thruster_use) ||
       (type & THRUSTERFLAG_ENGINE_BACKWARD & thruster_use)) {

      device = od->find_specific(EQUIP_ENGINE);

      if (device && device->hp) {
         *ratio = ((float)device->hp)/device->maxhp;
         return 1;
      }

   }

   if ((type & THRUSTERFLAG_PITCH_UP & thruster_use) ||
       (type & THRUSTERFLAG_PITCH_DOWN & thruster_use) ||
       (type & THRUSTERFLAG_YAW_LEFT & thruster_use) ||
       (type & THRUSTERFLAG_YAW_RIGHT & thruster_use) ||
       (type & THRUSTERFLAG_ROLL_CLOCK & thruster_use) ||
       (type & THRUSTERFLAG_ROLL_CCLOCK & thruster_use)) {

      device = od->find_specific(EQUIP_THRUSTER);

      if (device && device->hp) {
         *ratio = ((float)device->hp)/device->maxhp;
         return 1;
      }

   }

   return 0;
}


/* *************************************************************
************************************************************* */
void thruster::begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   antineutron::begin(hiearchy_manager, parent, mx);
   complex->gfx->gfxPolygonIncrementTime((polygon *)ob, complex->timer.speedscale/duration);
}

   
/* *************************************************************
************************************************************* */
void thruster::whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   linktype *ptr;
   float damage;

   matmatmulto(mx, initxform, state.xmx);
   copymx4x4o(state.node, state.xmx);
   
   // apply xform to children
   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent)
         ptr->link->whereami(hiearchy_manager, this, state.node);
	  
   state.center[0] = state.xmx[0][3];
   state.center[1] = state.xmx[1][3];
   state.center[2] = state.xmx[2][3];

   if (!(parent->flags & QUARK_FLAG_ACTIVE)) {
      flags &= ~QUARK_FLAG_ACTIVE;
      return;
   }

   if (query_thruster_use(&damage)) {
      thruster_scale += accel*complex->timer.speedscale;

      if (thruster_scale > 1.0f)
         thruster_scale = 1.0f;

      damage *= thruster_scale*thruster_scale_limit;
   }

   else {
      thruster_scale -= accel*complex->timer.speedscale;
      if (thruster_scale <= 0) {
         thruster_scale = 0;
         flags &= ~QUARK_FLAG_ACTIVE;
         return;
      }

      damage = thruster_scale*thruster_scale_limit;
   }

   state.xmx[0][2] *= damage;
   state.xmx[1][2] *= damage;
   state.xmx[2][2] *= damage;
   flags |= QUARK_FLAG_ACTIVE;

   complex->gfx->gfxPolygonIncrementTime((polygon *)ob, complex->timer.speedscale/duration);
   setup();
}

