

#if !defined __STARS_H
#define __STARS_H

#include "darkqurk.h"
#include "darkstrg.h"


/* *************************************************************
************************************************************* */
class stars : public gamequark {

   public:

      // superclass
      int  query_whatami() { return OBJECT_STARS; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);

      // quark
      void render_object(engine *proc, quark *parent, vector4f *frustum, unsigned int frustum_flag);
      void setup();

      // stars
      stars();
      virtual ~stars() {}
};


/* *************************************************************
************************************************************* */
class stars_loader : public quark_loader {

   protected:
      superclass *make_object() { return new stars; }

   public:
      stars_loader() { object_name = alias_name = TOKEN_STARS_STR; }

      virtual ~stars_loader() {}
};


/* *************************************************************
************************************************************* */
class dust : public gamequark {

   protected:
      int update_counter;
      
   public:

      // superclass
      int  query_whatami() { return OBJECT_DUST; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);

      // quark
      void render_object(engine *proc, quark *parent, vector4f *frustum, unsigned int frustum_flag);
      void setup();

      // dust
      dust();
      virtual ~dust() {}
};


/* *************************************************************
************************************************************* */
class dust_loader : public quark_loader {

   protected:
      superclass *make_object() { return new dust; }

   public:
      dust_loader() { object_name = alias_name = TOKEN_DUST_STR; }

      virtual ~dust_loader() {}
};


#endif

