

#include <stdlib.h>
#include <string.h>

#include "pstring.h"

#include "gamegine.h"
#include "pcloud.h"

#include "stars.h"


#define MAX_STARS       512
#define MAX_STAR_DEPTH  999999.0f


/* *************************************************************
************************************************************* */
int stars::query_whatwasi(int type) {

   return (stars::query_whatami() == type) ? 1 : gamequark::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
stars::stars() {

   int i;
   float scale;
   
   ob = complex->gfx->gfxAllocRenderObject(OBJECT_PARTICLE_CLOUD);
   ob->id = object_counter;
   object_counter++;

   ((pcloud *)ob)->count = MAX_STARS;
   ((pcloud *)ob)->cloud = new particulate[MAX_STARS];
   
   for (i=0; i<MAX_STARS; i++) {
      ((pcloud *)ob)->cloud[i].color[0] = ((pcloud *)ob)->cloud[i].color[1] = ((pcloud *)ob)->cloud[i].color[2] = 64 + (rand() % 191);

      ((pcloud *)ob)->cloud[i].pos[0] = (float)((rand() & 2047) - 1023);
      ((pcloud *)ob)->cloud[i].pos[1] = (float)((rand() & 2047) - 1023);
      ((pcloud *)ob)->cloud[i].pos[2] = (float)((rand() & 2047) - 1023);
      ((pcloud *)ob)->cloud[i].pos[3] = 1.0f;
      
      scale = (float)(MAX_STAR_DEPTH/magnitude3(((pcloud *)ob)->cloud[i].pos));
      smultarray3(((pcloud *)ob)->cloud[i].pos, scale);
   }

}


/* *************************************************************
************************************************************* */
int stars::parse(FILE *infile, char *token) {

   switch (token[0]) {
      case 'b':
         if (!strcmp(token, TOKEN_BACKGROUND_STR)) {
            get_token(infile, token);
            ((pc *)ob)->groundflag = BACKGROUND;
            ((pc *)ob)->renderpriority = atoi(token);
            return 1;
         }

         break;

      case 'f':
         if (!strcmp(token, TOKEN_FOREGROUND_STR)) {
            get_token(infile, token);
            ((pc *)ob)->groundflag = FOREGROUND;
            ((pc *)ob)->renderpriority = atoi(token);
            return 1;
         }

         break;

      case 'm':
         if (!strcmp(token, TOKEN_MIDGROUND_STR)) {
            ((pc *)ob)->groundflag = MIDGROUND;
            return 1;
         }

         break;

      default:
         break;
   }

   return gamequark::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void stars::preprocess(void *data) {

   gamequark::preprocess(data);

   state.state_flags &= ~STATE_MASK_BOUND;
   state.state_flags |= STATE_FLAG_BSPHERE;
   state.bradius = (float)sqrt(3.0*MAX_STAR_DEPTH*MAX_STAR_DEPTH);
   state.bcenter[0] = state.bcenter[1] = state.bcenter[2] = 0;

   ((pcloud *)ob)->local_bradius2 = state.bradius*state.bradius;
   ((pcloud *)ob)->local_bcenter[0] = ((pcloud *)ob)->local_bcenter[1] = ((pcloud *)ob)->local_bcenter[2] = 0;
   ((pcloud *)ob)->local_bcenter[3] = 1.0f;
   ((pcloud *)ob)->recalc_bound_flag = 0; 
}


/* *************************************************************
************************************************************* */
void stars::setup() {

//   copymx4x4o(((pc *)ob)->rotate, state.xmx);
   ((pc *)ob)->rotate = state.xmx;

   ((pc *)ob)->bound_sphere();
   
   if (((pc *)ob)->bvalid_flag) {
      state.state_flags &= ~(STATE_MASK_BOUND | STATE_FLAG_AUTO_UPDATE);
      state.state_flags |= STATE_FLAG_BSPHERE;
      state.bradius = ((pc *)ob)->bradius;
      copyarray3(state.bcenter, ((pc *)ob)->bcenter);
   }

}


/* *************************************************************
************************************************************* */
void stars::render_object(engine *proc, quark *parent, vector4f *frustum, unsigned int frustum_flag) {

   linktype *ptr;

   // cull node w/ view frustum
   if ((old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TNONE)
      frustum_flag = 0;
      
   if (frustum_flag) {
      if ((old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TSPHERE &&
          query_frustum_clip(old_state.tree_radius, old_state.tree_center, frustum, &frustum_flag, frustum_fail_data))
         return;
      
      if ((flags & QUARK_FLAG_ACTIVE) && (!((pc *)ob)->bvalid_flag || !frustum_flag || !query_frustum_clip(((pc *)ob)->bradius, ((pc *)ob)->bcenter, frustum, &frustum_flag, frustum_fail_data)))
         proc->engine_submit(ob);
   }

   else if (flags & QUARK_FLAG_ACTIVE)
      proc->engine_submit(ob);
      
   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent)
         ptr->link->render_object(proc, this, frustum, frustum_flag);
}
