

#include "boid.h"

#include "darkgine.h"
#include "darkfx.h"
#include "fighter.h"
#include "thruster.h"


#define BREATHING_ROOM_DIST  1000.0f
#define TARGET_STATUS(xxx)  (xxx && (xxx->flags & QUARK_FLAG_ACTIVE))
#define MAXIMUM_ATTACK_RANGE 3000.0f
#define AI_DEFAULT_DELAY 1.0f
#define AI_AVOID_TIMESPAN 1.0f


/* ****************************************************************
**************************************************************** */
void npcfighter_event::evaluate(int frameno, atom *source, dbl_llist_manager *hiearchy_manager) {

   npcfighter_event *ptr;
   basic_event *qtr;
   
   ((npc_fighter *)source)->status_flag |= event_flag;

   ptr = alloc();
   
   ptr->reset_timer = reset_timer;
   ptr->timer = reset_timer + timer;

   for (qtr = (basic_event *)((npc_fighter *)source)->event_manager.head; qtr && qtr->timer < reset_timer; qtr = (basic_event *)qtr->next);
   
   if (qtr)
      ((npc_fighter *)source)->event_manager.insert(ptr, qtr);
   else
      ((npc_fighter *)source)->event_manager.append(ptr, NULL);
}


/* *************************************************************
************************************************************* */
npc_fighter::~npc_fighter() {

   if (voicefx)
      voicefx->stop();
}


/* *************************************************************
************************************************************* */
int npc_fighter::query_whatwasi(int type) {

   return (npc_fighter::query_whatami() == type) ? 1 : fighter::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
int npc_fighter::parse(FILE *infile, char *token) {

   if (brain.parse(infile, token))
      return 1;

   return fighter::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void npc_fighter::preprocess(void *data) {

   basic_event *qtr;
   npcfighter_event *ptr[3];
   int i;
   float adjust;
   
   fighter::preprocess(data);

   fallback[0] = fallback[1] = fallback[2] = 0;
   status_flag = STATUS_MODE_AI_IDLE;

   brain.set_source((gameatom *)((geneological_type *)data)->tree->htree);
   brain.set_target_alliance(calc_enemy(flags));
   brain.set_range(-1);

   status.set_primary_mode(PRIMARY_MODE_ROBIN);

   target_dir[0] = old_state.xmx[0][2];
   target_dir[1] = old_state.xmx[1][2];
   target_dir[2] = old_state.xmx[2][2];
   normalize3(target_dir);

   afterburner_timer = 0;

   ptr[0] = new npcfighter_avoid_event;
   ptr[1] = new npcfighter_fire_primary_event;
   ptr[2] = new npcfighter_fire_secondary_event;

   if (status.pilot_param) {
      ptr[0]->reset_timer = status.pilot_param->avoid_delay;
      ptr[1]->reset_timer = status.pilot_param->fire_primary_delay;
      ptr[2]->reset_timer = status.pilot_param->fire_secondary_delay;
   }
   
   else
      ptr[0]->reset_timer = ptr[1]->reset_timer = ptr[2]->reset_timer = AI_DEFAULT_DELAY;

   adjust = (float)(1.0 + 0.1*(id&0x03));

   for (i=0; i<3; i++) {
      ptr[i]->timer = ptr[i]->reset_timer*adjust;
      for (qtr = (basic_event *)event_manager.head; qtr && qtr->timer < ptr[i]->timer; qtr = (basic_event *)qtr->next);
   
      if (qtr)
         event_manager.insert(ptr[i], qtr);
      else
         event_manager.append(ptr[i], NULL);
   }

   if (voicefx) {
      voicefx->stop();
      voicefx = NULL;
   }

   jump_timer = (float)(id & 0x03);
}


/* *************************************************************
************************************************************* */
int npc_fighter::play_voice(int id) {

   sound_id_type *sid;

   if (!status.pilot_param)
      return 0;

   if (voicefx) {
      if ((voicefx->flags & FLAG_SOUND_PLAYING) && voice_priority > id)
         return 0;

      voicefx->flags &= ~FLAG_SOUND_LOCK;
   }

   sid = (sound_id_type *)status.pilot_param->jukebox[id].get();
   if (sid) {
      voicefx = complex->soundmanager->play(sid);

      if (voicefx)
         voicefx->flags |= FLAG_SOUND_LOCK;

      voice_priority = id;
   }

   else
      voicefx = NULL;

   return 1;
}


/* *************************************************************
   calc course and evaluate ai plans
************************************************************* */
void npc_fighter::ai_afterburners(int override_flag) {

   if (!override_flag) {
      afterburner_timer += complex->timer.speedscale;
      if (afterburner_timer < status.afterburner_burntime*0.5f)
         return;
   }

   afterburner_timer = 0;

   if (status.afterburner_timer > status.afterburner_burntime*0.5f+CORRECT) {
      status.afterburner_toggle = 0;
      return;
   }

   if (status_flag & STATUS_MODE_AI_ATTACK) {
      status.afterburner_toggle = (dist2target > MAXIMUM_ATTACK_RANGE);
      return;
   }

   // evading
   status.afterburner_toggle = 1;
}


/* *************************************************************
************************************************************* */
int npc_fighter::npc_ai_avoid(dbl_llist_manager *hiearchy_manager) {

   vector3f work;
   avoid_pathway avoid;

   // if avoiding - time to finish
   if (status_flag & STATUS_MODE_AI_AVOID) {
      avoid_timer -= complex->timer.speedscale;

      if (avoid_timer < 0) {
         status_flag &= ~STATUS_MODE_AI_MASK;
         status_flag |= STATUS_MODE_AI_IDLE;
         return 0;
      }

      return 1;
   }

   work[0] = old_state.xmx[0][2];
   work[1] = old_state.xmx[1][2];
   work[2] = old_state.xmx[2][2];

   if (status_flag & STATUS_MODE_AI_CALC_AVOID) {
      status_flag &= ~STATUS_MODE_AI_CALC_AVOID;

      // if new obstacle
      if (avoid.calc_avoid(this, hiearchy_manager, work, status.speed, status.dorient, target_dir) == RED_ALERT) {
         status_flag &= ~STATUS_MODE_AI_MASK;
         status_flag = STATUS_MODE_AI_AVOID;
         dist2target = 999999.0f;
         avoid_timer = AI_AVOID_TIMESPAN;

         status.afterburner_toggle = 0;
         return 1;
      }

   }
   
   return 0;
}


/* *************************************************************
************************************************************* */
int npc_fighter::npc_ai_pursue() {

   float *bc1;
   float dist, t;
   intercept_pathway prediction_comp;
   float time2target;
   vector3f work;
   
   bc1 = ((old_state.state_flags & STATE_MASK_BOUND) == STATE_FLAG_BSPHERE) ? old_state.bcenter : old_state.center;

   if (!(status.equip_stat[CRADLE_PRIMARY].current && status.find_specific(EQUIP_TARGETING_COMPUTER) && prediction_comp.intercept_prediction(mark.specific, old_state.center, ((equip_weapon *)status.equip_stat[CRADLE_PRIMARY].current->link)->speed, target_pos, &time2target)))
      if ((mark.specific->old_state.state_flags & STATE_MASK_BOUND) == STATE_FLAG_BSPHERE) {
         copyarray3(target_pos, mark.specific->old_state.bcenter);
      }
	 
      else {
         copyarray3(target_pos, mark.specific->old_state.center);
      }
	 
   subeqarray3(target_dir, target_pos, bc1);
   dist = dotproduct3(target_dir, target_dir);

   if (dist < CORRECT) {
      target_dir[0] = old_state.xmx[0][2];
      target_dir[1] = old_state.xmx[1][2];
      target_dir[2] = old_state.xmx[2][2];
      dist = dotproduct3(target_dir, target_dir);
   }

   dist = (float)sqrt(dist);
   t = (float)(1.0/dist);
   smultarray3(target_dir, t);

   if ((old_state.state_flags & STATE_MASK_BOUND) == STATE_FLAG_BSPHERE)
      dist -= old_state.bradius;

   if ((mark.specific->old_state.state_flags & STATE_MASK_BOUND) == STATE_FLAG_BSPHERE)
      dist -= mark.specific->old_state.bradius;

   status_flag &= ~STATUS_MODE_AI_MASK;
   
   work[0] = old_state.xmx[0][2];
   work[1] = old_state.xmx[1][2];
   work[2] = old_state.xmx[2][2];

   if (dotproduct3(work, target_dir) < CORRECT && dist < BREATHING_ROOM_DIST) {
      status_flag |= STATUS_MODE_AI_BREATHING_ROOM;
      target.specific = pursuer.specific = mark.specific;
      target.specific_parent = pursuer.specific_parent = mark.specific_parent;
      target.object = pursuer.object = mark.object;
      dist2target = 999999.0f;
      safe_dist = BREATHING_ROOM_DIST+BREATHING_ROOM_DIST;
      copyarray3(target_dir, work);
      normalize3(target_dir);
   }

   else {
      status_flag |= STATUS_MODE_AI_ATTACK;
      target.specific = mark.specific;
      target.specific_parent = mark.specific_parent;
      target.object = mark.object;
      dist2target = dist;
   }

   ai_afterburners(1);
   return 1;
}


/* *************************************************************
************************************************************* */
int npc_fighter::npc_ai_evade() {

   float *bc1;
   float dist, t;

   // calculate evasive maneuvers
   bc1 = ((old_state.state_flags & STATE_MASK_BOUND) == STATE_FLAG_BSPHERE) ? old_state.bcenter : old_state.center;

   if ((pursuer.specific->old_state.state_flags & STATE_MASK_BOUND) == STATE_FLAG_BSPHERE) {
      copyarray3(target_pos, pursuer.specific->old_state.bcenter);
   }
	 
   else
      copyarray3(target_pos, pursuer.specific->old_state.center);

   subeqarray3(target_dir, bc1, target_pos);

   dist = dotproduct3(target_dir, target_dir);

   if (dist < CORRECT) {
      target_dir[0] = old_state.xmx[0][2];
      target_dir[1] = old_state.xmx[1][2];
      target_dir[2] = old_state.xmx[2][2];
      dist = dotproduct3(target_dir, target_dir);
   }

   dist = (float)sqrt(dist);
   t = (float)(1.0/dist);
   smultarray3(target_dir, t);

   if ((old_state.state_flags & STATE_MASK_BOUND) == STATE_FLAG_BSPHERE)
      dist -= old_state.bradius;

   if ((pursuer.specific->old_state.state_flags & STATE_MASK_BOUND) == STATE_FLAG_BSPHERE)
      dist -= pursuer.specific->old_state.bradius;

   if (dist < safe_dist) {
      target.specific = pursuer.specific;
      target.specific_parent = pursuer.specific_parent;
      target.object = pursuer.object;
      ai_afterburners(0);
      return 1;
   }

   status.afterburner_toggle = 0;
   status_flag &= ~STATUS_MODE_AI_MASK;
   status_flag |= STATUS_MODE_AI_IDLE;
   return 0;
}


/* *************************************************************
************************************************************* */
int npc_fighter::npc_ai_check_orders() {

   sim_task_node *ptr;
   int priority = FLAG_PRIORITY_NULL;
   int i;
   vector3f pos;
   float temp;

   for (ptr = (sim_task_node *)task_manager.head; ptr; ptr = (sim_task_node *)ptr->next) {
      i = ptr->node->query_priority();
      if (i > priority && ptr->node->query_specific_data(TASK_ORDERS_LOCATION, pos))
         priority = i;
   }

   if (priority == FLAG_PRIORITY_NULL)
      return 0;

   subeqarray3(target_dir, pos, old_state.center);
   dist2target = dotproduct3(target_dir, target_dir);
   dist2target = dist2target > 1 ? ((float)(sqrt(dist2target))): 1.0f;
   temp = (float)(1.0/dist2target);
   smultarray3(target_dir, temp);

   status.afterburner_toggle = 0;
   status_flag &= ~STATUS_MODE_AI_MASK;
   status_flag = STATUS_MODE_AI_IDLE;

   return 1;
}


/* *************************************************************
   calc course and evaluate ai plans
************************************************************* */
int npc_fighter::calc_course(dbl_llist_manager *hiearchy_manager) {

   if (npc_ai_avoid(hiearchy_manager))
      return 1;
      
   // if chasing...
   if (!(status_flag & STATUS_MODE_AI_BREATHING_ROOM) && TARGET_STATUS(mark.specific) && npc_ai_pursue())
      return 1;
      
   if ((status_flag & STATUS_MODE_AI_BREATHING_ROOM) && TARGET_STATUS(pursuer.specific) && npc_ai_evade())
      return 1;

   if (npc_ai_check_orders())
      return 1;
      
   // else just mosy on...
   status.afterburner_toggle = 0;
   status_flag &= ~STATUS_MODE_AI_MASK;
   status_flag |= STATUS_MODE_AI_IDLE;
   dist2target = 0;
   return 0;
}


/* *************************************************************
************************************************************* */
void npc_fighter::choose_target(dbl_llist_manager *hiearchy_manager) {

   equip_targeting_computer *tc;
   int priority = FLAG_PRIORITY_NULL;
   sim_task_node *ptr;
   int i;
   target_type old_target;
   
   old_target.object   = mark.object;
   old_target.specific = mark.specific;
   
   // find nearest threat
   if (ai_identify_threat(&threat_manager, &mark, this, NULL))
      priority = ~FLAG_PRIORITY_NULL;
      
   // check orders
   if (priority == FLAG_PRIORITY_NULL)
      for (ptr = (sim_task_node *)task_manager.head; ptr; ptr = (sim_task_node *)ptr->next) {
         i = ptr->node->query_priority();
         if (i > priority && ptr->node->query_specific_data(TASK_ORDERS_TARGET, &mark))
            priority = i;
      }

   if (priority == FLAG_PRIORITY_NULL)
      // if no current valid target, get one!
      if (!GATOM_STATUS(mark.object) || !GQUARK_STATUS(mark.specific, (gameatom *)mark.object->htree))
         brain.get_nearest_target(hiearchy_manager, &complex->teacher, &mark);

   if (GATOM_STATUS(mark.object) && (old_target.object != mark.object || old_target.specific != mark.specific)) {
      tc = (equip_targeting_computer *)status.find_specific(EQUIP_TARGETING_COMPUTER);

      if (tc)
         tc->set_target(&mark);
   }
   
}


/* *************************************************************
************************************************************* */
void npc_fighter::process_intel(dbl_llist_manager *hiearchy_manager, vector4f *mx) {

   orient_pathway orient;
   chase_pathway  chase;
   float dist;
   vector4f r[4], s[4], t[4], imx[4];
   vector3f work, dir;
   
   target.specific = NULL;
   target.specific_parent = NULL;
   target.object = NULL;

   // choose target
   choose_target(hiearchy_manager);
   
   thruster_flag = THRUSTERFLAG_NULL;

   // calc course
   if (calc_course(hiearchy_manager)) {
      inversemx(old_state.xmx, imx);
      matvecmultv(imx, target_dir, work);
      normalize3(work);

      dir[0] = 0;
      dir[1] = 0;
      dir[2] = 1;

      orient.calc_orientation(dir, work, status.dorient, r, AXIS_Y);

      // match roll w/ target
      if ((status_flag & STATUS_MODE_AI_ATTACK) && target.object->htree->query_whatwasi(OBJECT_FIGHTER)) {
         work[0] = target.specific->old_state.xmx[0][1];
         work[1] = target.specific->old_state.xmx[1][1];
         work[2] = target.specific->old_state.xmx[2][1];

         matvecmultv(imx, work);

         if (dotproduct2(work, work) > CORRECT) {
            work[2] = 0;
            normalize2(work);

            dir[0] = 0;
            dir[1] = 1;
            dir[2] = 0;

            orient.calc_orientation(dir, work, status.dorient, s, AXIS_Z);
            copymx4x4o(t, r);
            matmatmulto(t, s, r);
         }

      }

      // calculate thruster state
      decompose_xyz(r, &dir[0], &dir[1], &dir[2]);

      if (dir[0] < -CORRECT)
         thruster_flag |= THRUSTERFLAG_ROLL_CLOCK;
      else if (dir[0] > CORRECT)
         thruster_flag |= THRUSTERFLAG_ROLL_CCLOCK;

      if (dir[1] < -CORRECT)
         thruster_flag |= THRUSTERFLAG_PITCH_UP;
      else if (dir[1] > CORRECT)
         thruster_flag |= THRUSTERFLAG_PITCH_DOWN;

      if (dir[2] < -CORRECT)
         thruster_flag |= THRUSTERFLAG_YAW_RIGHT;
      else if (dir[2] > CORRECT)
         thruster_flag |= THRUSTERFLAG_YAW_LEFT;

      copymx4x4o(t, initxform);
      matmatmulto(t, r, initxform);
   }

   dir[0] = initxform[0][2];
   dir[1] = initxform[1][2];
   dir[2] = initxform[2][2];

   normalize3(dir);

   copyarray3(work, status.vel);
   dist = status.speed;

   chase.calc_velocity(dir, target_dir, dist2target, status.query_maxspeed(), status.query_accel(), work, status.speed, status.vel, &status.speed);

   dist = status.speed - dist;

   if (dist > CORRECT)
      thruster_flag |= THRUSTERFLAG_ENGINE_FORWARD;
   else if (dist < -CORRECT)
      thruster_flag |= THRUSTERFLAG_ENGINE_BACKWARD;

   dist = status.speed * complex->timer.speedscale;
   initxform[0][3] += dist * status.vel[0];
   initxform[1][3] += dist * status.vel[1];
   initxform[2][3] += dist * status.vel[2];
}


/* *************************************************************
************************************************************* */
void npc_fighter::choose_secondary() {

   switch (target.object->htree->flags & GAMEFLAG_DESC_MASK) {
      case GAMEFLAG_FIGHTER:
      case GAMEFLAG_BOMBER:
         status.select_secondary(SECONDARY_MODE_GUIDED);
         return;

      case GAMEFLAG_STATION:
      case GAMEFLAG_CAPSHIP:
         status.select_secondary(SECONDARY_MODE_MAX_DAMAGE);
         return;

      default:
         status.select_secondary(SECONDARY_MODE_OTHER);
         return;
   }

}


/* *************************************************************
************************************************************* */
void npc_fighter::process_fire_control(dbl_llist_manager *hiearchy_manager) {

   vector3f dir;
   equip_weapon *weapon;
   equip_launcher *weapon2;
   equip_targeting_computer *tc;

   // check weapon and target status
   if (!(status_flag & STATUS_MODE_AI_ATTACK) || !TARGET_STATUS(target.specific))
      return;

   if (status_flag & STATUS_MODE_AI_FIRE_PRIMARY) {
      weapon = status.query_fire(EQUIPCAT_PRIMARY_WEAPON);

      if (weapon) {
         dir[0] = state.xmx[0][2];
         dir[1] = state.xmx[1][2];
         dir[2] = state.xmx[2][2];
         normalize3(dir);

         // decide to fire primary
         if (dist2target < CORRECT || query_fire_primary(this, flags, hiearchy_manager, state.center, dir, weapon->max_range, target.specific, target_dir, dist2target, target_pos, target.specific->old_state.bradius))
            status.fire_weapon(&target, state.xmx, EQUIPCAT_PRIMARY_WEAPON);
      }
  
      status_flag &= ~STATUS_MODE_AI_FIRE_PRIMARY;
   }
   
   if (status_flag & STATUS_MODE_AI_FIRE_SECONDARY) {
      if (!(status_flag & STATUS_MODE_AMMO_IN_FLIGHT))  {
         choose_secondary();
         weapon2 = (equip_launcher *)status.query_fire(EQUIPCAT_SECONDARY_WEAPON);

         // decide to fire secondary
         if (weapon2) {
            if (!weapon) {
               dir[0] = state.xmx[0][2];
               dir[1] = state.xmx[1][2];
               dir[2] = state.xmx[2][2];
               normalize3(dir);
            }

            if (weapon2->query_guidance()) {
               tc = (equip_targeting_computer *)status.find_specific(EQUIP_TARGETING_COMPUTER);

               if ((!tc || tc->missilelock_countdown < 0) && query_fire_secondary(this, flags, hiearchy_manager, state.center, dir, weapon2->max_range, target.specific, target_dir, dist2target)) {
                  status.fire_weapon(&target, state.xmx, EQUIPCAT_SECONDARY_WEAPON);
                  status_flag |= STATUS_MODE_AMMO_IN_FLIGHT;
               }

            }

            else if (query_fire_secondary(this, flags, hiearchy_manager, state.center, dir, weapon2->max_range, target.specific, target_dir, dist2target)) {
               status.fire_weapon(&target, state.xmx, EQUIPCAT_SECONDARY_WEAPON);
               status_flag |= STATUS_MODE_AMMO_IN_FLIGHT;
            }

         }
	 
      }

      status_flag &= ~STATUS_MODE_AI_FIRE_SECONDARY;
   }

}


/* *************************************************************
************************************************************* */
int npc_fighter::set_specific_data(unsigned int type, void *data) {

   hit_type *htr;

   switch (type) {

      case DATAFLAG_SECONDARY_DETONATION:
         status_flag &= ~STATUS_MODE_AMMO_IN_FLIGHT;
         return 1;

      case DATAFLAG_KILL_NOTICE:

         // check to see if kill ally by accident (?)
         if (flags & GAMEFLAG_ALLIANCE_MASK & ((gameatom *)data)->flags)
            return 0;

         // check to see if entity is on the player's side or person kills target
         if (global_player == (gameatom *)data) {
            if (!(flags & GAMEFLAG_ALLIANCE_MASK & global_player->flags))
               play_voice(VOICE_PILOT_TRIUMPH);
         }

         else if (flags & GAMEFLAG_ALLIANCE_MASK & global_player->flags)
            play_voice(VOICE_PILOT_TRIUMPH);

         return 1;

      case DATAFLAG_KILLED_BY_NOTICE:
         // is killer the player ?

         if (!global_player)
            return 0;

         if (((atom_list_type *)data)->htree == global_player) {
            // is this an ally of the player ?
            if (global_player->flags & GAMEFLAG_ALLIANCE_MASK & flags) {
               play_voice(VOICE_PILOT_TRAITOR);	       
               attack_traitor((atom_list_type *)data);
            }

            else
               play_voice(VOICE_PILOT_DEATH);	       

            if (sheader)
               for (htr = (hit_type *)sheader->player_hit_manager.head; htr; htr = (hit_type *)htr->next)
                  if (htr->target == this) {
                     sheader->player_hit_manager.remove(htr);
                     delete htr;
                     break;
                  }

         }

         // is this an ally of the player ?
         else if (global_player->flags & GAMEFLAG_ALLIANCE_MASK & flags)
            play_voice(VOICE_PILOT_DEATH);	       

         return 1;

      default:
         break;
   }

   return fighter::set_specific_data(type, data);
}


/* *************************************************************
************************************************************* */
void npc_fighter::update(dbl_llist_manager *hiearchy_manager, quark *parent) {

   sim_task_node *ptr;
   shockwave *sfx;
   explosion *efx;

   if (flags & QUARK_FLAG_ACTIVE)
      for (ptr = (sim_task_node *)task_manager.head; ptr; ptr = (sim_task_node *)ptr->next)
         if (ptr->node->query_whatami() == DARKSIM_JUMP) {
            jump_timer -= complex->timer.speedscale;
	    
            if (jump_timer <= 0) {
               ptr->node->owner->flags |= DARKSIM_FLAG_JUMP;

               sfx = (shockwave *)complex->teacher.issue(OBJECT_SHOCKWAVE);
               sfx->init(old_state.xmx, 5, 5000);

               efx = (explosion *)complex->teacher.issue(OBJECT_EXPLOSION);
               efx->init(old_state.xmx, 5, 5000);
               flags &= ~QUARK_FLAG_ACTIVE;
            }
	    
            break;
         }

   fighter::update(hiearchy_manager, parent);
}


