

#ifdef WIN32

#include <sys/timeb.h>
#include "WIN_W32.h"

#else

#include "WIN_X.h"

#endif

#include "darkgine.h"
#include "darkmenu.h"

#define SOUND_STATE_IDLE            0
#define SOUND_STATE_SLIDER_SELECT   1
#define SOUND_STATE_FUNCTION_SELECT 2
#define SOUND_STATE_QUIT            3

#define SOUND_FUNCTION_SAVE     0
#define SOUND_FUNCTION_CANCEL   1

char FILENAME_SOUND_MENU[]      = "config/sound.mnu";
char FILENAME_SOUND_SCENE[]     = "mission/sndmenu.cnt";

/* **************************************************
************************************************** */
int sound_state_idle(sound_menu_widget *sound_menu, menu_data_type *data, int *state, int winx, int winy) {

   generic_widget *ptr;

   ptr = sound_menu->select((int)((io[0]*MAX_WIN_WIDTH)/winx), (int)((io[1]*MAX_WIN_HEIGHT)/winy));

   while (ptr && !(ptr->flags & WIDGETFLAG_SELECTABLE))
      ptr = ptr->parent;
      
   if (!ptr || (ptr->flags & WIDGETFLAG_LOCK_OPTION))
      return 0;
	   
   if (ptr->query_whatwasi(WIDGET_BUTTON)) {
      if (io[2] == BUTTON_UP) {
         ptr->flags |= WIDGETFLAG_SELECTED;
         ptr->refresh();
         data->selected = ptr;

         *state = SOUND_STATE_FUNCTION_SELECT;
	 
         return 1;
      }

   }

   if (ptr->query_whatwasi(WIDGET_HSLIDER)) {
      if (io[2] == BUTTON_DOWN) {
         ptr->flags |= WIDGETFLAG_SELECTED;
         data->selected = ptr;

         *state = SOUND_STATE_SLIDER_SELECT;
         return 1;

      }

   }

   if (!(ptr->flags & WIDGETFLAG_SELECTED)) {
      ptr->flags |= WIDGETFLAG_HIGHLIGHT;
      ptr->refresh();
      data->highlight = ptr;
   }

   return 0;
}


/* **************************************************
************************************************** */
void sound_state_function_select(menu_data_type *data, int *state) {
   
   switch (((button_widget *)data->selected)->action_code) {

      case SOUND_FUNCTION_SAVE:
         global_music_volume = complex->soundmanager->volume[SOUND_MUSIC];
         global_sfx_volume   = complex->soundmanager->volume[SOUND_SFX];
         global_voice_volume = complex->soundmanager->volume[SOUND_VOICE];
         writeinput(FILENAME_SETUP);

         data->selected = NULL;
         data->highlight = NULL;
         *state = SOUND_STATE_QUIT;
         return;
	     
//      case SOUND_FUNCTION_CANCEL:
      default:
         data->selected = NULL;
         data->highlight = NULL;
         complex->soundmanager->volume[SOUND_MUSIC] = global_music_volume;
         complex->soundmanager->volume[SOUND_SFX]   = global_sfx_volume;
         complex->soundmanager->volume[SOUND_VOICE] = global_voice_volume;
         *state = SOUND_STATE_QUIT;
         return;
   }
   
}


/* **************************************************
************************************************** */
void sound_state_slider_select(menu_data_type *data, int winx, int winy) {

   float iscale = (float)(MAX_WIN_WIDTH/winx);
   float t;
   int width, height;

   t = io[0]*iscale;

   width  = data->selected->x[1] - data->selected->x[0];
   height = data->selected->y[1] - data->selected->y[0];

   t -= data->selected->x[0] + (width>>3);
   t *= 4.0f/(width*3.0f);

   if (t < 0)
      t = 0;
   else if (t > 1.0f)
      t = 1.0f;

   ((sound_slider_widget *)data->selected)->set_value(t);
   ((sound_slider_widget *)data->selected)->button->x[0] = ((sound_slider_widget *)data->selected)->x[0] + ((width-height)>>3) + ((int)(width*0.75*t));
   ((sound_slider_widget *)data->selected)->button->x[1] = ((sound_slider_widget *)data->selected)->button->x[0] + (height>>2);
}


/* **************************************************
************************************************** */
void sound_volume_menu(BLTwindow *win) {

   int       framecount = 0;
   vector4f  mx[4];
   atom_list_type  *atr;
   camera    *camptr;
   vector4f  frustum[FRUSTUM_COUNT];

   sound_menu_widget sound_menu;
   menu_data_type string_data;
   int done = 0;
   int state = SOUND_STATE_IDLE;
   int old_mousex;
   sound_id_type menu_sound;
   sound_id_type highlight_sound;
   sound_type *menu_sndfx;
   sound_id_type sound_id[SOUND_MAX_TYPES];
   sound_type *sndfx[SOUND_MAX_TYPES];
   vector3f pos = { 0, 0, 0 };
   vector3f vup = { 0, 1, 0 };
   vector3f dir = { 0, 0, 1 };
   generic_widget *ptr;
   int i;

   init_mx(mx);
   complex->timer.pause(1);

   menu_sound.name.stringcpy("sound/stereo/menupulldown.wav"); 
   menu_sound.volume(100);
   menu_sound.flags = FLAG_SOUND_WAV;
   complex->soundmanager->find(&menu_sound);
   menu_sndfx = complex->soundmanager->play(&menu_sound);

   if (menu_sndfx)
      menu_sndfx->flags |= FLAG_SOUND_LOCK;

   highlight_sound.name.stringcpy("sound/stereo/lazer_026.wav"); 
   highlight_sound.volume(90);
   highlight_sound.flags = FLAG_SOUND_WAV;
   complex->soundmanager->find(&highlight_sound);

   sound_id[SOUND_MUSIC].name.stringcpy("sound/music/grunge.wav"); 
   sound_id[SOUND_MUSIC].volume(100);
   sound_id[SOUND_MUSIC].flags = FLAG_SOUND_WAV | FLAG_SOUND_LOOPING | FLAG_SOUND_MUSIC;
   complex->soundmanager->find(&sound_id[SOUND_MUSIC]);
   sndfx[SOUND_MUSIC] = complex->soundmanager->play(&sound_id[SOUND_MUSIC]);

   sound_id[SOUND_SFX].name.stringcpy("sound/whoosh.wav"); 
   sound_id[SOUND_SFX].volume(100);
   sound_id[SOUND_SFX].flags = FLAG_SOUND_WAV | FLAG_SOUND_3D | FLAG_SOUND_LOOPING;
   complex->soundmanager->find(&sound_id[SOUND_SFX]);
   sndfx[SOUND_SFX] = complex->soundmanager->play(&sound_id[SOUND_SFX]);

   sound_id[SOUND_VOICE].name.stringcpy("sound/stereo/flygirl_ki00.wav"); 
   sound_id[SOUND_VOICE].volume(100);
   sound_id[SOUND_VOICE].flags = FLAG_SOUND_WAV | FLAG_SOUND_LOOPING | FLAG_SOUND_VOICE;
   complex->soundmanager->find(&sound_id[SOUND_VOICE]);
   sndfx[SOUND_VOICE] = complex->soundmanager->play(&sound_id[SOUND_VOICE]);

   parse_animate_list(&complex->animation_manager, FILENAME_SOUND_SCENE);

   io[0] = win->mapbuffer.maxx>>1;
   io[1] = win->mapbuffer.maxy>>1;
   io[2] = 0;
   io[3] = 0;
   
   sound_menu.read_sound_menu(FILENAME_SOUND_MENU, &string_data);

   vfx_init(&complex->animation_manager, win->mapbuffer.maxx, win->mapbuffer.maxy);

   // find camera
   for (camptr=NULL, atr=(atom_list_type *)complex->animation_manager.head; atr && !camptr; atr=(atom_list_type *)atr->next)
      camptr = (camera *)atr->htree->find_ob(NULL, OBJECT_CAMERA);

   camptr->set_dim(win->mapbuffer.maxx, win->mapbuffer.maxy);

   complex->timer.pause(0);

   // first frame :)
   for (atr=(atom_list_type *)complex->animation_manager.head; atr; atr=(atom_list_type *)atr->next) {
      atr->htree->new_action(0, &complex->animation_manager);
      atr->htree->begin(&complex->animation_manager, NULL, mx);
   }

   for (atr=(atom_list_type *)complex->animation_manager.head; atr; atr=(atom_list_type *)atr->next)
      atr->htree->update(&complex->animation_manager, NULL);

   while (!done) {

      while (!complex->timer.tick());

      // process user input
      event_proc(win);

      // process objects
   for (atr=(atom_list_type *)complex->animation_manager.head; atr; atr=(atom_list_type *)atr->next) {
         atr->htree->new_action(framecount, &complex->animation_manager);
         atr->htree->whereami(&complex->animation_manager, NULL, mx);
      }

      for (atr=(atom_list_type *)complex->animation_manager.head; atr; atr=(atom_list_type *)atr->next)
         atr->htree->update(&complex->animation_manager, NULL);

      // send objects to rendering buffer
      proc.engine_init();
           
      if (camptr) {
         camptr->calc_clip_plane();
         camptr->query_frustum(frustum);

         for (atr=(atom_list_type *)complex->animation_manager.head; atr; atr=(atom_list_type *)atr->next)
            atr->htree->render_object(&proc, NULL, frustum, FRUSTUM_CLIP_ALL);
	    
         proc.spawn(framecount, &win->mapbuffer);
      }
      
      complex->gfx->gfx2DMode(win->mapbuffer.maxx, win->mapbuffer.maxy);
      vfx_dazzle_the_crowd(&complex->animation_manager, &win->mapbuffer, camptr);

      ptr = string_data.highlight;

      if (string_data.highlight) {
         string_data.highlight->flags &= ~WIDGETFLAG_HIGHLIGHT;
         string_data.highlight->refresh();
         string_data.highlight = NULL;
      }
	       
      switch (state) {
         case SOUND_STATE_SLIDER_SELECT:
            if (old_mousex != io[0]) {
               sound_state_slider_select(&string_data, win->mapbuffer.maxx, win->mapbuffer.maxy);

               for (i=0; i<SOUND_MAX_TYPES; i++)
                  if (sndfx[i])
                     sndfx[i]->volume(100);
            }

            if (io[2] == BUTTON_UP)
               state = SOUND_STATE_IDLE;

            break;
	    
         case SOUND_STATE_FUNCTION_SELECT:
            sound_state_function_select(&string_data, &state);
            break;
	 
         case SOUND_STATE_IDLE:
            sound_state_idle(&sound_menu, &string_data, &state, win->mapbuffer.maxx, win->mapbuffer.maxy);
            if (state == SOUND_STATE_SLIDER_SELECT)
               old_mousex = io[0];

            break;
	    
//         case SOUND_STATE_QUIT:
         default:
            done = 1;
      }

      if (string_data.highlight && ptr != string_data.highlight)
         complex->soundmanager->play(&highlight_sound);

      sound_menu.render(&win->mapbuffer);
      render_mouse(&win->mapbuffer);
      complex->gfx->gfxBitblt(win, &win->mapbuffer);
      complex->soundmanager->update(pos, dir, vup);
   }

   if (menu_sndfx)
      menu_sndfx->stop();

   for (i = 0; i < SOUND_MAX_TYPES; i++)
      if (sndfx[i])
         sndfx[i]->stop();

   menu_sndfx = complex->soundmanager->play(&menu_sound);
   if (menu_sndfx) {
      menu_sndfx->flags |= FLAG_SOUND_LOCK;

      while (menu_sndfx->flags & FLAG_SOUND_PLAYING)
         complex->soundmanager->update(pos, dir, vup);

      menu_sndfx->stop();
   }

   endgame(win);
}

