
#ifdef WIN32

#include "WIN_W32.h"

#else

#include "WIN_X.h"

#endif

#include <GL/gl.h>

#include "darkmenu.h"
#include "darkgine.h"

#define MAIN_STATE_RESUME       0  
#define MAIN_STATE_LOAD         1  
#define MAIN_STATE_SAVE         2  
#define MAIN_STATE_NEW          3  
#define MAIN_STATE_SOUND_VOLUME 4 
#define MAIN_STATE_CONTROLLER   5 
#define MAIN_STATE_CREDITS      6 
#define MAIN_STATE_EXIT         7

char FILENAME_MAIN_MENU[]       = "config/main.mnu";
char FILENAME_MAIN_MENU_SCENE[] = "mission/mainmenu.cnt";

vector4i io;


/* **************************************************
************************************************** */
void event_proc(BLTwindow *win) {

   int i;

#ifdef WIN32

   MSG message;
   
   // redundant in user_io->process_events();
   // this is here to detect when a window comes down right away
   while (PeekMessage(&message, NULL, 0, 0, PM_REMOVE)) {

      // If we get a quit message, drop out to quit
      if (message.message == WM_QUIT)
         return;
	 
      DispatchMessage(&message);
   }

#endif

   complex->userinput->process_events(&complex->timer);

   io[0] = (int)((1 + complex->userinput->joyaxis[AXIS_MOUSE_X])*win->mapbuffer.maxx*0.5);
   io[1] = (int)((1 - complex->userinput->joyaxis[AXIS_MOUSE_Y])*win->mapbuffer.maxy*0.5);

   if (complex->userinput->status_buttonpress & BUTTONLEFT)
      io[2] = BUTTON_DOWN;
   else if (io[2] == BUTTON_DOWN)
      io[2] = BUTTON_UP;
   else
      io[2] = 0;

   io[3] = 0;

   for (i=0; i<MAXKEYS; i++)
      if (complex->userinput->pure_keypress[i]) {
         io[3] = i;
         break;
      }

}


/* **************************************************
************************************************** */
void render_mouse(mapul *mapbuffer) {
      
   vector4uc blue = { 0, 0, 255, 255 };
   vector2i v;

   complex->gfx->gfxColor3ubv(blue);
   complex->gfx->gfxBegin(GFX_LINES, mapbuffer);
      v[0] = io[0];
      v[1] = io[1] - 5;
      complex->gfx->gfxVertex2iv(v);
      v[1] = io[1] + 5;
      complex->gfx->gfxVertex2iv(v);
      v[0] = io[0] - 5;
      v[1] = io[1];
      complex->gfx->gfxVertex2iv(v);
      v[0] = io[0] + 5;
      complex->gfx->gfxVertex2iv(v);
   complex->gfx->gfxEnd();
}


/* **************************************************
************************************************** */
void main_menu_init(camera **camptr, sound_id_type *sound_id, sound_type **sndfx, texbase **tob, string_type *backname, int winx, int winy) {

   atom_list_type *atr;
   vector4f mx[4];
   
   init_mx(mx);

   complex->userinput->flag_on(FLAG_IO_MOUSE_CONSTRAIN);
   complex->gfx->gfxDisable(GFX_CLEAR_COLOR_BUFFER);
   complex->timer.pause(1);

   // background   
   *tob = (texbase *)((frame_manager *)global_resource_manager)->read_tex(backname->string);

   // ambient sound
   sound_id->name.stringcpy("sound/stereo/insideshipconsole.wav"); 
   sound_id->volume(100);
   sound_id->flags = FLAG_SOUND_WAV | FLAG_SOUND_LOOPING | FLAG_SOUND_MUSIC;
   complex->soundmanager->find(sound_id);
   *sndfx = complex->soundmanager->play(sound_id);

   if (*sndfx)
      (*sndfx)->flags |= FLAG_SOUND_LOCK;

   // load scene
   parse_animate_list(&complex->animation_manager, FILENAME_MAIN_MENU_SCENE);

   // find camera
   for (*camptr=NULL, atr=(atom_list_type *)complex->animation_manager.head; atr && !*camptr; atr=(atom_list_type *)atr->next)
      *camptr = (camera *)atr->htree->find_ob(NULL, OBJECT_CAMERA);

   (*camptr)->set_dim(winx, winy);

   // init f/x
   vfx_init(&complex->animation_manager, winx, winy);

   complex->timer.pause(0);

   // first frame :)
   for (atr=(atom_list_type *)complex->animation_manager.head; atr; atr=(atom_list_type *)atr->next) {
      atr->htree->new_action(0, &complex->animation_manager);
      atr->htree->begin(&complex->animation_manager, NULL, mx);
   }

   for (atr=(atom_list_type *)complex->animation_manager.head; atr; atr=(atom_list_type *)atr->next)
      atr->htree->update(&complex->animation_manager, NULL);
}

      
/* **************************************************
************************************************** */
void main_menu_shutdown(BLTwindow *win, sound_type **sndfx) {

   if (*sndfx)
      (*sndfx)->stop();

   endgame(win);
   
   complex->gfx->gfxEnable(GFX_CLEAR_COLOR_BUFFER);
}


/* **************************************************
************************************************** */
int main_loop(BLTwindow *win, menu_data_type *data, main_menu_widget *main_menu, sound_type **sndfx) {

   generic_widget *ptr;

   ptr = main_menu->select((int)((io[0]*MAX_WIN_WIDTH)/win->mapbuffer.maxx), (int)((io[1]*MAX_WIN_HEIGHT)/win->mapbuffer.maxy));

   while (ptr && !(ptr->flags & WIDGETFLAG_SELECTABLE))
      ptr = ptr->parent;
      
   if (!ptr || !ptr->query_whatwasi(WIDGET_BUTTON))
      return 0;

   if (io[2] == BUTTON_UP) {
      switch (((button_widget *)ptr)->action_code) {
         case MAIN_STATE_RESUME:
            main_menu_shutdown(win, sndfx);
            gameloop(win);
            return -1;
   
         case MAIN_STATE_LOAD:  
            return 0;
   
         case MAIN_STATE_SAVE:  
            return 0;
   
         case MAIN_STATE_NEW:  
            return 0;
   
         case MAIN_STATE_SOUND_VOLUME:  
            main_menu_shutdown(win, sndfx);
            sound_volume_menu(win);
            return -1;
   
         case MAIN_STATE_CONTROLLER: 
            main_menu_shutdown(win, sndfx);
            render_io_menu(win);
            return -1;
   
         case MAIN_STATE_CREDITS: 
            main_menu_shutdown(win, sndfx);
            credits_menu(win);
            return -1;

//         case MAIN_STATE_EXIT: 
         default:
            return 1;
      }

      // should never get here
      return 0;
   }

   ptr->flags |= WIDGETFLAG_HIGHLIGHT;
   ptr->refresh();
   data->highlight = ptr;

   return 0;
}


/* **************************************************
************************************************** */
void render_main_menu(BLTwindow *win) {

   vector4f  mx[4];
   main_menu_widget main_menu;
   menu_data_type string_data;
   atom_list_type *atr;
   camera    *camptr;
   int ret = -1;
   int framecount = 0;
   vector4f  frustum[FRUSTUM_COUNT];
   TIME_STRUCT t;
   string_type backname;
   texbase *tob;
   sound_id_type sound_id;
   sound_id_type highlight_sound;
   sound_type *sndfx = NULL;
   generic_widget *ptr;

   init_mx(mx);

   io[0] = win->mapbuffer.maxx>>1;
   io[1] = win->mapbuffer.maxy>>1;
   io[2] = 0;
   io[3] = 0;

   main_menu.read_main_menu(FILENAME_MAIN_MENU, &backname, &string_data);

   // rest of frames ...
   do {

      if (ret == -1) {
         main_menu_init(&camptr, &sound_id, &sndfx, &tob, &backname, win->mapbuffer.maxx, win->mapbuffer.maxy);

         highlight_sound.name.stringcpy("sound/stereo/lazer_026.wav"); 
         highlight_sound.volume(90);
         highlight_sound.flags = FLAG_SOUND_WAV;
         complex->soundmanager->find(&highlight_sound);
      }

      while (!complex->timer.tick());

      // process user input
      event_proc(win);

      complex->gfx->gfxPaste2D(&win->mapbuffer, tob, NULL, 0,0,win->mapbuffer.maxx, win->mapbuffer.maxy, GFX_NULL);

      // process objects
      for (atr=(atom_list_type *)complex->animation_manager.head; atr; atr=(atom_list_type *)atr->next) {
         atr->htree->new_action(framecount, &complex->animation_manager);
         atr->htree->whereami(&complex->animation_manager, NULL, mx);
      }

      for (atr=(atom_list_type *)complex->animation_manager.head; atr; atr=(atom_list_type *)atr->next)
         atr->htree->update(&complex->animation_manager, NULL);

      // send objects to rendering buffer
      proc.engine_init();

      if (camptr) {
         camptr->calc_clip_plane();
         camptr->query_frustum(frustum);

         for (atr=(atom_list_type *)complex->animation_manager.head; atr; atr=(atom_list_type *)atr->next)
            atr->htree->render_object(&proc, NULL, frustum, FRUSTUM_CLIP_ALL);
 
         proc.spawn(framecount, &win->mapbuffer);
      }

      complex->gfx->gfx2DMode(win->mapbuffer.maxx, win->mapbuffer.maxy);
      vfx_dazzle_the_crowd(&complex->animation_manager, &win->mapbuffer, camptr);
      main_menu.render(&win->mapbuffer);
      render_mouse(&win->mapbuffer);

      ptr = string_data.highlight;
      if (string_data.highlight) {
         string_data.highlight->flags &= ~WIDGETFLAG_HIGHLIGHT;
         string_data.highlight->refresh();
         string_data.highlight = NULL;
      }
	       
      ret = main_loop(win, &string_data, &main_menu, &sndfx);

      // render to screen
      if (ret != -1) {
         if (string_data.highlight && ptr != string_data.highlight)
            complex->soundmanager->play(&highlight_sound);

         complex->gfx->gfxBitblt(win, &win->mapbuffer);
         GETTIME(&t);
         global_resource_manager->update((float)TIME2FLOAT(t));
         framecount++;
      }
   
      else 
         framecount = 0;      

   } while (ret != 1);
   
   main_menu_shutdown(win, &sndfx);
}
