

#ifdef WIN32

#include <sys/timeb.h>
#include "WIN_W32.h"

#else

#include "WIN_X.h"

#endif

#include "darkgine.h"
#include "darkmenu.h"

#define KEYBOARD_STATE_IDLE            0
#define KEYBOARD_STATE_KEY_SELECT      1
#define KEYBOARD_STATE_BUTTON_SELECT   2
#define KEYBOARD_STATE_FUNCTION_SELECT 3
#define KEYBOARD_STATE_QUIT            4

char FILENAME_KEYBOARD_MENU[]   = "config/io.mnu";


/* **************************************************
************************************************** */
int keyboard_state_idle(keyboard_menu_widget *keyboard_menu, keyboard_data_type *data, int *state, int winx, int winy) {

   generic_widget *ptr;

   ptr = keyboard_menu->select((int)((io[0]*MAX_WIN_WIDTH)/winx), (int)((io[1]*MAX_WIN_HEIGHT)/winy));

   while (ptr && !(ptr->flags & WIDGETFLAG_SELECTABLE))
      ptr = ptr->parent;
      
   if (!ptr || (ptr->flags & WIDGETFLAG_LOCK_OPTION))
      return 0;
	
   if (ptr->query_whatwasi(WIDGET_BUTTON)) {
      if (io[2] == BUTTON_UP) {
         ptr->flags |= WIDGETFLAG_SELECTED;
         ptr->refresh();
         data->selected = ptr;

         if (ptr->query_whatwasi(WIDGET_KEY))
            *state = KEYBOARD_STATE_KEY_SELECT;
         else if (ptr->query_whatwasi(WIDGET_MOUSEBUTTON))
            *state = KEYBOARD_STATE_BUTTON_SELECT;
         else
            *state = KEYBOARD_STATE_FUNCTION_SELECT;
	 
         return 1;
      }

   }

   if (!(ptr->flags & WIDGETFLAG_SELECTED)) {
      ptr->flags |= WIDGETFLAG_HIGHLIGHT;
      ptr->refresh();
      data->highlight = ptr;
   }

   return 0;
}


/* **************************************************
************************************************** */
int keyboard_state_key_select(mapul *mapbuffer, keyboard_data_type *data, keyboard_menu_widget *keyboard_menu, int *state) {

   float scale;
   int sx, sy;
   char message[] = "Press a key";
   int i;
   perform_data_type pdt;
   
   // check to se if nothing has been pressed
   if (!io[3]) {
      scale = (float)((mapbuffer->maxy*10)/MAX_WIN_HEIGHT);
      sy = (int)(scale*3.0);

      complex->font->set_scale(scale);

      sx = (int)(0.5 *(mapbuffer->maxx + ((424.0*mapbuffer->maxx)/MAX_WIN_WIDTH) - complex->font->pixel_length((unsigned char *)message)));

      complex->font->set_color((char)255, (char)255, (char)64);
      complex->font->print(sx, sy, (unsigned char *)message, mapbuffer);
      return 0;
   }

   // convert platform keystroke to internal key mapping
   for (i=0; i<256 && io[3] != complex->userinput->keyboard_driver[i]; i++);

   if (i==256)
      return 0;

   switch (i) {
      case KEYSTROKE_1:
      case KEYSTROKE_2:
      case KEYSTROKE_3:
      case KEYSTROKE_4:
      case KEYSTROKE_5:
      case KEYSTROKE_6:
      case KEYSTROKE_7:
      case KEYSTROKE_8:
      case KEYSTROKE_9:
         return 0;
	 
      default:
         break;
   }
   
   if (i) {
      ((key_widget *)data->selected)->update(i, data);

      pdt.widget = data->selected;
      pdt.data = data;
      pdt.tempi = 0;
      keyboard_menu->perform(WIDGETTASK_CLEAR_UNIQUE, &pdt);
   }
   
   data->selected->flags &= ~WIDGETFLAG_SELECTED;
   data->selected->refresh();
   *state = KEYBOARD_STATE_IDLE;
   return 1;
}


/* **************************************************
************************************************** */
int keyboard_state_button_select(mapul *mapbuffer, keyboard_data_type *data, keyboard_menu_widget *keyboard_menu, int *state) {

   generic_widget *ptr;
   float scale;
   int sx, sy;
   char message[] = "Select a Key Button";
     
   // convert platform keystroke to internal key mapping
   if (complex->userinput->key_stroke(KEYSTROKE_ESC)) {
      data->selected->flags &= ~WIDGETFLAG_SELECTED;
      data->selected->refresh();
      *state = KEYBOARD_STATE_IDLE;
      return 1;
   }

   // print message 
   scale = (float)((mapbuffer->maxy*10)/MAX_WIN_HEIGHT);
   sy = (int)(scale*3.0);

   complex->font->set_scale(scale);

   sx = (int)(0.5 *(mapbuffer->maxx + ((424.0*mapbuffer->maxx)/MAX_WIN_WIDTH) - complex->font->pixel_length((unsigned char *)message)));

   complex->font->set_color((char)255, (char)255, (char)64);
   complex->font->print(sx, sy, (unsigned char *)message, mapbuffer);

   // find hit
   ptr = keyboard_menu->select((int)((io[0]*MAX_WIN_WIDTH)/mapbuffer->maxx), (int)((io[1]*MAX_WIN_HEIGHT)/mapbuffer->maxy));

   while (ptr && !(ptr->flags & WIDGETFLAG_SELECTABLE))
      ptr = ptr->parent;
      
   if (!ptr || !ptr->query_whatwasi(WIDGET_KEY))
      return 0;
   
   if (io[2] != BUTTON_UP) {
      ptr->flags |= WIDGETFLAG_HIGHLIGHT;
      ptr->refresh();
      data->highlight = ptr;
      return 0;
   }

   ((mousebutton_widget *)data->selected)->update(((button_widget *)ptr)->action_code, data);

   data->selected->flags &= ~WIDGETFLAG_SELECTED;
   data->selected->refresh();
   *state = KEYBOARD_STATE_IDLE;
   return 1;
}


/* **************************************************
************************************************** */
void keyboard_state_function_select(keyboard_data_type *data, keyboard_menu_widget *keyboard_menu, int *state) {

   switch (((button_widget *)data->selected)->action_code) {

      case KEYBOARD_FUNCTION_KEYBOARD:
      case KEYBOARD_FUNCTION_MOUSE:
      case KEYBOARD_FUNCTION_JOYSTICK:
         data->controller->flags &= ~WIDGETFLAG_SELECTED;
         data->controller->refresh();
	 	    
         data->controller = data->selected;
         data->controller->flags |= WIDGETFLAG_SELECTED;
         data->controller->refresh();
         *state = KEYBOARD_STATE_IDLE;
         return;   
   
      case KEYBOARD_FUNCTION_SAVE:

         data->write_commands(FILENAME_CURRENT_COMMANDS);
         complex->userinput->read_commands(FILENAME_CURRENT_COMMANDS);

         switch (((button_widget *)data->controller)->action_code) {
            case KEYBOARD_FUNCTION_KEYBOARD:
               CONTROLLER = CONTROLKEYBOARD;
               break;
		  
            case KEYBOARD_FUNCTION_MOUSE:
               CONTROLLER = CONTROLMOUSE;
               break;
		  
//            case KEYBOARD_FUNCTION_JOYSTICK:
            default:
               CONTROLLER = CONTROLJOYSTICK;
               break;	       
         }

         writeinput(FILENAME_SETUP);
	    
         data->controller = NULL;	    
         data->selected = NULL;
         data->highlight = NULL;
         *state = KEYBOARD_STATE_QUIT;
         return;
	     
      case KEYBOARD_FUNCTION_DEFAULT:
         data->controller = NULL;	    
         data->selected = NULL;
         data->highlight = NULL;
	 
         keyboard_menu->read_keyboard_menu(FILENAME_KEYBOARD_MENU, NULL, NULL, data);
         *state = KEYBOARD_STATE_IDLE;
         return;
	     
//      case KEYBOARD_FUNCTION_CANCEL:
      default:
         data->controller = NULL;	    
         data->selected = NULL;
         data->highlight = NULL;
         *state = KEYBOARD_STATE_QUIT;
         return;
   }
   
}


/* **************************************************
************************************************** */
void render_io_menu(BLTwindow *win) {

   int state = KEYBOARD_STATE_IDLE;
   int done = 0;
   keyboard_menu_widget keyboard_menu;
   keyboard_data_type string_data;
   int ret;
   texbase *tob;
   jukebox_manager jukebox;
   sound_id_type *sound_id;
   sound_id_type menu_sound;
   sound_id_type select_sound;
   sound_id_type highlight_sound;
   sound_type *sndfx;
   float timer = 0;
   vector3f pos = { 0, 0, 0 };
   vector3f vup = { 0, 1, 0 };
   vector3f dir = { 0, 0, 1 };
   string_type backname;
   generic_widget *ptr;

   menu_sound.name.stringcpy("sound/stereo/menupulldown.wav"); 
   menu_sound.volume(100);
   menu_sound.flags = FLAG_SOUND_WAV;
   complex->soundmanager->find(&menu_sound);
   sndfx = complex->soundmanager->play(&menu_sound);

   if (sndfx)
      sndfx->flags |= FLAG_SOUND_LOCK;

   highlight_sound.name.stringcpy("sound/stereo/lazer_026.wav"); 
   highlight_sound.volume(90);
   highlight_sound.flags = FLAG_SOUND_WAV;
   complex->soundmanager->find(&highlight_sound);

   select_sound.name.stringcpy("sound/stereo/select1.wav"); 
   select_sound.volume(100);
   select_sound.flags = FLAG_SOUND_WAV;
   complex->soundmanager->find(&select_sound);

   jukebox.append(sound_id = new sound_id_type, NULL);
   sound_id->name.stringcpy("sound/stereo/electricity3.wav"); 
   sound_id->volume(90);
   sound_id->flags = FLAG_SOUND_WAV;
   complex->soundmanager->find(sound_id);

   jukebox.append(sound_id = new sound_id_type, NULL);
   sound_id->name.stringcpy("sound/stereo/electricitybolt2.wav"); 
   sound_id->volume(90);
   sound_id->flags = FLAG_SOUND_WAV;
   complex->soundmanager->find(sound_id);

   jukebox.append(sound_id = new sound_id_type, NULL);
   sound_id->name.stringcpy("sound/stereo/electricityloop2.wav"); 
   sound_id->volume(90);
   sound_id->flags = FLAG_SOUND_WAV;
   complex->soundmanager->find(sound_id);

   io[0] = win->mapbuffer.maxx>>1;
   io[1] = win->mapbuffer.maxy>>1;
   io[2] = 0;
   io[3] = 0;
   
   // read menu
   string_data.read_key_name("config/keystring");
   keyboard_menu.read_keyboard_menu(FILENAME_KEYBOARD_MENU, FILENAME_CURRENT_COMMANDS, &backname, &string_data);
   tob = (texbase *)((frame_manager *)global_resource_manager)->read_tex(backname.string);
   
   while (!done) {

      while (!complex->timer.tick());

      event_proc(win);
      complex->gfx->gfxPaste2D(&win->mapbuffer, tob, NULL, 0, 0, win->mapbuffer.maxx, win->mapbuffer.maxy, GFX_NULL);

      ptr = string_data.highlight;
      if (string_data.highlight) {
         string_data.highlight->flags &= ~WIDGETFLAG_HIGHLIGHT;
         string_data.highlight->refresh();
         string_data.highlight = NULL;
      }

      switch (state) {
         case KEYBOARD_STATE_KEY_SELECT:
            ret = keyboard_state_key_select(&win->mapbuffer, &string_data, &keyboard_menu, &state);
            break;
	    
         case KEYBOARD_STATE_BUTTON_SELECT:
            ret = keyboard_state_button_select(&win->mapbuffer, &string_data, &keyboard_menu, &state);
            break;

         case KEYBOARD_STATE_FUNCTION_SELECT:
            keyboard_state_function_select(&string_data, &keyboard_menu, &state);
            ret = 1;
            break;
	 
         case KEYBOARD_STATE_IDLE:
            ret = keyboard_state_idle(&keyboard_menu, &string_data, &state, win->mapbuffer.maxx, win->mapbuffer.maxy);
            break;
	    
//         case KEYBOARD_STATE_QUIT:
         default:
            ret = 0;
            done = 1;
      }

      if (string_data.highlight && ptr != string_data.highlight)
         complex->soundmanager->play(&highlight_sound);

      if (ret)
         complex->soundmanager->play(&select_sound);

      keyboard_menu.render(&win->mapbuffer);

      render_mouse(&win->mapbuffer);

      complex->gfx->gfxBitblt(win, &win->mapbuffer);

      if (sndfx) {
         complex->soundmanager->update(pos, dir, vup);

         if (!(sndfx->flags & FLAG_SOUND_PLAYING)) {
            sndfx->flags &= ~FLAG_SOUND_LOCK;
            sndfx = NULL;
            timer = 0.25f;
         }

      }

      else {
         timer -= complex->timer.speedscale;
         if (timer < 0) {
            sndfx = complex->soundmanager->play((sound_id_type *)jukebox.get());
            if (sndfx)
               sndfx->flags |= FLAG_SOUND_LOCK;
         }

      }

   }
   
   if (sndfx)
      sndfx->stop();

   sndfx = complex->soundmanager->play(&menu_sound);

   if (sndfx) {
      sndfx->flags |= FLAG_SOUND_LOCK;

      while (sndfx->flags & FLAG_SOUND_PLAYING)
         complex->soundmanager->update(pos, dir, vup);

      sndfx->stop();
   }

   endgame(win);
}


