

#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "image.h"
#include "pstring.h"

#include "darkgine.h"
#include "fighter.h"

#ifdef WIN32

#include <sys/timeb.h>

#include "winsnd.h"
#include "WIN_W32.h"

#else

#include "WIN_X.h"

#endif

#define ASSIST_MODIFIER 0.25


//#define SHOW_STATS
#ifdef SHOW_STATS

/* **************************************************
************************************************** */
void stats(camera *camptr, gengine *proc, mapul *mapbuffer) {

   char buffer[MAXSTRLEN];
   float scale = (float)(1.0/complex->timer.speedscale);
   float rowsize = (float)(mapbuffer->maxy/64.0);
   float colsize = (float)(mapbuffer->maxx/640.0);
   float y;
   int x1 = (int)(colsize*10);
   int x2 = (int)(colsize*125);

   complex->font->set_color(127, 255, 127);
   complex->font->set_scale((float)(rowsize*0.85));

   y = mapbuffer->maxy - rowsize;
   sprintf(buffer, "Vertex:   %d", (int)(proc->countvertex*scale));
   complex->font->print(x1, (int)y, (unsigned char *)buffer, mapbuffer);
   sprintf(buffer, "%d", proc->countvertex);
   complex->font->print(x2, (int)y, (unsigned char *)buffer, mapbuffer);

   y -= rowsize;
   sprintf(buffer, "Face:     %d", (int)(proc->countface*scale));
   complex->font->print(x1, (int)y, (unsigned char *)buffer, mapbuffer);
   sprintf(buffer, "%d", proc->countface);
   complex->font->print(x2, (int)y, (unsigned char *)buffer, mapbuffer);

   y -= rowsize;
   sprintf(buffer, "Edge:     %d", (int)(proc->countedge*scale));
   complex->font->print(x1, (int)y, (unsigned char *)buffer, mapbuffer);
   sprintf(buffer, "%d", proc->countedge);
   complex->font->print(x2, (int)y, (unsigned char *)buffer, mapbuffer);

   y -= rowsize;
   sprintf(buffer, "Frame rate: %6.1f", scale);
   complex->font->print(x1, (int)y, (unsigned char *)buffer, mapbuffer);

   y -= rowsize;
   sprintf(buffer, "Material: %d", global_statistic_material_count);
   complex->font->print(x1, (int)y, (unsigned char *)buffer, mapbuffer);

   y -= rowsize;
   sprintf(buffer, "UV:       %d", global_statistic_uv_count);
   complex->font->print(x1, (int)y, (unsigned char *)buffer, mapbuffer);

   y -= rowsize;
   sprintf(buffer, "Texture:  %d", global_statistic_texture_count);
   complex->font->print(x1, (int)y, (unsigned char *)buffer, mapbuffer);

   y -= rowsize;
   sprintf(buffer, "Sphere:   %d", global_statistic_sphere_count);
   complex->font->print(x1, (int)y, (unsigned char *)buffer, mapbuffer);

   y -= rowsize;
   sprintf(buffer, "Object:   %d", global_statistic_object_count);
   complex->font->print(x1, (int)y, (unsigned char *)buffer, mapbuffer);

   y -= rowsize;
   sprintf(buffer, "X: %f Y: %f Z: %f", camptr->location[0], camptr->location[1], camptr->location[2]);
   complex->font->print(x1, (int)y, (unsigned char *)buffer, mapbuffer);

}

#endif


/* **************************************************
************************************************** */
void pregame() {

   global_player = NULL;
   complex->teacher.reset();
}


/* **************************************************
************************************************** */
int read_postgame_data(char *filename, jukebox_manager *jukebox, int success_flag) {

   FILE *infile;
   char token[MAXSTRLEN];
   sound_id_type *sound_id;

   jukebox->dest();

   if (!find_file(filename, "r", NULL, PLATFORM_SLASH, NULL, &infile))
      return 0;

   while (get_token(infile, token)) {
      lower_case(token);

      if (!strcmp(TOKEN_SUCCESS_STR, token) && success_flag) {
         jukebox->append(sound_id = new sound_id_type, NULL);
         sound_id->flags = FLAG_SOUND_WAV | FLAG_SOUND_MUSIC;

         get_token(infile, token);
         sound_id->name.stringcpy(token);

         get_token(infile, token);
         sound_id->volume(atoi(token));

         complex->soundmanager->find(sound_id);
         continue;
      }

      if (!strcmp(TOKEN_FAILURE_STR, token) && !success_flag) {
         jukebox->append(sound_id = new sound_id_type, NULL);
         sound_id->flags = FLAG_SOUND_WAV | FLAG_SOUND_MUSIC;

         get_token(infile, token);
         sound_id->name.stringcpy(token);

         get_token(infile, token);
         sound_id->volume(atoi(token));

         complex->soundmanager->find(sound_id);
         continue;
      }

   }

   fclose(infile);
   return 1;
}


/* **************************************************
************************************************** */
void post_game_background(mapul *mapbuffer) {

   vector4uc green = { 0, 64, 0, 255 };
   vector2i v;
   float t, dt;
   int i;
   
   complex->gfx->gfxClear(mapbuffer, &proc.zdata);
   complex->gfx->gfxColor3ubv(green);

   complex->gfx->gfxBegin(GFX_LINES, mapbuffer);

      // vertical
      dt = (float)(mapbuffer->maxx/128.0);
      for (t = 0, i = 0; i < 128; i++, t += dt) {
         v[0] = (int)t;
         v[1] = 0;
         complex->gfx->gfxVertex2iv(v);

         v[1] = mapbuffer->maxy - 1;
         complex->gfx->gfxVertex2iv(v);
      }

      v[0] = mapbuffer->maxx - 1;
      v[1] = 0;
      complex->gfx->gfxVertex2iv(v);

      v[1] = mapbuffer->maxy - 1;
      complex->gfx->gfxVertex2iv(v);

      // horizontal
      dt = (float)(mapbuffer->maxy/96.0);
      for (t = 0, i = 0; i < 96; i++, t += dt) {
         v[0] = 0;
         v[1] = (int)t;
         complex->gfx->gfxVertex2iv(v);

         v[0] = mapbuffer->maxx - 1;
         complex->gfx->gfxVertex2iv(v);
      }

      v[0] = 0;
      v[1] = mapbuffer->maxy - 1;
      complex->gfx->gfxVertex2iv(v);

      v[0] = mapbuffer->maxx - 1;
      complex->gfx->gfxVertex2iv(v);

   complex->gfx->gfxEnd();
}


/* **************************************************
************************************************** */
void postgame(BLTwindow *win, string_type *backname) {

   hit_type *htr;
   unsigned int enemy_mask;
   int done = 0;
   char buffer[MAXSTRLEN];
   float rowsize;
   float fy;
   int x1, x2;
   int i;
   unsigned int old_buttonpress = 0;
   jukebox_manager jukebox;
   sound_type *sndfx = NULL;
   sound_id_type *sid;
   vector3f pos = { 0, 0, 0 };
   vector3f vup = { 0, 1, 0 };
   vector3f dir = { 0, 0, 1 };
   char msg[] = "Press a key/button";

   int   kill_enemy_fighter, kill_enemy_cap, assist_kill_enemy_fighter, assist_kill_enemy_cap;
   int   kill_ally_fighter, kill_ally_cap, assist_kill_ally_fighter, assist_kill_ally_cap;
   float pprimary_shots, psecondary_shots;
   int   success_flag;

   if (!sheader || !global_player)
      return;
      
   complex->timer.pause(1);

   enemy_mask = calc_enemy(global_player->flags);

   for (htr = (hit_type *)sheader->player_hit_manager.head; htr; htr = (hit_type *)htr->next)
      if (!(htr->target->flags & QUARK_FLAG_ACTIVE) && htr->max_amount && htr->amount >= htr->max_amount*ASSIST_MODIFIER)
         if (htr->target->flags & global_player->flags & GAMEFLAG_ALLIANCE_MASK) {
            if (htr->target->flags & (GAMEFLAG_FIGHTER | GAMEFLAG_BOMBER))
               sheader->player_assist_ally_fighter_kill_count++;
            else if (htr->target->flags & (GAMEFLAG_CAPSHIP | GAMEFLAG_STATION))
               sheader->player_assist_ally_cap_kill_count++;
         }

         else if (htr->target->flags & enemy_mask & GAMEFLAG_ALLIANCE_MASK)
            if (htr->target->flags & (GAMEFLAG_FIGHTER | GAMEFLAG_BOMBER))
               sheader->player_assist_enemy_fighter_kill_count++;
            else if (htr->target->flags & (GAMEFLAG_CAPSHIP | GAMEFLAG_STATION))
               sheader->player_assist_enemy_cap_kill_count++;

   rowsize = (float)(win->mapbuffer.maxy/48.0);
   complex->font->set_scale((float)(rowsize*0.85));
   x1 = (int)(win->mapbuffer.maxx*0.05f);
   x2 = (int)(win->mapbuffer.maxx*0.6667f);

   success_flag = sheader->flags & DARKSIM_FLAG_SUCCESS;
   read_postgame_data(backname->string, &jukebox, success_flag);

   kill_enemy_fighter = sheader->player_enemy_fighter_kill_count;
   assist_kill_enemy_fighter = sheader->player_assist_enemy_fighter_kill_count;
   
   kill_enemy_cap = sheader->player_enemy_cap_kill_count;
   assist_kill_enemy_cap = sheader->player_assist_enemy_cap_kill_count;

   kill_ally_fighter = sheader->player_ally_fighter_kill_count;
   assist_kill_ally_fighter = sheader->player_assist_ally_fighter_kill_count;
   
   kill_ally_cap = sheader->player_ally_cap_kill_count;
   assist_kill_ally_cap = sheader->player_assist_ally_cap_kill_count;

//   primary_shots = sheader->player_primary_hit_count;
   pprimary_shots = sheader->player_primary_fire_count ? (100.0f*sheader->player_primary_hit_count)/sheader->player_primary_fire_count : 0.0f;

//   secondary_shots = sheader->player_secondary_hit_count;
   psecondary_shots = sheader->player_secondary_fire_count ? (100.0f*sheader->player_secondary_hit_count)/sheader->player_secondary_fire_count : 0.0f;

   delete sheader;
   sheader = NULL;

   complex->animation_manager.dest();

   // background
   complex->gfx->gfx2DMode(win->mapbuffer.maxx, win->mapbuffer.maxy);

   complex->timer.pause(0);

   while (!done) {

      while (!complex->timer.tick());

      // process user io
      complex->userinput->process_events(&complex->timer);
            
      if (!complex->userinput->status_buttonpress && old_buttonpress)
         done = 1;
      else {
         old_buttonpress = complex->userinput->status_buttonpress;
         for (i=0; i<MAXKEYS; i++)
            done |= complex->userinput->status_keypress[i] && !complex->userinput->status_keyold[i];
      }
      
      // process_sound
      if (sndfx)
         complex->soundmanager->update(pos, dir, vup);

      if (!sndfx || !(sndfx->flags & FLAG_SOUND_PLAYING)) {
         if (sndfx) {
            sndfx->flags &= ~FLAG_SOUND_LOCK;
            sndfx = NULL;
         }

         sid = (sound_id_type *)jukebox.get();
         if (sid) {
            sndfx = complex->soundmanager->play(sid);
            if (sndfx)

               sndfx->flags |= FLAG_SOUND_LOCK;
         }

      }

      post_game_background(&win->mapbuffer);

      fy = (win->mapbuffer.maxy>>1) + 7.0f*rowsize;

      if (success_flag) {
         complex->font->set_color((char)64, (char)255, (char)64);
         complex->font->print(x1, (int)fy, (unsigned char *)"Mission Status: Success", &win->mapbuffer);
      }

      else {
         complex->font->set_color((char)255, (char)64, (char)64);
         complex->font->print(x1, (int)fy, (unsigned char *)"Mission Status: Failure", &win->mapbuffer);
      }

      fy -= rowsize + rowsize;
      
      complex->font->set_color((char)64, (char)255, (char)255);

      // stats for killed enemy fighters
      complex->font->print(x1, (int)fy, (unsigned char *)"Enemy Ship Kills:", &win->mapbuffer);
      sprintf(buffer, "%d", kill_enemy_fighter);
      complex->font->print(x2, (int)fy, (unsigned char *)buffer, &win->mapbuffer);
      fy -= rowsize;

      complex->font->print(x1, (int)fy, (unsigned char *)"Enemy Ship Assists:", &win->mapbuffer);
      sprintf(buffer, "%d", assist_kill_enemy_fighter);
      complex->font->print(x2, (int)fy, (unsigned char *)buffer, &win->mapbuffer);
      fy -= rowsize;
      
      // stats for killed enemy strategic targets
      complex->font->print(x1, (int)fy, (unsigned char *)"Enemy Strategic Kills:", &win->mapbuffer);
      sprintf(buffer, "%d", kill_enemy_cap);
      complex->font->print(x2, (int)fy, (unsigned char *)buffer, &win->mapbuffer);
      fy -= rowsize;

      complex->font->print(x1, (int)fy, (unsigned char *)"Enemy Strategic Assists:", &win->mapbuffer);
      sprintf(buffer, "%d", assist_kill_enemy_cap);
      complex->font->print(x2, (int)fy, (unsigned char *)buffer, &win->mapbuffer);
      fy -= rowsize;

      // stats for killed allies fighters
      fy -= rowsize;
      complex->font->set_color((char)255, (char)64, (char)64);
      
      complex->font->print(x1, (int)fy, (unsigned char *)"Ally Ship Kills:", &win->mapbuffer);
      sprintf(buffer, "%d", kill_ally_fighter);
      complex->font->print(x2, (int)fy, (unsigned char *)buffer, &win->mapbuffer);
      fy -= rowsize;

      complex->font->print(x1, (int)fy, (unsigned char *)"Ally Ship Assists:", &win->mapbuffer);
      sprintf(buffer, "%d", assist_kill_ally_fighter);
      complex->font->print(x2, (int)fy, (unsigned char *)buffer, &win->mapbuffer);
      fy -= rowsize;
      
      // stats for killed ally strategic targets
      complex->font->print(x1, (int)fy, (unsigned char *)"Ally Strategic Kills:", &win->mapbuffer);
      sprintf(buffer, "%d", kill_ally_cap);
      complex->font->print(x2, (int)fy, (unsigned char *)buffer, &win->mapbuffer);
      fy -= rowsize;

      complex->font->print(x1, (int)fy, (unsigned char *)"Ally Strategic Assists:", &win->mapbuffer);
      sprintf(buffer, "%d", assist_kill_ally_cap);
      complex->font->print(x2, (int)fy, (unsigned char *)buffer, &win->mapbuffer);
      fy -= rowsize;

      // stats for shooting accuracy
      fy -= rowsize;
      complex->font->set_color((char)255, (char)255, (char)64);
 
      complex->font->print(x1, (int)fy, (unsigned char *)"Primary hits:", &win->mapbuffer);
      sprintf(buffer, "%3.1f%%", pprimary_shots);
      complex->font->print(x2, (int)fy, (unsigned char *)buffer, &win->mapbuffer);
      fy -= rowsize;
      
      complex->font->print(x1, (int)fy, (unsigned char *)"Secondary hits:", &win->mapbuffer);
      sprintf(buffer, "%3.1f%%", psecondary_shots);
      complex->font->print(x2, (int)fy, (unsigned char *)buffer, &win->mapbuffer);
      fy -= rowsize;

      complex->font->print((win->mapbuffer.maxx - complex->font->pixel_length((unsigned char *)msg))>>1, (int)rowsize, (unsigned char *)msg, &win->mapbuffer);

      complex->gfx->gfxBitblt(win, &win->mapbuffer);
   }

   if (sndfx)
      sndfx->stop();
}

/* **************************************************
************************************************** */
void gameloop(BLTwindow *win) {

   int       framecount = 0;
   float     framemin, framemax;
   atom_list_type  *atr;
   vector4f  mx[4];
   camera    *camptr;
   vector4f  frustum[FRUSTUM_COUNT];
   int       snapcount = 0;
   float     duration;
   time_t    oldtime, newtime;
   TIME_STRUCT t;
   float     rowsize = (float)(win->mapbuffer.maxy/24.0);
   int       quit_flag = 0;
   char      msg_pause[] = "PAUSED";
   char      msg_quit[]  = "ABORT? (Y/N)";
   int       record_flag = 0;
   char      buffer[MAXSTRLEN];
   string_type backname;
   quark *last;
   dbl_llist_manager list;
   hiearchy_list_type *ptr;
   int i;
   bmp coder;
   
   // parsing the game scripts
   if (!DEFLST) {
      pprintf("ERROR: NO SCRIPT FILE!!!\n");
      return;
   }

   pregame();
   
   time(&oldtime);
   init_mx(mx);

   complex->userinput->flag_on(FLAG_IO_MOUSE_CONSTRAIN | FLAG_IO_MOUSE_DEADZONE);
   complex->timer.pause(1);
   ((dark_god *)complex)->setup_equipment();
      
   sprintf(buffer, "%s%s", FILENAME_PREMIS, SDEFLST.string);
   parse_animate_list(&complex->animation_manager, buffer, &backname);

   if (!global_player) {
      pprintf("ERROR: NO PLAYER OBJECT!!!\n");
      endgame(win);
      return;
   }
      
   for (i = strlen(buffer)-1; i > -1 && buffer[i] != '.'; i--);
   buffer[i+1] = 0;
   strcat(buffer, "mis");
   sheader = (sim_sim *)parse_ai_list(buffer);

   vfx_init(&complex->animation_manager, win->mapbuffer.maxx, win->mapbuffer.maxy);

   // find camera
   for (camptr=NULL, atr=(atom_list_type *)complex->animation_manager.head; atr && !camptr; atr=(atom_list_type *)atr->next)
      camptr = (camera *)atr->htree->find_ob(NULL, OBJECT_CAMERA);

   camptr->set_dim(win->mapbuffer.maxx, win->mapbuffer.maxy);

   complex->timer.pause(0);

   // first frame :)
   for (atr=(atom_list_type *)complex->animation_manager.head; atr; atr=(atom_list_type *)atr->next) {
      atr->htree->new_action(0, &complex->animation_manager);
      atr->htree->begin(&complex->animation_manager, NULL, mx);
   }

   for (atr=(atom_list_type *)complex->animation_manager.head; atr; atr=(atom_list_type *)atr->next)
      atr->htree->update(&complex->animation_manager, NULL);

   // rest of frames ...
   while (1) {

      // process user io
      complex->userinput->process_events(&complex->timer);

      if (complex->userinput->translate_stroke(KEYSTROKE_RECORD))
         record_flag = !record_flag;

      if (quit_flag) {
         if (complex->userinput->key_stroke(KEYSTROKE_Y)) {
            complex->timer.pause(0);
            break;
         }
     
         if (complex->userinput->key_stroke(KEYSTROKE_N) ||
             complex->userinput->translate_stroke(KEYSTROKE_QUIT)) {
            quit_flag = 0;
            complex->timer.pause(0);
            continue;
         }

      }
      
      if (complex->userinput->translate_stroke(KEYSTROKE_QUIT)) {
         complex->timer.pause(1);
         quit_flag = 1;
      }
      
      if (!quit_flag && complex->userinput->translate_stroke(KEYSTROKE_PAUSE))
         complex->timer.pause(!complex->timer.query_pause());

      if (sheader && (sheader->flags & DARKSIM_FLAG_JUMP))
         break;

      if (!complex->timer.query_pause()) {

         // update timer
         if (record_flag)
            complex->timer.manual_tick(0.03f);
         else
            while (!complex->timer.tick());

         if (sheader)
            sheader->process_ai();

         // process objects
         for (atr=(atom_list_type *)complex->animation_manager.head; atr; atr=(atom_list_type *)atr->next) {
            atr->htree->new_action(framecount, &complex->animation_manager);
            atr->htree->whereami(&complex->animation_manager, NULL, mx);
         }

         // update objects and build list of "collision" objects
         world_sphere.deconstruct(&world_freelist);
         for (atr=(atom_list_type *)complex->animation_manager.head; atr; atr=(atom_list_type *)atr->next) {
            atr->htree->update(&complex->animation_manager, NULL);

            if (!(atr->htree->flags & QUARK_FLAG_ACTIVE) || (atr->htree->old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TNONE)
               continue;

            last = NULL;
            do {
               last = atr->htree->find(NULL, OBJECT_ANTINEUTRON, last, NULL);
            } while (last && !(last->flags & QUARK_FLAG_ACTIVE));

            if (!last)
               continue;

            if (world_freelist.head)
               world_freelist.remove(ptr = (hiearchy_list_type *)world_freelist.head);
            else
               ptr = new hiearchy_list_type;
     
            list.append(ptr, NULL);
            ptr->hiearchy = atr;
         }

         world_sphere.construct(&list);

         // process F/X
         ((dark_god *)complex)->teacher.whereami(&complex->animation_manager, NULL, mx);
         ((dark_god *)complex)->teacher.update(&complex->animation_manager, NULL);

         // update sound
         if (camptr)
            complex->soundmanager->update(camptr->location, camptr->vpn, camptr->vup);
      }

      // send objects to rendering buffer
      proc.engine_init();

      if (camptr) {
         camptr->calc_clip_plane();
         camptr->query_frustum(frustum);
#ifdef ASDF_WONT_CONTAIN_CAMERA_AND_LIGHT
         world_sphere.frustum_vs_obj(frustum, FRUSTUM_CLIP_ALL, &list, &world_freelist);
         
         while (list.head) {
            list.remove(ptr = (gameatom_list_type *)list.head);
            ptr->object->render_object(&proc, NULL, frustum, FRUSTUM_CLIP_ALL);
            world_freelist.insert(ptr, NULL);
         }
#else
         for (atr=(atom_list_type *)complex->animation_manager.head; atr; atr=(atom_list_type *)atr->next)
            atr->htree->render_object(&proc, NULL, frustum, FRUSTUM_CLIP_ALL);
#endif

         ((dark_god *)complex)->teacher.render_object(&proc, NULL, frustum, FRUSTUM_CLIP_ALL);
      }
      
      // render frame
      proc.spawn(framecount, &win->mapbuffer);

      // display hud
      complex->gfx->gfx2DMode(win->mapbuffer.maxx, win->mapbuffer.maxy);
      vfx_dazzle_the_crowd(&complex->animation_manager, &win->mapbuffer, camptr);
      
      if (global_player->flags & QUARK_FLAG_ACTIVE)
         ((player *)global_player)->display_hud(&complex->animation_manager, &proc, &win->mapbuffer);

      if (sheader)
         sheader->render2d(&win->mapbuffer);

#ifdef SHOW_STATS
      stats(camptr, &proc, &win->mapbuffer);
#endif

      if (quit_flag) {
         complex->font->set_color((char)255, (char)0, (char)255);
         complex->font->set_scale((float)(rowsize*0.85));
         complex->font->print((win->mapbuffer.maxx - complex->font->pixel_length((unsigned char *)msg_quit))>>1, (int)((win->mapbuffer.maxy-rowsize)*0.5), (unsigned char *)msg_quit, &win->mapbuffer);
      }
      
      else if (complex->timer.query_pause()) {
         complex->font->set_color((char)200, (char)0, (char)255);
         complex->font->set_scale((float)(rowsize*0.85));
         complex->font->print((win->mapbuffer.maxx - complex->font->pixel_length((unsigned char *)msg_pause))>>1, (int)((win->mapbuffer.maxy-rowsize)*0.5), (unsigned char *)msg_pause, &win->mapbuffer);
      }

      // render to screen
      if (!complex->timer.query_pause()) {
         if ((record_flag || complex->userinput->translate_stroke(KEYSTROKE_SNAPSHOT))) {
            sprintf(buffer, "imag%04d.bmp",  snapcount);
            snapcount++;
            complex->gfx->gfxSnapshot(buffer, &win->mapbuffer, &coder);
         }

         GETTIME(&t);
         global_resource_manager->update((float)TIME2FLOAT(t));
      }

      complex->gfx->gfxBitblt(win, &win->mapbuffer);
      
      if (framecount == 1)
         framemin = framemax = complex->timer.speedscale;
      else if (framemin < complex->timer.speedscale)
         framemin = complex->timer.speedscale;
      else if (framemax > complex->timer.speedscale)
         framemax = complex->timer.speedscale;

      framecount++;
   }

   if (logfile) {
      time(&newtime);
      duration = (float)(newtime - oldtime);

      fprintf(logfile, "Framecount %d\n", framecount);
      fprintf(logfile, "Framerate Average %4.2f\n", framecount/duration);
      fprintf(logfile, "Framerate Minimum %4.2f\n", 1.0/framemin);
      fprintf(logfile, "Framerate Maximum %4.2f\n", 1.0/framemax);
   }

   postgame(win, &backname);
   endgame(win);   
}

