

#include <stdlib.h>

#ifdef WIN32

#include <sys/timeb.h>
#include "WIN_W32.h"

#else

#include "WIN_X.h"

#endif

#include "pstring.h"

#include "darkgine.h"


/* **************************************************
************************************************** */
class text_node : public circular_dbl_llist {

   public:
      string_type text;

      virtual ~text_node() {}
      virtual void display(int y, mapul *mapbuffer);
};


/* **************************************************
************************************************** */
class title_node : public text_node {

   public:
      virtual ~title_node() {}
      virtual void display(int y, mapul *mapbuffer);
};


char FILENAME_CREDIT_SCENE[] = "mission/credits.cnt";
char FILENAME_CREDITS[]      = "mission/credits.txt";


/* **************************************************
************************************************** */
void text_node::display(int y, mapul *mapbuffer) {

   complex->font->print(0, y, (unsigned char *)text.string, mapbuffer);
};


/* **************************************************
************************************************** */
void title_node::display(int y, mapul *mapbuffer) {

   complex->font->print((mapbuffer->maxx-complex->font->pixel_length((unsigned char *)text.string))>>1, y, (unsigned char *)text.string, mapbuffer);
};


/* **************************************************
************************************************** */
int read_menu(char *filename, string_type *fontname, string_type *musicname, circular_dbl_llist_manager *text_manager, float *linespersec) {

   FILE *infile;
   char token[MAXSTRLEN];
   text_node *ptr;

   text_manager->dest();

   if (!find_file(filename, "r", NULL, PLATFORM_SLASH, NULL, &infile))
      return 0;

   get_token(infile, token);
   if (get_token(infile, token))
      fontname->stringcpy(token);

   get_token(infile, token);
   if (get_token(infile, token))
      musicname->stringcpy(token);

   get_token(infile, token);
   if (get_token(infile, token))
      *linespersec = (float)atof(token);

   while (get_token(infile, token)) {
      text_manager->append(ptr = new title_node, NULL);
      ptr->text.stringcpy(token);

      get_token(infile, token); // '{'

      while (get_token(infile, token) && token[0] != '}') {
         text_manager->append(ptr = new text_node, NULL);
         ptr->text.stringcpy(token);
      }

   }

   fclose(infile);
   return 1;
}


/* **************************************************
************************************************** */
void credits_menu(BLTwindow *win) {

   int       framecount = 0;
   vector4f  mx[4];
   atom_list_type  *atr;
   camera    *camptr;
   string_type fontname, musicname;
   circular_dbl_llist_manager text_manager;
   float linespersec;
   text_node *ptr, *qtr;
   float rowsize = (float)(win->mapbuffer.maxy/32.0);
   float fy = 0;
   float work;
   int done = 0;
   vector4f  frustum[FRUSTUM_COUNT];
   TIME_STRUCT t;
   sound_id_type menu_sound;
   sound_type *menu_sndfx = NULL;
   sound_id_type sound_id;
   sound_type *sndfx = NULL;
   vector3f pos = { 0, 0, 0 };
   vector3f vup = { 0, 1, 0 };
   vector3f dir = { 0, 0, 1 };

   init_mx(mx);
   complex->timer.pause(1);

   menu_sound.name.stringcpy("sound/stereo/menupulldown.wav"); 
   menu_sound.volume(100);
   menu_sound.flags = FLAG_SOUND_WAV;
   complex->soundmanager->find(&menu_sound);
   menu_sndfx = complex->soundmanager->play(&menu_sound);

   if (menu_sndfx)
      menu_sndfx->flags |= FLAG_SOUND_LOCK;

   parse_animate_list(&complex->animation_manager, FILENAME_CREDIT_SCENE);
   read_menu(FILENAME_CREDITS, &fontname, &musicname, &text_manager, &linespersec);

   ptr = (text_node *)text_manager.head;
   if (!ptr)
      return;

   complex->set_font(fontname.string, FONT_RASTER);
   complex->font->set_scale(rowsize*0.85f);
   complex->font->set_color((char)255, (char)255, (char)255);

   linespersec *= rowsize;

   vfx_init(&complex->animation_manager, win->mapbuffer.maxx, win->mapbuffer.maxy);

   sound_id.name.stringcpy(musicname.string); 
   sound_id.volume(90);
   sound_id.flags = FLAG_SOUND_WAV | FLAG_SOUND_LOOPING  | FLAG_SOUND_MUSIC;
   sound_id.id = NULL;

   complex->soundmanager->find(&sound_id);
   sndfx = complex->soundmanager->play(&sound_id);

   // find camera
   for (camptr=NULL, atr=(atom_list_type *)complex->animation_manager.head; atr && !camptr; atr=(atom_list_type *)atr->next)
      camptr = (camera *)atr->htree->find_ob(NULL, OBJECT_CAMERA);

   camptr->set_dim(win->mapbuffer.maxx, win->mapbuffer.maxy);

   complex->timer.pause(0);

   // first frame :)
   for (atr=(atom_list_type *)complex->animation_manager.head; atr; atr=(atom_list_type *)atr->next) {
      atr->htree->new_action(0, &complex->animation_manager);
      atr->htree->begin(&complex->animation_manager, NULL, mx);
   }

   for (atr=(atom_list_type *)complex->animation_manager.head; atr; atr=(atom_list_type *)atr->next)
      atr->htree->update(&complex->animation_manager, NULL);

   // rest of frames ...
   while (!done) {

      // increment text on screen
      while (!complex->timer.tick());

      fy += complex->timer.speedscale*linespersec;

      while (fy > win->mapbuffer.maxy) {
         ptr = (text_node *)ptr->next;
         fy -= rowsize;
      }

      // process user input
      event_proc(win);
           
      if (io[2] == BUTTON_UP || io[3])
         done = 1;

      // process objects
      for (atr=(atom_list_type *)complex->animation_manager.head; atr; atr=(atom_list_type *)atr->next) {
         atr->htree->new_action(framecount, &complex->animation_manager);
         atr->htree->whereami(&complex->animation_manager, NULL, mx);
      }

      for (atr=(atom_list_type *)complex->animation_manager.head; atr; atr=(atom_list_type *)atr->next)
         atr->htree->update(&complex->animation_manager, NULL);

      // send objects to rendering buffer
      proc.engine_init();

      if (camptr) {
         camptr->calc_clip_plane();
         camptr->query_frustum(frustum);

         for (atr=(atom_list_type *)complex->animation_manager.head; atr; atr=(atom_list_type *)atr->next)
            atr->htree->render_object(&proc, NULL, frustum, FRUSTUM_CLIP_ALL);
	    
         proc.spawn(framecount, &win->mapbuffer);
      }
      
      // display hud
      complex->gfx->gfx2DMode(win->mapbuffer.maxx, win->mapbuffer.maxy);
      vfx_dazzle_the_crowd(&complex->animation_manager, &win->mapbuffer, camptr);
    
      // draw text
      for (qtr = ptr, work = fy; work > 0; qtr = (text_node *)qtr->next, work -= rowsize)
         qtr->display((int)work, &win->mapbuffer);

      // render to screen
      GETTIME(&t);
      global_resource_manager->update((float)TIME2FLOAT(t));
      complex->gfx->gfxBitblt(win, &win->mapbuffer);
      
      framecount++;
   }
   
   if (sndfx)
      sndfx->stop();
   
   if (menu_sndfx)
      menu_sndfx->stop();

   menu_sndfx = complex->soundmanager->play(&menu_sound);
   if (menu_sndfx) {
      menu_sndfx->flags |= FLAG_SOUND_LOCK;

      while (menu_sndfx->flags & FLAG_SOUND_PLAYING)
         complex->soundmanager->update(pos, dir, vup);

      menu_sndfx->stop();
   }

   endgame(win);
}
