

#include "linetype.h"
#include "pstring.h"

#include "darkgine.h"
#include "darkwin.h"

#ifdef WIN32
#define UI_TYPE dark_uio_win
#else
#define UI_TYPE dark_uio_X
#endif

#define LL_DISPLAY_EQUIPMENT 0
#define LL_DISPLAY_TARGET    1
#define LL_DISPLAY_COMM      2
#define LL_DISPLAY_TASKS     3


comm_menu_options comm_orders[MAX_COMM_MENU_OPTIONS] = {
   "Attack my target", VOICE_PILOT_DYNAMIC_ATTACK,
   "Defend my target", VOICE_PILOT_DYNAMIC_DEFEND,
   "Protect my six",   VOICE_PILOT_DYNAMIC_WINGMAN,
   "Break and attack", VOICE_PILOT_DYNAMIC_RESCIND
};
   
   
/*
   update equipment after movement
   if OPENGL, assumed already in ortho mode
*/


/* *************************************************************
************************************************************* */
void hud_display_calc_bbox(float *pos, float radius, camera *cam, vector2i *out) {

   vector4f posll;
   vector3f posur;

   matvecmulto(cam->transform, pos, posll);

   copyarray3(posur, posll);

   posll[0] -= radius;
   posll[1] -= radius;
   cam->map2screen(posll);

   posur[0] += radius;
   posur[1] += radius;
   cam->map2screen(posur);

   if (posur[0] - posll[0] < 4) {
      posur[0] += 2;
      posll[0] -= 2;
   }

   if (posur[1] - posll[1] < 4) {
      posur[1] += 2;
      posll[1] -= 2;
   }

   out[0][0] = (int)posll[0];
   out[0][1] = (int)posll[1];
   out[1][0] = out[0][0];
   out[1][1] = (int)posur[1];
   out[2][0] = (int)posur[0];
   out[2][1] = out[1][1];
   out[3][0] = out[2][0];
   out[3][1] = out[0][1];
}


/* *************************************************************
************************************************************* */
void hud_display_calc_bbox(float *pos, int size, camera *cam, vector2i *out) {

   vector4f v;
   vector2i iv;

   size >>= 1;   
   
   matvecmulto(cam->transform, pos, v);
   cam->map2screen(v);

   iv[0] = (int)v[0];
   iv[1] = (int)v[1];
   
   out[0][0] = iv[0] - size;
   out[0][1] = iv[1] - size;
   out[1][0] = out[0][0];
   out[1][1] = iv[1] + size;
   out[2][0] = iv[0] + size;
   out[2][1] = out[1][1];
   out[3][0] = out[2][0];
   out[3][1] = out[0][1];
}


/* *************************************************************
************************************************************* */
void hud_display_primary_weapon(mapul *mapbuffer, equip_weapon *source, fighter_desc *inventory, float length) {

   vector2i pt1, pt2;
   float y;
   float rowsize = mapbuffer->maxy/64.0f;
   int x3 = (int)((mapbuffer->maxx*50.0f)/64.0f);
   string_type token;
   vector4uc color;
   
   // primary text
   complex->font->set_scale(rowsize*0.85f);
   y = 6*rowsize;

   complex->font->set_color((unsigned char)127, (unsigned char)255, (unsigned char)127);

   if (inventory->query_primary_mode() == PRIMARY_MODE_FULL)
      token.stringcpy("Primary: FULL");
   else {
      token.stringcpy("Primary: ");
      token.stringcat(&source->full_name);
   }

   complex->font->print(x3, (int)y, (unsigned char *)token.string, mapbuffer);

   // primary status bar
   if (length > 0) {
      y -= rowsize;
      color[0] = 63 + (int)(192.0*(1.0-length));
      color[1] = 31 + (int)(32.0*length);
      color[2] = 31 + (int)(224.0*length);

      complex->gfx->gfxColor3ubv(color);

      pt1[0] = x3;
      pt1[1] = (int)(y + 0.2*rowsize);
      pt2[0] = (int)(x3 + (length*100.0*mapbuffer->maxx)/640.0);
      pt2[1] = (int)(y + 0.8*rowsize);

      complex->gfx->gfxRectiv(mapbuffer, pt1, pt2);
   }
   
}


/* *************************************************************
************************************************************* */
void hud_display_secondary_weapon(mapul *mapbuffer, equip_weapon *source, int count, int maxcount) {

   float fpt1, finc;
   int ipt2;
   vector2i pt1, pt2;
   float y;
   float rowsize = mapbuffer->maxy/64.0f;
   int x3 = (int)((mapbuffer->maxx*50.0f)/64.0f);
   string_type token;
   float t;
   vector4uc color;
   
   // secondary text
   complex->font->set_scale(rowsize*0.85f);
   y = 4.0f*rowsize;

   complex->font->set_color((unsigned char)127, (unsigned char)255, (unsigned char)127);

   token.stringcpy("Secondary: ");
   token.stringcat(&source->full_name);
   complex->font->print(x3, (int)y, (unsigned char *)token.string, mapbuffer);

   // secondary status bar
   y -= rowsize;
   color[0] = 128;
   color[1] = 128;
   color[2] = 255;

   complex->gfx->gfxColor3ubv(color);

   t = mapbuffer->maxx/(maxcount*640.0f);
   
   finc = 100.0f*t;

   fpt1 = (float)x3;
   ipt2 = (int)(90*t);
   pt1[1] = (int)(y + 0.2*rowsize);
   pt2[1] = (int)(y + 0.8*rowsize);
   
   for (; count; count--) {
      pt1[0] = (int)fpt1;
      pt2[0] = pt1[0] + ipt2;
      fpt1 += finc;
      complex->gfx->gfxRectiv(mapbuffer, pt1, pt2);
   }
   
}

/* *************************************************************
************************************************************* */
void hud_display_systems_info(mapul *mapbuffer, equipment *tronic, int x, float rowsize, gameatom *target, unsigned char *oglrgb, int type) {

   char token[MAXSTRLEN];
   int i, j;
   equipment *ptr;
   float d, y;
   dbl_llist_manager string_man;
   string_type *str;
   sim_object *sai;
   sim_infobyte_type *sit;
   status_type status_data;
   vector2i pt[2];
   atom_list_type *atr;
   
   // show equipment status
   switch (type) {
  
      case LL_DISPLAY_COMM:
         rowsize *= 0.9f;
         complex->font->set_scale(rowsize*0.85f);

         if (((UI_TYPE *)complex->userinput)->mode == COMM_MODE_TARGET) {
	    
            for (atr = (atom_list_type *)complex->animation_manager.head, i = 0; atr && i < 7; atr = (atom_list_type *)atr->next)
               if (((gameatom *)atr->htree)->total_hp > 0 && (global_player->flags & atr->htree->flags & GAMEFLAG_ALLIANCE_MASK) && atr->htree->query_whatami() == OBJECT_NPC_FIGHTER) {
                  i++;
                  string_man.append(str = new string_type, NULL);
                  str->stringcpy(&((gameatom *)atr->htree)->full_name);
               }

            if (!string_man.head) {
               ((UI_TYPE *)complex->userinput)->mode = COMM_MODE_IDLE;
               return;
            }

            y = (string_man.count+3)*rowsize;   

            complex->font->set_color((unsigned char)255, (unsigned char)255, (unsigned char)0);
            complex->font->print(x*3, (int)y, (unsigned char *)"RECEIVER", mapbuffer);
            y -= rowsize;

            complex->font->set_color(oglrgb[0], oglrgb[1], oglrgb[2]);
            for (str = (string_type *)string_man.head, i = 0; str; str = (string_type *)str->next, i++) {
               sprintf(token, "%d: %s", i+1, str->string);
               complex->font->print(x, (int)y, (unsigned char *)token, mapbuffer);
               y -= rowsize;
            }
	    	    	    	       
            complex->font->print(x, (int)y, (unsigned char *)"8: All", mapbuffer);
            y -= rowsize;

            complex->font->print(x, (int)y, (unsigned char *)"9: Abort", mapbuffer);
            y -= rowsize;
	    
            return;
         }
	 
         // COMM_MODE_ORDER:
         y = (MAX_COMM_MENU_OPTIONS+2)*rowsize;   
      
         complex->font->set_color((unsigned char)255, (unsigned char)255, (unsigned char)0);
         complex->font->print(x*6, (int)y, (unsigned char *)"ORDER", mapbuffer);
         y -= rowsize;

         complex->font->set_color(oglrgb[0], oglrgb[1], oglrgb[2]);
         for (i=0; i<MAX_COMM_MENU_OPTIONS; i++) {
            sprintf(token, "%d: %s", i+1, comm_orders[i].text);
            complex->font->print(x, (int)y, (unsigned char *)token, mapbuffer);
            y -= rowsize;
         }
	    
         complex->font->print(x, (int)y, (unsigned char *)"9: Abort", mapbuffer);
         y -= rowsize;
         return;
	     
      case LL_DISPLAY_TARGET:
         y = 6*rowsize;   

         complex->font->set_scale(rowsize*0.85f);
         complex->font->set_color(oglrgb[0], oglrgb[1], oglrgb[2]);

         sprintf(token, "Target: %s", target->full_name.string);
         complex->font->print(x, (int)y, (unsigned char *)token, mapbuffer);
         y -= rowsize;

         if (target->query_specific_data(DATAFLAG_STATUS, &status_data)) {

            // shield strength
            d = status_data.maxshields < 0.5 ? 0 : status_data.shields/(float)status_data.maxshields;
            complex->font->set_color(63 + (int)(192*(1-d)), 31 + (int)(224*d), 31 + (int)(32*d));
            sprintf(token, "S:");
            complex->font->print(x, (int)y, (unsigned char *)token, mapbuffer);

            pt[0][0] = (int)(x + 2*rowsize);
            pt[0][1] = (int)(y + 0.2*rowsize);
            pt[1][0] = (int)(x + (2+8*d)*rowsize);
            pt[1][1] = (int)(y + 0.8*rowsize);
            complex->gfx->gfxRectiv(mapbuffer, pt[0], pt[1]);
            y -= rowsize;

            // systems integrety
            d = status_data.maxhp < 0.5 ? 0 : status_data.hp/(float)status_data.maxhp;
            complex->font->set_color(63 + (int)(192*(1.0-d)), 31 + (int)(224.0*d), 31 + (int)(32.0*d));
            sprintf(token, "I:");
            complex->font->print(x, (int)y, (unsigned char *)token, mapbuffer);

            pt[0][0] = (int)(x + 2*rowsize);
            pt[0][1] = (int)(y + 0.2*rowsize);
            pt[1][0] = (int)(x + (2+8*d)*rowsize);
            pt[1][1] = (int)(y + 0.8*rowsize);
            complex->gfx->gfxRectiv(mapbuffer, pt[0], pt[1]);
            y -= rowsize;
            return;
         }
      
         // shield strength
         complex->font->set_color((unsigned char)200, (unsigned char)200, (unsigned char)0);
         sprintf(token, "S: ???");
         complex->font->print(x, (int)y, (unsigned char *)token, mapbuffer);
         y -= rowsize;

         // systems integrety
         complex->font->set_color((unsigned char)200, (unsigned char)200, (unsigned char)0);
         sprintf(token, "I: ???");
         complex->font->print(x, (int)y, (unsigned char *)token, mapbuffer);
         y -= rowsize;
         return;      
       
      case LL_DISPLAY_EQUIPMENT:
         rowsize *= 0.9f;
         complex->font->set_scale(rowsize*0.85f);
   
         ptr = (equipment *)tronic->gear->inventory.head;

         if (tronic->gear->inventory.count < 8) {
            i = 0;
            j = tronic->gear->inventory.count;
         }
      
         else {
            for (i = ((equip_systems_computer *)tronic)->current_status_index % tronic->gear->inventory.count; i > 0; i--, ptr=(equipment *)ptr->next);
            j = 8;
         }
      
         y = 0;
      
         for (; i < j && ptr; i++, ptr = (equipment *)ptr->next) {
            d = ptr->hp*ptr->imaxhp;
            complex->font->set_color(63 + (int)(192*(1-d)), 31 + (int)(224*d), 31 + (int)(32*d));
            sprintf(token, "%s: %d%%", ptr->full_name.string, (int)(d*100));
            complex->font->print(x, (int)y, (unsigned char *)token, mapbuffer);
            y += rowsize;
         }

         for (ptr = (equipment *)tronic->gear->inventory.head; i < j; i++, ptr = (equipment *)ptr->next) {
            d = ptr->hp*ptr->imaxhp;
            complex->font->set_color(63 + (int)(192*(1-d)), 31 + (int)(224*d), 31 + (int)(32*d));
            sprintf(token, "%s: %d%%", ptr->full_name.string, (int)(d*100));
            complex->font->print(x, (int)y, (unsigned char *)token, mapbuffer);
            y += rowsize;
         }
            
         complex->font->set_color((unsigned char)255, (unsigned char)255, (unsigned char)0);
         complex->font->print(x*3, (int)y, (unsigned char *)"Equipment", mapbuffer);
         y += rowsize;
         return;
	    
//      case LL_DISPLAY_TASKS:
      default:
         sai = sheader ? sheader->find_ob(TOKEN_SPLAYER_NAME_STR) : (sim_object *)NULL;

         if (sai) {
            for (sit = (sim_infobyte_type *)sai->success_manager.head; sit; sit = (sim_infobyte_type *)sit->next)
               if (sit->query_class() == SIM_MANAGER_TASK) {
                  ((sim_task_type *)sit)->get_status(str = new string_type);

                  if (!str->string[0])
                     delete str;
                  else
                     string_man.append(str, NULL);
               }

            for (sit = (sim_infobyte_type *)sai->script_manager[SIM_MANAGER_TASK].head; sit; sit = (sim_infobyte_type *)sit->next) {
               ((sim_task_type *)sit)->get_status(str = new string_type);

               if (!str->string[0])
                  delete str;
               else
                  string_man.append(str, NULL);
            }

         }

         rowsize *= 0.9f;
         complex->font->set_scale(rowsize*0.85f);
         complex->font->set_color((unsigned char)127, (unsigned char)255, (unsigned char)127);
   
         if (string_man.count < 8) {
            i = 0;
            j = string_man.count;
         }
      
         else {
            for (i = ((equip_systems_computer *)tronic)->current_status_index % string_man.count, str = (string_type *)string_man.head; i > 0; i--, str=(string_type *)str->next);
            j = 8;
         }
      
         y = 0;
      
         for (; i < j && str; i++, str=(string_type *)str->next) {
            complex->font->print(x, (int)y, (unsigned char *)str->string, mapbuffer);
            y += rowsize;
         }

         for (str = (string_type *)string_man.head; i < j; i++, str=(string_type *)str->next) {
            complex->font->print(x, (int)y, (unsigned char *)str->string, mapbuffer);
            y += rowsize;
         }

         complex->font->print(x*5, (int)y, (unsigned char *)"TASKS", mapbuffer);
         return;
   }
      
}


/* *************************************************************
************************************************************* */
void hud_display_systems_computer(mapul *mapbuffer, equip_systems_computer *sc) {

   char token[MAXSTRLEN];
   float rowsize = mapbuffer->maxy/64.0f;
   int x3 = (int)((mapbuffer->maxx*50.0f)/64.0f);
   float y, d;
   vector2i pt1, pt2, pt3, pt4;
   int i;
   equip_inertial_compensator *ic;
   vector4uc color;
   
   complex->font->set_scale(rowsize*0.85f);
   
   // crosshairs
   i = (int)(rowsize*0.3536);
   pt4[0] = mapbuffer->maxx>>1;
   pt4[1] = mapbuffer->maxy>>1;
   pt1[0] = pt4[0] - i;
   pt1[1] = pt4[1];
   pt2[0] = pt4[0] + i + 1;
   pt2[1] = pt4[1];
   pt3[0] = pt4[0];
   pt3[1] = pt4[1] - i;
   pt4[1] += i + 1;

   complex->gfx->gfxColor3ubv(sc->rgb);

   complex->gfx->gfxBegin(GFX_LINES, mapbuffer);
      complex->gfx->gfxVertex2iv(pt1);
      complex->gfx->gfxVertex2iv(pt2);
      complex->gfx->gfxVertex2iv(pt3);
      complex->gfx->gfxVertex2iv(pt4);
   complex->gfx->gfxEnd();
      
   y = mapbuffer->maxy - rowsize;

   // speed
   if (((fighter_desc *)sc->gear)->speed < 0) {
      complex->font->set_color((unsigned char)255, (unsigned char)127, (unsigned char)127);
      d = -((fighter_desc *)sc->gear)->speed/((fighter_desc *)sc->gear)->maxspeed;
   }

   else {
      complex->font->set_color((unsigned char)127, (unsigned char)255, (unsigned char)127);
      d = ((fighter_desc *)sc->gear)->speed/((fighter_desc *)sc->gear)->maxspeed;
   }

   sprintf(token, "Speed: %d", (int)(((fighter_desc *)sc->gear)->speed));
   complex->font->print(x3, (int)y, (unsigned char *)token, mapbuffer);
   y -= rowsize;

   if (d > 1.0)
      d = 1.0f;

   pt1[0] = x3;
   pt1[1] = (int)(y + 0.2*rowsize);
   pt2[0] = (int)(x3 + (d*100.0*mapbuffer->maxx)/640.0);
   pt2[1] = (int)(y + 0.8*rowsize);
   complex->gfx->gfxRectiv(mapbuffer, pt1, pt2);
   y -= rowsize;

   // speed setting
   ic = (equip_inertial_compensator *)((fighter_desc *)sc->gear)->find_category(EQUIPCAT_INERTIA);
   if (ic && ic->toggle) {
      if (((fighter_desc *)sc->gear)->set_speed_ratio < 0) {
         complex->font->set_color((unsigned char)255, (unsigned char)127, (unsigned char)127);
         d = -((fighter_desc *)sc->gear)->set_speed_ratio;
      }

      else {
         complex->font->set_color((unsigned char)127, (unsigned char)255, (unsigned char)127);
         d = ((fighter_desc *)sc->gear)->set_speed_ratio;
      }

      sprintf(token, "Speed Setting: %d%%", (int)(100.0*((fighter_desc *)sc->gear)->set_speed_ratio));
      complex->font->print(x3, (int)y, (unsigned char *)token, mapbuffer);
      y -= rowsize;

      // speed setting bar
      pt1[0] = x3;
      pt1[1] = (int)(y + 0.2*rowsize);
      pt2[0] = (int)(x3 + (d*100.0*mapbuffer->maxx)/640.0);
      pt2[1] = (int)(y + 0.8*rowsize);
      complex->gfx->gfxRectiv(mapbuffer, pt1, pt2);
      y -= rowsize;
   }

   // Overdrive text
   complex->font->set_color((unsigned char)127, (unsigned char)255, (unsigned char)127);
   complex->font->print(x3, (int)y, (unsigned char *)"Overdrive:", mapbuffer);
   y -= rowsize;

   // secondary status bar
   d = ((fighter_desc *)sc->gear)->afterburner_timer*((fighter_desc *)sc->gear)->afterburner_iburntime;
   
   if (d > 0 && ((fighter_desc *)sc->gear)->query_maxspeed() > 1.0f) {
      color[0] = (int)(d < 0.25 ? 0 : 340.0*(d-0.25));
      color[1] = (int)(255.0*( d > 0.5 ? 1.0 - d : d));
      color[2] = (int)(d > 0.75 ? 0 : 340*(0.75-d));

      complex->gfx->gfxColor3ubv(color);

      pt1[0] = x3;
      pt1[1] = (int)(y + 0.2*rowsize);
      pt2[0] = (int)(x3 + (d*100.0*mapbuffer->maxx)/640.0);
      pt2[1] = (int)(y + 0.8*rowsize);

      complex->gfx->gfxRectiv(mapbuffer, pt1, pt2);
   }

   y -= rowsize;
   
   // shield strength
   d = ((fighter_desc *)sc->gear)->max_shields < 0.5 ? 0 : ((fighter_desc *)sc->gear)->shields/((fighter_desc *)sc->gear)->max_shields;
   color[0] = 63 + (int)(192*(1-d));
   color[1] = 31 + (int)(224*d);
   color[2] = 31 + (int)(32*d);
   complex->gfx->gfxColor3ubv(color);
   complex->font->set_color(color[0], color[1], color[2]);
   sprintf(token, "S:");
   complex->font->print(x3, (int)y, (unsigned char *)token, mapbuffer);
   pt1[0] = (int)(x3 + 2*rowsize);
   pt1[1] = (int)(y + 0.2*rowsize);
   pt2[0] = (int)(x3 + (2+8*d)*rowsize);
   pt2[1] = (int)(y + 0.8*rowsize);
   complex->gfx->gfxRectiv(mapbuffer, pt1, pt2);
   y -= rowsize;

   // armour strength
   d = (((fighter_desc *)sc->gear)->max_armour < 0.5) ? 0 : ((fighter_desc *)sc->gear)->armour/(float)((fighter_desc *)sc->gear)->max_armour;
   color[0] = 63 + (int)(192*(1-d));
   color[1] = 31 + (int)(224*d);
   color[2] = 31 + (int)(32*d);
   complex->gfx->gfxColor3ubv(color);
   complex->font->set_color(color[0], color[1], color[2]);
   sprintf(token, "A:");
   complex->font->print(x3, (int)y, (unsigned char *)token, mapbuffer);
   pt1[0] = (int)(x3 + 2*rowsize);
   pt1[1] = (int)(y + 0.2*rowsize);
   pt2[0] = (int)(x3 + (2+8*d)*rowsize);
   pt2[1] = (int)(y + 0.8*rowsize);
   complex->gfx->gfxRectiv(mapbuffer, pt1, pt2);
   y -= rowsize;

   // systems integrety
   d = ((float)sc->gear->hp)/sc->gear->maxhp;
   color[0] = 63 + (int)(192*(1-d));
   color[1] = 31 + (int)(224*d);
   color[2] = 31 + (int)(32*d);
   complex->gfx->gfxColor3ubv(color);
   complex->font->set_color(color[0], color[1], color[2]);
   sprintf(token, "I:");
   complex->font->print(x3, (int)y, (unsigned char *)token, mapbuffer);
   pt1[0] = (int)(x3 + 2*rowsize);
   pt1[1] = (int)(y + 0.2*rowsize);
   pt2[0] = (int)(x3 + (2+8*d)*rowsize);
   pt2[1] = (int)(y + 0.8*rowsize);
   complex->gfx->gfxRectiv(mapbuffer, pt1, pt2);
   y -= rowsize;

   color[0] = 63;
   color[1] = 255;
   color[2] = 63;

   x3 = (int)(mapbuffer->maxx/64.0f);

   if (((UI_TYPE *)complex->userinput)->mode == COMM_MODE_IDLE) {
      if (sc->current_flag == 1)
         hud_display_systems_info(mapbuffer, sc, x3, rowsize, NULL, color, LL_DISPLAY_EQUIPMENT);
      else if (sc->current_flag == 2)
         hud_display_systems_info(mapbuffer, sc, x3, rowsize, NULL, color, LL_DISPLAY_TASKS);
   }
   
   else
      hud_display_systems_info(mapbuffer, NULL, x3, rowsize, NULL, color, LL_DISPLAY_COMM);
}


/* *************************************************************
   (target->old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TSPHERE
************************************************************* */
int hud_display_target(mapul *mapbuffer, gameatom *target, camera *cam, int target_status_flag) {

   int hwinx, hwiny;
   float radius, dist, dist05;
   vector4f u, v;
   vector2i pt[4];
   vector2f work;
   unsigned char *oglrgb;
   float *tv;
   float cosz, sinz;
   float dist2target;
   char token[MAXSTRLEN];
   float rowsize = mapbuffer->maxy/64.0f;
   int x3 = (int)(mapbuffer->maxx/64.0f);
   int ret;
   
   // alliance colors
   switch (target->flags & GAMEFLAG_ALLIANCE_MASK) {
      case GAMEFLAG_RED:
         oglrgb = ogl_red;
         break;

      case GAMEFLAG_GREEN:
         oglrgb = ogl_green;
         break;

      default:      // case GAMEFLAG_BLUE:
         oglrgb = ogl_blue;
         break;
   }

   copyarray3(v, target->old_state.tree_center);
   v[3] = 1.0f;

   radius = target->old_state.tree_radius * 0.7071f;

   // if offscreen, show direction arrow
   if (cam->query_frustum_clip(radius, v, &dist, ~FRUSTUM_CLIP_BACK) || dist < 0) {
      matvecmulto(cam->transform, v);

      if (v[2] > 0)
         v[2] = -v[2];

      cam->map2screen(v);

      hwinx = mapbuffer->maxx>>1;
      hwiny = mapbuffer->maxy>>1;

      v[0] -= (float)hwinx;
      v[1] -= (float)hwiny;

      // directly behind camera
      if ((int)v[0] && (int)v[1]) {
         normalize2(v);

         dist = (float)((hwinx < hwiny) ? hwinx : hwiny);
         dist05 = dist*0.05f;
         dist *= 0.95f;

         cosz = v[1];
         sinz = -v[0];

         pt[3][0] = (int)(v[0] * dist + hwinx);
         pt[3][1] = (int)(v[1] * dist + hwiny);

         work[0] = 0;
         work[1] = dist05;

         pt[0][0] = (int)(cosz*work[0] - sinz*work[1]) + pt[3][0];
         pt[0][1] = (int)(sinz*work[0] + cosz*work[1]) + pt[3][1];

         work[0] = 0.4330f*dist05;
         work[1] = -0.5f*dist05;

         pt[1][0] = (int)(cosz*work[0] - sinz*work[1]) + pt[3][0];
         pt[1][1] = (int)(sinz*work[0] + cosz*work[1]) + pt[3][1];

         work[0] = -0.4330f*dist05;
         work[1] = -0.5f*dist05;

         pt[2][0] = (int)(cosz*work[0] - sinz*work[1]) + pt[3][0];
         pt[2][1] = (int)(sinz*work[0] + cosz*work[1]) + pt[3][1];

         complex->gfx->gfxColor3ubv(oglrgb);

         complex->gfx->gfxBegin(GFX_LINE_LOOP, mapbuffer);
            complex->gfx->gfxVertex2iv(pt[0]);
            complex->gfx->gfxVertex2iv(pt[1]);
            complex->gfx->gfxVertex2iv(pt[2]);
         complex->gfx->gfxEnd();
      }
      
      ret = 0;
   }

   else {
      // show target box
      hud_display_calc_bbox(v, radius, cam, pt);

      complex->gfx->gfxColor3ubv(oglrgb);

      complex->gfx->gfxBegin(GFX_LINE_LOOP, mapbuffer);
         complex->gfx->gfxVertex2iv(pt[0]);
         complex->gfx->gfxVertex2iv(pt[1]);
         complex->gfx->gfxVertex2iv(pt[2]);
         complex->gfx->gfxVertex2iv(pt[3]);
      complex->gfx->gfxEnd();

      subeqarray3(u, v, cam->location);

      dist2target = (float)(magnitude3(u) - target->old_state.tree_radius);

      if (dist2target < 0)
         dist2target = 0;

      // print target distance
      if (dist2target < 1000)
         sprintf(token, " %d", (int)dist2target);
      else if (dist2target < 1000000)
         sprintf(token, " %dK", (int)(dist2target*0.001));
      else if (dist2target < 1000000000)
         sprintf(token, " %dM", (int)(dist2target*0.000001));
      else
         sprintf(token, " ##");

      complex->font->set_color(oglrgb[0], oglrgb[1], oglrgb[2]);
      dist = mapbuffer->maxy/64.0f;
      complex->font->set_scale(dist*0.9f);

      complex->font->print(pt[2][0], pt[0][1], (unsigned char *)token, mapbuffer);

      target->query_specific_data(DATAFLAG_PERCEIVED_VELOCITY, &tv);
      sprintf(token, " %d", tv[3] > CORRECT ? (int)(magnitude3(tv)/tv[3]) : 0);
      complex->font->set_color(ogl_green[0], ogl_green[1], ogl_green[2]);
      complex->font->print(pt[2][0], (int)(pt[0][1]+dist), (unsigned char *)token, mapbuffer);

      ret = 1;
   }
   
   if (target_status_flag && ((UI_TYPE *)complex->userinput)->mode == COMM_MODE_IDLE)
      hud_display_systems_info(mapbuffer, NULL, x3, rowsize, target, oglrgb, LL_DISPLAY_TARGET);

   return ret;
}


/* *************************************************************
************************************************************* */
void hud_display_subtarget(mapul *mapbuffer, gamequark *subtarget, camera *cam) {

   vector4uc oglrgb;
   vector4f v;
   float radius, dist;
   vector2i pt[4];

   if ((subtarget->old_state.state_flags & STATE_MASK_BOUND) != STATE_FLAG_BSPHERE)
      return;

   copyarray3(v, subtarget->old_state.bcenter);
   v[3] = 1.0f;

   radius = subtarget->old_state.bradius * 0.7f;

   // check for offscreen
   if (cam->query_frustum_clip(radius, v, &dist, ~FRUSTUM_CLIP_BACK) || dist < 0)
      return;

   // show target box
   hud_display_calc_bbox(v, radius, cam, pt);

   // mix yellow;
   oglrgb[0] = ogl_red[0] | ogl_green[0];
   oglrgb[1] = ogl_red[1] | ogl_green[1];
   oglrgb[2] = ogl_red[2] | ogl_green[2];
   oglrgb[3] = ogl_red[3] | ogl_green[3];

   complex->gfx->gfxColor3ubv(oglrgb);

   complex->gfx->gfxBegin(GFX_LINE_LOOP, mapbuffer);
      complex->gfx->gfxVertex2iv(pt[0]);
      complex->gfx->gfxVertex2iv(pt[1]);
      complex->gfx->gfxVertex2iv(pt[2]);
      complex->gfx->gfxVertex2iv(pt[3]);
   complex->gfx->gfxEnd();
}


/* *************************************************************
   - draw prediction reticule
   - (target->old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TSPHERE
************************************************************* */
void hud_display_intercept(mapul *mapbuffer, gameatom *target, camera *cam, quark *source, object_desc *ob, equip_targeting_computer *tc) {

   vector2i pt[4];
   vector4f v;
   vector4f target_vel;
   float dist;
   intercept_pathway prediction_comp;
   float time2target;
   equip_weapon *weapon;
   int size = mapbuffer->maxy >> 5;
   substate_type *str;
   
   if (!((fighter_desc *)ob)->equip_stat[CRADLE_PRIMARY].current)
      return;

   weapon = (equip_weapon *)((fighter_desc *)ob)->equip_stat[CRADLE_PRIMARY].current->link;
   
   matvecmulto(source->old_state.xmx, weapon->offset, v);

   target_vel[0] = target_vel[1] = target_vel[2] = target_vel[3] = 0;
   
   for (str = (substate_type *)tc->target_substate_manager.head; str; str = (substate_type *)str->next)
      addarray4(target_vel, str->weighted_velocity);
      
   // calc if target in range, and interception location
   if (!prediction_comp.intercept_prediction(target->old_state.tree_center, target_vel, v, weapon->speed, v, &time2target) ||
       cam->query_frustum_clip(target->old_state.tree_radius, v, &dist, ~FRUSTUM_CLIP_BACK) || dist < 0 ||
       time2target > weapon->max_range/weapon->speed)
      return;

   hud_display_calc_bbox(v, size, cam, pt);

   complex->gfx->gfxColor3ubv(ogl_green);

   complex->gfx->gfxBegin(GFX_LINE_LOOP, mapbuffer);
      complex->gfx->gfxVertex2iv(pt[0]);
      complex->gfx->gfxVertex2iv(pt[1]);
      complex->gfx->gfxVertex2iv(pt[2]);
      complex->gfx->gfxVertex2iv(pt[3]);
   complex->gfx->gfxEnd();
}


/* *************************************************************
    (target->old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TSPHERE
************************************************************* */
void hud_display_missile_lock(mapul *mapbuffer, gameatom *target, camera *cam, quark *source, float countdown, float maxtime, object_desc *ob) {

   float dist;
   vector4uc color;
   vector2i pt[4];
   vector2i circ[8];
   vector2i cross[4];
   vector2i center;
   int iradius1, iradius2, iradius3;

   if (!((fighter_desc *)ob)->query_fire(EQUIPCAT_SECONDARY_WEAPON))
      return;

//   if (cam->query_frustum_clip(target->old_state.tree_radius, target->old_state.tree_center, &dist, ~FRUSTUM_CLIP_BACK) || dist < 0)
//      return;

   // show target box
   hud_display_calc_bbox(target->old_state.tree_center, target->old_state.tree_radius, cam, pt);
   dist =  (countdown < 0) ? 0.5f : 0.5f - (countdown * 0.5f)/maxtime;
   center[0] = (int)(dist*(pt[0][0] + pt[2][0]));
   center[1] = (int)(dist*(pt[0][1] + pt[1][1]));

   iradius1 = (pt[2][0] - pt[0][0]) >> 1;
   iradius2 = (pt[1][1] - pt[0][1]) >> 1;

   if (iradius2 > iradius1)
      iradius1 = iradius2;

   iradius2 = (int)(iradius1 * 0.3536);
   iradius3 = (int)(iradius1 * 0.25);
   iradius1 = (int)(iradius1 * 0.5);

   if (iradius3 < 2) {
      iradius3 = 2;
      iradius2 = 3;
      iradius1 = 4;
   }

   circ[0][0] = center[0];
   circ[0][1] = center[1] + iradius2;
   circ[1][0] = center[0] + iradius3;
   circ[1][1] = center[1] + iradius3;
   circ[2][0] = center[0] + iradius2;
   circ[2][1] = center[1];
   circ[3][0] = center[0] + iradius3;
   circ[3][1] = center[1] - iradius3;
   circ[4][0] = center[0];
   circ[4][1] = center[1] - iradius2;
   circ[5][0] = center[0] - iradius3;
   circ[5][1] = center[1] - iradius3;
   circ[6][0] = center[0] - iradius2;
   circ[6][1] = center[1];
   circ[7][0] = center[0] - iradius3;
   circ[7][1] = center[1] + iradius3;

   cross[0][0] = center[0] - iradius1;
   cross[0][1] = center[1];
   cross[1][0] = center[0] + iradius1;
   cross[1][1] = center[1];

   cross[2][0] = center[0];
   cross[2][1] = center[1] - iradius1;
   cross[3][0] = center[0];
   cross[3][1] = center[1] + iradius1;

   if (countdown > 0) {
      complex->gfx->gfxColor3ubv(ogl_red);
   }

   else {
      iradius1 = ((int)(countdown * 127)) & 127;

      if (iradius1 < 127)
         dist = iradius1/63.0f;
      else
         dist = (127-iradius1)/63.0f;

      color[0] = (unsigned char )(ogl_red[0] * dist);
      color[1] = (unsigned char )(ogl_red[1] * dist);
      color[2] = (unsigned char )(ogl_red[2] * dist);
      color[3] = 255;
      complex->gfx->gfxColor3ubv(color);
   }

   complex->gfx->gfxBegin(GFX_LINE_LOOP, mapbuffer);
      complex->gfx->gfxVertex2iv(circ[0]);
      complex->gfx->gfxVertex2iv(circ[1]);
      complex->gfx->gfxVertex2iv(circ[2]);
      complex->gfx->gfxVertex2iv(circ[3]);
      complex->gfx->gfxVertex2iv(circ[4]);
      complex->gfx->gfxVertex2iv(circ[5]);
      complex->gfx->gfxVertex2iv(circ[6]);
      complex->gfx->gfxVertex2iv(circ[7]);
   complex->gfx->gfxEnd();

   complex->gfx->gfxBegin(GFX_LINES, mapbuffer);
      complex->gfx->gfxVertex2iv(cross[0]);
      complex->gfx->gfxVertex2iv(cross[1]);
      complex->gfx->gfxVertex2iv(cross[2]);
      complex->gfx->gfxVertex2iv(cross[3]);
   complex->gfx->gfxEnd();
}

