

/* *************************************************************
   This file contains some of the file I/O routines
************************************************************** */


#include <stdlib.h>


#ifdef WIN32
#include "winsnd.h"

#define USER_IO_TYPE dark_uio_win
#define SOUNDMAN_TYPE soundman_win

#else

#include <string.h>

#include "soundman.h"
#include "WIN_X.h"

#define USER_IO_TYPE dark_uio_X
#define SOUNDMAN_TYPE soundman

#endif

#include "image.h"
#include "pstring.h"

#include "electron.h"
#include "photon.h"

#include "follow.h"
#include "flat.h"

#include "cam_ai.h"
#include "thruster.h"
#include "turrent.h"
#include "darkgine.h"
#include "fighter.h"
#include "stars.h"
#include "darkfx.h"
#include "darkwin.h"


/* *************************************************************
************************************************************* */
int parse_animate_list(dbl_llist_manager *hiearchy_manager, char *filename, string_type *backname) {

   FILE       *infile;                          // input file
   int        count;                            // # of objects
   gameatom   *ptr;                             // temp ptr
   atom_list_type *atr;
   int        i;                                // looping var
   char token[MAXSTRLEN], buffer[MAXSTRLEN];
   eventtype *etr;
   dbl_llist_manager *atom_loader;
   geneological_type ani_param;

   if (backname)
      backname->string[0] = 0;

   atom_loader = (dbl_llist_manager *)global_resource_manager->get_resource_object(RESOURCE_ATOM_LOADER);

   if (!atom_loader->head) {
      fprintf(logfile, "Error: No \"atom loader\" resources are registered...  Aborting...\n");
      exit(0);
   }

   infile = fopen(filename, "r");

   if (!infile) {
      fprintf(logfile, "Error: Could not access %s...  Aborting...\n", filename);
      exit(0);
   }

   get_token(infile, token);
   lower_case(token);

   if (strcmp(token, "gamegine")) {
      fprintf(logfile, "Error: Input file not a Gamegine script...  Aborting...\n");
      fclose(infile);
      exit(0);
   }

   get_token(infile, token);                // atom count
   get_token(infile, token);
   count = atoi(token);

   while (!count) {
      if (backname)
         backname->stringcpy(token);

      get_token(infile, token);                // atom count
      get_token(infile, token);
      count = atoi(token);
   }

   for (i=0; i<count; i++) {

      get_token(infile, token);             // atm type
      lower_case(token);
      get_token(infile, buffer);            // "{"

      ptr = (gameatom *)((quark_loader *)atom_loader->head)->parse(infile, token);

      if (!ptr) {
         fprintf(logfile, "Invalid object type \"%s\"\n", token);
         fclose(infile);
         exit(0);
      }

      for (etr=(eventtype *)ptr->event_manager.head; etr; etr=(eventtype *)etr->next) {
         sprintf(token, "%s%s", FILENAME_PREMIS, etr->efilename.string);
         etr->efilename.stringcpy(token);
      }

      strcpy(token, ptr->name.string[0] ? ptr->name.string : ptr->filename.string);
      sprintf(buffer, "%s%s", FILENAME_PREATM, ptr->filename.string);

      ptr->read_data(buffer);      // read atom hiearchy
      ptr->name.stringcpy(token);
      hiearchy_manager->append(atr = new atom_list_type, NULL);
      atr->htree = ptr;
   }

   for (atr = (atom_list_type *)hiearchy_manager->head; atr; atr = (atom_list_type *)atr->next) {
      ani_param.parent = NULL;
      ani_param.tree = atr;
      atr->htree->preprocess(&ani_param);
   }

   fclose(infile);
   return 1;
}


/* *************************************************************
************************************************************* */
sim_sim *parse_ai_list(char *filename) {

   sim_sim *ob;
   FILE    *infile;
   char    token[MAXSTRLEN];
   sim_preprocess_type spt;

   infile = fopen(filename, "r");

   ob = new sim_sim;

   spt.head = ob;
   spt.parent = NULL;

   if (infile) {
      
      while (get_token(infile, token))
         ob->parse(infile, token);

      ob->preprocess(&spt);
   
      fclose(infile);
   }

   return ob;
}


/* **************************************************
************************************************** */
void init_aloader(gamegod_type *ggod) {

   // texture loader
   ggod->register_resource_loader(RESOURCE_IMAGE_LOADER, new rtf);

   // quark loaders
   ggod->register_resource_loader(RESOURCE_OBJECT_LOADER, new electron_loader);
   ggod->register_resource_loader(RESOURCE_OBJECT_LOADER, new photon_loader);

   ggod->register_resource_loader(RESOURCE_OBJECT_LOADER, new gamequark_loader);
   ggod->register_resource_loader(RESOURCE_OBJECT_LOADER, new antiflat_loader);

   ggod->register_resource_loader(RESOURCE_OBJECT_LOADER, new darkneutron_loader);
   ggod->register_resource_loader(RESOURCE_OBJECT_LOADER, new stars_loader);
   ggod->register_resource_loader(RESOURCE_OBJECT_LOADER, new dust_loader);
   ggod->register_resource_loader(RESOURCE_OBJECT_LOADER, new turrent_loader);
   ggod->register_resource_loader(RESOURCE_OBJECT_LOADER, new barrel_loader);
   ggod->register_resource_loader(RESOURCE_OBJECT_LOADER, new thruster_loader);

   // atom loaders
   ggod->register_resource_loader(RESOURCE_ATOM_LOADER, new player_loader);
   ggod->register_resource_loader(RESOURCE_ATOM_LOADER, new npc_fighter_loader);
   ggod->register_resource_loader(RESOURCE_ATOM_LOADER, new follow_loader);
   ggod->register_resource_loader(RESOURCE_ATOM_LOADER, new camera_control_loader);
   ggod->register_resource_loader(RESOURCE_ATOM_LOADER, new darkmover_loader);
   ggod->register_resource_loader(RESOURCE_ATOM_LOADER, new darkentity_loader);
   ggod->register_resource_loader(RESOURCE_ATOM_LOADER, new gameatom_loader);

   // equipment loaders
   ggod->register_resource_loader(RESOURCE_EQUIP_LOADER, new equip_engine_loader);
   ggod->register_resource_loader(RESOURCE_EQUIP_LOADER, new equip_thruster_loader);
   ggod->register_resource_loader(RESOURCE_EQUIP_LOADER, new equip_lazer_loader);
   ggod->register_resource_loader(RESOURCE_EQUIP_LOADER, new equip_lazer2blu_loader);
   ggod->register_resource_loader(RESOURCE_EQUIP_LOADER, new equip_lazer2red_loader);
   ggod->register_resource_loader(RESOURCE_EQUIP_LOADER, new equip_dual_lazer_loader);
   ggod->register_resource_loader(RESOURCE_EQUIP_LOADER, new equip_cone_lazer_loader);
   ggod->register_resource_loader(RESOURCE_EQUIP_LOADER, new equip_rail_gun_loader);
   ggod->register_resource_loader(RESOURCE_EQUIP_LOADER, new equip_launcher_loader);
   ggod->register_resource_loader(RESOURCE_EQUIP_LOADER, new equip_zuni_launcher_loader);
   ggod->register_resource_loader(RESOURCE_EQUIP_LOADER, new equip_ssm_launcher_loader);
   ggod->register_resource_loader(RESOURCE_EQUIP_LOADER, new equip_targeting_computer_loader);
   ggod->register_resource_loader(RESOURCE_EQUIP_LOADER, new equip_systems_computer_loader);
   ggod->register_resource_loader(RESOURCE_EQUIP_LOADER, new equip_ablative_armour_loader);
   ggod->register_resource_loader(RESOURCE_EQUIP_LOADER, new equip_shields_loader);
   ggod->register_resource_loader(RESOURCE_EQUIP_LOADER, new equip_inertial_compensator_loader);
   ggod->register_resource_loader(RESOURCE_EQUIP_LOADER, new equip_inertial_dampener_loader);
   ggod->register_resource_loader(RESOURCE_EQUIP_LOADER, new equip_radar_loader);

   // fx loaders
   ggod->teacher.register_launcher(new fx_magnetic_mine_launcher);
   ggod->teacher.register_launcher(new fx_lazer_launcher);
   ggod->teacher.register_launcher(new fx_lazer2blu_launcher);
   ggod->teacher.register_launcher(new fx_lazer2red_launcher);
   ggod->teacher.register_launcher(new fx_lazerii_launcher);
   ggod->teacher.register_launcher(new fx_lazeriii_launcher);
   ggod->teacher.register_launcher(new fx_dual_lazer_launcher);
   ggod->teacher.register_launcher(new fx_cone_lazer_launcher);
   ggod->teacher.register_launcher(new fx_rail_round_launcher);
   ggod->teacher.register_launcher(new fx_missile_launcher);
   ggod->teacher.register_launcher(new fx_zuni_missile_launcher);
   ggod->teacher.register_launcher(new fx_ssm_missile_launcher);
   ggod->teacher.register_launcher(new fx_generic_flat_launcher);
   ggod->teacher.register_launcher(new fx_human_shield_ripple_launcher);
   ggod->teacher.register_launcher(new fx_alien_shield_ripple_launcher);
   ggod->teacher.register_launcher(new fx_smoke_trail_launcher);
   ggod->teacher.register_launcher(new fx_explosion_launcher);
   ggod->teacher.register_launcher(new fx_shockwave_launcher);
}


/* **************************************************
************************************************** */
void init_game(BLTwindow *win) {

   dark_god *darky;

   strcpy(FILENAME_PREILM, "objects/");

   // setup managers
   darky = new dark_god(&proc);
   darky->set_win(win);
   darky->set_game_manager(new game_manager);
   darky->set_sound_manager(new SOUNDMAN_TYPE);
   darky->set_io_manager(new USER_IO_TYPE);
   darky->set_gfx_manager(RENDER_MODE == RENDERER_OPENGL ? (base_gfx *)new ogl_gfx : (base_gfx *)new sw_gfx);

   // build anitroll loader list
   init_aloader(darky);

   // init gamegine libs
   init_gamegine(darky);
}


/* **************************************************
************************************************** */
void cleanup_game () {

   world_sphere.deconstruct(&world_freelist);

   world_freelist.dest();

   vfx_dest();
   
   // garbage cleanup
   complex->animation_manager.dest();

   if (sheader) {
      delete sheader;
      sheader = NULL;
   }

}


/* **************************************************
************************************************** */
void dest_game() {

   cleanup_game();
   shutdown_gamegine();
}


/* **************************************************
************************************************** */
void endgame(BLTwindow *win) {

   cleanup_game();
   global_resource_manager->reset();
   complex->reset();
   complex->gfx->gfx2DMode(win->mapbuffer.maxx, win->mapbuffer.maxy);
}
