

#include <stdlib.h>

#include "darkgine.h"

#ifdef WIN32

#include "WIN_WOGL.h"
#include "winsnd.h"

#define WINDOWTYPE WIN32window

char PIXCON_ENV[] = "PIXCON_PATH=textures;font";

#else

#ifdef __FreeBSD__
#include <floatingpoint.h>
#endif

#include "WIN_XOGL.h"

#define WINDOWTYPE XOGLwindow

char PIXCON_ENV[] = "PIXCON_PATH=textures:font";

#endif


int shutdown_flag = 0;


/* **************************************************
************************************************** */
void shutdown() {

   if (shutdown_flag)
      return;

#ifdef __FreeBSD__
   fpresetsticky(FP_X_INV|FP_X_OFL|FP_X_UFL|FP_X_DZ|FP_X_IMP|FP_X_DNML);
#endif

   dest_game();
   shutdown_flag = 1;
}


/* **************************************************
   main: program controller
************************************************** */


#ifdef WIN32
int PASCAL WinMain(HINSTANCE currentInstance, HINSTANCE previousInstance, LPSTR commandLine, int commandShow) {

   int argc = 1;
   char *argv[1] = { commandLine };

#else
int main(int argc, char **argv) {
#endif

   WINDOWTYPE *win;
   int winx, winy;

   int attribs[] = {
//      OGLFLAG_BPP, 16,
      OGLFLAG_BPP, 32,
      OGLFLAG_DOUBLEBUFFER,
      OGLFLAG_RGBA,
      OGLFLAG_MAPBUFFER,
      OGLFLAG_DEPTH_SIZE, 1,
      OGLFLAG_NULL
   };

   putenv(PIXCON_ENV);
   atexit(shutdown);

   // config system
   gfx_get_screen_dim(&winx, &winy);
   parseinput(FILENAME_SETUP);
   parseinput(argc, argv);

#ifdef WIN32

   // init screen
   win = (WIN32window *)new WOGLwindow;

#else

#ifdef __FreeBSD__
   fpsetmask(0);
#endif

   if (RENDER_MODE != RENDERER_OPENGL)
      attribs[5] = OGLFLAG_NULL;

   // init screen
   win = new XOGLwindow;
#endif

   if (!win->VIRTUALreset(argc, argv, winx, winy, "Pixcon", (void *)attribs))
      return 0;

   // init the game engine
   init_game(win);

   // init buffers
   if (RENDER_MODE != RENDERER_OPENGL)
      proc.zdata.init_map(winx, winy, 2);

   // start up the game
   render_main_menu(win);

   shutdown();
   win->VIRTUALcancel();
   delete win;

   return 1;
}

