

#include <string.h>

#include "pstring.h"

#include "polygame.h"

#include "darkgine.h"
#include "darkfx.h"


#define SMOKE_XY2UV_SCALE 0.25f  // object is 4 units wide


/* *************************************************************
************************************************************* */
smoke_trail::smoke_trail() {

   char buffer[MAXSTRLEN];

   ob = complex->gfx->gfxAllocRenderObject(OBJECT_POLYGON);
   ob->id = object_counter;
   object_counter++;

   sprintf(buffer, "smoke%d.tex", id);

   tob = new texpolygon;
   tob->altname.stringcpy(buffer);
   tob->dataname.stringcpy(buffer);

   global_resource_manager->register_resource_object(RESOURCE_UVCOORD, tob);

   tob->setup(1);

   ((polygame *)ob)->texname2.stringcpy(buffer);
   ((polygame *)ob)->setup_texture(tob);
}


/* *************************************************************
************************************************************* */
int smoke_trail::query_whatwasi(int type) {

   return (smoke_trail::query_whatami() == type) ? 1 : fx_type::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
void smoke_trail::preprocess(void *data) {

   char buffer[MAXSTRLEN];
   
   ((polygame *)ob)->filename.stringcpy(FILENAME_SMOKE_TRAIL);
   ((polygame *)ob)->filename.stringcat(".spg");
   
   sprintf(buffer, "fakelum%d.ilm", id);
   ((polygame *)ob)->colorname.stringcpy(buffer);

   ((polygame *)ob)->mctype.set_master(CONSTANT);
   ((polygame *)ob)->mcinfo.mask_and(~(CITRANSPARENT | CITEXTURE));

   fx_type::preprocess(data);
   
   ((polygame *)ob)->mcinfo.mask_or(CITRANSPARENT | CITEXTURE);
   
   cam = NULL;
}


/* *************************************************************
   asdf - code should handle case where smoke intersects camera
          or is parallel/on the line of sight
	  same code as lazer2blu
************************************************************* */
void  smoke_trail::fail_rotate() {

}


/* *************************************************************
   note: assume no scaling in state.xmx
************************************************************* */
int smoke_trail::post_rotate() {

   vector3f v0, v1, v2;
   
   v2[0] = state.xmx[0][3];
   v2[1] = state.xmx[1][3];
   v2[2] = state.xmx[2][3];
   
   subeqarray3(v1, cam->state.center, v2);

   v2[0] = state.xmx[0][2];
   v2[1] = state.xmx[1][2];
   v2[2] = state.xmx[2][2];
   
   xproduct(v0, v1, v2);

   // check if same positions
   if (dotproduct3(v0, v0) < CORRECT) {
      fail_rotate();      
      return 0;      
   }
   
   normalize3(v0);

   // check if parallel
   if (dotproduct3(v0, v2) > ICORRECT) {
      fail_rotate();      
      return 0;      
   }

   xproduct(v1, v2, v0);

   state.xmx[0][0] = v0[0];   
   state.xmx[1][0] = v0[1];   
   state.xmx[2][0] = v0[2];   

   state.xmx[0][1] = v1[0];   
   state.xmx[1][1] = v1[1];   
   state.xmx[2][1] = v1[2];   

   return 1;
}
 
  
/* *************************************************************
************************************************************* */
void smoke_trail::begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   quark::begin(hiearchy_manager, parent, mx);

   complex->gfx->gfxPolygonIncrementTime((polygon *)ob, complex->timer.speedscale/duration);
}


/* *************************************************************
************************************************************* */
void smoke_trail::whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   linktype *ptr;
   float t;
   shadetype *ilm;
   shade_block *sblock;

   matmatmulto(mx, initxform, state.xmx);

   post_rotate();
   
   copymx4x4o(state.node, state.xmx);
   
   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent)                   
         ptr->link->whereami(hiearchy_manager, this, state.node);

   state.center[0] = state.xmx[0][3];
   state.center[1] = state.xmx[1][3];
   state.center[2] = state.xmx[2][3];

   state.xmx[0][2] *= dist_scale;
   state.xmx[1][2] *= dist_scale;
   state.xmx[2][2] *= dist_scale;

   setup();
   
   t = 1.0f/duration;
   complex->gfx->gfxPolygonIncrementTime((polygon *)ob, complex->timer.speedscale*t);

   if (timer_flag) {
      timer -= complex->timer.speedscale;
      t *= timer;

      sblock = (shade_block *)((polygame *)ob)->lob->query_data();
      ilm = &((polygame *)ob)->lob->base;

      sblock->shade_palette[0].lum[0] = sblock->shade_palette[0].lum[1] = sblock->shade_palette[0].lum[2] = 
         ilm->lum[0] = ilm->lum[1] = ilm->lum[2] = (int)(255.0*t);

      sblock->shade_palette[0].flum[0] = sblock->shade_palette[0].flum[1] = sblock->shade_palette[0].flum[2] = 
         ilm->flum[0] = ilm->flum[1] = ilm->flum[2] = t;
   }

}


/* *************************************************************
************************************************************* */
void smoke_trail::update(dbl_llist_manager *hiearchy_manager, quark *parent) {

   gamequark::update(hiearchy_manager, parent);

   if (timer <= 0)
      flags &= ~QUARK_FLAG_ACTIVE;
}


/* *************************************************************
************************************************************* */
void smoke_trail::update(float *pos, int breakflag) {

   vector2f uv[4];
   vector4f x, y, z;
   vector4f r[4];
   float t;
   
   if (breakflag)
      timer_flag = 1;
 
   if (!pos)
      return;
              
   copyarray4(end, pos);
   subeqarray3(z, pos, start);

   dist_scale = dotproduct3(z, z);
   dist_scale = dist_scale < 1.0f ? 1.0f : (float)sqrt(dist_scale);
   t = dist_scale*SMOKE_XY2UV_SCALE;
   
   uv[0][0] = 0;
   uv[0][1] = t;
   uv[1][0] = 0;
   uv[1][1] = 0;
   uv[2][0] = 1.0f;
   uv[2][1] = 0;
   uv[3][0] = 1.0f;
   uv[3][1] = t;

   t = 1.0f/dist_scale;
   tob->direct2Dmap(0, uv, tmap, 4, 0);

   smultarray3(z, t);
   
   //scale is built in ...
   initxform[0][2] = z[0];
   initxform[1][2] = z[1];
   initxform[2][2] = z[2];

   if (fabs(z[0]) < 0.6) {
      y[0] = 1.0f;
      y[1] = y[2] = 0;
   }

   else if (fabs(z[1]) < 0.6) {
      y[1] = 1.0f;
      y[0] = y[2] = 0;
   }

   else {
      y[2] = 1.0f;
      y[0] = y[1] = 0;
   }

   xproduct(x, y, z);
   normalize3(x);

   initxform[0][0] = x[0];
   initxform[1][0] = x[1];
   initxform[2][0] = x[2];

   xproduct(y, z, x);

   initxform[0][1] = y[0];
   initxform[1][1] = y[1];
   initxform[2][1] = y[2];

   initxform[0][3] = end[0];
   initxform[1][3] = end[1];
   initxform[2][3] = end[2];

   initxform[3][0] = initxform[3][1] = initxform[3][2] = 0;
   initxform[3][3] = 1.0f;

   // convert initxform into "local" coords
   inversemx(complex->teacher.old_state.xmx, r);
   matmatmulto(r, initxform);
}


/* *************************************************************
************************************************************* */
void smoke_trail::init(vector4f *mx, float *offset, float timelimit, texbase *stob) {

   vector4f v;
   shadetype *ilm;
   shade_block *sblock;
   atom_list_type *atr;

   tmap = stob;

   for (atr = (atom_list_type *)complex->animation_manager.head; atr && !atr->htree->query_whatwasi(OBJECT_CAMERA_CONTROL); atr = (atom_list_type *)atr->next);

   cam = atr ? (gameatom *)atr->htree : (gameatom *)NULL;

   matvecmulto(mx, offset, start);

   v[0] = start[0] + mx[0][2];
   v[1] = start[1] + mx[1][2];
   v[2] = start[2] + mx[2][2];
   v[3] = 1.0f;

   ilm = &((polygame *)ob)->lob->base;
   ilm->ka[0] = ilm->ka[1] = ilm->ka[2] = 0;
   ilm->kp[0] = ilm->kp[1] = ilm->kp[2] = 0;
   ilm->ks[0] = ilm->ks[1] = ilm->ks[2] = 0;
   ilm->fka[0] = ilm->fka[1] = ilm->fka[2] = 0;
   ilm->fkp[0] = ilm->fkp[1] = ilm->fkp[2] = 0;
   ilm->fks[0] = ilm->fks[1] = ilm->fks[2] = 0;
   ilm->specn = 1.0f;
   ilm->lum[0] = ilm->lum[1] = ilm->lum[2] = 255;
   ilm->flum[0] = ilm->flum[1] = ilm->flum[2] = 1.0f;

   sblock = (shade_block *)((polygame *)ob)->lob->query_data();
   memcpy(&sblock->shade_palette[0], ilm, sizeof(shadetype));

   timer = duration = timelimit;
   update(v, 0);
}
