

#include "polygame.h"
#include "gamegine.h"

#include "darkfx.h"


/* *************************************************************
************************************************************* */
shield_ripple::shield_ripple() {

   ob = complex->gfx->gfxAllocRenderObject(OBJECT_POLYGON);
   ob->id = object_counter;
   object_counter++;
}


/* *************************************************************
************************************************************* */
int shield_ripple::query_whatwasi(int type) {

   return shield_ripple::query_whatami() == type ? 1 : fx_type::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
void shield_ripple::preprocess(void *data) {

   ((polygame *)ob)->filename.stringcpy(FILENAME_SHIELD);
   ((polygame *)ob)->filename.stringcat(".spg");
   
   ((polygame *)ob)->texname2.stringcpy(FILENAME_SHIELD);
   ((polygame *)ob)->texname2.stringcat(".tex");
   
   ((polygame *)ob)->colorname.stringcpy(FILENAME_LUM);
   ((polygame *)ob)->colorname.stringcat(".ilm");
   
   ((pc *)ob)->mcinfo.mask_or(CITEXTURE | CITRANSPARENT | CIINVISO);
   ((polygon *)ob)->inviso = 0;

   ((polygame *)ob)->mctype.set_master(CONSTANT);

   fx_type::preprocess(data);
}


/* *************************************************************
************************************************************* */
void shield_ripple::update(dbl_llist_manager *hiearchy_manager, quark *parent) {

   gamequark::update(hiearchy_manager, parent);

   if (countdown > timelimit)
      flags &= ~QUARK_FLAG_ACTIVE;
}


/* *************************************************************
************************************************************* */
void shield_ripple::init() {

   fx_type::init();

   init_mx(initxform);
   countdown = timelimit = 0;
   complex->gfx->gfxPolygonInit((polygon *)ob);
   tether = NULL;
}


/* *************************************************************
************************************************************* */
void shield_ripple::init(quark *source, vector4f *parent_mx, float *pos, float *shield_data, float duration) {

   vector4f imx[4];
   vector4f v;
   float dist, len;
   float *scale, *bcenter;

   attach_flag = 1;
   scale  = shield_data;
   bcenter = &shield_data[3];

   timelimit = duration;
   init_mx(localmx);

   // convert pos to a local offset
   inversemx(source->old_state.xmx, imx);

   matvecmulto(imx, pos, v);
   v[3] = 1.0f;

   subarray3(v, bcenter);
   divarray3(v, scale);

   len = dotproduct3(v, v);

   if (len > CORRECT) {
      len = (float)sqrt(len);

      // pitch
      rotate_mx_x(localmx, -ASIN(v[1]/len));

      // yaw
      dist = v[0]*v[0] + v[2]*v[2];

      if (dist > CORRECT) {
         dist = (v[0] >= 0) ? ACOS(v[2]/sqrt(dist)) : -ACOS(v[2]/sqrt(dist));
         rotate_mx_y(localmx, dist);
      }

   }

   else
      len = 1.0;

   dist = len*scale[0];
   smultarray3(localmx[0], dist);
   dist = len*scale[1];
   smultarray3(localmx[1], dist);
   dist = len*scale[2];
   smultarray3(localmx[2], dist);

   localmx[0][3] = bcenter[0];
   localmx[1][3] = bcenter[1];
   localmx[2][3] = bcenter[2];

   tether = source;
}


/* *************************************************************
************************************************************* */
void shield_ripple::begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   quark::begin(hiearchy_manager, parent, mx);

   complex->gfx->gfxPolygonIncrementTime((polygon *)ob, complex->timer.speedscale/timelimit);
}


/* *************************************************************
    attached to an object -> "mx" is ignored
************************************************************* */
void shield_ripple::whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   linktype *ptr;

   countdown += complex->timer.speedscale;

   if (tether)
      if (tether->flags & QUARK_FLAG_ACTIVE) {
         copymx4x4o(state.node, tether->old_state.xmx);
      }
      
      else if (attach_flag) {
         attach_flag = 0;
         inversemx(mx, state.node);
         matmatmulto(state.node, tether->old_state.xmx, initxform);
         initxform[3][0] = initxform[3][1] = initxform[3][2] = 0;
         initxform[3][3] = 1;
         copymx4x4o(state.node, initxform);
      }

      else {
         copymx4x4o(state.node, initxform);
      }
      
   else {
      copymx4x4o(state.node, initxform);
   }
   
   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent)                          
         ptr->link->whereami(hiearchy_manager, this, state.node);

   matmatmulto(state.node, localmx, state.xmx);
   state.xmx[3][0] = state.xmx[3][1] = state.xmx[3][2] = 0;
   state.xmx[3][3] = 1;

   state.center[0] = state.xmx[0][3];
   state.center[1] = state.xmx[1][3];
   state.center[2] = state.xmx[2][3];

   setup(); 
   complex->gfx->gfxPolygonIncrementTime((polygon *)ob, complex->timer.speedscale/timelimit);
}

