

#include "polygame.h"
#include "anineutr.h"

#include "darkfx.h"
#include "darkgine.h"


#define BLAST_RADIUS    32


/* *************************************************************
************************************************************* */
int rail_round::query_whatwasi(int type) {

   return rail_round::query_whatami() == type ? 1 : lazer::query_whatwasi(type);
}


/* *************************************************************
   bypasses lazer::preprocess();
************************************************************* */
void rail_round::preprocess(void *data) {

   antineutron *head;
   polygon *rob;

   ((polygame *)ob)->filename.stringcpy(FILENAME_RAIL_GUN_BURSTB);
   ((polygame *)ob)->filename.stringcat(".spb");
   
   ((polygame *)ob)->texname2.stringcpy(FILENAME_RAIL_GUN_BURSTB);
   ((polygame *)ob)->texname2.stringcat(".tex");
   
   ((polygame *)ob)->colorname.stringcpy(FILENAME_RAIL_GUN_BURSTB);
   ((polygame *)ob)->colorname.stringcat(".ilm");
   
   ((polygame *)ob)->mcinfo.mask_or(CITEXTURE);
   ((polygame *)ob)->mctype.set_master(CONSTANT);

   death_tob = NULL;

   // tracer
   head = new antineutron;

   head->create_link(this);
   create_link(head);

   rob = (polygon *)head->get_render_object();

   rob->filename.stringcpy(FILENAME_RAIL_GUN_BURSTA);
   rob->filename.stringcat(".spg");
   
   rob->colorname.stringcpy(FILENAME_LUM);
   rob->colorname.stringcat(".ilm");
   
   rob->mctype.set_master(CONSTANT);

   fx_type::preprocess(data);
}


/* *************************************************************
************************************************************* */
void rail_round::whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   target_type target;
   linktype *ptr;
   vector4f pos;
   vector3f normal;
   int col_type;
   generic_flat *fx;
   vector4f r[4];

   process_intel();

   matmatmulto(mx, initxform, state.xmx);

   process_collision(&target, pos, normal, &col_type);

   if (target.object) {

      distance = -1;

      if (sheader && owner->htree == global_player)
         sheader->player_primary_hit_count++;

      // explosion f/x
      if (col_type != COL_SHIELDS && death_tob) {
         fx = (generic_flat *)complex->teacher.issue(OBJECT_GENERIC_FLAT);

         init_mx(r);
         r[0][0] = r[1][1] = r[2][2] = BLAST_RADIUS;
         fx->init(target.specific ? target.specific : target.object->htree, DEFAULT_FX_BLAST_TIME, BLAST_RADIUS, pos, mx, r, death_tob);
      }

      // damage
      damage_target((gameatom *)target.object->htree, target.specific ? target.specific : target.object->htree, target.specific_parent, NULL, pos, mx);
   }

   copymx4x4o(state.node, state.xmx);

   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent)                       
         ptr->link->whereami(hiearchy_manager, this, state.node);

   state.center[0] = state.xmx[0][3];
   state.center[1] = state.xmx[1][3];
   state.center[2] = state.xmx[2][3];

   setup();
}

