

#include "brain.h"
#include "polygame.h"
#include "gamegine.h"

#include "darkfx.h"


/* *************************************************************
************************************************************* */
void ssm_missile::process_intel() {

   float temp, dist;
   float timescale = complex->timer.speedscale;
   vector3f v, curr_dir;
   int flag = 0;
   vector4f r[4];
   orient_pathway orient;
   intercept_pathway predict;

   if (!lockflag) {
      missile::process_intel();
      return;
   }
   
   // calc destination
   if (GQUARK_STATUS(specific_target.specific, (gameatom *)specific_target.object->htree))
      flag = predict.intercept_prediction(specific_target.specific, old_state.center, maxspeed, target_pos, &temp);
   else if (GATOM_STATUS(specific_target.object))
      flag = predict.intercept_prediction(specific_target.object->htree, old_state.center, maxspeed, target_pos, &temp);
   else
      lockflag = 0;
	 
   if (!lockflag) {
      temp = (float)(target_speed/sqrt(initxform[0][2]*initxform[0][2] + initxform[1][2]*initxform[1][2] + initxform[2][2]*initxform[2][2]));

      target_vel[0] = temp*initxform[0][2];
      target_vel[1] = temp*initxform[1][2];
      target_vel[2] = temp*initxform[2][2];

      missile::process_intel();
      return;
   }
   
   if (flag) {
      inversemx(complex->teacher.old_state.xmx, r);
      matvecmulto(r, target_pos);
      specific_target.object->htree->set_specific_data(DATAFLAG_MISSILE_LOCK, this);
   }
   
   else {
      target_pos[0] += timescale*target_vel[0];
      target_pos[1] += timescale*target_vel[1];
      target_pos[2] += timescale*target_vel[2];
   }
      
   // calc desired direction
   v[0] = target_pos[0] - initxform[0][3];
   v[1] = target_pos[1] - initxform[1][3];
   v[2] = target_pos[2] - initxform[2][3];
   normalize3(v);

   curr_dir[0] = initxform[0][2];
   curr_dir[1] = initxform[1][2];
   curr_dir[2] = initxform[2][2];
   normalize3(curr_dir);
   
   orient.calc_orientation(curr_dir, v, dorient, r, AXIS_Y);
   matmatmultv(r, initxform);

   // calculate  new speed/velocity
   temp = timescale*accel;
   v[0] = speed*vel[0] + temp*initxform[0][2];
   v[1] = speed*vel[1] + temp*initxform[1][2];
   v[2] = speed*vel[2] + temp*initxform[2][2];

   temp = dotproduct3(v,v);

   if (temp > CORRECT) {
      copyarray3(vel, v);
	  speed = (float)sqrt(temp);

      temp = 1.0f/speed;
      smultarray3(vel, temp);
      if (speed > maxspeed)
         speed = maxspeed;
   }

   else
      speed = 0;

   dist = timescale*speed;

   initxform[0][3] += dist * vel[0];
   initxform[1][3] += dist * vel[1];
   initxform[2][3] += dist * vel[2];

   // adjust by dotproduct/cos()  w/ new dir vs desired dir
   if (dist > distance)
      distance = -1;
   else
      distance -= dist;
}


/* *************************************************************
************************************************************* */
int ssm_missile::query_whatwasi(int type) {

   return ssm_missile::query_whatami() == type ? 1 : missile::query_whatwasi(type);
}


/* *************************************************************
   bypasses missile::preprocess();
************************************************************* */
void ssm_missile::preprocess(void *data) {

   ((polygame *)ob)->filename.stringcpy(FILENAME_SSM_MISSILE);
   ((polygame *)ob)->filename.stringcat(".spb");
   
   ((polygame *)ob)->texname2.stringcpy(FILENAME_SSM_MISSILE);
   ((polygame *)ob)->texname2.stringcat(".tex");
   
   ((polygame *)ob)->colorname.stringcpy(FILENAME_SSM_MISSILE);
   ((polygame *)ob)->colorname.stringcat(".ilm");
   
   ((polygame *)ob)->mctype.set_master(CONSTANT);
   ((polygame *)ob)->mcinfo.mask_or(CITEXTURE);

   death_tob = trail_tob = smoke_tob = NULL;

   fx_type::preprocess(data);
}
