 

#include "brain.h"
#include "polygame.h"

#include "fighter.h"
#include "darkfx.h"
#include "darkgine.h"

#define TRAIL_TIME      2.4f
#define TRAIL_RADIUS    5.7f
#define BLAST_RADIUS    32


/* *************************************************************
************************************************************* */
missile::missile() {

   ob = complex->gfx->gfxAllocRenderObject(OBJECT_POLYGON);
   ob->id = object_counter;
   object_counter++;
}


/* *************************************************************
************************************************************* */
int missile::query_whatwasi(int type) {

   return missile::query_whatami() == type ? 1 : fx_type::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
void missile::preprocess(void *data) {

   ((polygame *)ob)->filename.stringcpy(FILENAME_MISSILE);
   ((polygame *)ob)->filename.stringcat(".spb");
   
   ((polygame *)ob)->colorname.stringcpy(FILENAME_MISSILE);
   ((polygame *)ob)->colorname.stringcat(".ilm");
   
   ((polygame *)ob)->mctype.set_master(CONSTANT);

   death_tob = trail_tob = smoke_tob = NULL;

   fx_type::preprocess(data);
}


/* *************************************************************
************************************************************* */
void missile::process_intel() {

   float temp, dist;
   float timescale = complex->timer.speedscale;
   vector3f v, curr_dir;

   vector4f r[4];
   orient_pathway orient;

   // calc destination
   target_pos[0] += timescale*target_vel[0];
   target_pos[1] += timescale*target_vel[1];
   target_pos[2] += timescale*target_vel[2];

   v[0] = target_pos[0] - initxform[0][3];
   v[1] = target_pos[1] - initxform[1][3];
   v[2] = target_pos[2] - initxform[2][3];
   normalize3(v);

   curr_dir[0] = initxform[0][2];
   curr_dir[1] = initxform[1][2];
   curr_dir[2] = initxform[2][2];
   normalize3(curr_dir);
   
   orient.calc_orientation(curr_dir, v, dorient, r, AXIS_Y);
   matmatmultv(r, initxform);

   // calculate  new speed/velocity
   temp = timescale*accel;
   v[0] = speed*vel[0] + temp*initxform[0][2];
   v[1] = speed*vel[1] + temp*initxform[1][2];
   v[2] = speed*vel[2] + temp*initxform[2][2];

   temp = dotproduct3(v,v);

   if (temp > CORRECT) {
      copyarray3(vel, v);
	  speed = (float)sqrt(temp);

      temp = 1.0f/speed;
      smultarray3(vel, temp);
      if (speed > maxspeed)
         speed = maxspeed;
   }

   else
      speed = 0;

   dist = timescale*speed;

   initxform[0][3] += dist * vel[0];
   initxform[1][3] += dist * vel[1];
   initxform[2][3] += dist * vel[2];

   // adjust by dotproduct/cos()  w/ new dir vs desired dir
   if (dist > distance)
      distance = -1;
   else
      distance -= dist;
}


/* *************************************************************
************************************************************* */
void missile::trail(float *v2, vector4f *mx) {

   vector4f r[4];
   fx_link *ftr;
   vector4f v1;

   puff = (generic_flat *)complex->teacher.issue(OBJECT_GENERIC_FLAT);
   init_mx(r);
   r[0][0] = r[1][1] = r[2][2] = TRAIL_RADIUS;
   puff->init(TRAIL_TIME, TRAIL_RADIUS, v2, mx, r, trail_tob);
   puff->update(0);

   puffman.insert(ftr = new fx_link, NULL);
   ftr->link = puff;
	         
   smoke = (smoke_trail *)complex->teacher.issue(OBJECT_SMOKE_TRAIL);
   v1[0] = v1[1] = v1[2] = 0;
   v1[3] = 1.0f;
   smoke->init(state.xmx, v1, TRAIL_TIME, smoke_tob);

   smokeman.insert(ftr = new fx_link, NULL);
   ftr->link = smoke;
}


/* *************************************************************
************************************************************* */
void missile::whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   target_type target;
   linktype *ptr;
   vector4f pos, midpt;
   vector3f normal;
   float rad, t;
   vector4f v1, v2;
   vector3f ray;
   int col_type;
   vector4f r[4];
   generic_flat *fx;
   dbl_llist_manager man;
   hiearchy_list_type *gtr;
   
   process_intel();

   matmatmulto(mx, initxform, state.xmx);

   copyarray3(v1, old_state.center);
   v1[3] = 1.0f;

   v2[0] = state.xmx[0][3];
   v2[1] = state.xmx[1][3];
   v2[2] = state.xmx[2][3];
   v2[3] = 1.0f;

   subeqarray3(ray, v2, v1);
   rad = (float)(0.5 * magnitude3(ray));

   midpt[0] = (v1[0] + v2[0]) * 0.5f;
   midpt[1] = (v1[1] + v2[1]) * 0.5f;
   midpt[2] = (v1[2] + v2[2]) * 0.5f;

   // collision
   if (specific_target.specific)
      if (atom_vs_lineseg(specific_target.object, midpt, rad, ray, v1, &target, pos, &col_type) && col_type == COL_NULL) {
         specific_object_vs_lineseg(specific_target.specific, midpt, rad, ray, v1, v2, COL_POLYGON, &target, pos, normal, &col_type);
         if (target.specific) {
            target.specific_parent = specific_target.specific_parent;
            target.object = specific_target.object;
         }

      }
         
   if (!target.object) {
      world_sphere.sphere_vs_obj(midpt, rad, &man, &world_freelist);

      for (gtr = (hiearchy_list_type *)man.head; gtr && !target.object; gtr = (hiearchy_list_type *)gtr->next)
         object_vs_lineseg(specific_target.specific, gtr->hiearchy, midpt, rad, ray, v1, v2, COL_POLYGON, &target, pos, normal, &col_type);

      while (man.head) {
         man.remove(gtr = (hiearchy_list_type *)man.head);
         world_freelist.insert(gtr, NULL);
      }

   }

   // hit something
   if (target.object) {

      distance = -1;

      if (sheader && owner->htree == global_player)
         sheader->player_secondary_hit_count++;

      // explosion f/x
      if (death_tob) {
         fx = (generic_flat *)complex->teacher.issue(OBJECT_GENERIC_FLAT);
         init_mx(r);
         r[0][0] = r[1][1] = r[2][2] = BLAST_RADIUS;
         fx->init(target.specific ? target.specific : target.object->htree, DEFAULT_FX_BLAST_TIME, BLAST_RADIUS, pos, mx, r, death_tob);
      }

      // detonation sound
      if (target.object->htree->query_whatwasi(OBJECT_PLAYER))
         ((player *)target.object)->attach_sound(&detonate_sndfx_id, pos);

      // damage
      damage_target((gameatom *)target.object->htree, target.specific ? target.specific : target.object->htree, target.specific_parent, NULL, pos, mx);
   }   
   
   // missile trail f/x
   else if (smoke_tob && trail_tob && camptr && distance > 0)
      if (!smoke)
         trail(v2, mx);
      else {
         smoke->update(v2, 0);

         subeqarray3(ray, v2, smoke->start);
         t = dotproduct3(perceived_vel, perceived_vel) * dotproduct3(ray, ray);
	 
         if (t > CORRECT) {
	    
            t = (float)(dotproduct3(ray, perceived_vel)/sqrt(t));

            if (t < 0.997) // 5 degrees	 
               trail(v2, mx);
         }
      
      }
      
   copymx4x4o(state.node, state.xmx);
   
   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)             
      if (ptr->link != parent)                         
         ptr->link->whereami(hiearchy_manager, this, state.node);

   copyarray3(state.center, v2);

   setup();
}


/* *************************************************************
************************************************************* */
void missile::update(dbl_llist_manager *hiearchy_manager, quark *parent) {

   gamequark::update(hiearchy_manager, parent);

   if (distance <= 0)
      flags &= ~QUARK_FLAG_ACTIVE;
}


/* *************************************************************
   - init_v, offset is in world coord
************************************************************* */
void missile::init(atom_list_type *source, float dist, int dam, vector4f *mx, texbase *dtob, texbase *ttob, texbase *stob, float maxspd, float acl, float dor, float init_spd, float *init_v, target_type *target, sound_id_type *sound_id) {

   vector4f r[4];
   vector4f v;
   float temp;
   atom_list_type *atr;
   
   if (sheader && source->htree == global_player)
      sheader->player_secondary_fire_count++;

   for (camptr = NULL, atr=(atom_list_type *)complex->animation_manager.head; atr && !camptr; atr=(atom_list_type *)atr->next)
      camptr = (camera *)atr->htree->find_ob(NULL, OBJECT_CAMERA, &src);

   if (target) {
      specific_target.object = target->object;
      specific_target.specific_parent = target->specific_parent;
      specific_target.specific = target->specific;
   }

   else {
      specific_target.object = NULL;
      specific_target.specific_parent = NULL;
      specific_target.specific = NULL;
   }

   // calculate world mx
   transpose(initxform, mx);
   normalize3(initxform[0]);
   normalize3(initxform[1]);
   normalize3(initxform[2]);
   copyarray3(old_state.center, initxform[3]);
   transpose(initxform);

   copymx4x4o(old_state.xmx, initxform);

   // convert initxform into "local" coords
   inversemx(complex->teacher.old_state.xmx, r);
   matmatmulto(r, initxform);

   // calculate desired travel direction
   target_vel[0] = initxform[0][2];
   target_vel[1] = initxform[1][2];
   target_vel[2] = initxform[2][2];
   temp = (float)(((1+CORRECT)*maxspd)/magnitude3(target_vel));
   smultarray3(target_vel, temp);

   // calculate path waypoint
   matvecmulto(r, old_state.center, target_pos);

   v[0] = target_pos[0] - initxform[0][3];
   v[1] = target_pos[1] - initxform[1][3];
   v[2] = target_pos[2] - initxform[2][3];

   temp = dotproduct3(v, v);
   if (temp > CORRECT) {
      temp = (float)(sqrt(temp)/((1+CORRECT)*maxspd));
      target_pos[0] += temp*target_vel[0];
      target_pos[1] += temp*target_vel[1];
      target_pos[2] += temp*target_vel[2];
   }

   // set desired speed
   target_speed = maxspd;

   // calculate current direction and speed
   subeqarray3(v, source->htree->state.center, source->htree->old_state.center);
   temp = dotproduct3(v,v);
   temp = (float)((temp < CORRECT) ? 0 : 1.0/(sqrt(temp)*complex->timer.speedscale));

   vel[0] = init_v[0]*init_spd + v[0]*temp;
   vel[1] = init_v[1]*init_spd + v[1]*temp;
   vel[2] = init_v[2]*init_spd + v[2]*temp;

   temp = dotproduct3(vel,vel);
   speed = (temp < CORRECT) ? 0 : (float)sqrt(temp);

   if (speed > maxspd)
      speed = maxspd;

   matvecmultv(r, vel);
   normalize3(vel);

   // init rest of setup
   accel = acl;
   maxspeed = maxspd;
   dorient = dor;

   distance = dist;
   damage = dam;
   owner = source;
   flags &= (GAMEFLAG_ALLIANCE_MASK | QUARK_FLAG_ACTIVE);
   flags |= (source->htree->flags & GAMEFLAG_ALLIANCE_MASK);
   death_tob = dtob;
   trail_tob = ttob;
   smoke_tob = stob;
   
   detonate_sndfx_id.name.stringcpy(&sound_id->name);
   detonate_sndfx_id.flags = sound_id->flags;
   detonate_sndfx_id.id = sound_id->id;
}


/* *************************************************************
************************************************************* */
void missile::dest() {

   fx_link *ftr;
   
   if (owner)
      owner->htree->set_specific_data(DATAFLAG_SECONDARY_DETONATION, this);

   for (ftr = (fx_link *)smokeman.head; ftr; ftr = (fx_link *)ftr->next)
      ((smoke_trail *)ftr->link)->update(NULL, 1);

   smokeman.dest();

   for (ftr = (fx_link *)puffman.head; ftr; ftr = (fx_link *)ftr->next)
      ((generic_flat *)ftr->link)->update(1);

   puffman.dest();

   fx_type::dest();
}

