

#include "polygame.h"
#include "gamegine.h"

#include "darkfx.h"


/* *************************************************************
************************************************************* */
magnetic_mine::magnetic_mine() {

   ob = complex->gfx->gfxAllocRenderObject(OBJECT_POLYGON);
   ob->id = object_counter;
   object_counter++;
}


/* *************************************************************
************************************************************* */
int magnetic_mine::query_whatwasi(int type) {

   return (magnetic_mine::query_whatami() == type) ? 1 : fx_type::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
void magnetic_mine::preprocess(void *data) {

   ((polygame *)ob)->filename.stringcpy(FILENAME_MAGNETIC_MINE);
   ((polygame *)ob)->filename.stringcat(".spg");
   
   ((polygame *)ob)->colorname.stringcpy(FILENAME_MAGNETIC_MINE);
   ((polygame *)ob)->colorname.stringcat(".ilm");
   
   ((polygame *)ob)->mctype.parse(SHADE_GOURAUD_STR);

   fx_type::preprocess(data);
}


/* *************************************************************
    attached to an object -> "mx" is ignored
************************************************************* */
void magnetic_mine::whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   linktype *ptr;
   vector4f r[4];

//asdf travel to target and stick to it! if player hits a target, credit a "hit"

   countdown -= complex->timer.speedscale;

   if (tether)
      if (tether->flags & QUARK_FLAG_ACTIVE)
         matmatmulto(tether->old_state.node, initxform, state.xmx);
      else if (attachflag) {
         attachflag = 0;
         matmatmulto(tether->old_state.node, initxform, state.xmx);
	 
         inversemx(mx, r);
         matmatmulto(r, state.xmx, initxform);
      }

      else
         matmatmulto(mx, initxform, state.xmx);
   else
      matmatmulto(mx, initxform, state.xmx);

   copymx4x4o(state.node, state.xmx);
   
   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next) 
      if (ptr->link != parent)                         
         ptr->link->whereami(hiearchy_manager, this, state.node);

   state.center[0] = state.xmx[0][3];
   state.center[1] = state.xmx[1][3];
   state.center[2] = state.xmx[2][3];

   setup();
}


/* *************************************************************
************************************************************* */
void magnetic_mine::update(dbl_llist_manager *hiearchy_manager, quark *parent) {

   gamequark::update(hiearchy_manager, parent);

   if (countdown <= 0) {
      flags &= ~QUARK_FLAG_ACTIVE;
//asdf explode and do damage
// note mines shouldnt be "attracted" or "triggered" by other mines, except by collision or incidental damage (chain reaction)
// chain reactions shouldnt be cause by "initial" placements either...
   }
   
}


/* *************************************************************
************************************************************* */
void magnetic_mine::attach(quark *target, float *pos) {

   vector4f r[4];

   tether = target;

   initxform[0][3] = pos[0];
   initxform[1][3] = pos[1];
   initxform[2][3] = pos[2];

   // convert initxform into "local" coords
   inversemx(tether->old_state.node, r);
   matmatmulto(r, initxform);
   attachflag = 1;
}


/* *************************************************************
************************************************************* */
/*
void magnetic_mine::init(gameatom *source, gameatom *target) {

if source == player, credit a fire
asdf setup
   
}

*/
