

#include "darkgine.h"

#include "polygame.h"

#include "darkfx.h"


/* *************************************************************
************************************************************* */
int lazer2blu::query_whatwasi(int type) {

   return lazer2blu::query_whatami() == type ? 1 : lazer::query_whatwasi(type);
}


/* *************************************************************
   bypasses lazer::preprocess();
************************************************************* */
void lazer2blu::preprocess(void *data) {

   ((polygame *)ob)->filename.stringcpy(FILENAME_LAZER2BLU);
   ((polygame *)ob)->filename.stringcat(".spg");
   
   ((polygame *)ob)->texname2.stringcpy(FILENAME_LAZER2BLU);
   ((polygame *)ob)->texname2.stringcat(".tex");
   
   ((polygame *)ob)->colorname.stringcpy(FILENAME_LUM);
   ((polygame *)ob)->colorname.stringcat(".ilm");
   
   ((polygame *)ob)->mcinfo.mask_or(CITRANSPARENT | CITEXTURE);
   ((polygame *)ob)->mctype.set_master(CONSTANT);

   death_tob = NULL;
   
   fx_type::preprocess(data);
}


/* *************************************************************
   asdf - code should handle case where lazer intersects camera
          or is parallel/on the line of sight
************************************************************* */
void lazer2blu::fail_rotate() {

}


/* *************************************************************
   note: assume state.xmx[x][2] "normalized"
************************************************************* */
int lazer2blu::post_rotate() {

   vector3f v0, v1, v2;
   
   v2[0] = state.xmx[0][3];
   v2[1] = state.xmx[1][3];
   v2[2] = state.xmx[2][3];
   
   subeqarray3(v1, cam->state.center, v2);

   v2[0] = state.xmx[0][2];
   v2[1] = state.xmx[1][2];
   v2[2] = state.xmx[2][2];
   
   xproduct(v0, v1, v2);

   // check if same positions
   if (dotproduct3(v0, v0) < CORRECT) {
      fail_rotate();      
      return 0;      
   }
   
   normalize3(v0);

   // check if parallel
   if (dotproduct3(v0, v2) > ICORRECT) {
      fail_rotate();      
      return 0;      
   }

   xproduct(v1, v2, v0);

   state.xmx[0][0] = v0[0];   
   state.xmx[1][0] = v0[1];   
   state.xmx[2][0] = v0[2];   

   state.xmx[0][1] = v1[0];   
   state.xmx[1][1] = v1[1];   
   state.xmx[2][1] = v1[2];   
   return 1;
}
   

/* *************************************************************
************************************************************* */
void lazer2blu::init() {

   atom_list_type *atr;

   for (atr = (atom_list_type *)complex->animation_manager.head; atr && !atr->htree->query_whatwasi(OBJECT_CAMERA_CONTROL); atr = (atom_list_type *)atr->next);

   cam = atr ? (gameatom *)atr->htree : (gameatom *)NULL;
   
   lazer::init();
}
