

#include "polygame.h"

#include "darkgine.h"
#include "darkfx.h"

#define BLAST_RADIUS    32


/* *************************************************************
************************************************************* */
lazer::lazer() {

   ob = complex->gfx->gfxAllocRenderObject(OBJECT_POLYGON);
   ob->id = object_counter;
   object_counter++;
}


/* *************************************************************
************************************************************* */
int lazer::query_whatwasi(int type) {

   return lazer::query_whatami() == type ? 1 : fx_type::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
void lazer::preprocess(void *data) {

   ((polygame *)ob)->filename.stringcpy(FILENAME_LAZER);
   ((polygame *)ob)->filename.stringcat(".spg");
   
   ((polygame *)ob)->colorname.stringcpy(FILENAME_LAZER);
   ((polygame *)ob)->colorname.stringcat(".ilm");
   
   ((polygame *)ob)->mcinfo.mask_or(CITRANSPARENT);
   ((polygame *)ob)->mctype.set_master(CONSTANT);

   death_tob = NULL;

   fx_type::preprocess(data);
}


/* *************************************************************
************************************************************* */
void lazer::process_intel() {

   copyarray3(end, old_state.center);

   dist_scale = speed * complex->timer.speedscale;

   if (dist_scale < CORRECT)
      dist_scale = (float)CORRECT;

   if (dist_scale + CORRECT > distance) {
      dist_scale = (distance>1) ? distance : 1;
      distance = -1;
   }

   else
      distance -= dist_scale;

   initxform[0][3] += dist_scale * dir[0];
   initxform[1][3] += dist_scale * dir[1];
   initxform[2][3] += dist_scale * dir[2];
}


/* *************************************************************
************************************************************* */
void lazer::process_collision(target_type *target, float *pos, float *normal, int *col_type) {

   float rad;
   vector4f v1, v2;
   vector3f ray;
   vector4f midpt;
   hiearchy_list_type *qtr;
   dbl_llist_manager man;

   v2[0] = state.xmx[0][3];
   v2[1] = state.xmx[1][3];
   v2[2] = state.xmx[2][3];
   v2[3] = 1.0f;

   copyarray3(v1, end);
   v1[3] = 1.0f;

   subeqarray3(ray, v2, v1);
   rad = (float)(0.5 * magnitude3(ray));

   midpt[0] = (v1[0] + v2[0]) * 0.5f;
   midpt[1] = (v1[1] + v2[1]) * 0.5f;
   midpt[2] = (v1[2] + v2[2]) * 0.5f;

   // collision
   if (specific_target.specific)
      if (atom_vs_lineseg(specific_target.object, midpt, rad, ray, v1, target, pos, col_type)) {
         if (*col_type != COL_NULL)
            return;
	    
         specific_object_vs_lineseg(specific_target.specific, midpt, rad, ray, v1, v2, COL_POLYGON, target, pos, normal, col_type);

         if (target->specific) {
            target->specific_parent = specific_target.specific_parent;
            target->object = specific_target.object;
            return;
         }

      }

   world_sphere.sphere_vs_obj(midpt, rad, &man, &world_freelist);
   for (qtr = (hiearchy_list_type *)man.head; qtr && !target->object; qtr = (hiearchy_list_type *)qtr->next)
      object_vs_lineseg(specific_target.specific, qtr->hiearchy, midpt, rad, ray, v1, v2, COL_POLYGON, target, pos, normal, col_type);

   while (man.head) {
      man.remove(qtr = (hiearchy_list_type *)man.head);
      world_freelist.insert(qtr, NULL);
   }
   
}


/* *************************************************************
************************************************************* */
int lazer::post_rotate() {

   return 0;
}

   
/* *************************************************************
************************************************************* */
void lazer::whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   target_type target;
   linktype *ptr;
   vector4f pos;
   vector3f normal;
   int col_type;
   generic_flat *fx;
   vector4f r[4];

   process_intel();

   matmatmulto(mx, initxform, state.xmx);

   post_rotate();
   
   process_collision(&target, pos, normal, &col_type);

   if (target.object) {

      distance = -1;

      if (sheader && owner->htree == global_player)
         sheader->player_primary_hit_count++;

      // explosion f/x
      if (col_type != COL_SHIELDS && death_tob) {
         fx = (generic_flat *)complex->teacher.issue(OBJECT_GENERIC_FLAT);

         init_mx(r);
         r[0][0] = r[1][1] = r[2][2] = BLAST_RADIUS;
         fx->init(target.specific ? target.specific : target.object->htree, DEFAULT_FX_BLAST_TIME, BLAST_RADIUS, pos, mx, r, death_tob);
      }

      // damage
      damage_target((gameatom *)target.object->htree, target.specific ? target.specific : target.object->htree, target.specific_parent, NULL, pos, mx);
   }

   copymx4x4o(state.node, state.xmx);
   
   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent)                   
         ptr->link->whereami(hiearchy_manager, this, state.node);

   // should really be applied to initxform/local_mx -> initxform should really be local_mx
   time_scale += complex->timer.speedscale;
   if (time_scale > 0.2) {
      time_scale = 0.2f;
      dist_scale = 0.2f*speed;
   }

   else
      dist_scale = time_scale * speed;

   state.xmx[0][2] *= dist_scale;
   state.xmx[1][2] *= dist_scale;
   state.xmx[2][2] *= dist_scale;

   state.center[0] = state.xmx[0][3];
   state.center[1] = state.xmx[1][3];
   state.center[2] = state.xmx[2][3];

   setup();
}


/* *************************************************************
************************************************************* */
void lazer::update(dbl_llist_manager *hiearchy_manager, quark *parent) {

   gamequark::update(hiearchy_manager, parent);

   if (distance <= 0)
      flags &= ~QUARK_FLAG_ACTIVE;
}


/* *************************************************************
************************************************************* */
void lazer::init(atom_list_type *source, float dist, float spd, int dam, float *oclock, float *offset, vector4f *mx, texbase *tob, target_type *target) {

   vector4f r[4];

   if (sheader && source->htree == global_player)
      sheader->player_primary_fire_count++;

   if (target) {
      specific_target.object = target->object;
      specific_target.specific_parent = target->specific_parent;
      specific_target.specific = target->specific;
   }

   else {
      specific_target.object = NULL;
      specific_target.specific_parent = NULL;
      specific_target.specific = NULL;
   }

   distance = dist;                 // units
   speed = spd;                     // units/sec
   damage = dam;
   dist_scale = 1;
   owner = source;
   death_tob = tob;
   time_scale = 0;
   copyarray3(dir, oclock);

   matvecmulto(mx, offset, end);

   copymx4x4o(initxform, mx);

   initxform[0][3] = end[0];
   initxform[1][3] = end[1];
   initxform[2][3] = end[2];

   // convert initxform into "local" coords
   inversemx(complex->teacher.old_state.xmx, r);
   matmatmulto(r, initxform);
}

