

#include "flat.h"

#include "darkgine.h"
#include "darkfx.h"


/* *************************************************************
************************************************************* */
generic_flat::generic_flat() {

   ob = complex->gfx->gfxAllocRenderObject(OBJECT_FXFLAT);
   ob->id = object_counter;
   object_counter++;
}
      
      
/* *************************************************************
************************************************************* */
int generic_flat::query_whatwasi(int type) {

   return (generic_flat::query_whatami() == type) ? 1 : fx_type::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
void generic_flat::preprocess(void *data) {

   ((pc *)ob)->colorname.stringcpy(FILENAME_LUM);
   ((pc *)ob)->colorname.stringcat(".ilm");

   ((pc *)ob)->mcinfo.mask_or(CITEXTURE | CITRANSPARENT | CIINVISO | CIBITMAP);
   ((polygon *)ob)->inviso = 0;

   ((pc *)ob)->mctype.set_master(CONSTANT);

   fx_type::preprocess(data);
}


/* *************************************************************
************************************************************* */
void generic_flat::begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   quark::begin(hiearchy_manager, parent, mx);

   complex->gfx->gfxFlatIncrementTime((fxflat *)ob, complex->timer.speedscale/timelimit);
}


/* *************************************************************
    attached to an object -> "mx" is ignored
************************************************************* */
void generic_flat::whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   linktype *ptr;
   vector4f s[4];
   atom_list_type *atr;
   vector3f v1, v2;
   float dist, dist2;
   quark *qtr;
   
   if (goflag)
      countdown += complex->timer.speedscale;

   if (tether)
      if (tether->flags & QUARK_FLAG_ACTIVE)
         matmatmulto(tether->old_state.node, initxform, state.node);
      else if (attachflag) {
         attachflag = 0;
         matmatmulto(tether->old_state.node, initxform, state.node);

         inversemx(mx, s);
         matmatmulto(s, state.node, initxform);
      }

      else
         matmatmulto(mx, initxform, state.node);
   else
      matmatmulto(mx, initxform, state.node);

   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent)                     
         ptr->link->whereami(hiearchy_manager, this, state.node);

   matmatmulto(state.node, localmx, state.xmx);

   if (!cam)
      for (atr = (atom_list_type *)hiearchy_manager->head; atr; atr = (atom_list_type *)atr->next) {
         qtr = atr->htree->find(NULL, OBJECT_ELECTRON, NULL);

         if (qtr && (qtr->flags & QUARK_FLAG_ACTIVE)) {
            cam = qtr;
            break;
         }
	    
      }

   // note: this is here because camera is already processed
   if (cam) {
      v1[0] = state.xmx[0][3];
      v1[1] = state.xmx[1][3];
      v1[2] = state.xmx[2][3];

      dist = radius + 2;
      subeqarray3(v2, cam->old_state.center, v1);
      dist2 = dotproduct3(v2, v2);

      // if camera w/in effect put it on screen (full?)
      if (dist2 < dist*dist) {
         state.xmx[0][3] = cam->old_state.center[0] + 2 * cam->old_state.xmx[0][2];
         state.xmx[1][3] = cam->old_state.center[1] + 2 * cam->old_state.xmx[1][2];
         state.xmx[2][3] = cam->old_state.center[2] + 2 * cam->old_state.xmx[2][2];
      }

      else {
         dist /= (float)sqrt(dist2);
         state.xmx[0][3] += dist*v2[0];
         state.xmx[1][3] += dist*v2[1];
         state.xmx[2][3] += dist*v2[2];
      }

   }

   state.center[0] = state.xmx[0][3];
   state.center[1] = state.xmx[1][3];
   state.center[2] = state.xmx[2][3];

   setup();
   complex->gfx->gfxFlatIncrementTime((fxflat *)ob, complex->timer.speedscale/timelimit);
}


/* *************************************************************
************************************************************* */
void generic_flat::update(dbl_llist_manager *hiearchy_manager, quark *parent) {

   gamequark::update(hiearchy_manager, parent);

   if (countdown > timelimit)
      flags &= ~QUARK_FLAG_ACTIVE;
}


/* *************************************************************
************************************************************* */
void generic_flat::attach(quark *target, float *pos) {

   vector4f r[4];
   vector4f v;

   tether = target;

   // convert initxform into "local" coords
   inversemx(tether->old_state.node, r);

   matvecmulto(r, pos, v);

   init_mx(initxform);

   initxform[0][3] = v[0];
   initxform[1][3] = v[1];
   initxform[2][3] = v[2];

   attachflag = 1;
}


/* *************************************************************
************************************************************* */
void generic_flat::init() {

   fx_type::init();

   countdown = 0;
   attachflag = 0;
   radius = 0;
   cam = NULL;
   goflag = 1;
   tether = NULL;
}


/* *************************************************************
************************************************************* */
void generic_flat::init(quark *source, float duration, float rad, float *center, vector4f *parent_mx, vector4f *mx, texbase *tob) {

   complex->gfx->gfxFxflatInit((polygon *)ob, tob);

   copymx4x4o(localmx, mx);
   radius = rad;
   timelimit = duration;

   attach(source, center);
}


/* *************************************************************
************************************************************* */
void generic_flat::init(float duration, float rad, float *center, vector4f *parent_mx, vector4f *mx, texbase *tob) {

   vector4f r[4];
   vector4f v;

   complex->gfx->gfxFxflatInit((polygon *)ob, tob);

   copymx4x4o(localmx, mx);
   radius = rad;
   timelimit = duration;

   inversemx(((dark_god *)complex)->teacher.old_state.node, r);

   matvecmulto(r, center, v);

   init_mx(initxform);
   initxform[0][3] = v[0];
   initxform[1][3] = v[1];
   initxform[2][3] = v[2];
}


/* *************************************************************
************************************************************* */
void generic_flat::update(int flag) {

   goflag = flag;
}


