

#include <string.h>

#include "pstring.h"

#include "gamegine.h"
#include "flat.h"

#include "darkfx.h"


/* *************************************************************
************************************************************* */
int explosion::query_whatwasi(int type) {

   return explosion::query_whatami() == type ? 1 : fx_type::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
explosion::explosion() {

   ob = complex->gfx->gfxAllocRenderObject(OBJECT_FLAT);
   ob->id = object_counter;
   object_counter++;
}


/* *************************************************************
************************************************************* */
void explosion::preprocess(void *data) {

   char buffer[MAXSTRLEN];
   
   sprintf(buffer, "fakelum%d.ilm", id);
   ((polygon *)ob)->colorname.stringcpy(buffer);
   
   ((polygon *)ob)->texname2.stringcpy(FILENAME_FLARE2);
   ((polygon *)ob)->texname2.stringcat(".rtf");

   ((pc *)ob)->mcinfo.mask_or(CITEXTURE | CITRANSPARENT | CIINVISO | CIBITMAP);
   ((polygon *)ob)->inviso = 0;

   ((pc *)ob)->mctype.set_master(CONSTANT);

   fx_type::preprocess(data);
}


/* *************************************************************
************************************************************* */
void explosion::begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   quark::begin(hiearchy_manager, parent, mx);
   
   complex->gfx->gfxFlatIncrementTime((flat *)ob, complex->timer.speedscale/duration);
}


/* *************************************************************
************************************************************* */
void explosion::whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   linktype *ptr;
   float s, t, u;
   shadetype *ilm;
   shade_block *sblock;

   matmatmulto(mx, initxform, state.xmx);
   copymx4x4o(state.node, state.xmx);
   
   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent)                   
         ptr->link->whereami(hiearchy_manager, this, state.node);

   state.center[0] = state.xmx[0][3];
   state.center[1] = state.xmx[1][3];
   state.center[2] = state.xmx[2][3];

   timer -= complex->timer.speedscale;
   t = 1.0f/duration;
   s = timer*t;
   u = s*max_size;

   smultarray3(state.xmx[0], u);
   smultarray3(state.xmx[1], u);
   smultarray3(state.xmx[2], u);

   setup();
   
   complex->gfx->gfxFlatIncrementTime((flat *)ob, complex->timer.speedscale*t);

   s = s > 0.5 ? 1.0f : s+s;

   sblock = (shade_block *)((flat *)ob)->lob->query_data();
   ilm = &((flat *)ob)->lob->base;

   sblock->shade_palette[0].lum[0] = sblock->shade_palette[0].lum[1] = sblock->shade_palette[0].lum[2] = 
      ilm->lum[0] = ilm->lum[1] = ilm->lum[2] = (int)(255.0*s);

   sblock->shade_palette[0].flum[0] = sblock->shade_palette[0].flum[1] = sblock->shade_palette[0].flum[2] = 
      ilm->flum[0] = ilm->flum[1] = ilm->flum[2] = s;
}


/* *************************************************************
************************************************************* */
void explosion::update(dbl_llist_manager *hiearchy_manager, quark *parent) {

   gamequark::update(hiearchy_manager, parent);

   if (timer <= 0)
      flags &= ~QUARK_FLAG_ACTIVE;
}


/* *************************************************************
************************************************************* */
void explosion::init(vector4f *mx, float timelimit, float maxsize) {

   shadetype *ilm;
   vector4f r[4];
   shade_block *sblock;

   // convert initxform into "local" coords
   copymx4x4(initxform, mx);
   inversemx(complex->teacher.old_state.xmx, r);
   matmatmulto(r, initxform);

   ilm = &((flat *)ob)->lob->base;
   ilm->ka[0] = ilm->ka[1] = ilm->ka[2] = 0;
   ilm->kp[0] = ilm->kp[1] = ilm->kp[2] = 0;
   ilm->ks[0] = ilm->ks[1] = ilm->ks[2] = 0;
   ilm->fka[0] = ilm->fka[1] = ilm->fka[2] = 0;
   ilm->fkp[0] = ilm->fkp[1] = ilm->fkp[2] = 0;
   ilm->fks[0] = ilm->fks[1] = ilm->fks[2] = 0;
   ilm->specn = 1.0f;
   ilm->lum[0] = ilm->lum[1] = ilm->lum[2] = 255;
   ilm->flum[0] = ilm->flum[1] = ilm->flum[2] = 1.0f;

   sblock = (shade_block *)((flat *)ob)->lob->query_data();
   memcpy(&sblock->shade_palette[0], ilm, sizeof(shadetype));

   timer = duration = timelimit;
   max_size = maxsize;
}


