

#if !defined __FIGHTER_H
#define __FIGHTER_H

#include "darkequp.h"
#include "anineutr.h"
#include "darkbrai.h"

#define STATUS_MODE_NULL              0x0000

#define STATUS_MODE_AI_IDLE           0x0001
#define STATUS_MODE_AI_AVOID          0x0002
#define STATUS_MODE_AI_ATTACK         0x0004
#define STATUS_MODE_AI_BREATHING_ROOM 0x0008
#define STATUS_MODE_AI_MASK           0x000f

#define STATUS_MODE_AMMO_IN_FLIGHT    0x0010
#define STATUS_MODE_AI_CALC_AVOID     0x0020
#define STATUS_MODE_AI_FIRE_PRIMARY   0x0040
#define STATUS_MODE_AI_FIRE_SECONDARY 0x0080

#define EVENT_NPC_FIGHTER                (EVENT_STANDARD_ANITROLL+1)
#define EVENT_NPC_FIGHTER_AVOID          (EVENT_STANDARD_ANITROLL+2)
#define EVENT_NPC_FIGHTER_FIRE_PRIMARY   (EVENT_STANDARD_ANITROLL+3)
#define EVENT_NPC_FIGHTER_FIRE_SECONDARY (EVENT_STANDARD_ANITROLL+4)


/* ****************************************************************
**************************************************************** */
class npcfighter_event : public basic_event {

   public:
      int query_whatami() { return EVENT_NPC_FIGHTER; }
      void evaluate(int frameno, atom *source, dbl_llist_manager *hiearchy_manager);

      float reset_timer;
      unsigned int event_flag;
      
      virtual ~npcfighter_event() {}
      virtual npcfighter_event *alloc() = 0;
};


/* ****************************************************************
**************************************************************** */
class npcfighter_avoid_event : public npcfighter_event {

   public:
      int query_whatami() { return EVENT_NPC_FIGHTER_AVOID; }

      npcfighter_event *alloc() { return new npcfighter_avoid_event; }

      npcfighter_avoid_event() { event_flag = STATUS_MODE_AI_CALC_AVOID; }
      virtual ~npcfighter_avoid_event() {}
};


/* ****************************************************************
**************************************************************** */
class npcfighter_fire_primary_event : public npcfighter_event {

   public:
      int query_whatami() { return EVENT_NPC_FIGHTER_FIRE_PRIMARY; }

      npcfighter_event *alloc() { return new npcfighter_fire_primary_event; }

      npcfighter_fire_primary_event() { event_flag = STATUS_MODE_AI_FIRE_PRIMARY; }
      virtual ~npcfighter_fire_primary_event() {}
};


/* ****************************************************************
**************************************************************** */
class npcfighter_fire_secondary_event : public npcfighter_event {

   public:
      int query_whatami() { return EVENT_NPC_FIGHTER_FIRE_SECONDARY; }

      npcfighter_event *alloc() { return new npcfighter_fire_secondary_event; }

      npcfighter_fire_secondary_event() { event_flag = STATUS_MODE_AI_FIRE_SECONDARY; }
      virtual ~npcfighter_fire_secondary_event() {}
};


/* *************************************************************
************************************************************* */
class fighter : public darkentity {

   protected:
      // gameatom
      void sum_hp(quark *target, quark *parent);

      // fighter
      fighter_desc status;
      float shield_data[6];
      float pilot_state[6];
      coldata_type coldata;
      float chase_dist;
      unsigned int thruster_flag;

      int  collision(quark *obstacle, quark *parent, int level);
      int  obj_vs_spherelist(antineutron *obstacle, int level);
      void death_by_ruru(quark *target, quark *parent);

      virtual void process_collision(vector4f *mx);
      virtual void process_fire_control(dbl_llist_manager *hiearchy_manager) = 0;

   public:
      // superclass
      int  query_whatami() { return OBJECT_FIGHTER; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);

      // quark
      void update(dbl_llist_manager *hiearchy_manager, quark *parent);
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      int  query_specific_data(unsigned int type, void *data);
      int  set_specific_data(unsigned int type, void *data);

      // gameatom
      int apply_damage(gamequark *child, unsigned int properties, int *damage, float *pos, vector4f *mx);

      // fighter
      string_type fighter_name;
      string_type pilot_name;

      fighter();
      virtual ~fighter() {}
};


/* *************************************************************
************************************************************* */
class player : public fighter {

   protected:
      // darkentity
      void process_intel(dbl_llist_manager *hiearchy_manager, vector4f *mx);

      // fighter
      void process_collision(vector4f *mx);
      void process_fire_control(dbl_llist_manager *hiearchy_manager);

      // player
      dbl_llist_manager sndfx_manager;
      int throttle_toggle, stop_toggle;
      sound_id_type collision_sndfx_id;
      sound_id_type jump_sndfx_id;
      sound_type *jump_sndfx;
      
      void update_engines();
      void update_instruments();
      
   public:
      // superclass
      int  query_whatami() { return OBJECT_PLAYER; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);

      // quark
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void update(dbl_llist_manager *hiearchy_manager, quark *parent);
      int  set_specific_data(unsigned int type, void *data);

      // player
      player();
      virtual ~player() {}
      
      void display_hud(dbl_llist_manager *hiearchy_manager, engine *proc, mapul *mapbuffer);
      void attach_sound(sound_id_type *sndfx_id, float *pos);
      void update_sound();
};


/* ****************************************************************
**************************************************************** */
class player_loader : public quark_loader {

   public:
      superclass *make_object() { return new player; }

      player_loader() { object_name = alias_name = TOKEN_PLAYER_STR; }
      virtual ~player_loader() {}
};


/* *************************************************************
************************************************************* */
class npc_fighter : public fighter {

   protected:
      // darkentity
      void process_intel(dbl_llist_manager *hiearchy_manager, vector4f *mx);

      // fighter
      void choose_target(dbl_llist_manager *hiearchy_manager);
      void process_fire_control(dbl_llist_manager *hiearchy_manager);
      void choose_secondary();

      // npc_fighter
      vector3f fallback;                    // fallback position if crippled or mission over
      target_type target;                   // calculated in select_target()
      float dist2target;
      vector3f target_dir;
      vector3f target_pos;
      target_type mark;                     // attack target
      target_type pursuer;                  // evade target
      float safe_dist;
      float avoid_timer;
      smart_targeting_pathway brain;
      float afterburner_timer;
      sound_type *voicefx;
      int voice_priority;
      float jump_timer;
      
      int calc_course(dbl_llist_manager *hiearchy_manager);
      void ai_afterburners(int override_flag);

      int npc_ai_avoid(dbl_llist_manager *hiearchy_manager);
      int npc_ai_pursue();
      int npc_ai_evade();
      int npc_ai_check_orders();

   public:
      // superclass
      int  query_whatami() { return OBJECT_NPC_FIGHTER; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);

      // quark
      void update(dbl_llist_manager *hiearchy_manager, quark *parent);
      int  set_specific_data(unsigned int type, void *data);

      // npc_fighter
      unsigned int status_flag;

      npc_fighter() { voicefx = NULL; }
      virtual ~npc_fighter();

      int play_voice(int id);
};


/* ****************************************************************
**************************************************************** */
class npc_fighter_loader : public quark_loader {

   protected:
      superclass *make_object() { return new npc_fighter; }

   public:
      npc_fighter_loader() { object_name = alias_name = TOKEN_NPCFIGHTER_STR; }
      virtual ~npc_fighter_loader() {}
};


#endif
