

#include <stdlib.h>
#include <string.h>

#include "pstring.h"

#include "polygame.h"

#include "darkgine.h"
#include "fighter.h"


#define CHASE_DISTANCE  96.0f


/* *************************************************************
************************************************************* */
fighter::fighter() {

   chase_dist = CHASE_DISTANCE;
   thruster_flag = 0;
   flags |= GAMEFLAG_COMPARTMENTALIZED;
   pilot_state[0] = pilot_state[1] = pilot_state[2] = pilot_state[3] = pilot_state[4] = pilot_state[5] = 0;
}


/* *************************************************************
************************************************************* */
int fighter::query_whatwasi(int type) {

   return fighter::query_whatami() == type ? 1 : darkentity::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
int fighter::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_PILOT_NAME_STR)) {
      get_token(infile, token);
      pilot_name.stringcpy(token);
      return 1;
   }

   if (!strcmp(token, TOKEN_HULL_TYPE_STR)) {
      get_token(infile, token);
      fighter_name.stringcpy(token);
      return 1;
   }

   if (!strcmp(token, TOKEN_SHIELD_DATA_STR)) {

      // scale
      get_token(infile, token);
      shield_data[0] = (float)atof(token);

      get_token(infile, token);
      shield_data[1] = (float)atof(token);

      get_token(infile, token);
      shield_data[2] = (float)atof(token);

      // offset
      get_token(infile, token);
      shield_data[3] = (float)atof(token);

      get_token(infile, token);
      shield_data[4] = (float)atof(token);

      get_token(infile, token);
      shield_data[5] = (float)atof(token);

      flags |= GAMEFLAG_SHIELD_MX;

      return 1;
   }

   if (!strcmp(token, TOKEN_PILOT_DATA_STR)) {
      get_token(infile, token);
      pilot_state[0] = (float)atof(token);
      get_token(infile, token);
      pilot_state[1] = (float)atof(token);
      get_token(infile, token);
      pilot_state[2] = (float)atof(token);

      get_token(infile, token);
      pilot_state[3] = (float)deg2rad(atof(token));
      get_token(infile, token);
      pilot_state[4] = (float)deg2rad(atof(token));
      get_token(infile, token);
      pilot_state[5] = (float)deg2rad(atof(token));
      return 1;
   }

   if (!strcmp(token, TOKEN_CHASE_DISTANCE_STR)) {
      get_token(infile, token);
      chase_dist = (float)atof(token);
      return 1;
   }

   return darkentity::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void fighter::preprocess(void *data) {

   status.build_equip_list(&((dark_god *)complex)->quartermaster, ((geneological_type *)data)->tree);

   darkentity::preprocess(data);
}


/* *************************************************************

   Collision code - should really find closest hit object instead
   of pseudo first/bastard code - seems to work well enough though...

************************************************************* */
void fighter::whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   linktype *ptr;
   coldata_type cdata;
   dbl_llist_manager man;
   hiearchy_list_type *gtr;
   
   if (!(flags & QUARK_FLAG_ACTIVE))
      return;

   // someone ran into me
   if (coldata.collision_flag)
      process_collision(mx);

   // I ran into someone
   else {
      process_intel(hiearchy_manager, mx);

      matmatmulto(mx, initxform, state.xmx);

      // collision
      if ((old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TSPHERE) {

         coldata.normal[0] = -status.vel[0];
         coldata.normal[1] = -status.vel[1];
         coldata.normal[2] = -status.vel[2];

         world_sphere.sphere_vs_obj(old_state.tree_center, old_state.tree_radius, &man, &world_freelist);

         while (man.head) {
            man.remove(gtr = (hiearchy_list_type *)man.head);
            world_freelist.insert(gtr, NULL);

//            if (collision(gtr->hiearchy->htree, NULL, COL_SUBSPHERE_1)) {
            if (collision(gtr->hiearchy->htree, NULL, COL_POLYGON)) {
               process_collision(mx);

               copyarray3(cdata.pos, coldata.pos);
               cdata.pos[3] = 1.0f;
		  
               cdata.normal[0] = -coldata.normal[0];
               cdata.normal[1] = -coldata.normal[1];
               cdata.normal[2] = -coldata.normal[2];

               gtr->hiearchy->htree->set_specific_data(DATAFLAG_COLLISION, &cdata);

               while (man.head) {
                  man.remove(gtr = (hiearchy_list_type *)man.head);
                  world_freelist.insert(gtr, NULL);
               }

               break;
            }

         }

      }

   }
   
   copymx4x4o(state.node, state.xmx);

   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent)
         ptr->link->whereami(hiearchy_manager, this, state.node);

   state.center[0] = state.xmx[0][3];
   state.center[1] = state.xmx[1][3];
   state.center[2] = state.xmx[2][3];

   status.update_fx(state.xmx);
   process_fire_control(hiearchy_manager);
}


/* *************************************************************
   bypass darkentity::update()
************************************************************* */
void fighter::update(dbl_llist_manager *hiearchy_manager, quark *parent) {

   linktype *ptr;

   gameatom::update(hiearchy_manager, parent);

   if (!(flags & QUARK_FLAG_ACTIVE))
      return;
      
   coldata.collision_flag = 0;

   if (total_hp <= 0) {
      for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)
         death_by_ruru(ptr->link, this);

      flags &= ~QUARK_FLAG_ACTIVE;
      if (last_attacker) {
         last_attacker->htree->set_specific_data(DATAFLAG_KILL_NOTICE, this);
         set_specific_data(DATAFLAG_KILLED_BY_NOTICE, last_attacker);
      }

   }

   else
      update_threat_manager();
}


/* *************************************************************
************************************************************* */
void fighter::sum_hp(quark *target, quark *parent) {

   status.update(&complex->animation_manager);
   total_hp = status.hp + status.armour;

   // shields check
   if (status.shields > 0 && status.shields_downtime <= 0)
      flags |= GAMEFLAG_SHIELDS;
}


/* *************************************************************
************************************************************* */
void fighter::process_collision(vector4f *mx) {

   float temp;
   vector4f r[4];
   vector4f v, s;
   
   temp = old_state.tree_radius + 10.0f;

   state.xmx[0][3] = v[0] = coldata.pos[0] + temp*coldata.normal[0];
   state.xmx[1][3] = v[1] = coldata.pos[1] + temp*coldata.normal[1];
   state.xmx[2][3] = v[2] = coldata.pos[2] + temp*coldata.normal[2];
   v[3] = 1.0f;
   
   inversemx(mx, r);
   matvecmulto(r, v, s);
   initxform[0][3] = s[0];
   initxform[1][3] = s[1];
   initxform[2][3] = s[2];

   // 25% loss in speed;
   status.speed *= 0.75f;

   // reflect velocity vector
   reflect(coldata.normal, status.vel);
}


/* *************************************************************
************************************************************* */
int fighter::collision(quark *obstacle, quark *parent, int level) {

   linktype *ptr;
   float radius;

   // tree doesnt intersect w/ its children
   if ((obstacle->old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TNONE || this == obstacle)
      return 0;

   // check fighter vs tree
   if ((obstacle->old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TSPHERE) {

      // essentially query_sphere_sphere_intersect()
      radius = obstacle->old_state.tree_radius + old_state.tree_radius;

      coldata.pos[0] = obstacle->old_state.tree_center[0] - state.xmx[0][3];
      coldata.pos[1] = obstacle->old_state.tree_center[1] - state.xmx[1][3];
      coldata.pos[2] = obstacle->old_state.tree_center[2] - state.xmx[2][3];

      if (radius*radius < dotproduct3(coldata.pos, coldata.pos))
         return 0;
   }
   
   // check fighter vs checkable object
   if ((obstacle->flags & QUARK_FLAG_ACTIVE) && (obstacle->flags & GAMEFLAG_PHYSICAL) &&
       obj_vs_spherelist((antineutron *)obstacle, level))
      return 1;

   // check w/ subtree
   for (ptr=(linktype *)obstacle->edge.head; ptr; ptr=(linktype *)ptr->next) {
      if (ptr->link == parent)
         continue;

      if (collision(ptr->link, obstacle, level))
         return 1;
   }

   return 0;
}


/* *************************************************************
************************************************************* */
int fighter::obj_vs_spherelist(antineutron *obstacle, int level) {

   spheretype *sphrlist;
   float radius;
   polytype *poly;
   polygon_object_type *pot;
   vector4f v;
   char *face_index;
   polygame *data_ob;
   int i;
   sphere_block *sblock;
   
   sphrlist = obstacle->colsphere;
   data_ob = (polygame *)obstacle->get_render_object();

   if (!sphrlist || !data_ob || !data_ob->get_render_object())
      return 0;

   sblock = (sphere_block *)sphrlist->query_data();

   if (!sblock || !sblock->countsphere)
      return 0;

   v[0] = state.xmx[0][3];
   v[1] = state.xmx[1][3];
   v[2] = state.xmx[2][3];
   v[3] = 1.0f;

   if (!(obstacle->old_state.state_flags & STATE_FLAG_INVERSE)) {
      inversemx(obstacle->old_state.xmx, obstacle->old_state.ixmx);
      obstacle->old_state.state_flags |= STATE_FLAG_INVERSE;
   }

   matvecmulto(obstacle->old_state.ixmx, v);
   
   // state_flags is already guarenteed to be of STATE_FLAG_TSPHERE
   radius = (float)(old_state.tree_radius*magnitude3(obstacle->old_state.ixmx[0]));

   poly = data_ob->get_render_object();
   pot = (polygon_object_type *)poly->query_data();
   i = (poly->countobject + 3) & 0xfffffffc;
   face_index = (char *)((dark_god *)complex)->teacher.mmanager->control->pop(MM_BUFFER, i);
   memset(face_index, 0, i);

   switch (sblock->slist[0].collision(sblock->slist, pot, face_index, radius, v, coldata.pos, coldata.normal, level)) {

      case 0:
         return 0;

      case 1:
         matvecmultv(obstacle->old_state.xmx, coldata.normal);
         normalize3(coldata.normal);
         matvecmulto(obstacle->old_state.xmx, coldata.pos);
         return 1;

      default:      // -1
         radius = coldata.pos[3];
         coldata.pos[3] = 1.0f;
         matvecmulto(obstacle->old_state.xmx, coldata.pos);
         normalize3(coldata.normal);

         coldata.pos[0] += radius * coldata.normal[0];
         coldata.pos[1] += radius * coldata.normal[1];
         coldata.pos[2] += radius * coldata.normal[2];
         return 1;
   }

}


/* *************************************************************
************************************************************* */
int fighter::apply_damage(gamequark *child, unsigned int properties, int *damage, float *pos, vector4f *mx) {

   int ret;
   
   ret = status.apply_damage(properties, damage, pos, mx);

   // shields check
   if (status.shields <= 0 || status.shields_downtime > 0)
      flags &= ~GAMEFLAG_SHIELDS;

   return ret;
}


/* *************************************************************
************************************************************* */
int fighter::query_specific_data(unsigned int type, void *data) {

   switch (type) {

      case DATAFLAG_SHIELDS:
         if ((flags & GAMEFLAG_SHIELDS) && (flags & GAMEFLAG_SHIELD_MX)) {
            *(float **)data = shield_data;
            return 1;
         }

         return 0;

      case DATAFLAG_DEFAULT_CAMERA_STATE:
         *(float **)data = pilot_state;
         return 1;

      case DATAFLAG_FOLLOW_DISTANCE:
         *(float *)data = chase_dist;
         return 1;
	 
      case DATAFLAG_EQUIPMENT:
         *(object_desc **)data = &status;
         return 1;
	 
      case DATAFLAG_THRUSTER_USE:
         *(unsigned int *)data = thruster_flag;
         return 1;

      case DATAFLAG_STATUS:
         ((status_type *)data)->hp = status.hp;
         ((status_type *)data)->maxhp = status.maxhp;
         ((status_type *)data)->armour = status.armour;
         ((status_type *)data)->maxarmour = status.max_armour;
         ((status_type *)data)->shields = status.shields;
         ((status_type *)data)->maxshields = (int)status.max_shields;
         return 1;

      default:
         break;
   }

   return darkentity::query_specific_data(type, data);
}


/* *************************************************************
************************************************************* */
void fighter::death_by_ruru(quark *target, quark *parent) {

   linktype *ptr;

   if (target->query_whatwasi(OBJECT_GAMEQUARK))
      ((gamequark *)target)->hp = 0;

   // check w/ subtree
   for (ptr=(linktype *)target->edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent)
         death_by_ruru(ptr->link, target);
}


/* *************************************************************
************************************************************* */
int fighter::set_specific_data(unsigned int type, void *data) {

   equip_radar *radar;
   float range2;
   vector3f dist;
   coldata_type *cdata;
   
   switch (type) {

      case DATAFLAG_MISSILE_LOCK:
         radar = (equip_radar *)status.find_specific(EQUIP_RADAR);

         if (radar)
            radar->set_missile_lock((gameatom *)data);

         return 1;

      case DATAFLAG_RADAR_LOCK:
         radar = (equip_radar *)status.find_specific(EQUIP_RADAR);

         if (radar)
            radar->set_radar_lock((gameatom *)data);

         return 1;

      case DATAFLAG_COLLISION:
      
         if ((old_state.state_flags & STATE_MASK_TREE) != STATE_FLAG_TSPHERE)
            return 0;
	    
	 cdata = (coldata_type *)data;
	 
         subeqarray3(dist, old_state.tree_center, cdata->pos);
         range2 = dotproduct3(dist, dist);

         if (coldata.collision_flag && range2 >= coldata.range2)
	    return 0;
	    
         coldata.collision_flag = 1;
         coldata.range2 = range2;

         copyarray3(coldata.pos, cdata->pos);
         coldata.pos[3] = 1.0f;
		  
         copyarray3(coldata.normal, cdata->normal);

         return 1;

      default:
         break;
   }

   return darkentity::set_specific_data(type, data);
}
