

#include <stdlib.h>
#include <string.h>

#include "stars.h"

#include "gamegine.h"
#include "pcloud.h"

#include "pstring.h"

#define MAX_DUST            256
#define MAX_DUST_MASK       255
#define MAX_DUST_DEPTH      512.0f
#define MAX_DUST_DEPTH_MASK 511
#define MAX_DUST_RANGE      1023


/* *************************************************************
************************************************************* */
int dust::query_whatwasi(int type) {

   return (dust::query_whatami() == type) ? 1 : gamequark::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
dust::dust() {

   int i;

   ob = complex->gfx->gfxAllocRenderObject(OBJECT_PARTICLE_CLOUD);
   ob->id = object_counter;
   object_counter++;

   ((pcloud *)ob)->count = MAX_DUST;
   ((pcloud *)ob)->cloud = new particulate[MAX_DUST];
   
   for (i=0; i<MAX_DUST; i++) {
      ((pcloud *)ob)->cloud[i].color[0] = ((pcloud *)ob)->cloud[i].color[1] = ((pcloud *)ob)->cloud[i].color[2] = 64 + (rand() % 191);

      ((pcloud *)ob)->cloud[i].pos[0] = (float)((rand() & MAX_DUST_RANGE) - MAX_DUST_DEPTH_MASK);
      ((pcloud *)ob)->cloud[i].pos[1] = (float)((rand() & MAX_DUST_RANGE) - MAX_DUST_DEPTH_MASK);
      ((pcloud *)ob)->cloud[i].pos[2] = (float)((rand() & MAX_DUST_RANGE) - MAX_DUST_DEPTH_MASK);
      ((pcloud *)ob)->cloud[i].pos[3] = 1.0f;
   }

   update_counter = 0;
}


/* *************************************************************
************************************************************* */
int dust::parse(FILE *infile, char *token) {

   switch (token[0]) {
      case 'b':
         if (!strcmp(token, TOKEN_BACKGROUND_STR)) {
            get_token(infile, token);
            ((pc *)ob)->groundflag = BACKGROUND;
            ((pc *)ob)->renderpriority = atoi(token);
            return 1;
         }

         break;

      case 'f':
         if (!strcmp(token, TOKEN_FOREGROUND_STR)) {
            get_token(infile, token);
            ((pc *)ob)->groundflag = FOREGROUND;
            ((pc *)ob)->renderpriority = atoi(token);
            return 1;
         }

         break;

      case 'm':
         if (!strcmp(token, TOKEN_MIDGROUND_STR)) {
            ((pc *)ob)->groundflag = MIDGROUND;
            return 1;
         }

         break;

      default:
         break;
   }

   return gamequark::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void dust::preprocess(void *data) {

   gamequark::preprocess(data);

   state.state_flags &= ~STATE_MASK_BOUND;
   state.state_flags |= STATE_FLAG_BSPHERE;
   state.bradius = (float)sqrt(MAX_DUST_DEPTH*MAX_DUST_DEPTH*3);
   state.bcenter[0] = state.bcenter[1] = state.bcenter[2] = 0;

   ((pcloud *)ob)->local_bradius2 = state.bradius*state.bradius;
   ((pcloud *)ob)->local_bcenter[0] = ((pcloud *)ob)->local_bcenter[1] = ((pcloud *)ob)->local_bcenter[2] = 0;
   ((pcloud *)ob)->local_bcenter[3] = 1.0f;
   ((pcloud *)ob)->recalc_bound_flag = 0; 

   update_counter = 0;
}


/* *************************************************************
   Note: full update every four frames (MAX_DUST must be a multiple of 4)
************************************************************* */
void dust::setup() {

   int i;
   vector3f v;
  
   for (update_counter &= MAX_DUST_MASK, i=update_counter+(MAX_DUST>>2); update_counter < i; update_counter++) {

      subeqarray3(v, ((pcloud *)ob)->cloud[update_counter].pos, state.center);
      
      if (v[0] < -MAX_DUST_DEPTH)
         ((pcloud *)ob)->cloud[update_counter].pos[0] = state.center[0] + (rand() & MAX_DUST_DEPTH_MASK);
      else if (v[0] > MAX_DUST_DEPTH)	 
         ((pcloud *)ob)->cloud[update_counter].pos[0] = state.center[0] - (rand() & MAX_DUST_DEPTH_MASK);

      if (v[1] < -MAX_DUST_DEPTH)
         ((pcloud *)ob)->cloud[update_counter].pos[1] = state.center[1] + (rand() & MAX_DUST_DEPTH_MASK);
      else if (v[1] > MAX_DUST_DEPTH)	 
         ((pcloud *)ob)->cloud[update_counter].pos[1] = state.center[1] - (rand() & MAX_DUST_DEPTH_MASK);

      if (v[2] < -MAX_DUST_DEPTH)
         ((pcloud *)ob)->cloud[update_counter].pos[2] = state.center[2] + (rand() & MAX_DUST_DEPTH_MASK);
      else if (v[2] > MAX_DUST_DEPTH)	 
         ((pcloud *)ob)->cloud[update_counter].pos[2] = state.center[2] - (rand() & MAX_DUST_DEPTH_MASK);
   }

   copyarray3(((pcloud *)ob)->local_bcenter, state.center);
   ((pc *)ob)->bound_sphere();
   
   if (((pc *)ob)->bvalid_flag) {
      state.state_flags &= ~(STATE_MASK_BOUND | STATE_FLAG_AUTO_UPDATE);
      state.state_flags |= STATE_FLAG_BSPHERE;
      state.bradius = ((pc *)ob)->bradius;
      copyarray3(state.bcenter, ((pc *)ob)->bcenter);
   }

}


/* *************************************************************
************************************************************* */
void dust::render_object(engine *proc, quark *parent, vector4f *frustum, unsigned int frustum_flag) {

   linktype *ptr;

   // cull node w/ view frustum
   if ((old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TNONE)
      frustum_flag = 0;
      
   if (frustum_flag) {
      if ((old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TSPHERE &&
          query_frustum_clip(old_state.tree_radius, old_state.tree_center, frustum, &frustum_flag, frustum_fail_data))
         return;

      if ((flags & QUARK_FLAG_ACTIVE) && (!((pc *)ob)->bvalid_flag || !frustum_flag || !query_frustum_clip(((pc *)ob)->bradius, ((pc *)ob)->bcenter, frustum, &frustum_flag, frustum_fail_data)))
         proc->engine_submit(ob);
   }

   else if (flags & QUARK_FLAG_ACTIVE)
      proc->engine_submit(ob);

   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent)
         ptr->link->render_object(proc, this, frustum, frustum_flag);
}
