

#if !defined __DARKTRON_H
#define __DARKTRON_H

#include "darkqurk.h"
#include "darkstrg.h"
#include "polygame.h"
#include "anineutr.h"


/* ****************************************************************
**************************************************************** */
class darkneutron : public antineutron {

   protected:
      void deathcheck(quark *parent);

   public:
      // superclass
      int  query_whatami() { return OBJECT_DARKNEUTRON; }
      int  query_whatwasi(int type);
      void preprocess(void *data);
      int  parse(FILE *infile, char *token); 

      // darkquark
      float countdown;
      string_type deathname;
      texbase *death_tob;

      darkneutron() { death_tob = NULL; }
      virtual ~darkneutron() {}
      
      void big_bang(float blast_time);
};


/* ****************************************************************
    // replacement for "quark" objects
**************************************************************** */
class darkneutron_loader : public quark_loader {

   protected:
      superclass *make_object() { return new darkneutron; }

   public:

      darkneutron_loader() {
         object_name = TOKEN_DARKNEUTRON_STR;
         alias_name  = TOKEN_NEUTRON_STR;
      }

      virtual ~darkneutron_loader() {}
};


#endif
