

#include <stdlib.h>
#include <string.h>

#include "pstring.h"

#include "darkgine.h"
#include "darktron.h"
#include "darkfx.h"

#define TIME_2_DIE              1
#define BLAST_RADIUS            64


/* *************************************************************
************************************************************* */
int darkneutron::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_DEATHNAME_STR)) {
      get_token(infile, token);
      deathname.stringcpy(token);
      return 1;
   }

   return antineutron::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void darkneutron::preprocess(void *data) {

   antineutron::preprocess(data);

   if (deathname.string[0])
      death_tob = (texbase *)((frame_manager *)global_resource_manager)->read_tex(deathname.string);
}


/* *************************************************************
************************************************************* */
int darkneutron::query_whatwasi(int type) {

   return (darkneutron::query_whatami() == type) ? 1 : antineutron::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
void darkneutron::deathcheck(quark *parent) {

   if (!(flags & QUARK_FLAG_ACTIVE))
      return;

   if (total_hp) {

      if (!death_tob || hp || (flags & GAMEFLAG_JUNK))
         return;

      flags |= GAMEFLAG_JUNK;
      big_bang(DEFAULT_BLAST_TIME);
      return;
   }

   // remove death check
   if (!death_tob) {
      flags &= ~(GAMEFLAG_DEATHCHECK | QUARK_FLAG_ACTIVE);
      return;
   }

   if (!(flags & GAMEFLAG_COUNTDOWN)) {
      flags |= GAMEFLAG_COUNTDOWN;
      countdown = TIME_2_DIE;
      big_bang((float)(DEFAULT_BLAST_TIME * (1 + (rand() & 0xff)/256.0)));
      return;
   }

   countdown -= complex->timer.speedscale;

   if (countdown > 0)
      return;

   // remove death check
   flags &= ~(GAMEFLAG_DEATHCHECK | QUARK_FLAG_ACTIVE);
}


/* *********************************************************************************
********************************************************************************* */
void darkneutron::big_bang(float blast_time) {

   generic_flat *fx;
   vector4f mx[4];
   float radius;
   vector4f temp;

   fx = (generic_flat *)complex->teacher.issue(OBJECT_GENERIC_FLAT);

   init_mx(mx);

   if ((old_state.state_flags & STATE_MASK_BOUND) == STATE_FLAG_BSPHERE) {
      radius = mx[0][0] = mx[1][1] = mx[2][2] = old_state.bradius*1.414f;
      copyarray4(temp, state.bcenter);
   }

   else {
      mx[0][0] = mx[1][1] = mx[2][2] = BLAST_RADIUS;
      copyarray4(temp, state.center);
   }

   fx->init(this, blast_time, radius, temp, state.node, mx, death_tob);
}

