

#if !defined __DARKQURK_H
#define __DARKQURK_H

#include "gamequrk.h"

#define OBJECT_ENTITY               110
#define OBJECT_MOVER                111
#define OBJECT_FIGHTER              112
#define OBJECT_PLAYER               113
#define OBJECT_NPC_FIGHTER          114

#define OBJECT_TURRENT              130
#define OBJECT_BARREL               131
#define OBJECT_DUST                 132
#define OBJECT_STARS                133
#define OBJECT_DARKNEUTRON          134
#define OBJECT_THRUSTER             135

#define OBJECT_AMMO_TYPE            211
#define OBJECT_LAZER                212
#define OBJECT_LAZER2BLU            213
#define OBJECT_LAZER2RED            214
#define OBJECT_LAZERII              215
#define OBJECT_LAZERIII             216
#define OBJECT_DUAL_LAZER           217
#define OBJECT_CONE_LAZER           218
#define OBJECT_RAIL_ROUND           219
#define OBJECT_MAGNETIC_MINE        220
#define OBJECT_MISSILE              221
#define OBJECT_ZUNI_MISSILE         222
#define OBJECT_SSM_MISSILE          223
#define OBJECT_GENERIC_FLAT         224
#define OBJECT_SHIELD_RIPPLE        225
#define OBJECT_HUMAN_SHIELD_RIPPLE  226
#define OBJECT_ALIEN_SHIELD_RIPPLE  227
#define OBJECT_SMOKE_TRAIL          228
#define OBJECT_EXPLOSION            229
#define OBJECT_SHOCKWAVE            230

#define GAMEFLAG_FIGHTER           0x00800000
#define GAMEFLAG_BOMBER            0x01000000
#define GAMEFLAG_STATION           0x02000000
#define GAMEFLAG_CAPSHIP           0x04000000
#define GAMEFLAG_DESC_MASK         0x07800000

#define GAMEFLAG_COUNTDOWN         0x08000000    // flag if death countdown is started
#define GAMEFLAG_JUNK              0x10000000    // flag if gamequark is dead, but still visible
#define GAMEFLAG_SHIELDS           0x20000000    // object has shields
#define GAMEFLAG_SHIELD_MX         0x40000000    // object has shield shape data

#define DATAFLAG_SHIELDS              0x00010000
//#define DATAFLAG_EQUIP_SHIELDS        0x00020000
#define DATAFLAG_COLLISION            0x00030000
#define DATAFLAG_EQUIPMENT            0x00040000
#define DATAFLAG_THRUSTER_USE         0x00050000
// used to inform gun that missile has exploded
#define DATAFLAG_SECONDARY_DETONATION 0x00060000
#define DATAFLAG_STATUS               0x00070000
#define DATAFLAG_RADAR_LOCK           0x00080000
#define DATAFLAG_MISSILE_LOCK         0x00090000
#define DATAFLAG_UNRELIABLE           0x000a0000
#define DATAFLAG_THREAT_LIST          0x000b0000
#define DATAFLAG_THREAT               0x000c0000
#define DATAFLAG_ACCEL                0x000d0000
#define DATAFLAG_MAXSPEED             0x000e0000
#define DATAFLAG_DEULER               0x000f0000
#define DATAFLAG_KILL_NOTICE          0x00100000
#define DATAFLAG_KILLED_BY_NOTICE     0x00200000
#define DATAFLAG_DECLARED_HOSTILE     0x00300000

#define TARGETFLAG_FIGHTER 0x01
#define TARGETFLAG_BOMBER  0x02
#define TARGETFLAG_STATION 0x03
#define TARGETFLAG_CAPSHIP 0x04
#define TARGETFLAG_TURRENT 0x05
#define TARGETFLAG_MINE    0x06
#define TARGETFLAG_MISSILE 0x07

#define FLAG_THREAT_NULL             0x00
#define FLAG_THREAT_DECLARED_HOSTILE 0x01

#define DEFAULT_BLAST_TIME      2


typedef struct {
   int hp, armour; 
   float shields;
   int maxhp, maxarmour, maxshields;
} status_type;


/* ************************************************************
************************************************************ */
class mini_memman {

   protected:
      dbl_llist_manager man;
      
   public:
      virtual ~mini_memman() {}

      virtual void *pop() = 0;
      void push(dbl_llist *mem) { man.insert(mem, NULL); }
};


/* ************************************************************
************************************************************ */
class threat_type : public dbl_llist {

   public:
      atom_list_type *threat;
      dbl_llist_manager mayday_manager; // hiearchy_list_type - protectors
      int hit_count;
      float damage;
      int flags;
      float timer;
      
      threat_type() { threat = NULL; timer = 0; hit_count = 0; damage = 0; flags = FLAG_THREAT_NULL; }
      virtual ~threat_type() {}
};


/* **********************************************************
********************************************************** */
class darkentity : public gameatom {

   protected:
      dbl_llist_manager task_manager;
      dbl_llist_manager threat_manager;
      atom_list_type *last_attacker;
      
      void update_threat_manager();
      void attack_traitor(atom_list_type *target);

      virtual void process_intel(dbl_llist_manager *hiearchy_manager, vector4f *mx) { }

   public:
      // superclass
      int  query_whatami() { return OBJECT_ENTITY; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);

      // quark
      void update(dbl_llist_manager *hiearchy_manager, quark *parent);
      void render_object(engine *proc, quark *parent, vector4f *frustum, unsigned int frustum_flag);
      int  set_specific_data(unsigned int type, void *data);
      int  query_specific_data(unsigned int type, void *data);

      // darkentity
      darkentity() { last_attacker = NULL; }
      virtual ~darkentity() {}
};


/* ****************************************************************
**************************************************************** */
class darkentity_loader : public quark_loader {

   protected:
      superclass *make_object() { return new darkentity; }

   public:
      darkentity_loader();
      virtual ~darkentity_loader() {}
};


/* **********************************************************
********************************************************** */
class darkmover : public darkentity {

   protected:
      float dist2target;
      vector3f target_dir;
      vector3f target_pos;
      vector4f current_velocity;
      float maxspeed, accel, dorient;
      float jump_timer;
      
      void process_intel(dbl_llist_manager *hiearchy_manager, vector4f *mx);

   public:
      // superclass
      int  query_whatami() { return OBJECT_MOVER; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      // quark
      void update(dbl_llist_manager *hiearchy_manager, quark *parent);
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      int  set_specific_data(unsigned int type, void *data);

      // darkmover
      virtual ~darkmover() {}
};


/* ****************************************************************
**************************************************************** */
class darkmover_loader : public quark_loader {

   protected:
      superclass *make_object() { return new darkmover; }

   public:
      darkmover_loader();
      virtual ~darkmover_loader() {}
};


/* *************************************************************
************************************************************* */
class base_container_type {

   public:
      virtual ~base_container_type() {}
      
      // generate octtree
      virtual void construct(dbl_llist_manager *src) = 0;

      // release pointers
      virtual void deconstruct(dbl_llist_manager *free_manager) = 0;

      // build list based on sphere intersection
      virtual void sphere_vs_obj(float *bcenter, float bradius, dbl_llist_manager *out, dbl_llist_manager *free_manager) = 0;
      virtual void frustum_vs_obj(vector4f *frustum, unsigned int frustum_flag, dbl_llist_manager *out, dbl_llist_manager *free_manager) = 0;
};


/* *************************************************************
************************************************************* */
class hiearchy_list_type : public dbl_llist {

   public:
      atom_list_type *hiearchy;

      hiearchy_list_type() { hiearchy = NULL; }
      virtual ~hiearchy_list_type() {}
};


/* *************************************************************
************************************************************* */
class hiearchy_container_type : public base_container_type {

   public:
      hiearchy_list_type *node;
      
      virtual ~hiearchy_container_type() { }

      void construct(dbl_llist_manager *src);
      void deconstruct(dbl_llist_manager *free_manager);
      void sphere_vs_obj(float *bcenter, float bradius, dbl_llist_manager *out, dbl_llist_manager *free_manager);
      void frustum_vs_obj(vector4f *frustum, unsigned int frustum_flag, dbl_llist_manager *out, dbl_llist_manager *free_manager);
};


/* *************************************************************
************************************************************* */
class container_type : public base_container_type {

   protected:
      union { vector4uc frustum_fail_data; unsigned int frustum_fail_flag; };

   public:
      base_container_type *branch[8];
      vector3f center;
      float radius;

      container_type();
      virtual ~container_type() { dest(); }       
      void dest();

      void construct(dbl_llist_manager *src);
      void deconstruct(dbl_llist_manager *free_manager);
      void sphere_vs_obj(float *bcenter, float bradius, dbl_llist_manager *out, dbl_llist_manager *free_manager);
      void frustum_vs_obj(vector4f *frustum, unsigned int frustum_flag, dbl_llist_manager *out, dbl_llist_manager *free_manager);
};


/* *************************************************************
************************************************************* */
class world_type : public base_container_type {

   public:
      container_type sphere;
      dbl_llist_manager all;
      
      virtual ~world_type() {}

      void construct(dbl_llist_manager *src);
      void deconstruct(dbl_llist_manager *free_manager);
      void sphere_vs_obj(float *bcenter, float bradius, dbl_llist_manager *out, dbl_llist_manager *free_manager);
      void frustum_vs_obj(vector4f *frustum, unsigned int frustum_flag, dbl_llist_manager *out, dbl_llist_manager *free_manager);
};


typedef struct {

   unsigned int source_flags;
   float *attacker_pos;
   float *attacker_dir;
   quark *target;
   vector4f midpt;
   float range;
} los_type;


int query_fire_primary(gameatom *source_atom, unsigned int source_flags,
               dbl_llist_manager *hiearchy_manager, float *attacker_pos, float *attacker_dir,
	       float range, quark *target, float *oclock,
	       float dist2target, float *target_pos, float target_radius);
int query_fire_secondary(gameatom *source_atom, unsigned int source_flags, dbl_llist_manager *hiearchy_manager, float *attacker_pos,
               float *attacker_dir, float range, quark *target,
	       float *oclock, float dist2target);

#endif

