

#include <string.h>

#include "pstring.h"

#include "anineutr.h"

#include "darkgine.h"
#include "darkfx.h"


#define COS_ACCURACY            0.9
#define MIN_SECONDARY_DIST      32
#define DAMAGE_MULTIPLIER       1
#define THREAT_COUNTDOWN        5


/* *************************************************************
************************************************************* */
int darkentity::query_whatwasi(int type) {

   return darkentity::query_whatami() == type ? 1 : gameatom::query_whatwasi(type);
}


/* *********************************************************************************
********************************************************************************* */
int darkentity::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_TYPE_STR)) {

      get_token(infile, token);
      lower_case(token);

      if (!strcmp(token, TOKEN_FIGHTER_STR)) {
         flags |= GAMEFLAG_FIGHTER;
         return 1;
      }

      if (!strcmp(token, TOKEN_BOMBER_STR)) {
         flags |= GAMEFLAG_BOMBER;
         return 1;
      }

      if (!strcmp(token, TOKEN_CAPSHIP_STR)) {
         flags |= GAMEFLAG_CAPSHIP;
         return 1;
      }

      if (!strcmp(token, TOKEN_STATION_STR)) {
         flags |= GAMEFLAG_STATION;
         return 1;
      }

      return 1;
   }

   return gameatom::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void darkentity::preprocess(void *data) {

   quark::preprocess(data);
}

   
/* *************************************************************
************************************************************* */
void darkentity::update_threat_manager() {

   threat_type *ttr, *ptr;
   hiearchy_list_type *gtr, *htr;

   ttr = (threat_type *)threat_manager.head;
   while (ttr) {
      ptr = ttr;
      ttr = (threat_type *)ttr->next;

      ptr->damage -= complex->timer.speedscale;
      ptr->timer -= complex->timer.speedscale;

      if ((!(ptr->flags & FLAG_THREAT_DECLARED_HOSTILE) && (ptr->timer <= 0 || ptr->damage <= 0)) || !GATOM_STATUS(ptr->threat)) {
         threat_manager.remove(ptr);
         delete ptr;
      }

      else {
         // remove obsolete defenders
         htr = (hiearchy_list_type *)ptr->mayday_manager.head;

         while (htr) {
            gtr = htr;
            htr = (hiearchy_list_type *)htr->next;

            if (!GATOM_STATUS(gtr->hiearchy)) {
               ptr->mayday_manager.remove(gtr);
               delete gtr;
            }

         }

      }

   }

}


/* *************************************************************
************************************************************* */
void darkentity::update(dbl_llist_manager *hiearchy_manager, quark *parent) {

   gameatom::update(hiearchy_manager, parent);

   if (!(flags & QUARK_FLAG_ACTIVE))
      return; 

   if (total_hp <= 0) {
      flags &= ~QUARK_FLAG_ACTIVE;

      if (last_attacker && (flags & GAMEFLAG_DESC_MASK)) {
         last_attacker->htree->set_specific_data(DATAFLAG_KILL_NOTICE, this);
         set_specific_data(DATAFLAG_KILLED_BY_NOTICE, last_attacker);
      }

   }

   else
      update_threat_manager();
}


/* *************************************************************
************************************************************* */
void darkentity::render_object(engine *proc, quark *parent, vector4f *frustum, unsigned int frustum_flag) {

   if (flags & QUARK_FLAG_ACTIVE)
      atom::render_object(proc, parent, frustum, frustum_flag);
   else
      flags &= ~QUARK_FLAG_VISIBLE;
}


/* *************************************************************
************************************************************* */
int darkentity::query_specific_data(unsigned int type, void *data) {

   switch (type) {
      case DATAFLAG_THREAT_LIST:
         *(dbl_llist_manager **)data = &threat_manager;
         return 1;

      default:
         break;
   }

   return gameatom::query_specific_data(type, data);
}


/* *************************************************************
************************************************************* */
int darkentity::set_specific_data(unsigned int type, void *data) {

   sim_task_node *ptr;
   threat_type *threat, *ttr;
   atom_list_type *target;
   hit_type *htr;

   switch (type) {
      case DATAFLAG_AI_REMOVE_TASK:
         for (ptr = (sim_task_node *)task_manager.head; ptr; ptr = (sim_task_node *)ptr->next)
            if (ptr->node == (sim_task_type *)data) {
               task_manager.remove(ptr);
               delete ptr;
               return 1;
            }

         return 0;

      case DATAFLAG_AI_NEW_TASK:
         task_manager.append(ptr = new sim_task_node, NULL);
         ptr->node = (sim_task_type *)data;
         return 1;

      case DATAFLAG_THREAT:
         threat = (threat_type *)data;

         last_attacker = threat->threat;

         if ((gameatom *)threat->threat == (gameatom *)this || (threat->threat->htree->flags & flags & GAMEFLAG_ALLIANCE_MASK))
            return 0;

         for (ttr = (threat_type *)threat_manager.head; ttr; ttr = (threat_type *)ttr->next)
            if (ttr->threat == threat->threat)
               break;

         if (!ttr) {
            threat_manager.append(ttr = new threat_type, NULL);
            ttr->threat = threat->threat;
         }

         ttr->hit_count += threat->hit_count;
         ttr->damage += threat->damage*DAMAGE_MULTIPLIER;
         ttr->timer = THREAT_COUNTDOWN;
         return 1;

      case DATAFLAG_DECLARED_HOSTILE:
         target = (atom_list_type *)data;

         if (target->htree == this)
            return 0;
	    
         for (ttr = (threat_type *)threat_manager.head; ttr; ttr = (threat_type *)ttr->next)
            if (ttr->threat == target)
               break;

         if (!ttr) {
            threat_manager.append(ttr = new threat_type, NULL);
            ttr->threat = target;
         }

         ttr->flags |= FLAG_THREAT_DECLARED_HOSTILE;	 
         return 1;

      case DATAFLAG_KILLED_BY_NOTICE:

          if (((atom_list_type *)data)->htree != global_player)
             return 1;

         if (global_player->flags & GAMEFLAG_ALLIANCE_MASK & flags)
            attack_traitor((atom_list_type *)data);

         if (sheader)
            for (htr = (hit_type *)sheader->player_hit_manager.head; htr; htr = (hit_type *)htr->next)
               if (htr->target == this) {
                  sheader->player_hit_manager.remove(htr);
                  delete htr;
                  break;
               }

         return 1;

      default:
         break;
   }

   return quark::set_specific_data(type, data);
}


/* *************************************************************
************************************************************* */
void darkentity::attack_traitor(atom_list_type *target) {

   atom_list_type *atr;
   int alliance;
   
   alliance = target->htree->flags & GAMEFLAG_ALLIANCE_MASK;
     
   for (atr = (atom_list_type *)complex->animation_manager.head; atr; atr = (atom_list_type *)atr->next)
      if (atr->htree->flags & alliance)
         atr->htree->set_specific_data(DATAFLAG_DECLARED_HOSTILE, target);
}


/* *************************************************************
************************************************************* */
darkentity_loader::darkentity_loader() {

   object_name = alias_name = TOKEN_ENTITY_STR;
}


/* *************************************************************
************************************************************* */
int darkmover::query_whatwasi(int type) {

   return darkmover::query_whatami() == type ? 1 : darkentity::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
void darkmover::preprocess(void *data) {

   darkentity::preprocess(data);

   target_dir[0] = old_state.xmx[0][2];
   target_dir[1] = old_state.xmx[1][2];
   target_dir[2] = old_state.xmx[2][2];
   normalize3(target_dir);
   current_velocity[0] = current_velocity[1] = current_velocity[2] = current_velocity[3] = 0;
   maxspeed = accel = dorient = 0;
   jump_timer = (float)(id & 0x03);
}


/* *************************************************************
************************************************************* */
void darkmover::process_intel(dbl_llist_manager *hiearchy_manager, vector4f *mx) {

   sim_task_node *ptr;
   int priority = -1;
   int i;
   vector3f pos, dir;
   float temp;
   vector4f r[4], s[4];
   vector3f work;
   orient_pathway orient;
   chase_pathway  chase;
   float dist;
      
   for (ptr = (sim_task_node *)task_manager.head; ptr; ptr = (sim_task_node *)ptr->next) {
      i = ptr->node->query_priority();
      if (i > priority && ptr->node->query_specific_data(TASK_ORDERS_LOCATION, pos))
         priority = i;      
   }

   // else just mosy on...
   if (priority == -1) {
      dist2target = 0;
      return;
   }

   subeqarray3(target_dir, pos, old_state.center);
   dist2target = dotproduct3(target_dir, target_dir);
   
   if (dist2target < 1) {
      initxform[0][3] = pos[0];
      initxform[1][3] = pos[1];
      initxform[2][3] = pos[2];
      dist2target = 0;
      return;
   }
   
   dist2target = (float)sqrt(dist2target);
   temp = (float)(1.0/dist2target);
   smultarray3(target_dir, temp);

   if (!(old_state.state_flags & STATE_FLAG_INVERSE)) {
      inversemx(old_state.xmx, old_state.ixmx);
      old_state.state_flags |= STATE_FLAG_INVERSE;
   }

   inversemx(old_state.xmx, old_state.ixmx);
   matvecmultv(old_state.ixmx, target_dir, work);
   normalize3(work);

   dir[0] = 0;
   dir[1] = 0;
   dir[2] = 1;

   orient.calc_orientation(dir, work, dorient, r, AXIS_Y);
   copymx4x4o(s, initxform);
   matmatmulto(s, r, initxform);

   dir[0] = initxform[0][2];
   dir[1] = initxform[1][2];
   dir[2] = initxform[2][2];

   normalize3(dir);

   copyarray3(work, current_velocity);

   chase.calc_velocity(dir, target_dir, dist2target, maxspeed, accel, work, current_velocity[3], current_velocity, &current_velocity[3]);

   dist = current_velocity[3] * complex->timer.speedscale;
   initxform[0][3] += dist * current_velocity[0];
   initxform[1][3] += dist * current_velocity[1];
   initxform[2][3] += dist * current_velocity[2];
}


/* *************************************************************
************************************************************* */
void darkmover::whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   linktype *ptr;			

   if (!(flags & QUARK_FLAG_ACTIVE))
      return;

   process_intel(hiearchy_manager, mx);

   matmatmulto(mx, initxform, state.xmx);
   copymx4x4o(state.node, state.xmx);

   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)                 
      if (ptr->link != parent)                         
         ptr->link->whereami(hiearchy_manager, this, state.node);

   state.center[0] = state.xmx[0][3];
   state.center[1] = state.xmx[1][3];
   state.center[2] = state.xmx[2][3];
}


/* *************************************************************
************************************************************* */
void darkmover::update(dbl_llist_manager *hiearchy_manager, quark *parent) {

   sim_task_node *ptr;
   shockwave *sfx;
   explosion *efx;

   if (flags & QUARK_FLAG_ACTIVE)
      for (ptr = (sim_task_node *)task_manager.head; ptr; ptr = (sim_task_node *)ptr->next)
         if (ptr->node->query_whatami() == DARKSIM_JUMP) {
            jump_timer -= complex->timer.speedscale;
	 
            if (jump_timer <= 0) {
               ptr->node->owner->flags |= DARKSIM_FLAG_JUMP;

               sfx = (shockwave *)complex->teacher.issue(OBJECT_SHOCKWAVE);
               sfx->init(old_state.xmx, 5, 5000);

               efx = (explosion *)complex->teacher.issue(OBJECT_EXPLOSION);
               efx->init(old_state.xmx, 5, 5000);
               flags &= ~QUARK_FLAG_ACTIVE;
            }
   
            break;
         }
	 
   darkentity::update(hiearchy_manager, parent);
}


/* *************************************************************
************************************************************* */
int darkmover::set_specific_data(unsigned int type, void *data) {

   switch (type) {
      case DATAFLAG_ACCEL:
         accel = *(float *)data;
         return 1;

      case DATAFLAG_MAXSPEED:
         maxspeed = *(float *)data;
         return 1;

      case DATAFLAG_DEULER:
         dorient = *(float *)data;
         return 1;

      default:
         break;
   }

   return darkentity::set_specific_data(type, data);
}


/* *************************************************************
************************************************************* */
darkmover_loader::darkmover_loader() {

   object_name = alias_name = TOKEN_MOVER_STR;
}


/* *************************************************************
************************************************************* */
void hiearchy_container_type::construct(dbl_llist_manager *src) {

   src->remove(node = (hiearchy_list_type *)src->head);
}


/* *************************************************************
************************************************************* */
void hiearchy_container_type::deconstruct(dbl_llist_manager *free_manager) {

   free_manager->insert(node, NULL);
   node = NULL;
}


/* *************************************************************
   same as frustum_vs_obj
************************************************************* */
void hiearchy_container_type::sphere_vs_obj(float *bcenter, float bradius, dbl_llist_manager *out, dbl_llist_manager *free_manager) {

   hiearchy_list_type *ptr;

   if (free_manager->head)
      free_manager->remove(ptr = (hiearchy_list_type *)free_manager->head);
   else
      ptr = new hiearchy_list_type;
      
   out->append(ptr, NULL);
   ptr->hiearchy = node->hiearchy;
}

      
/* *************************************************************
   same as sphere_vs_obj
************************************************************* */
void hiearchy_container_type::frustum_vs_obj(vector4f *frustum, unsigned int frustum_flag, dbl_llist_manager *out, dbl_llist_manager *free_manager) {

   hiearchy_list_type *ptr;

   if (free_manager->head)
      free_manager->remove(ptr = (hiearchy_list_type *)free_manager->head);
   else
      ptr = new hiearchy_list_type;
      
   out->append(ptr, NULL);
   ptr->hiearchy = node->hiearchy;
}

      
/* *************************************************************
************************************************************* */
container_type::container_type() {

   int i;
   
   for (i=0; i<8; i++)
      branch[i] = NULL;
             
   frustum_fail_data[0] = 0;
   frustum_fail_data[1] = 1;
}


/* *************************************************************
************************************************************* */
void container_type::dest() {
   
   int i;
   
   for (i=0; i<8; i++)
      if (branch[i]) {
         delete branch[i];
         branch[i] = NULL;
      }

}       


/* *************************************************************
************************************************************* */
void container_type::sphere_vs_obj(float *bcenter, float bradius, dbl_llist_manager *out, dbl_llist_manager *free_manager) {

   int i;
         
   if (query_sphere_sphere_intersect(bcenter, bradius, center, radius))
      for (i = 0; i < 8; i++)
         if (branch[i])
            branch[i]->sphere_vs_obj(bcenter, bradius, out, free_manager);
}

      
/* *************************************************************
************************************************************* */
void container_type::frustum_vs_obj(vector4f *frustum, unsigned int frustum_flag, dbl_llist_manager *out, dbl_llist_manager *free_manager) {

   int i;

   if (!query_frustum_clip(radius, center, frustum, &frustum_flag, frustum_fail_data))
      for (i = 0; i < 8; i++)
         if (branch[i])
            branch[i]->frustum_vs_obj(frustum, frustum_flag, out, free_manager);
}


/* *************************************************************
************************************************************* */
void container_type::construct(dbl_llist_manager *src) {

   int i;
   dbl_llist_manager x[8];
   hiearchy_list_type *ptr;
   vector3f min, max;
   float t;

   // calc center and radius
   for (ptr = (hiearchy_list_type *)src->head; ptr; ptr = (hiearchy_list_type *)ptr->next)
      if (ptr == (hiearchy_list_type *)src->head) {
         copyarray3(min, ptr->hiearchy->htree->old_state.tree_min);
         copyarray3(max, ptr->hiearchy->htree->old_state.tree_max);
      }

      else {
         for (i=0; i<3; i++) {
            if (ptr->hiearchy->htree->old_state.tree_min[i] < min[i])
               min[i] = ptr->hiearchy->htree->old_state.tree_min[i];
            if (ptr->hiearchy->htree->old_state.tree_max[i] > max[i])
               max[i] = ptr->hiearchy->htree->old_state.tree_max[i];
         }

      }

   center[0] = 0.5f*(min[0] + max[0]);
   center[1] = 0.5f*(min[1] + max[1]);
   center[2] = 0.5f*(min[2] + max[2]);

   subarray3(max, min);
   t = dotproduct3(max, max);
   radius = t < 1 ? 1.0f : (float)sqrt(0.25*t);

   // if 8 or less nodes, just insert them in their own slots
   if (src->count < 9) {
      for (i = 0, ptr = (hiearchy_list_type *)src->head; ptr; i++, ptr = (hiearchy_list_type *)src->head) {
         branch[i] = new hiearchy_container_type;
         src->remove(ptr);
         x[0].append(ptr, NULL);
         branch[i]->construct(&x[0]);
      }

      return;
   }

   for (ptr = (hiearchy_list_type *)src->head; ptr; ptr = (hiearchy_list_type *)ptr->next)
      if (ptr == (hiearchy_list_type *)src->head) {
         copyarray3(min, ptr->hiearchy->htree->old_state.tree_center);
      }

      else
         addarray3(min, ptr->hiearchy->htree->old_state.tree_center);

   t = 1.0f/src->count;
   smultarray3(min, t);

   // else divide space into octree
   for (ptr = (hiearchy_list_type *)src->head; ptr; ptr = (hiearchy_list_type *)src->head) {
      src->remove(ptr);

      i = 0;

      if (ptr->hiearchy->htree->old_state.tree_center[0] > min[0])
         i |= 1;
      if (ptr->hiearchy->htree->old_state.tree_center[1] > min[1])
         i |= 2;
      if (ptr->hiearchy->htree->old_state.tree_center[2] > min[2])
         i |= 4;

      x[i].append(ptr, NULL);
   }

   for (i=0; i<8; i++)
      if (x[i].count) {
         if (!branch[i])
            branch[i] = new container_type;
         branch[i]->construct(&x[i]);
      }

}


/* *************************************************************
************************************************************* */
void container_type::deconstruct(dbl_llist_manager *free_manager) {
   
   int i;
   
   for (i=0; i<8; i++)
      if (branch[i])
         branch[i]->deconstruct(free_manager);

   dest();
}


/* *************************************************************
************************************************************* */
void world_type::construct(dbl_llist_manager *src) {

   hiearchy_list_type *ptr;
   dbl_llist_manager x;

   while(src->head) {
      src->remove(ptr = (hiearchy_list_type *)src->head);

      if ((ptr->hiearchy->htree->old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TALL)
         all.append(ptr, NULL);
      else
         x.append(ptr, NULL);
   }

   if (x.count)
      sphere.construct(&x);
}


/* *************************************************************
************************************************************* */
void world_type::deconstruct(dbl_llist_manager *free_manager) {

   hiearchy_list_type *ptr;
   
   sphere.deconstruct(free_manager);

   while (all.head) {
      all.remove(ptr=(hiearchy_list_type *)all.head);
      free_manager->insert(ptr, NULL);
   }
      
}


/* *************************************************************
************************************************************* */
void world_type::sphere_vs_obj(float *bcenter, float bradius, dbl_llist_manager *out, dbl_llist_manager *free_manager) {

   hiearchy_list_type *gtr, *ptr;

   for (ptr = (hiearchy_list_type *)all.head; ptr; ptr = (hiearchy_list_type *)ptr->next) {

      if (free_manager->head)
         free_manager->remove(gtr = (hiearchy_list_type *)free_manager->head);
      else
         gtr = new hiearchy_list_type;
      
      out->append(gtr, NULL);
      gtr->hiearchy = ptr->hiearchy;
   }

   sphere.sphere_vs_obj(bcenter, bradius, out, free_manager);
}


/* *************************************************************
************************************************************* */
void world_type::frustum_vs_obj(vector4f *frustum, unsigned int frustum_flag, dbl_llist_manager *out, dbl_llist_manager *free_manager) {

   hiearchy_list_type *gtr, *ptr;

   for (ptr = (hiearchy_list_type *)all.head; ptr; ptr = (hiearchy_list_type *)ptr->next) {

      if (free_manager->head)
         free_manager->remove(gtr = (hiearchy_list_type *)free_manager->head);
      else
         gtr = new hiearchy_list_type;
      
      out->append(gtr, NULL);
      gtr->hiearchy = ptr->hiearchy;
   }

   sphere.frustum_vs_obj(frustum, frustum_flag, out, free_manager);
}


/* *********************************************************************************
********************************************************************************* */
int query_clear_los(quark *parent, quark *obstacle, los_type *los_data) {

   vector4f p;
   vector3f v;
   float dist;
   linktype *ptr;
   unsigned int mask;

   if ((obstacle->old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TNONE)
      return 1;
      
   if (obstacle != los_data->target) {

      if ((obstacle->old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TSPHERE) {

         dist = los_data->range + obstacle->old_state.tree_radius;
         subeqarray3(v, obstacle->old_state.tree_center, los_data->attacker_pos);

         if (dist*dist < dotproduct3(v, v))
            return 1;
      }

      switch (los_data->source_flags & GAMEFLAG_ALLIANCE_MASK) {
         case GAMEFLAG_RED:
            mask = GAMEFLAG_GREEN | GAMEFLAG_RED;
            break;

         case GAMEFLAG_GREEN:
            mask = GAMEFLAG_GREEN | GAMEFLAG_BLUE;
            break;

         default:               //case GAMEFLAG_BLUE:
            mask = GAMEFLAG_GREEN | GAMEFLAG_BLUE;
	    break;
      }

      if ((obstacle->flags & mask) &&                    // target is considered an obstacle
	  (obstacle->flags & QUARK_FLAG_ACTIVE) &&       // target is alive
          (obstacle->flags & GAMEFLAG_PHYSICAL) &&       // target is physical
//          ((antineutron *)obstacle)->obj_vs_lineseg(los_data->attacker_pos, los_data->target->old_state.tree_center, los_data->midpt, los_data->range, p, v, COL_SUBSPHERE_1))
          ((antineutron *)obstacle)->obj_vs_lineseg(los_data->attacker_pos, los_data->target->old_state.tree_center, los_data->midpt, los_data->range, p, v, COL_POLYGON))
         return 0;
   }

   for (ptr=(linktype *)obstacle->edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent && !query_clear_los(obstacle, ptr->link, los_data))
         return 0;

   return 1;
}


/* *********************************************************************************
   assume attacker_dir and oclock are normalized
          oclock is toward target
********************************************************************************* */
int query_fire_primary(gameatom *source_atom, unsigned int source_flags, dbl_llist_manager *hiearchy_manager, float *attacker_pos,
               float *attacker_dir, float range, quark *target, float *oclock, float dist2target, float *target_pos, float target_radius) {

   atom_list_type *atr;
   los_type los_data;
   
   // check if target out of range
   if (range < dist2target)
      return 0;

   // check if in firing arc
   if ((target->old_state.state_flags & STATE_MASK_BOUND) == STATE_FLAG_BSPHERE) {
      if (!query_line_sphere_intersect(target_radius, target_pos, attacker_pos, attacker_dir))
         return 0;
   }

   else if (dotproduct3(oclock, attacker_dir) < COS_ACCURACY)
      return 0;

   los_data.source_flags = source_flags;
   los_data.attacker_pos = attacker_pos;
   los_data.attacker_dir = attacker_dir;
   los_data.target = target;
   los_data.midpt[0] = (attacker_pos[0] + source_atom->old_state.center[0]) * 0.5f;
   los_data.midpt[1] = (attacker_pos[1] + source_atom->old_state.center[1]) * 0.5f;
   los_data.midpt[2] = (attacker_pos[2] + source_atom->old_state.center[2]) * 0.5f;
   los_data.range = dist2target;
   
   for (atr = (atom_list_type *)hiearchy_manager->head; atr; atr = (atom_list_type *)atr->next)
      if (atr->htree != source_atom && !query_clear_los(NULL, atr->htree, &los_data))
         return 0;

    return 1;
}


/* *********************************************************************************
   assume attacker_dir and oclock are normalized
          oclock is toward target
********************************************************************************* */
int query_fire_secondary(gameatom *source_atom, unsigned int source_flags, dbl_llist_manager *hiearchy_manager, float *attacker_pos,
               float *attacker_dir, float range, quark *target, float *oclock, float dist2target) {

   atom_list_type *atr;
   vector3f v;
   float *tv;
   los_type los_data;

   // check if target w/in range (not too close, not too far)
   if (range < dist2target*0.8 || MIN_SECONDARY_DIST > dist2target)
      return 0;

   if (!target->query_specific_data(DATAFLAG_PERCEIVED_VELOCITY, &tv))
      return 0;

   subeqarray3(v, target->old_state.center, attacker_pos);

   // only shoot if target is going away from this
   if (dotproduct3(tv, v) < -CORRECT)
      return 0;

   // check if in firing arc
   if ((target->old_state.state_flags & STATE_MASK_BOUND) == STATE_FLAG_BSPHERE) {
      if (!query_line_sphere_intersect(target->old_state.bradius, target->old_state.bcenter, attacker_pos, attacker_dir))
         return 0;
   }

   else if (dotproduct3(oclock, attacker_dir) < COS_ACCURACY)
      return 0;

   los_data.source_flags = source_flags;
   los_data.attacker_pos = attacker_pos;
   los_data.attacker_dir = attacker_dir;
   los_data.target = target;
   los_data.midpt[0] = (attacker_pos[0] + source_atom->old_state.center[0]) * 0.5f;
   los_data.midpt[1] = (attacker_pos[1] + source_atom->old_state.center[1]) * 0.5f;
   los_data.midpt[2] = (attacker_pos[2] + source_atom->old_state.center[2]) * 0.5f;
   los_data.range = dist2target;
   
   for (atr = (atom_list_type *)hiearchy_manager->head; atr; atr = (atom_list_type *)atr->next)
      if (atr->htree != source_atom && !query_clear_los(NULL, atr->htree, &los_data))
         return 0;

    return 1;
}

