

#if !defined __DARKMENU_H
#define __DARKMENU_H

#include "menu.h"


#define WIDGET_KEYFRAME        10
#define WIDGET_FUNCTION_BUTTON 11
#define WIDGET_KEY             12
#define WIDGET_MOUSEBUTTON     13
#define WIDGET_JOYSTICKBUTTON  14
#define WIDGET_SOUNDFRAME      15
#define WIDGET_SOUND_SLIDER    16

#define WIDGET_MAIN_MENU       20
#define WIDGET_KEYBOARD_MENU   21
#define WIDGET_SOUND_MENU      22

#define WIDGETFLAG_COMMON 0x00010000  // not unique

#define KEYBOARD_FUNCTION_SAVE     0
#define KEYBOARD_FUNCTION_DEFAULT  1
#define KEYBOARD_FUNCTION_CANCEL   2
#define KEYBOARD_FUNCTION_KEYBOARD 3
#define KEYBOARD_FUNCTION_MOUSE    4
#define KEYBOARD_FUNCTION_JOYSTICK 5

#define WIDGETTASK_CLEAR_UNIQUE   0x00000000
#define WIDGETTASK_FIND_KEYCODE   0x00010000


/* **********************************************************
********************************************************** */
class keyboard_data_type : public menu_data_type {

   public:
      int key_count, cmd_count, button_count;
      string_type *key_name;
      int *cmd;
      int *button;
      generic_widget *controller;
      
      keyboard_data_type() { key_name = NULL; cmd = button = NULL; controller = NULL; }
      virtual ~keyboard_data_type() { if (key_name) delete [] key_name; if (cmd) delete [] cmd; if (button) delete [] button; }

      int read_key_name(char *filename);
      int read_commands(char *filename, char *altname);

      int write_commands(char *filename);
};

   
/* **********************************************************
********************************************************** */
typedef struct {
   int tempi;
   generic_widget *widget;
   keyboard_data_type *data;
} perform_data_type;


/* **********************************************************
********************************************************** */
class function_button_widget : public text_button_widget {

   public:
      // generic_widget
      int  query_whatami() { return WIDGET_FUNCTION_BUTTON; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      virtual ~function_button_widget() {}
};


/* **********************************************************
********************************************************** */
class key_widget : public text_button_widget {

   public:
      // generic_widget
      int  query_whatami() { return WIDGET_KEY; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);
      void refresh();
      void perform(int task, void *data);

      void update(int new_data, keyboard_data_type *data);
      
      virtual ~key_widget() {}
};


/* **********************************************************
********************************************************** */
class mousebutton_widget : public text_button_widget {

   public:
      // generic_widget
      int  query_whatami() { return WIDGET_MOUSEBUTTON; }
      int  query_whatwasi(int type);
      void preprocess(void *data);
      
      void update(int new_data, keyboard_data_type *data);

      virtual ~mousebutton_widget() {}   
};


/* **********************************************************
********************************************************** */
class joystickbutton_widget : public mousebutton_widget {

   public:
      // generic_widget
      int  query_whatami() { return WIDGET_JOYSTICKBUTTON; }
      int  query_whatwasi(int type);

      virtual ~joystickbutton_widget() {}   
};


/* **********************************************************
********************************************************** */
class keyframe_widget : public frame_widget {

   public:
      int  query_whatami() { return WIDGET_KEYFRAME; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      
      virtual ~keyframe_widget() {}
};


/* **********************************************************
********************************************************** */
class soundframe_widget : public frame_widget {

   public:
      int  query_whatami() { return WIDGET_SOUNDFRAME; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);

      virtual ~soundframe_widget() {}
};


/* **********************************************************
********************************************************** */
class sound_slider_widget : public hslider_widget {

   public:
      int  query_whatami() { return WIDGET_SOUND_SLIDER; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      void set_value(float v);

      virtual ~sound_slider_widget() {}
};


/* **********************************************************
********************************************************** */
class keyboard_menu_widget : public keyframe_widget {

   public:
      int query_whatami() { return WIDGET_KEYBOARD_MENU; }
      int query_whatwasi(int type);
      int read_keyboard_menu(char *filename, char *ioname, string_type *backname, keyboard_data_type *string_data);

      virtual ~keyboard_menu_widget() {}
};


/* **********************************************************
********************************************************** */
class sound_menu_widget : public frame_widget {

   public:
      int query_whatami() { return WIDGET_SOUND_MENU; }
      int query_whatwasi(int type);
      int parse(FILE *infile, char *token);

      int read_sound_menu(char *filename, menu_data_type *string_data);

      virtual ~sound_menu_widget() {}
};


/* **********************************************************
********************************************************** */
class main_menu_widget : public frame_widget {

   public:
      int query_whatami() { return WIDGET_MAIN_MENU; }
      int query_whatwasi(int type);
      int read_main_menu(char *filename, string_type *backname, menu_data_type *string_data);

      virtual ~main_menu_widget() {}
};


#endif
