

#include <stdlib.h>
#include <string.h>

#include "pstring.h"

#include "gamegine.h"

#include "darkmenu.h"


/* **********************************************************
********************************************************** */
int keyboard_data_type::read_key_name(char *filename) {

   FILE *infile;
   int i;
   char token[MAXSTRLEN];

   if (!find_file(filename, "r", NULL, PLATFORM_SLASH, NULL, &infile))
      return 0;

   // read in key count      
   get_token(infile, token);
   key_count = atoi(token);

   if (key_name)
      delete [] key_name;
      
   key_name  = new string_type[key_count];

   // read in key function names   
   for (i=0; i<key_count; i++) {
      get_token(infile, token);
      key_name[i].stringcpy(token);
   }
      
   fclose(infile);
   return 1;
}

      
/* **********************************************************
********************************************************** */
int keyboard_data_type::read_commands(char *filename, char *altname) {

   FILE *infile;
   int i;
   char token[MAXSTRLEN];
   
   if (!(filename && find_file(filename, "r", NULL, PLATFORM_SLASH, NULL, &infile)))
      if (!find_file(altname, "r", NULL, PLATFORM_SLASH, NULL, &infile))
         return 0;

   // read in key count      
   get_token(infile, token);
   cmd_count = atoi(token);
   
   if (cmd)
      delete [] cmd;
      
   cmd = new int[cmd_count];

   // read in commands   
   for (i=0; i<cmd_count; i++) {
      get_token(infile, token);
      cmd[i] = atoi(token);
   }
      
   // read in button count      
   get_token(infile, token);
   button_count = atoi(token);
   
   if (button)
      delete [] button;
      
   button = new int[button_count];

   // read in buttons   
   for (i=0; i<button_count; i++) {
      get_token(infile, token);
      button[i] = atoi(token);
   }
      
   fclose(infile);
   return 1;
}


/* **********************************************************
********************************************************** */
int keyboard_data_type::write_commands(char *filename) {

   FILE *outfile;
   int i;

   outfile = fopen(filename, "w");
   
   if (!outfile)
      return 0;

   // write command count      
   fprintf(outfile, "%d\n\n", cmd_count);

   // write commands   
   for (i=0; i<cmd_count; i++)
      fprintf(outfile, "%d\n", cmd[i]);
      
   // write button count      
   fprintf(outfile, "\n%d\n\n", button_count);
   
   // write buttons   
   for (i=0; i<button_count; i++)
      fprintf(outfile, "%d\n", button[i]);
      
   fclose(outfile);
   return 1;
}


/* **********************************************************
********************************************************** */
int function_button_widget::query_whatwasi(int type) {

   if (type == function_button_widget::query_whatami())
      return 1;
      
   return text_button_widget::query_whatwasi(type);
}


/* **********************************************************
********************************************************** */
void function_button_widget::preprocess(void *data) {

   text_button_widget::preprocess(data);

   switch (action_code) {
   
      case KEYBOARD_FUNCTION_KEYBOARD:
         if (CONTROLLER == CONTROLKEYBOARD) {
            flags |= WIDGETFLAG_SELECTED;
            refresh();
            ((keyboard_data_type *)data)->controller = this;
         }
	 
         break;
	 
      case KEYBOARD_FUNCTION_MOUSE:
         if (CONTROLLER == CONTROLMOUSE) {
            flags |= WIDGETFLAG_SELECTED;
            refresh();
            ((keyboard_data_type *)data)->controller = this;
         }
	 
         break;
	 
      case KEYBOARD_FUNCTION_JOYSTICK:
         if (CONTROLLER == CONTROLJOYSTICK) {
            flags |= WIDGETFLAG_SELECTED;
            refresh();
            ((keyboard_data_type *)data)->controller = this;
         }
	 
         break;
	 
      default:
         break;
   }

}


/* **********************************************************
********************************************************** */
int key_widget::query_whatwasi(int type) {

   return (type == key_widget::query_whatami()) ? 1 : text_button_widget::query_whatwasi(type);
}


/* **********************************************************
********************************************************** */
int key_widget::parse(FILE *infile, char *token) {

   return text_button_widget::parse(infile, token);
}


/* **********************************************************
********************************************************** */
void key_widget::preprocess(void *data) {

   text_button_widget::preprocess(data);

   if (action_code < ((keyboard_data_type *)data)->cmd_count && ((keyboard_data_type *)data)->cmd[action_code] != 255)
      ((text_widget *)children.head)->text.stringcpy(&((keyboard_data_type *)data)->key_name[((keyboard_data_type *)data)->cmd[action_code]]);
   else
      ((text_widget *)children.head)->text.stringcpy("N/A");
}


/* **********************************************************
********************************************************** */
void key_widget::refresh() {

   if (flags & WIDGETFLAG_COMMON) {
      if (flags & WIDGETFLAG_SELECTED) {
         copyarray4(current_color, select_color);
      }
   
      else if (flags & WIDGETFLAG_HIGHLIGHT) {
         copyarray4(current_color, highlight_color);
      }
   
      copyarray4(backup_color, current_color);
      copyarray4(((text_widget *)children.head)->foreground_color, backup_color);
      cycle_timer = 0;

      generic_widget::refresh();  
      return; 
   }
   
   text_button_widget::refresh();   
}


/* **********************************************************
********************************************************** */
void key_widget::update(int new_data, keyboard_data_type *data) {

   if (action_code < ((keyboard_data_type *)data)->cmd_count) {
      ((keyboard_data_type *)data)->cmd[action_code] = new_data;

      if (new_data != 255)
         ((text_widget *)children.head)->text.stringcpy(&((keyboard_data_type *)data)->key_name[new_data]);
      else
         ((text_widget *)children.head)->text.stringcpy("N/A");
   }

}


/* **********************************************************
********************************************************** */
void key_widget::perform(int task, void *data) {

   generic_widget *ptr;
   keyboard_data_type *sdata;
   
   switch (task) {

      case WIDGETTASK_CLEAR_UNIQUE:
         ptr = (generic_widget *)((perform_data_type *)data)->widget;
         sdata = (keyboard_data_type *)((perform_data_type *)data)->data;
	 
         if (this != ptr && ptr->query_whatwasi(WIDGET_KEY) &&
             action_code < sdata->cmd_count &&
             sdata->cmd[action_code] ==  sdata->cmd[((key_widget *)ptr)->action_code])

            update(255, sdata);
	 
         break;
	 
      case WIDGETTASK_FIND_KEYCODE:
   
         if (((perform_data_type *)data)->widget)
            return;
	    
         if (((perform_data_type *)data)->tempi == action_code) {
            ((perform_data_type *)data)->widget = this;
            return;
         }
	 
         break;
	 
      default:
         break;
   }
   
   generic_widget::perform(task, data);
}


/* **********************************************************
********************************************************** */
int mousebutton_widget::query_whatwasi(int type) {

   return (type == mousebutton_widget::query_whatami()) ? 1 : text_button_widget::query_whatwasi(type);
}


/* **********************************************************
********************************************************** */
void mousebutton_widget::preprocess(void *data) {

   perform_data_type work;

   text_button_widget::preprocess(data);

   work.widget = NULL;
   if (action_code < ((keyboard_data_type *)data)->button_count && ((keyboard_data_type *)data)->button[action_code] != 255) {
      work.tempi = ((keyboard_data_type *)data)->button[action_code];
      ((menu_data_type *)data)->main_widget->perform(WIDGETTASK_FIND_KEYCODE, &work);
   }

   if (work.widget) {
      ((text_widget *)children.head)->string_code = ((key_widget *)work.widget)->string_code;
      ((text_widget *)children.head)->text.stringcpy(&((menu_data_type *)data)->text_palette[((key_widget *)work.widget)->string_code]);
   }

   else
      ((text_widget *)children.head)->text.stringcpy("N/A");
}


/* **********************************************************
********************************************************** */
void mousebutton_widget::update(int new_data, keyboard_data_type *data) {

   perform_data_type work;

   ((keyboard_data_type *)data)->button[action_code] = new_data;

   work.widget = NULL;
   work.tempi = new_data;
   ((menu_data_type *)data)->main_widget->perform(WIDGETTASK_FIND_KEYCODE, &work);

   ((text_widget *)children.head)->string_code = ((key_widget *)work.widget)->string_code;
   ((text_widget *)children.head)->text.stringcpy(&((menu_data_type *)data)->text_palette[((key_widget *)work.widget)->string_code]);
}


/* **********************************************************
********************************************************** */
int joystickbutton_widget::query_whatwasi(int type) {

   return (type == joystickbutton_widget::query_whatami()) ? 1 : mousebutton_widget::query_whatwasi(type);
}


/* **********************************************************
********************************************************** */
int keyframe_widget::query_whatwasi(int type) {

   return (type == keyframe_widget::query_whatami()) ? 1 : frame_widget::query_whatwasi(type);
}


/* **********************************************************
********************************************************** */
int keyframe_widget::parse(FILE *infile, char *token) {

   generic_widget *ptr;

   if (!strcmp(token, "button")) {

      children.insert(ptr = new function_button_widget, NULL);
      ptr->parent = this;
      
      get_token(infile, token);  // '{'

      while (get_token(infile, token) && token[0] != '}') {

         lower_case(token);
         if (!ptr->parse(infile, token))
            return 0;
      }
	 
      return 1;
   }
      
   if (!strcmp(token, "keybutton")) {

      children.insert(ptr = new key_widget, NULL);
      ptr->parent = this;
      
      get_token(infile, token);  // '{'

      while (get_token(infile, token) && token[0] != '}') {
	    
         lower_case(token);

         if (!ptr->parse(infile, token))
            return 0;
      }
	 
      return 1;
   }
      
   if (!strcmp(token, "mousebutton")) {
      children.insert(ptr = new mousebutton_widget, NULL);
      ptr->parent = this;
      
      get_token(infile, token);  // '{'

      while (get_token(infile, token) && token[0] != '}') {
	    
         lower_case(token);
         if (!ptr->parse(infile, token))
            return 0;
      }
	 
      return 1;
   }
      
   if (!strcmp(token, "joybutton")) {
      children.insert(ptr = new joystickbutton_widget, NULL);
      ptr->parent = this;
      
      get_token(infile, token);  // '{'

      while (get_token(infile, token) && token[0] != '}') {
	    
         lower_case(token);
         if (!ptr->parse(infile, token))
            return 0;
      }
	 
      return 1;
   }

   if (!strcmp(token, "frame")) {
      children.insert(ptr = new keyframe_widget, NULL);
      ptr->parent = this;
      
      get_token(infile, token);  // '{'

      while (get_token(infile, token) && token[0] != '}') {
	    
         lower_case(token);
         if (!ptr->parse(infile, token))
            return 0;
      }
	 
      return 1;
   }

   return frame_widget::parse(infile, token);
}


/* **********************************************************
********************************************************** */
int keyboard_menu_widget::query_whatwasi(int type) {

   if (type == keyboard_menu_widget::query_whatami())
      return 1;
      
   return frame_widget::query_whatwasi(type);
}


/* **********************************************************
********************************************************** */
int keyboard_menu_widget::read_keyboard_menu(char *filename, char *ioname, string_type *backname, keyboard_data_type *string_data) {

   FILE *infile;
   char token[MAXSTRLEN];
   
   x[0] = 0;
   x[1] = (int)MAX_WIN_WIDTH;
   y[0] = 0;
   y[1] = (int)MAX_WIN_HEIGHT;

   string_data->read_commands(ioname, FILENAME_DEFAULT_COMMANDS);

   if (!find_file(filename, "r", NULL, PLATFORM_SLASH, NULL, &infile))
      return 0;
   
   if (get_token(infile, token) && backname)
      backname->stringcpy(token);

   string_data->read_menu_text(infile);
   
   // read in widgets
   children.dest();
   
   while (get_token(infile, token)) {
   
      lower_case(token);
      
      if (!keyframe_widget::parse(infile, token)) {
         sprintf(perror_buffer, "Error: Invalid token \"%s\"... Aborting...", token);
         pprintf(perror_buffer);
         fclose(infile);
         return 0;
      }
    
   }

   fclose(infile);

   string_data->main_widget = this;
   preprocess(string_data);
   return 1;
}


/* **********************************************************
********************************************************** */
int main_menu_widget::query_whatwasi(int type) {

   return (type == main_menu_widget::query_whatami()) ? 1 : frame_widget::query_whatwasi(type);
}


/* **********************************************************
********************************************************** */
int main_menu_widget::read_main_menu(char *filename, string_type *backname, menu_data_type *string_data) {

   FILE *infile;
   char token[MAXSTRLEN];
   
   x[0] = 0;
   x[1] = (int)MAX_WIN_WIDTH;
   y[0] = 0;
   y[1] = (int)MAX_WIN_HEIGHT;

   if (!find_file(filename, "r", NULL, PLATFORM_SLASH, NULL, &infile))
      return 0;
   
   if (get_token(infile, token) && backname)
      backname->stringcpy(token);

   string_data->read_menu_text(infile);
   
   // read in widgets
   children.dest();
   
   while (get_token(infile, token)) {
   
      lower_case(token);
      
      if (!frame_widget::parse(infile, token)) {
         sprintf(perror_buffer, "Error: Invalid token \"%s\"... Aborting...", token);
         pprintf(perror_buffer);
         fclose(infile);
         return 0;
      }
    
   }

   fclose(infile);

   string_data->main_widget = this;
   preprocess(string_data);
   return 1;
}


/* **********************************************************
********************************************************** */
int soundframe_widget::query_whatwasi(int type) {

   return (type == soundframe_widget::query_whatami()) ? 1 : frame_widget::query_whatwasi(type);
}


/* **********************************************************
********************************************************** */
int soundframe_widget::parse(FILE *infile, char *token) {

   generic_widget *ptr;

   if (!strcmp(token, "frame")) {
      children.insert(ptr = new soundframe_widget, NULL);
      ptr->parent = this;
      
      get_token(infile, token);  // '{'

      while (get_token(infile, token) && token[0] != '}') {
	    
         lower_case(token);
         if (!ptr->parse(infile, token))
            return 0;
      }
	 
      return 1;
   }

   if (!strcmp(token, "sound_slider")) {
      children.insert(ptr = new sound_slider_widget, NULL);
      ptr->parent = this;
      
      get_token(infile, token);  // '{'

      while (get_token(infile, token) && token[0] != '}') {
	    
         lower_case(token);
         if (!ptr->parse(infile, token))
            return 0;
      }
	 
      return 1;
   }

   return frame_widget::parse(infile, token);
}


/* **********************************************************
********************************************************** */
int sound_slider_widget::query_whatwasi(int type) {

   return (type == sound_slider_widget::query_whatami()) ? 1 : hslider_widget::query_whatwasi(type);
}


/* **********************************************************
  *value set in parent widget
********************************************************** */
void sound_slider_widget::preprocess(void *data) {

   value = 0.01f * complex->soundmanager->volume[id];
   value = (float)((pow(10, value)-1.0)/9.0);

   hslider_widget::preprocess(data);
}


/* **********************************************************
  *value set in parent widget
********************************************************** */
void sound_slider_widget::set_value(float v) {

   complex->soundmanager->volume[id] = (int)(100.0*log10(v*9.0 + 1.0));

   hslider_widget::set_value(v);
}


/* **********************************************************
********************************************************** */
int sound_menu_widget::query_whatwasi(int type) {

   return (type == sound_menu_widget::query_whatami()) ? 1 : frame_widget::query_whatwasi(type);
}


/* **********************************************************
********************************************************** */
int sound_menu_widget::parse(FILE *infile, char *token) {

   generic_widget *ptr;

   if (!strcmp(token, "frame")) {

      children.insert(ptr = new soundframe_widget, NULL);
      ptr->parent = this;
      
      get_token(infile, token);  // '{'

      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         if (!ptr->parse(infile, token))
            return 0;
      }
	 
      return 1;
   }
      
   return frame_widget::parse(infile, token);
}


/* **********************************************************
********************************************************** */
int sound_menu_widget::read_sound_menu(char *filename, menu_data_type *string_data) {

   FILE *infile;
   char token[MAXSTRLEN];
   
   x[0] = 0;
   x[1] = (int)MAX_WIN_WIDTH;
   y[0] = 0;
   y[1] = (int)MAX_WIN_HEIGHT;

   if (!find_file(filename, "r", NULL, PLATFORM_SLASH, NULL, &infile))
      return 0;
   
   string_data->read_menu_text(infile);
   
   // read in widgets
   children.dest();
   
   while (get_token(infile, token)) {
   
      lower_case(token);
      
      if (!parse(infile, token)) {
         sprintf(perror_buffer, "Error: Invalid token \"%s\"... Aborting...", token);
         pprintf(perror_buffer);
         fclose(infile);
         return 0;
      }
    
   }

   fclose(infile);

   string_data->main_widget = this;
   preprocess(string_data);
   return 1;
}

