

#if !defined __DARKMAN_H
#define __DARKMAN_H

#include "simman.h"
#include "soundman.h"

#include "darkqurk.h"

// info
#define DARKSIM_NAME           0x00000001
#define DARKSIM_WING_COMMANDER 0x00000002
#define DARKSIM_ACCEL          0x00000003
#define DARKSIM_MAXSPEED       0x00000004
#define DARKSIM_DEULER         0x00000005

// tasks
#define DARKSIM_MUSIC          0x00000100
#define DARKSIM_ESCORT         0x00000200
#define DARKSIM_JUMP           0x00000300
#define DARKSIM_GOTO           0x00000400
#define DARKSIM_WAIT           0x00000500
#define DARKSIM_SLEEP          0x00000600
#define DARKSIM_WAKEUP         0x00000700
#define DARKSIM_WIN            0x00000800
#define DARKSIM_FAIL           0x00000900
#define DARKSIM_ATTACK         0x00000a00
#define DARKSIM_SPEECH         0x00000b00
#define DARKSIM_DYNAMIC_ATTACK 0x00000c00
#define DARKSIM_DYNAMIC_ESCORT 0x00000d00

// events
#define DARKSIM_DEATH          0x00001000

// sim-objects
#define DARKSIM_SIM              0x01
#define DARKSIM_SIDE             0x02

#define DARKSIM_ENTITY           0x11
#define DARKSIM_PLAYER           0x12
#define DARKSIM_PLATFORM         0x13
#define DARKSIM_FIGHTER          0x14
#define DARKSIM_STRATEGIC_TARGET 0x15

// priority flags
#define FLAG_PRIORITY_NULL           0x00
#define FLAG_PRIORITY_MUSIC          0x01
#define FLAG_PRIORITY_ESCORT         0x0a
#define FLAG_PRIORITY_JUMP           0x02
#define FLAG_PRIORITY_GOTO           0x03
#define FLAG_PRIORITY_WAIT           0x02
#define FLAG_PRIORITY_SLEEP          0x02
#define FLAG_PRIORITY_WAKEUP         0x02
#define FLAG_PRIORITY_WIN            0x02
#define FLAG_PRIORITY_FAIL           0x02
#define FLAG_PRIORITY_ATTACK         0x04
#define FLAG_PRIORITY_SPEECH         0x01
#define FLAG_PRIORITY_DYNAMIC_ATTACK 0x14
#define FLAG_PRIORITY_DYNAMIC_ESCORT 0x1a

#define TASK_ORDERS_LOCATION     0x00010000
#define TASK_ORDERS_TARGET       0x00020000

#define DARKSIM_FLAG_JUMP        0x00010000
#define DARKSIM_FLAG_SUCCESS     0x00020000

#define DARKSIM_INFOFLAG_WINGMAN        0x00010000
#define DARKSIM_INFOFLAG_WING_COMMANDER 0x00020000
#define DARKSIM_INFOFLAG_TARGET_NAME    0x00030000

#define DARKSIM_TRIGGER_FLAG_SUCCESS    0x00
#define DARKSIM_TRIGGER_FLAG_FAILURE    0x01
#define DARKSIM_TRIGGER_FLAG_POPULATION 0x02
#define DARKSIM_TRIGGER_FLAG_TASK       0x04
#define DARKSIM_TRIGGER_FLAG_EVENT      0x08


class sim_sim;
class sim_side;
class sim_platform;


/* **********************************************************************
********************************************************************** */
typedef struct {

   sim_infobyte_type *order;
   int type;
} comm_order_type;

   
/* **********************************************************************
********************************************************************** */
class hit_type : public dbl_llist {

   public:
      gameatom *target;
      int amount;
      int max_amount;
      
      hit_type() { amount = max_amount = 0; target = NULL; }
      virtual ~hit_type() {}
};


/* **********************************************************************
********************************************************************** */
class trigger_type : public dbl_llist {

   public:
      int type;

      // wait for an event to happen or task to finish      
      string_type trigger_name;
      sim_infobyte_type *trigger;
      int trigger_id;

      // population count
      string_type pop_name;
      int pop_op;
      float pop_amount;
      sim_side *population;

      trigger_type();
      virtual ~trigger_type() {}

      int parse(FILE *infile, char *token);
      void preprocess(void *data);

      int evaluate();
};


/* **********************************************************************
********************************************************************** */
class jukebox_manager : public dbl_llist_manager {

   public:
      virtual ~jukebox_manager() {}
      
      dbl_llist *get();
};


/* *************************************************************
************************************************************* */
class sim_name_type : public sim_infobyte_type {

   public:
      // sim_infobyte_type
      int query_whatami()  { return DARKSIM_NAME; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data);

      // sim_name_type
      string_type name;

      virtual ~sim_name_type() {}
};


/* *************************************************************
************************************************************* */
class sim_wing_commander_type : public sim_infobyte_type {

   protected:
      // sim_wing_commander_type
      dbl_llist_manager wing_manager;

   public:
      // sim_infobyte_type
      int query_whatami()  { return DARKSIM_WING_COMMANDER; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data);

      virtual ~sim_wing_commander_type() {}
};


/* *************************************************************
************************************************************* */
class sim_accel_type : public sim_infobyte_type {

   protected:
      float accel;
      

   public:
      // sim_infobyte_type
      int query_whatami()  { return DARKSIM_ACCEL; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data);

      // sim_accel_type
      sim_accel_type() { accel = 0; }
      virtual ~sim_accel_type() {}
};


/* *************************************************************
************************************************************* */
class sim_maxspeed_type : public sim_infobyte_type {

   protected:
      float maxspeed;
      
   public:
      // sim_infobyte_type
      int query_whatami()  { return DARKSIM_MAXSPEED; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data);

      // sim_maxspeed_type
      sim_maxspeed_type() { maxspeed = 0; }
      virtual ~sim_maxspeed_type() {}
};


/* *************************************************************
************************************************************* */
class sim_deuler_type : public sim_infobyte_type {

   protected:
      float dorient;
      
   public:
      // sim_infobyte_type
      int query_whatami()  { return DARKSIM_DEULER; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data);

      // sim_deuler_type
      sim_deuler_type() { dorient = 0; }
      virtual ~sim_deuler_type() {}
};


/* *************************************************************
************************************************************* */
class sim_music_type : public sim_task_type {

   protected:
      jukebox_manager jukebox;
      sound_type *sndfx;
      sound_id_type *sndid;

   public:
      // sim_infobyte_type
      int query_whatami()  { return DARKSIM_MUSIC; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data);
      int update();

      // task
      int query_priority() { return FLAG_PRIORITY_MUSIC; }
      void get_status(string_type *token);

      // sim_music_type
      sim_music_type() { sndfx = NULL; sndid = NULL; }
      virtual ~sim_music_type();
};


/* *************************************************************
************************************************************* */
class sim_escort_type : public sim_task_type {

   protected:
      string_type target_name;

   public:
      // sim_infobyte_type
      int query_whatami()  { return DARKSIM_ESCORT; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data);
      int update();
      int query_specific_data(int type, void *data);
      int set_specific_data(int type, void *data);

      // task
      int query_priority() { return FLAG_PRIORITY_ESCORT; }
      void get_status(string_type *token);

      // sim_escort_type
      float range2;
      sim_platform *target;

      sim_escort_type() { target = NULL; range2 = 0; }
      virtual ~sim_escort_type() {}
};


/* *************************************************************
************************************************************* */
class sim_jump_type : public sim_task_type {

   public:
      // sim_infobyte_type
      int query_whatami()  { return DARKSIM_JUMP; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data);
      int update();

      // task
      int query_priority() { return FLAG_PRIORITY_JUMP; }
      void get_status(string_type *token);

      // sim_jump_type
      virtual ~sim_jump_type() {}
};


/* *************************************************************
************************************************************* */
class sim_goto_type : public sim_task_type {

   protected:
      vector3f dest;
      float range2;

   public:
      // sim_infobyte_type
      int query_whatami()  { return DARKSIM_GOTO; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data);
      int update();
      int query_specific_data(int type, void *data);

      // task
      int query_priority() { return FLAG_PRIORITY_GOTO; }
      void get_status(string_type *token);

      // sim_goto_type
      sim_goto_type() { dest[0] = dest[1] = dest[2] = 0; range2 = 0; }
      virtual ~sim_goto_type() {}
};


/* *************************************************************
************************************************************* */
class sim_wait_type : public sim_task_type {

   protected:
      dbl_llist_manager sleep_script_manager[SIM_MANAGER_MAX];
      trigger_type trigger;

   public:
      // sim_infobyte_type
      int query_whatami()  { return DARKSIM_WAIT; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data);
      sim_infobyte_type *find_subinfobyte(int type, int id);
      int update();

      // task
      int query_priority() { return FLAG_PRIORITY_WAIT; }
      void get_status(string_type *token);

      virtual ~sim_wait_type() {}
};


/* *************************************************************
************************************************************* */
class sim_sleep_type : public sim_task_type {

   public:
      // sim_infobyte_type
      int query_whatami()  { return DARKSIM_SLEEP; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data);
      int update();

      // task
      int query_priority() { return FLAG_PRIORITY_SLEEP; }
      void get_status(string_type *token);

      // sim_sleep_type
      virtual ~sim_sleep_type() {}
};


/* *************************************************************
************************************************************* */
class sim_wakeup_type : public sim_task_type {

   public:
      // sim_infobyte_type
      int query_whatami()  { return DARKSIM_WAKEUP; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data);
      int update();

      // task
      int query_priority() { return FLAG_PRIORITY_WAKEUP; }
      void get_status(string_type *token);

      // sim_wakeup_type
      virtual ~sim_wakeup_type() {}
};


/* *************************************************************
************************************************************* */
class sim_win_type : public sim_task_type {

   protected:
      dbl_llist_manager trigger_manager;

   public:
      // sim_infobyte_type
      int query_whatami()  { return DARKSIM_WIN; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data);
      int update();

      // task
      int query_priority() { return FLAG_PRIORITY_WIN; }
      void get_status(string_type *token);

      // sim_win_type
      virtual ~sim_win_type() {}
};


/* *************************************************************
************************************************************* */
class sim_fail_type : public sim_task_type {

   protected:
      dbl_llist_manager trigger_manager;

   public:
      // sim_infobyte_type
      int query_whatami()  { return DARKSIM_FAIL; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data);
      int update();

      // task
      int query_priority() { return FLAG_PRIORITY_FAIL; }
      void get_status(string_type *token);

      // sim_fail_type
      virtual ~sim_fail_type() {}
};


/* *************************************************************
************************************************************* */
class sim_attack_type : public sim_task_type {

   protected:
      string_type target_name;

   public:
      // sim_infobyte_type
      int query_whatami()  { return DARKSIM_ATTACK; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data);
      int update();
      int query_specific_data(int type, void *data);
      int set_specific_data(int type, void *data);

      // task
      int query_priority() { return FLAG_PRIORITY_ATTACK; }
      void get_status(string_type *token);

      // sim_attack_type
      sim_object *target;

      sim_attack_type() { target = NULL; }
      virtual ~sim_attack_type() {}
};


/* *************************************************************
************************************************************* */
class sim_speech_type : public sim_task_type {

   protected:
      sound_id_type sound_id;
      sound_type *sndfx;
      sfile speech;
      string_type speech_name;

   public:
      // sim_infobyte_type
      int query_whatami()  { return DARKSIM_SPEECH; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data);
      int update();
      void render2d(mapul *mapbuffer);

      // task
      int query_priority() { return FLAG_PRIORITY_SPEECH; }
      void get_status(string_type *token);

      // sim_speech_type
      sim_speech_type() { sndfx = NULL; }
      virtual ~sim_speech_type();
};


/* *************************************************************
************************************************************* */
class sim_dynamic_attack_type : public sim_attack_type {

   protected:
      sim_object *source;

   public:
      // sim_infobyte_type
      int query_whatami()  { return DARKSIM_DYNAMIC_ATTACK; }
      int query_specific_data(int type, void *data);
      int set_specific_data(int type, void *data);

      // task
      int query_priority() { return FLAG_PRIORITY_DYNAMIC_ATTACK; }

      // sim_dynamic_attack_type
      virtual ~sim_dynamic_attack_type() {}
};


/* *************************************************************
************************************************************* */
class sim_dynamic_escort_type : public sim_escort_type {

   protected:
      sim_object *source;

   public:
      // sim_infobyte_type
      int query_whatami()  { return DARKSIM_DYNAMIC_ESCORT; }
      int query_specific_data(int type, void *data);
      int set_specific_data(int type, void *data);

      // task
      int query_priority() { return FLAG_PRIORITY_DYNAMIC_ESCORT; }

      // sim_dynamic_escort_type
      virtual ~sim_dynamic_escort_type() {}
};


/* *************************************************************
************************************************************* */
class sim_death_type : public sim_event_type {

   protected:
      string_type target_name;
      sim_object *target;

   public:
      // sim_infobyte_type
      int query_whatami()  { return DARKSIM_DEATH; }
      
      int parse(FILE *infile, char *token);
      void preprocess(void *data);
      int update();

      // sim_death_type
      sim_death_type() { target = NULL; }
      virtual ~sim_death_type() {}
};


/* *************************************************************
************************************************************* */
class sim_sim : public sim_object {

   public:
      // sim_object
      int query_whatami()  { return DARKSIM_SIM; }
      int query_whatwasi(int type);
      int parse(FILE *infile, char *token);
      void preprocess(void *data);
      void process_ai();
      void render2d(mapul *mapbuffer);

      sim_infobyte_type *process_info(FILE *infile, char *token);
      sim_infobyte_type *process_task(FILE *infile, char *token);
      sim_infobyte_type *process_event(FILE *infile, char *token);

      // sim_sim
      dbl_llist_manager side_manager;
      dbl_llist_manager player_hit_manager;
      
      int player_enemy_fighter_count;
      int player_enemy_cap_count;
      int player_enemy_fighter_kill_count;
      int player_enemy_cap_kill_count;
      int player_assist_enemy_fighter_kill_count;
      int player_assist_enemy_cap_kill_count;
      int player_ally_fighter_count;
      int player_ally_cap_count;
      int player_ally_fighter_kill_count;
      int player_ally_cap_kill_count;
      int player_assist_ally_fighter_kill_count;
      int player_assist_ally_cap_kill_count;
      int player_primary_hit_count;
      int player_primary_fire_count;
      int player_secondary_hit_count;
      int player_secondary_fire_count;
      
      sim_sim();
      virtual ~sim_sim() {}
      sim_object *find_ob(char *name);
};


/* *************************************************************
************************************************************* */
class sim_side : public sim_object {

   public:
      // sim_object
      int query_whatami()  { return DARKSIM_SIDE; }
      int query_whatwasi(int type);
      int parse(FILE *infile, char *token);
      void preprocess(void *data);
      void process_ai();
      void render2d(mapul *mapbuffer);

      sim_infobyte_type *process_info(FILE *infile, char *token);
      sim_infobyte_type *process_task(FILE *infile, char *token);
      sim_infobyte_type *process_event(FILE *infile, char *token);

      // sim_side
      string_type name;
      dbl_llist_manager entity_manager, dead_manager;
      
      virtual ~sim_side() {}
      sim_object *find_ob(char *name);
};


/* *************************************************************
************************************************************* */
class sim_entity : public sim_object {

   public:
      // sim_object
      int  query_whatami()  { return DARKSIM_ENTITY; }
      int  query_whatwasi(int type);

      virtual ~sim_entity() {}
};


/* *************************************************************
************************************************************* */
class sim_player : public sim_entity {

   protected:
      dbl_llist_manager wing_manager;
      sim_object *wc;
      
   public:
      // sim_object
      int  query_whatami()  { return DARKSIM_PLAYER; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);
      int  set_specific_data(int type, void *data);
      void process_ai();

      sim_infobyte_type *process_info(FILE *infile, char *token);
      sim_infobyte_type *process_task(FILE *infile, char *token);
      sim_infobyte_type *process_event(FILE *infile, char *token);

      sim_player() { wc = NULL; }
      virtual ~sim_player() {}
};


/* *************************************************************
************************************************************* */
class sim_platform : public sim_entity {

   public:
      // sim_object
      int  query_whatami()  { return DARKSIM_PLATFORM; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);

      sim_infobyte_type *process_info(FILE *infile, char *token);
      sim_infobyte_type *process_task(FILE *infile, char *token);
      sim_infobyte_type *process_event(FILE *infile, char *token);

      // sim_platform
      virtual ~sim_platform() {}
      sim_object *find_ob(char *name);
};


/* *************************************************************
************************************************************* */
class sim_fighter : public sim_platform {

   protected:
      dbl_llist_manager wing_manager;
      sim_object *wc;
      
   public:
      // sim_object
      int  query_whatami()  { return DARKSIM_FIGHTER; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);
      int  set_specific_data(int type, void *data);
      void process_ai();

      sim_infobyte_type *process_info(FILE *infile, char *token);
      sim_infobyte_type *process_task(FILE *infile, char *token);
      sim_infobyte_type *process_event(FILE *infile, char *token);

      // sim_fighter
      sim_fighter() { wc = NULL; }
      virtual ~sim_fighter() {}
};


/* *************************************************************
************************************************************* */
class sim_strategic_target : public sim_platform {

   public:
      // sim_object
      int  query_whatami()  { return DARKSIM_STRATEGIC_TARGET; }
      int  query_whatwasi(int type);
      int  parse(FILE *infile, char *token);
      void preprocess(void *data);

      sim_infobyte_type *process_info(FILE *infile, char *token);
      sim_infobyte_type *process_task(FILE *infile, char *token);
      sim_infobyte_type *process_event(FILE *infile, char *token);

      // sim_strategic_target
      virtual ~sim_strategic_target() {}
};

int ai_identify_threat(dbl_llist_manager *threat_list, target_type *ob, gameatom *attacker, threat_type **threat);

#endif
