

#include <stdlib.h>
#include <string.h>

#include "pstring.h"

#include "darkgine.h"
#include "fighter.h"


/* *************************************************************
************************************************************* */
sim_sim::sim_sim() {

   player_enemy_fighter_count = 0;
   player_enemy_cap_count = 0;
   player_enemy_fighter_kill_count = 0;
   player_enemy_cap_kill_count = 0;
   player_assist_enemy_fighter_kill_count = 0;
   player_assist_enemy_cap_kill_count = 0;
   player_ally_fighter_count = 0;
   player_ally_cap_count = 0;
   player_ally_fighter_kill_count = 0;
   player_ally_cap_kill_count = 0;
   player_assist_ally_fighter_kill_count = 0;
   player_assist_ally_cap_kill_count = 0;
   player_primary_hit_count = 0;
   player_primary_fire_count = 0;
   player_secondary_hit_count = 0;
   player_secondary_fire_count = 0;
}


/* *************************************************************
************************************************************* */
int sim_sim::query_whatwasi(int type) {

   return (sim_sim::query_whatami() == type) ? 1 : sim_object::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
sim_infobyte_type *sim_sim::process_info(FILE *infile, char *token) {

   return sim_object::process_info(infile, token);
}


/* *************************************************************
************************************************************* */
sim_infobyte_type *sim_sim::process_task(FILE *infile, char *token) {

   sim_infobyte_type *ptr, *qtr;

   if (!strcmp(token, TOKEN_MUSIC_STR)) {
      ptr = (sim_infobyte_type *)script_manager[SIM_MANAGER_TASK].head;

      while (ptr) {
         qtr = ptr;
         ptr = (sim_infobyte_type *)ptr->next;
         if (qtr->query_whatami() == DARKSIM_MUSIC) {
            script_manager[SIM_MANAGER_TASK].remove(qtr);
            delete qtr;
         }
	 
      }
      
      ptr = new sim_music_type;
   }
   
   else if (!strcmp(token, TOKEN_WAIT_STR))
      ptr = new sim_wait_type;

   if (ptr) {
      ptr->owner = this;
      get_token(infile, token); // '{'

      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         ptr->parse(infile, token);
      }

      return ptr;
   }

   return sim_object::process_task(infile, token);
}


/* *************************************************************
************************************************************* */
sim_infobyte_type *sim_sim::process_event(FILE *infile, char *token) {

   return sim_object::process_event(infile, token);
}


/* *************************************************************
************************************************************* */
int sim_sim::parse(FILE *infile, char *token) {

   sim_side *ptr;
   sim_infobyte_type *itr;

   if (!strcmp(token, TOKEN_TASK_STR)) {
      get_token(infile, token);
      itr = process_task(infile, token);
      if (itr) {
         script_manager[SIM_MANAGER_TASK].append(itr, NULL);
         return 1;
      }

      return 0;
   }

   if (!strcmp(token, TOKEN_INFO_STR)) {
      get_token(infile, token);
      itr = process_info(infile, token);
      if (itr) {
         script_manager[SIM_MANAGER_INFO].append(itr, NULL);
         return 1;
      }

      return 0;
   }

   side_manager.append(ptr = new sim_side, NULL);

   ptr->name.stringcpy(token);

   get_token(infile, token); // '{'

   while (get_token(infile, token) && token[0] != '}') {
      lower_case(token);
      ptr->parse(infile, token);
   }

   return 1;
// bypassed   return sim_object::parse(infile, token);
}


/* *************************************************************
   note: data == this
************************************************************* */
void sim_sim::preprocess(void *data) {

   sim_object *otr;
   sim_preprocess_type spt;

   sim_object::preprocess(data);

   spt.head = ((sim_preprocess_type *)data)->head;
   spt.parent = this;

   for (otr = (sim_object *)side_manager.head; otr; otr = (sim_object *)otr->next)
      otr->preprocess(&spt);
}


/* *************************************************************
************************************************************* */
void sim_sim::process_ai() {

   sim_object *otr;

   for (otr = (sim_object *)side_manager.head; otr; otr = (sim_object *)otr->next)
      otr->process_ai();

   sim_object::process_ai();
}

   
/* *************************************************************
************************************************************* */
sim_object *sim_sim::find_ob(char *name) {

   sim_side *str;
   sim_object *ret;

   for (str = (sim_side *)side_manager.head; str; str = (sim_side *)str->next) {
      ret = str->find_ob(name);
      if (ret)
         return ret;
   }

   return NULL;
}


/* *************************************************************
************************************************************* */
void sim_sim::render2d(mapul *mapbuffer) {

   sim_side *str;

   for (str = (sim_side *)side_manager.head; str; str = (sim_side *)str->next)
      str->render2d(mapbuffer);

   sim_object::render2d(mapbuffer);
}


/* *************************************************************
************************************************************* */
int sim_side::query_whatwasi(int type) {

   return (sim_side::query_whatami() == type) ? 1 : sim_object::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
sim_infobyte_type *sim_side::process_info(FILE *infile, char *token) {

   sim_infobyte_type *ptr = NULL;

   if (!strcmp(token, TOKEN_NAME_STR))
      ptr = new sim_name_type;

   if (ptr) {
      ptr->owner = this;
      get_token(infile, token); // '{'

      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         ptr->parse(infile, token);
      }

      return ptr;
   }

   return sim_object::process_info(infile, token);
}


/* *************************************************************
************************************************************* */
sim_infobyte_type *sim_side::process_task(FILE *infile, char *token) {

   sim_infobyte_type *ptr = NULL;

   if (!strcmp(token, TOKEN_WIN_STR))
      ptr = new sim_win_type;
   else if (!strcmp(token, TOKEN_FAIL_STR))
      ptr = new sim_fail_type;
   else if (!strcmp(token, TOKEN_WAIT_STR))
      ptr = new sim_wait_type;
   else if (!strcmp(token, TOKEN_SLEEP_STR))
      ptr = new sim_sleep_type;
   else if (!strcmp(token, TOKEN_WAKEUP_STR))
      ptr = new sim_wakeup_type;


   if (ptr) {
      ptr->owner = this;
      get_token(infile, token); // '{'

      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         ptr->parse(infile, token);
      }

      return ptr;
   }

   return sim_object::process_task(infile, token);
}


/* *************************************************************
************************************************************* */
sim_infobyte_type *sim_side::process_event(FILE *infile, char *token) {

   sim_infobyte_type *ptr = NULL;

   if (!strcmp(token, TOKEN_DEATH_STR))
      ptr = new sim_death_type;

   if (ptr) {
      ptr->owner = this;
      get_token(infile, token); // '{'

      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         ptr->parse(infile, token);
      }

      return ptr;
   }

   return sim_object::process_event(infile, token);
}


/* *************************************************************
************************************************************* */
int sim_side::parse(FILE *infile, char *token) {

   sim_object *ptr;
   
   if (!strcmp(token, TOKEN_FIGHTER_STR) || !strcmp(token, TOKEN_BOMBER_STR)) {
      entity_manager.append(ptr = new sim_fighter, NULL);
      
      get_token(infile, token); // '{'
      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         ptr->parse(infile, token);
      }
      
      return 1;  
   }
   
   if (!strcmp(token, TOKEN_CAPSHIP_STR) || !strcmp(token, TOKEN_STATION_STR)) {
      entity_manager.append(ptr = new sim_strategic_target, NULL);
      
      get_token(infile, token); // '{'
      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         ptr->parse(infile, token);
      }
      
      return 1;  
   }
   
   if (!strcmp(token, TOKEN_PLAYER_STR)) {
      entity_manager.append(ptr = new sim_player, NULL);
      
      get_token(infile, token); // '{'
      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         ptr->parse(infile, token);
      }
      
      return 1;  
   }
   
   return sim_object::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void sim_side::preprocess(void *data) {

   sim_object *ptr;
   sim_preprocess_type spt;

   sim_object::preprocess(data);

   spt.head = ((sim_preprocess_type *)data)->head;
   spt.parent = this;

   for (ptr = (sim_object *)entity_manager.head; ptr; ptr = (sim_object *)ptr->next)
      ptr->preprocess(&spt);
}


/* *************************************************************
************************************************************* */
void sim_side::process_ai() {

   sim_object *otr, *ptr;

   otr = (sim_object *)entity_manager.head;

   while (otr) {
      ptr = otr;
      otr = (sim_object *)otr->next;

      if (ptr->owner && ((gameatom *)ptr->owner->htree)->total_hp <= 0) {
         entity_manager.remove(ptr);
         dead_manager.append(ptr, NULL);
         continue;
      }

      ptr->process_ai();
   }

   sim_object::process_ai();
}

   
/* *************************************************************
************************************************************* */
sim_object *sim_side::find_ob(char *name) {

   sim_object *str;
   sim_object *ret;
   sim_infobyte_type *ptr;

   for (ptr = (sim_infobyte_type *)script_manager[SIM_MANAGER_INFO].head; ptr; ptr = (sim_infobyte_type *)ptr->next)
      if (ptr->query_whatami() == DARKSIM_NAME && !((sim_name_type *)ptr)->name.stringcmp(name))
         return this;

   for (str = (sim_object *)entity_manager.head; str; str = (sim_object *)str->next) {
      if (str->query_whatami() == DARKSIM_PLAYER && !strcmp(name, TOKEN_PLAYER_STR))
         return str;
      
      ret = ((sim_platform *)str)->find_ob(name);
      if (ret)
         return ret;
   }

   return NULL;
}


/* *************************************************************
************************************************************* */
void sim_side::render2d(mapul *mapbuffer) {

   sim_platform *str;

   for (str = (sim_platform *)entity_manager.head; str; str = (sim_platform *)str->next)
      str->render2d(mapbuffer);

   sim_object::render2d(mapbuffer);
}


/* *************************************************************
************************************************************* */
int sim_entity::query_whatwasi(int type) {

   return (sim_entity::query_whatami() == type) ? 1 : sim_object::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
int sim_player::query_whatwasi(int type) {

   return (sim_player::query_whatami() == type) ? 1 : sim_entity::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
sim_infobyte_type *sim_player::process_info(FILE *infile, char *token) {

   sim_infobyte_type *ptr = NULL;

   if (!strcmp(token, TOKEN_NAME_STR))
      ptr = new sim_name_type;
   else if (!strcmp(token, TOKEN_WING_COMMANDER_STR))
      ptr = new sim_wing_commander_type;

   if (ptr) {
      ptr->owner = this;
      get_token(infile, token); // '{'

      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         ptr->parse(infile, token);
      }

      return ptr;
   }

   return sim_object::process_info(infile, token);
}


/* *************************************************************
************************************************************* */
sim_infobyte_type *sim_player::process_task(FILE *infile, char *token) {

   sim_infobyte_type *ptr = NULL;

   if (!strcmp(token, TOKEN_ESCORT_STR))
      ptr = new sim_escort_type;
   else if (!strcmp(token, TOKEN_GOTO_STR))
      ptr = new sim_goto_type;
   else if (!strcmp(token, TOKEN_WAIT_STR))
      ptr = new sim_wait_type;
   else if (!strcmp(token, TOKEN_JUMP_STR))
      ptr = new sim_jump_type;
   else if (!strcmp(token, TOKEN_SPEECH_STR))
      ptr = new sim_speech_type;

   if (ptr) {
      ptr->owner = this;
      get_token(infile, token); // '{'

      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         ptr->parse(infile, token);
      }

      return ptr;
   }

   return sim_object::process_task(infile, token);
}


/* *************************************************************
************************************************************* */
sim_infobyte_type *sim_player::process_event(FILE *infile, char *token) {

   sim_infobyte_type *ptr = NULL;

   if (!strcmp(token, TOKEN_DEATH_STR))
      ptr = new sim_death_type;

   if (ptr) {
      ptr->owner = this;
      get_token(infile, token); // '{'

      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         ptr->parse(infile, token);
      }

      return ptr;
   }

   return sim_object::process_event(infile, token);
}


/* *************************************************************
************************************************************* */
int sim_player::parse(FILE *infile, char *token) {

   return sim_object::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void sim_player::preprocess(void *data) {

   sim_object::preprocess(data);

   if (!owner) {
      pprintf("ERROR SIM: Player undefined... Aborting\n");
      exit(0);
   }
   
}


/* *************************************************************
************************************************************* */
int sim_player::set_specific_data(int type, void *data) {

   sim_object_list *wtr;
   sim_object *dob;
   
   switch (type) { 
      case DARKSIM_INFOFLAG_WINGMAN:
         dob = (sim_object *)data;
         if (dob == (sim_object *)this)
            return 0;

         for (wtr = (sim_object_list *)wing_manager.head; wtr; wtr = (sim_object_list *)wtr->next)
            if (wtr->ob == dob)
               return 0;
	       
         wing_manager.append(wtr = new sim_object_list, NULL);
         wtr->ob = dob;
         return 1;
	 
      case DARKSIM_INFOFLAG_WING_COMMANDER:
         wc = (sim_object *)data;
         return 1;

      default:
         break;
   }
   	 
   return sim_object::set_specific_data(type, data);
}


/* *************************************************************
************************************************************* */
void sim_player::process_ai() {

   sim_object_list *otr, *ptr;
   
   otr = (sim_object_list *)wing_manager.head;
   
   while (otr) {
      ptr = otr;
      otr = (sim_object_list *)otr->next;
      
      if (!ptr->ob->owner || ((gameatom *)ptr->ob->owner->htree)->total_hp <= 0) {
         wing_manager.remove(ptr);
         delete ptr;
      }

   }
   
   if (wc &&(!wc->owner || ((gameatom *)wc->owner->htree)->total_hp <= 0)) {
      wc = this;
	 
      for (ptr = (sim_object_list *)wing_manager.head; ptr; ptr = (sim_object_list *)ptr->next)
         ptr->ob->set_specific_data(DARKSIM_INFOFLAG_WING_COMMANDER, this);
   }

   sim_object::process_ai();
}


/* *************************************************************
************************************************************* */
int sim_platform::query_whatwasi(int type) {

   return (sim_platform::query_whatami() == type) ? 1 : sim_entity::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
sim_infobyte_type *sim_platform::process_info(FILE *infile, char *token) {

   sim_infobyte_type *ptr = NULL;

   if (!strcmp(token, TOKEN_NAME_STR))
      ptr = new sim_name_type;

   if (ptr) {
      ptr->owner = this;
      get_token(infile, token); // '{'

      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         ptr->parse(infile, token);
      }

      return ptr;
   }

   return sim_object::process_info(infile, token);
}


/* *************************************************************
************************************************************* */
sim_infobyte_type *sim_platform::process_task(FILE *infile, char *token) {

   sim_infobyte_type *ptr = NULL;

   if (!strcmp(token, TOKEN_GOTO_STR))
      ptr = new sim_goto_type;
   else if (!strcmp(token, TOKEN_ESCORT_STR))
      ptr = new sim_escort_type;
   else if (!strcmp(token, TOKEN_JUMP_STR))
      ptr = new sim_jump_type;
   else if (!strcmp(token, TOKEN_WAIT_STR))
      ptr = new sim_wait_type;
   else if (!strcmp(token, TOKEN_SLEEP_STR))
      ptr = new sim_sleep_type;
   else if (!strcmp(token, TOKEN_WAKEUP_STR))
      ptr = new sim_wakeup_type;
   else if (!strcmp(token, TOKEN_SPEECH_STR))
      ptr = new sim_speech_type;

   if (ptr) {
      ptr->owner = this;
      get_token(infile, token); // '{'

      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         ptr->parse(infile, token);
      }

      return ptr;
   }

   return sim_object::process_task(infile, token);
}


/* *************************************************************
************************************************************* */
sim_infobyte_type *sim_platform::process_event(FILE *infile, char *token) {

   sim_infobyte_type *ptr = NULL;

   if (!strcmp(token, TOKEN_DEATH_STR))
      ptr = new sim_death_type;

   if (ptr) {
      ptr->owner = this;
      get_token(infile, token); // '{'

      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         ptr->parse(infile, token);
      }

      return ptr;
   }

   return sim_object::process_event(infile, token);
}


/* *************************************************************
************************************************************* */
int sim_platform::parse(FILE *infile, char *token) {

   return sim_object::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void sim_platform::preprocess(void *data) {

   sim_object *str;
   hit_type *htr;
   unsigned int enemy_mask;
    
   sim_object::preprocess(data);

   if (!owner) {
      pprintf("Error SIM: platform undefined/unidentifiable... Aborting\n");
      exit(0);
   }

   for (str = ((sim_preprocess_type *)data)->parent; str && str->query_whatami() != DARKSIM_SIM; str = (sim_object *)str->next);

   if (!str)
      return;
      
   ((sim_sim *)str)->player_hit_manager.append(htr = new hit_type, NULL);
   
   htr->target = (gameatom *)owner->htree;
   htr->max_amount = ((gameatom *)owner->htree)->total_hp;
   
   if (global_player)
      if (owner->htree->flags & global_player->flags & GAMEFLAG_ALLIANCE_MASK) {
         if (owner->htree->flags & (GAMEFLAG_FIGHTER | GAMEFLAG_BOMBER))
            ((sim_sim *)((sim_preprocess_type *)data)->head)->player_ally_fighter_count++;
         else if (owner->htree->flags & (GAMEFLAG_FIGHTER | GAMEFLAG_BOMBER))
            ((sim_sim *)((sim_preprocess_type *)data)->head)->player_ally_cap_count++;
      }

      else {
         enemy_mask = calc_enemy(global_player->flags);

         if (owner->htree->flags & enemy_mask & GAMEFLAG_ALLIANCE_MASK)
            if (owner->htree->flags & (GAMEFLAG_FIGHTER | GAMEFLAG_BOMBER))
               ((sim_sim *)((sim_preprocess_type *)data)->head)->player_enemy_fighter_count++;
            else if (owner->htree->flags & (GAMEFLAG_FIGHTER | GAMEFLAG_BOMBER))
               ((sim_sim *)((sim_preprocess_type *)data)->head)->player_enemy_cap_count++;
      }

}


/* *************************************************************
************************************************************* */
sim_object *sim_platform::find_ob(char *name) {

   sim_infobyte_type *ptr;

   for (ptr = (sim_infobyte_type *)script_manager[SIM_MANAGER_INFO].head; ptr; ptr = (sim_infobyte_type *)ptr->next)
      if (ptr->query_whatami() == DARKSIM_NAME && !((sim_name_type *)ptr)->name.stringcmp(name))
         return this;

   return NULL;
}


/* *************************************************************
************************************************************* */
int sim_fighter::query_whatwasi(int type) {

   return (sim_fighter::query_whatami() == type) ? 1 : sim_platform::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
sim_infobyte_type *sim_fighter::process_info(FILE *infile, char *token) {

   sim_infobyte_type *ptr = NULL;

   if (!strcmp(token, TOKEN_WING_COMMANDER_STR))
      ptr = new sim_wing_commander_type;

   if (ptr) {
      ptr->owner = this;
      get_token(infile, token); // '{'

      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         ptr->parse(infile, token);
      }

      return ptr;
   }

   return sim_platform::process_info(infile, token);
}


/* *************************************************************
************************************************************* */
sim_infobyte_type *sim_fighter::process_task(FILE *infile, char *token) {

   sim_infobyte_type *ptr = NULL;

   if (!strcmp(token, TOKEN_ATTACK_STR))
      ptr = new sim_attack_type;

   if (ptr) {
      ptr->owner = this;
      get_token(infile, token); // '{'

      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         ptr->parse(infile, token);
      }

      return ptr;
   }

   return sim_platform::process_task(infile, token);
}


/* *************************************************************
************************************************************* */
sim_infobyte_type *sim_fighter::process_event(FILE *infile, char *token) {

   return sim_platform::process_event(infile, token);
}


/* *************************************************************
************************************************************* */
int sim_fighter::parse(FILE *infile, char *token) {

   return sim_platform::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void sim_fighter::preprocess(void *data) {

   sim_platform::preprocess(data);
}


/* *************************************************************
************************************************************* */
int sim_fighter::set_specific_data(int type, void *data) {

   sim_object_list *wtr;
   sim_object *dob;

   switch (type) { 
      case DARKSIM_INFOFLAG_WINGMAN:
         dob = (sim_object *)data;
         if (dob == (sim_object *)this)
            return 0;
	    
         for (wtr = (sim_object_list *)wing_manager.head; wtr; wtr = (sim_object_list *)wtr->next)
            if (wtr->ob == dob)
               return 0;
	       
         wing_manager.append(wtr = new sim_object_list, NULL);
         wtr->ob = dob;
         return 1;
	 
      case DARKSIM_INFOFLAG_WING_COMMANDER:
         wc = (sim_object *)data;
         return 1;

      case SIM_INFOFLAG_DYNAMIC_TASK:
         if (!sim_object::set_specific_data(type, ((comm_order_type *)data)->order))
            return 0;

         switch (((comm_order_type *)data)->type) {
            case VOICE_PILOT_DYNAMIC_ATTACK:
            case VOICE_PILOT_DYNAMIC_DEFEND:
            case VOICE_PILOT_DYNAMIC_WINGMAN:
//            case VOICE_PILOT_DYNAMIC_RESCIND:
               ((npc_fighter *)owner->htree)->play_voice(((comm_order_type *)data)->type);
               break;

            default:
               break;
         }

         return 1;

      case SIM_INFOFLAG_RESCIND_DYNAMIC_TASKS:
         if (!sim_object::set_specific_data(type, data))
            return 0;

         return ((npc_fighter *)owner->htree)->play_voice(VOICE_PILOT_DYNAMIC_RESCIND);

      default:
         break;
   }
   	 
   return sim_object::set_specific_data(type, data);
}


/* *************************************************************
************************************************************* */
void sim_fighter::process_ai() {

   sim_object_list *otr, *ptr;
   
   otr = (sim_object_list *)wing_manager.head;
   
   while (otr) {
      ptr = otr;
      otr = (sim_object_list *)otr->next;
      
      if (!ptr->ob->owner || ((gameatom *)ptr->ob->owner->htree)->total_hp <= 0) {
         wing_manager.remove(ptr);
         delete ptr;
      }

   }
 
   if (wc && (!wc->owner || ((gameatom *)wc->owner->htree)->total_hp <= 0)) {
      wc = this;
	 
      for (ptr = (sim_object_list *)wing_manager.head; ptr; ptr = (sim_object_list *)ptr->next)
         ptr->ob->set_specific_data(DARKSIM_INFOFLAG_WING_COMMANDER, this);
   }
   
   sim_object::process_ai();
}


/* *************************************************************
************************************************************* */
int sim_strategic_target::query_whatwasi(int type) {

   return (sim_strategic_target::query_whatami() == type) ? 1 : sim_platform::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
sim_infobyte_type *sim_strategic_target::process_info(FILE *infile, char *token) {

   sim_infobyte_type *ptr = NULL;

   if (!strcmp(token, TOKEN_ACCEL_STR))
      ptr = new sim_accel_type;
   else if (!strcmp(token, TOKEN_MAXSPEED_STR))
      ptr = new sim_maxspeed_type;
   else if (!strcmp(token, TOKEN_DORIENT_STR))
      ptr = new sim_deuler_type;

   if (ptr) {
      ptr->owner = this;
      get_token(infile, token); // '{'

      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         ptr->parse(infile, token);
      }

      return ptr;
   }

   return sim_platform::process_info(infile, token);
}


/* *************************************************************
************************************************************* */
sim_infobyte_type *sim_strategic_target::process_task(FILE *infile, char *token) {

   return sim_platform::process_task(infile, token);
}


/* *************************************************************
************************************************************* */
sim_infobyte_type *sim_strategic_target::process_event(FILE *infile, char *token) {

   return sim_platform::process_event(infile, token);
}


/* *************************************************************
************************************************************* */
int sim_strategic_target::parse(FILE *infile, char *token) {

   return sim_platform::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void sim_strategic_target::preprocess(void *data) {

   sim_platform::preprocess(data);
}
