

#include <stdlib.h>
#include <string.h>

#include "pstring.h"

#include "darkstrg.h"
#include "darkgine.h"


#define AI_THREAT_DAMAGE_THRESHOLD 5.0f
#define AI_THREAT_DISTANCE2_THRESHOLD 2250000.0f // sqr(1500M)


/* *************************************************************
************************************************************* */
int ai_identify_threat(dbl_llist_manager *threat_list, target_type *ob, gameatom *attacker, threat_type **threat) {

   threat_type *ttr, *current_threat;
   sub_targeting_pathway sub_target_neuron;
   float dist, t;
   target_type current_target, target;
   vector3f diff;
   
   if (!threat_list->count)
      return 0;

   current_target.object = NULL;
   
   for (ttr = (threat_type *)threat_list->head; ttr; ttr = (threat_type *)ttr->next) {

      // old threat is still considered a threat
      if (ttr->threat == ob->object) {
         sub_target_neuron.init();
         sub_target_neuron.get_next_subtarget(ttr->threat, &target);
         if (target.specific) {
            ob->object = target.object;
            ob->specific = target.specific;
            ob->specific_parent = target.specific_parent;
   
            if (threat)
               *threat = ttr;

            return 1;
         }
	 
         else
            continue;
      }
      
      if ((!threat || !ttr->mayday_manager.count) && ((ttr->flags & FLAG_THREAT_DECLARED_HOSTILE) || ttr->damage > AI_THREAT_DAMAGE_THRESHOLD)) {
         subeqarray3(diff, ttr->threat->htree->old_state.center, attacker->old_state.center);
         t = dotproduct3(diff, diff);
	 
         if (!current_target.object || dist > t) {
            target.object = NULL;
            target.specific = NULL;
            target.specific_parent = NULL;

            sub_target_neuron.init();
            sub_target_neuron.get_next_subtarget(ttr->threat, &target);
            if (target.specific) {
               current_target.object = target.object;
               current_target.specific = target.specific;
               current_target.specific_parent = target.specific_parent;
               dist = t;
               current_threat = ttr;
            }
	    
         }
	 
      }

   }
   	    
   if (!current_target.object || dist > AI_THREAT_DISTANCE2_THRESHOLD) {
      ob->object = NULL;
      return 0;
   }

   ob->object = current_target.object;
   ob->specific = current_target.specific;
   ob->specific_parent = current_target.specific_parent;
   
   if (threat)
      *threat = current_threat;

   return 1;   
}


/* *************************************************************
************************************************************* */
trigger_type::trigger_type() {

   population = NULL;
   trigger = NULL;
   type = DARKSIM_TRIGGER_FLAG_SUCCESS;
}


/* *************************************************************
************************************************************* */
int trigger_type::parse(FILE *infile, char *token) {

   if (!strcmp(TOKEN_TASK_STR, token)) {
      type |= DARKSIM_TRIGGER_FLAG_TASK;
      type &= ~DARKSIM_TRIGGER_FLAG_EVENT;
      get_token(infile, token);
      trigger_id = atoi(token);
      return 1;
   }

   if (!strcmp(TOKEN_EVENT_STR, token)) {
      type &= ~DARKSIM_TRIGGER_FLAG_TASK;
      type |= DARKSIM_TRIGGER_FLAG_EVENT;
      get_token(infile, token);
      trigger_id = atoi(token);
      return 1;
   }

   if (!strcmp(TOKEN_FAILURE_STR, token)) {
      type |= DARKSIM_TRIGGER_FLAG_FAILURE;
      get_token(infile, token);
      trigger_id = atoi(token);
      return 1;
   }

   if (!strcmp(TOKEN_TARGET_STR, token)) {
      get_token(infile, token);
      trigger_name.stringcpy(token);
      return 1;
   }

   if (!strcmp(TOKEN_SIDE_STR, token)) {
      type |= DARKSIM_TRIGGER_FLAG_POPULATION;
      get_token(infile, token);
      pop_name.stringcpy(token);
	    
      get_token(infile, token);

      switch (token[0]) {
         case '<':
            pop_op = -1;
            break;
	  
         case '>':
            pop_op = 1;
            break;
		  
         default: // '=='
            pop_op = 0;
            break;
      }
	    
      get_token(infile, token);
      pop_amount = (float)atof(token);
      return 1;
   }

   sprintf(perror_buffer, "WARNING: Invalid token '%s' in a WAIT trigger\n", token);
   pprintf(perror_buffer);

   return 1;
}


/* *************************************************************
************************************************************* */
void trigger_type::preprocess(void *data) {

   sim_object *ptr;
   
   if (type & DARKSIM_TRIGGER_FLAG_POPULATION) {
      for (population = (sim_side *)((sim_sim *)((sim_preprocess_type *)data)->head)->side_manager.head; population && population->name.stringcmp(&pop_name); population = (sim_side *)population->next);

      if (!population) {
         sprintf(perror_buffer, "Warning: unable to find population '%s'...\n", pop_name.string);
         pprintf(perror_buffer);
         pop_amount = 0;
      }

      else      
         pop_amount = population->entity_manager.count * pop_amount*0.01f;      
   }
   
   else {
      if (!trigger_name.string[0])
         ptr = ((sim_preprocess_type *)data)->parent;
      else
         ptr = (sim_object *)((sim_sim *)((sim_preprocess_type *)data)->head)->find_ob(trigger_name.string);

      if (!ptr) {
         sprintf(perror_buffer, "Warning: unable to find trigger object '%s'...\n", trigger_name.string);
         pprintf(perror_buffer);
      }
      
      else {
         trigger = ptr->find_infobyte((type & DARKSIM_TRIGGER_FLAG_EVENT) ? SIM_MANAGER_EVENT : SIM_MANAGER_TASK, trigger_id);

         if (!trigger) {
            sprintf(perror_buffer, "Warning: unable to find trigger id '%s %d'...\n", trigger_name.string, trigger_id);
            pprintf(perror_buffer);
         }

      }

   }
   
}


/* *************************************************************
************************************************************* */
int trigger_type::evaluate() {

   int flag;

   if (type & DARKSIM_TRIGGER_FLAG_POPULATION) {
      if (!population)
         return 0;
               
      switch (pop_op) {
         case -1:
            flag = population->entity_manager.count < pop_amount;
            break;
		  
         case 1:
            flag = population->entity_manager.count > pop_amount;
            break;

         default:            
            flag = population->entity_manager.count == pop_amount;
            break;
      }

   }
   
   else {
      if (!trigger)
         return 0;
     
      if (type & DARKSIM_TRIGGER_FLAG_FAILURE) {
         if (trigger->flags & SIM_INFOBYTE_FLAG_SUCCESS)
            return 0;
        
         flag = trigger->flags & SIM_INFOBYTE_FLAG_FAILURE;
      }

      else {          
         if (trigger->flags & SIM_INFOBYTE_FLAG_FAILURE)
            return 0;
        
         flag = trigger->flags & SIM_INFOBYTE_FLAG_SUCCESS;
      }
      
   }

   return flag ? 1 : -1;
}


/* *************************************************************
************************************************************* */
int sim_name_type::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_NAME_STR)) {
      get_token(infile, token);
      name.stringcpy(token);
      return 1;
   }

   return sim_infobyte_type::parse(infile, token);   
}


/* *************************************************************
************************************************************* */
void sim_name_type::preprocess(void *data) {

   sim_infobyte_type *ptr;
   atom_list_type *gtr;

   sim_infobyte_type::preprocess(data);

   for (ptr = (sim_infobyte_type *)next; ptr; ptr = (sim_infobyte_type *)ptr->next)
      if (ptr->query_whatami() == DARKSIM_NAME) {
         flags |= SIM_INFOBYTE_FLAG_REDUNDANT;
         return;
      }

   if (owner && owner->query_whatwasi(DARKSIM_ENTITY)) {
      for (gtr=(atom_list_type *)complex->animation_manager.head; gtr && name.stringcmp(&gtr->htree->name); gtr = (atom_list_type *)gtr->next);

      if (!gtr) {
         sprintf(perror_buffer, "WARNING: unable to find entity '%s'...\n", name.string);
         pprintf(perror_buffer);
      }
   
      else
         owner->owner = gtr;
   }
   
}


/* *************************************************************
************************************************************* */
int sim_wing_commander_type::parse(FILE *infile, char *token) {

   string_type *str;
   
   if (!strcmp(token, TOKEN_WINGMAN_STR)) {
      get_token(infile, token);
   
      for (str = (string_type *)wing_manager.head; str; str = (string_type *)str->next)
         if (!str->stringcmp(str))
	    return 1;

      wing_manager.append(str = new string_type, NULL);
      str->stringcpy(token);
      return 1;
   }
   	    
   return sim_infobyte_type::parse(infile, token);   
}


/* *************************************************************
************************************************************* */
void sim_wing_commander_type::preprocess(void *data) {

   string_type *str;
   sim_object_list *otr, *ptr;
   dbl_llist_manager wman;
   sim_object *sim, *ob;
         
   sim_infobyte_type::preprocess(data);

   owner->set_specific_data(DARKSIM_INFOFLAG_WING_COMMANDER, owner);
   
   for (sim = owner; sim && sim->query_whatami() != DARKSIM_SIDE; sim = sim->parent);

   if (!sim)
      return;
   
   for (str = (string_type *)wing_manager.head; str; str = (string_type *)str->next) {
      ob = ((sim_side *)sim)->find_ob(str->string); 

      if (!ob)
         continue;
	 
      wman.append(ptr = new sim_object_list, NULL);
      ptr->ob = ob;
      owner->set_specific_data(DARKSIM_INFOFLAG_WINGMAN, ob);
   }

   for (ptr = (sim_object_list *)wman.head; ptr; ptr = (sim_object_list *)ptr->next) {
      ptr->ob->set_specific_data(DARKSIM_INFOFLAG_WING_COMMANDER, owner);
      ptr->ob->set_specific_data(DARKSIM_INFOFLAG_WINGMAN, owner);
      
      for (otr = (sim_object_list *)wman.head; otr; otr = (sim_object_list *)otr->next)
         if (otr != ptr)
            ptr->ob->set_specific_data(DARKSIM_INFOFLAG_WINGMAN, otr->ob);
   }
      
}


/* *************************************************************
************************************************************* */
int sim_accel_type::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_ACCEL_STR)) {
      get_token(infile, token);
      accel = (float)atof(token);
      return 1;
   }

   return sim_infobyte_type::parse(infile, token);   
}


/* *************************************************************
************************************************************* */
void sim_accel_type::preprocess(void *data) {

   sim_infobyte_type::preprocess(data);
   
   if (owner && owner->owner)
      owner->owner->htree->set_specific_data(DATAFLAG_ACCEL, &accel);
}


/* *************************************************************
************************************************************* */
int sim_maxspeed_type::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_MAXSPEED_STR)) {
      get_token(infile, token);
      maxspeed = (float)atof(token);
      return 1;
   }

   return sim_infobyte_type::parse(infile, token);   
}


/* *************************************************************
************************************************************* */
void sim_maxspeed_type::preprocess(void *data) {

   sim_infobyte_type::preprocess(data);

   if (owner && owner->owner)
      owner->owner->htree->set_specific_data(DATAFLAG_MAXSPEED, &maxspeed);
}


/* *************************************************************
************************************************************* */
int sim_deuler_type::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_DORIENT_STR)) {
      get_token(infile, token);
      dorient = (float)deg2rad(atof(token));
      return 1;
   }

   return sim_infobyte_type::parse(infile, token);   
}


/* *************************************************************
************************************************************* */
void sim_deuler_type::preprocess(void *data) {

   sim_infobyte_type::preprocess(data);

   if (owner && owner->owner)
      owner->owner->htree->set_specific_data(DATAFLAG_DEULER, &dorient);
}


/* *************************************************************
************************************************************* */
int sim_music_type::parse(FILE *infile, char *token) {

   sound_id_type *sound_id;
   
   if (!strcmp(token, TOKEN_WAV_STR)) {
      get_token(infile, token);
      jukebox.append(sound_id = new sound_id_type, NULL);
      sound_id->name.stringcpy(token);
      get_token(infile, token);
      sound_id->volume(atoi(token));
      sound_id->flags = FLAG_SOUND_WAV | FLAG_SOUND_MUSIC;
      return 1;
   }

   if (!strcmp(token, TOKEN_MIDI_STR)) {
      get_token(infile, token);
      jukebox.append(sound_id = new sound_id_type, NULL);
      sound_id->name.stringcpy(token);
      get_token(infile, token);
      sound_id->volume(atoi(token));
      sound_id->flags = FLAG_SOUND_MIDI | FLAG_SOUND_MUSIC;
      return 1;
   }

   return sim_infobyte_type::parse(infile, token);   
}


/* *************************************************************
************************************************************* */
void sim_music_type::preprocess(void *data) {

   sound_id_type *sound_id;
   sim_task_type *ptr;
   sim_music_type *qtr;
   
   sim_task_type::preprocess(data);

   ptr = (sim_task_type *)owner->script_manager[SIM_MANAGER_TASK].head;

   while (ptr)
      if (ptr != this && ptr->query_whatami() == DARKSIM_MUSIC) {
         qtr = (sim_music_type *)ptr;
         ptr = (sim_task_type *)ptr->next;
         owner->script_manager[SIM_MANAGER_TASK].remove(qtr);
         owner->success_manager.append(qtr, NULL);
         qtr->flags |= SIM_INFOBYTE_FLAG_SUCCESS;
         if (qtr->sndfx) {
            qtr->sndfx->stop();
            qtr->sndfx = NULL;
         }
	 
      }

      else 
         ptr = (sim_task_type *)ptr->next;
	 
   for (sound_id = (sound_id_type *)jukebox.head; sound_id; sound_id = (sound_id_type *)sound_id->next)
      complex->soundmanager->find(sound_id);
}



/* *************************************************************
************************************************************* */
sim_music_type::~sim_music_type() {

   if (sndfx)
      sndfx->stop();
}


/* *************************************************************
************************************************************* */
int sim_music_type::update() {

   if (!sndfx || !(sndfx->flags & FLAG_SOUND_PLAYING)) {
      if (sndfx)
         sndfx->flags &= ~FLAG_SOUND_LOCK;

      sndfx = complex->soundmanager->play(sndid = (sound_id_type *)jukebox.get());

      if (sndfx)
         sndfx->flags |= FLAG_SOUND_LOCK;
   }

   return 1;
}


/* *************************************************************
************************************************************* */
void sim_music_type::get_status(string_type *token) {

   if (sndid) {
      token->stringcpy("Now playing: ");
      token->stringcat(&sndid->name);
   }
   
   else
      token->stringcpy("");
}


/* *************************************************************
************************************************************* */
int sim_escort_type::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_RANGE_STR)) {
      get_token(infile, token);
      range2 = (float)atof(token);
      return 1;
   }

   if (!strcmp(token, TOKEN_TARGET_STR)) {
      get_token(infile, token);
      target_name.stringcpy(token);
      return 1;
   }

   return sim_infobyte_type::parse(infile, token);   
}


/* *************************************************************
************************************************************* */
void sim_escort_type::preprocess(void *data) {

   sim_task_type::preprocess(data);

   target = (sim_platform *)((sim_sim *)((sim_preprocess_type *)data)->head)->find_ob(target_name.string);
   range2 *= range2;
}


/* *************************************************************
************************************************************* */
int sim_escort_type::update() {

   // if escort doesnt exists (ie dead or jumped), dont escort :)
   if (!target || !target->owner || !owner || !owner->owner) {
      flags |= SIM_INFOBYTE_FLAG_FAILURE;
      return 0;
   }
   
   if (((gameatom *)target->owner->htree)->total_hp <= 0)
      flags |= SIM_INFOBYTE_FLAG_FAILURE;
   else if (target->flags & DARKSIM_FLAG_JUMP)
      flags |= SIM_INFOBYTE_FLAG_SUCCESS;
      
   return 1;
}


/* *************************************************************
************************************************************* */
void sim_escort_type::get_status(string_type *token) {

   if (target && target->owner) {
      token->stringcpy("Escort: ");
      token->stringcat(&((gameatom *)target->owner->htree)->full_name);
   }
   
   else
      token->stringcpy("");   
}


/* *************************************************************
************************************************************* */
int sim_escort_type::query_specific_data(int type, void *data) {

   vector3f temp;
   dbl_llist_manager *threat_list;
   threat_type *ttr;
   hiearchy_list_type *gtr;
   
   switch (type) {

      case TASK_ORDERS_LOCATION:
         if (!owner || !owner->owner || !target || !target->owner)
            return 0;

         subeqarray3(temp, owner->owner->htree->old_state.center, target->owner->htree->old_state.center);
         if (dotproduct3(temp, temp) < range2)
            return 0;

         copyarray3(((float *)data), target->owner->htree->old_state.center);
         return 1;

      case TASK_ORDERS_TARGET:
         if (target && target->owner &&
             target->owner->htree->query_specific_data(DATAFLAG_THREAT_LIST, &threat_list) &&
             ai_identify_threat(threat_list, (target_type *)data, (gameatom *)owner->owner->htree, &ttr)) {
	     
            ttr->mayday_manager.insert(gtr = new hiearchy_list_type, NULL);
            gtr->hiearchy = owner->owner;
            return 1;   
	 }
	 
	 return 0;

      default:
         break;
   }

   return sim_infobyte_type::query_specific_data(type, data);
}


/* *************************************************************
************************************************************* */
int sim_escort_type::set_specific_data(int type, void *data) {

   switch (type) {
      case DARKSIM_INFOFLAG_TARGET_NAME:
         target_name.stringcpy((char *)data);
         return 1;

      default:
         break;
   }

   return sim_infobyte_type::set_specific_data(type, data);
}


/* *************************************************************
************************************************************* */
int sim_jump_type::parse(FILE *infile, char *token) {

   return sim_task_type::parse(infile, token);   
}


/* *************************************************************
************************************************************* */
void sim_jump_type::preprocess(void *data) {

   sim_task_type::preprocess(data);
}


/* *************************************************************
************************************************************* */
int sim_jump_type::update() {

   if (!owner || !owner->owner) {
      flags |= SIM_INFOBYTE_FLAG_FAILURE;
      return 0;
   }
   
   if (((gameatom *)owner->owner->htree)->total_hp <= 0)
      flags |= SIM_INFOBYTE_FLAG_FAILURE;
   else if (owner->flags & DARKSIM_FLAG_JUMP)
      flags |= SIM_INFOBYTE_FLAG_SUCCESS;

   return 1;
}


/* *************************************************************
************************************************************* */
void sim_jump_type::get_status(string_type *token) {

   token->stringcpy("Activate jump engine");
}


/* *************************************************************
************************************************************* */
int sim_goto_type::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_LOCATION_STR)) {
      get_token(infile, token);
      dest[0] = (float)atof(token);

      get_token(infile, token);
      dest[1] = (float)atof(token);

      get_token(infile, token);
      dest[2] = (float)atof(token);

      return 1;
   }

   if (!strcmp(token, TOKEN_RANGE_STR)) {
      get_token(infile, token);
      range2 = (float)atof(token);
      return 1;
   }

   return sim_infobyte_type::parse(infile, token);   
}


/* *************************************************************
************************************************************* */
void sim_goto_type::preprocess(void *data) {

   sim_task_type::preprocess(data);

   range2 *= range2;
}


/* *************************************************************
************************************************************* */
int sim_goto_type::update() {

   vector3f temp;
   
   if (!owner || !owner->owner) {
      flags |= SIM_INFOBYTE_FLAG_FAILURE;
      return 0;
   }
         
   subeqarray3(temp, owner->owner->htree->state.center, dest);
   if (dotproduct3(temp, temp) <= range2)
      flags |= SIM_INFOBYTE_FLAG_SUCCESS;
 
   return 1;
}


/* *************************************************************
************************************************************* */
void sim_goto_type::get_status(string_type *token) {

   char buffer[MAXSTRLEN];

   sprintf(buffer, "Goto: %6.2f %6.2f %6.2f", dest[0], dest[1], dest[2]);
   token->stringcpy(buffer);
}


/* *************************************************************
************************************************************* */
int sim_goto_type::query_specific_data(int type, void *data) {

   switch (type) {
      
      case TASK_ORDERS_LOCATION:
         copyarray3(((float *)data), dest);	 
         return 1;

      default:
         break;
   }

   return sim_infobyte_type::query_specific_data(type, data);
}


/* *************************************************************
************************************************************* */
int sim_wait_type::parse(FILE *infile, char *token) {

   sim_infobyte_type *itr;

   if (!strcmp(token, TOKEN_TRIGGER_STR)) {

      get_token(infile, token); // '{'

      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         trigger.parse(infile, token);
      }

      return 1;
   }

   if (!strcmp(token, TOKEN_INFO_STR)) {
      get_token(infile, token);
      itr = owner->process_info(infile, token);
      if (itr) {
         sleep_script_manager[SIM_MANAGER_INFO].append(itr, NULL);
         return 1;
      }

      return 0;
   }

   if (!strcmp(token, TOKEN_TASK_STR)) {
      get_token(infile, token);
      itr = owner->process_task(infile, token);
      if (itr) {
         sleep_script_manager[SIM_MANAGER_TASK].append(itr, NULL);
         return 1;
      }

      return 0;
   }

   if (!strcmp(token, TOKEN_EVENT_STR)) {
      get_token(infile, token);
      itr = owner->process_event(infile, token);
      if (itr) {
         sleep_script_manager[SIM_MANAGER_EVENT].append(itr, NULL);
         return 1;
      }

      return 0;
   }

   return sim_infobyte_type::parse(infile, token);   
}


/* *************************************************************
************************************************************* */
void sim_wait_type::preprocess(void *data) {

   sim_preprocess_type prep;

   sim_task_type::preprocess(data);

   prep.head = ((sim_preprocess_type *)data)->head;
   prep.parent = owner;

   trigger.preprocess(&prep);
}


/* *************************************************************
************************************************************* */
sim_infobyte_type *sim_wait_type::find_subinfobyte(int type, int fid) {

   sim_infobyte_type *ptr, *qtr;
   int i;

   for (ptr = (sim_infobyte_type *)sleep_script_manager[type].head; ptr; ptr = (sim_infobyte_type *)ptr->next)
      if (ptr->id == fid)
         return ptr;

   for (i=0; i<SIM_MANAGER_MAX; i++)
      for (ptr = (sim_infobyte_type *)sleep_script_manager[i].head; ptr; ptr = (sim_infobyte_type *)ptr->next) {
         qtr = ptr->find_subinfobyte(type, fid);
         if (qtr)
            return qtr;
      }

   return NULL;
}


/* *************************************************************
************************************************************* */
int sim_wait_type::update() {

   sim_preprocess_type data;
   sim_infobyte_type *ptr;
   int i;

   switch (trigger.evaluate()) {

      case 0:
         flags |= SIM_INFOBYTE_FLAG_FAILURE;
         return 0;

      case 1:
         flags |= SIM_INFOBYTE_FLAG_SUCCESS;

         for (data.head = owner; data.head && data.head->parent; data.head = data.head->parent);
         data.parent = owner;
         for (i=0; i<SIM_MANAGER_MAX; i++)
            while (sleep_script_manager[i].head) {
               sleep_script_manager[i].remove(ptr = (sim_infobyte_type *)sleep_script_manager[i].head);
               ptr->preprocess(&data);
               owner->script_manager[i].append(ptr, NULL);
            }

         return 1;

      default: // -1
         break;
   }
   
   return 1;
}


/* *************************************************************
************************************************************* */
void sim_wait_type::get_status(string_type *token) {

   char buffer[MAXSTRLEN];

   if (trigger.type & DARKSIM_TRIGGER_FLAG_POPULATION) {

      sprintf(buffer, "Wait for population %s ", trigger.pop_name.string);
      token->stringcpy(buffer);

      switch (trigger.pop_op) {
         case -1:
            token->stringcat("< ");
            break;
		  
         case 1:
            token->stringcat("> ");
            break;

         default:            
            token->stringcat("== ");
            break;
      }
      
      sprintf(buffer, "%f%%", trigger.pop_amount);
      token->stringcat(buffer);
      return;
   }
   
   if (trigger.trigger->owner && trigger.trigger->owner->owner) {
      sprintf(buffer, "Wait for task/event %s %d", ((gameatom *)trigger.trigger->owner->owner->htree)->full_name.string, trigger.trigger->id);
      token->stringcpy(buffer);
      return;
   }
   
   sprintf(buffer, "Wait for task/event %d", trigger.trigger->id);
   token->stringcpy(buffer);
}


/* *************************************************************
************************************************************* */
int sim_sleep_type::parse(FILE *infile, char *token) {

   return sim_infobyte_type::parse(infile, token);   
}


/* *************************************************************
************************************************************* */
void sim_sleep_type::preprocess(void *data) {

   sim_task_type::preprocess(data);
}


/* *************************************************************
************************************************************* */
int sim_sleep_type::update() {

   if (owner && owner->owner) {
      owner->owner->htree->flags &= ~QUARK_FLAG_ACTIVE;
      flags |= SIM_INFOBYTE_FLAG_SUCCESS;
      return 1;
   }

   flags |= SIM_INFOBYTE_FLAG_FAILURE;
   return 1;
}


/* *************************************************************
************************************************************* */
void sim_sleep_type::get_status(string_type *token) {

   token->stringcpy("Sleep");
}


/* *************************************************************
************************************************************* */
int sim_wakeup_type::parse(FILE *infile, char *token) {

   return sim_task_type::parse(infile, token);   
}


/* *************************************************************
************************************************************* */
void sim_wakeup_type::preprocess(void *data) {

   sim_task_type::preprocess(data);
}


/* *************************************************************
************************************************************* */
int sim_wakeup_type::update() {

   if (owner && owner->owner) {
      owner->owner->htree->flags |= QUARK_FLAG_ACTIVE;
      flags |= SIM_INFOBYTE_FLAG_SUCCESS;
      return 1;
   }

   flags |= SIM_INFOBYTE_FLAG_FAILURE;
   return 1;
}


/* *************************************************************
************************************************************* */
void sim_wakeup_type::get_status(string_type *token) {

   token->stringcpy("Active");
}


/* *************************************************************
************************************************************* */
int sim_win_type::parse(FILE *infile, char *token) {

   trigger_type *ttr;

   if (!strcmp(token, TOKEN_TRIGGER_STR)) {
      trigger_manager.append(ttr = new trigger_type, NULL);

      get_token(infile, token); // '{'

      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         ttr->parse(infile, token);
      }

      return 1;
   }

   return sim_infobyte_type::parse(infile, token);   
}


/* *************************************************************
************************************************************* */
void sim_win_type::preprocess(void *data) {

   sim_preprocess_type prep;
   trigger_type *ttr;

   sim_task_type::preprocess(data);

   prep.head = ((sim_preprocess_type *)data)->head;
   prep.parent = owner;

   for (ttr=(trigger_type *)trigger_manager.head; ttr; ttr = (trigger_type *)ttr->next)
      ttr->preprocess(&prep);
}


/* *************************************************************
************************************************************* */
int sim_win_type::update() {

   trigger_type *ttr, *ptr;
   sim_object *str;

   ttr = (trigger_type *)trigger_manager.head;
   while (ttr) {
      ptr = ttr;
      ttr = (trigger_type *)ttr->next;

      switch (ptr->evaluate()) {

         case 0:  // cannot succeed (faulty ai)
            return 1;

         case 1:
            trigger_manager.remove(ptr);
            delete ptr;
            break;

         default: // -1
            break;
      }
   
   }

   if (!trigger_manager.head) {
      flags |= SIM_INFOBYTE_FLAG_SUCCESS;
      for (str=owner; str && str->query_whatami() != DARKSIM_SIDE; str = (sim_object *)str->next);
      if (str && ((sim_side *)str)->find_ob(TOKEN_SPLAYER_NAME_STR))
         sheader->flags |= DARKSIM_FLAG_SUCCESS;
   }
   
   return 1;
}


/* *************************************************************
************************************************************* */
void sim_win_type::get_status(string_type *token) {

   token->stringcpy("");
}


/* *************************************************************
************************************************************* */
int sim_fail_type::parse(FILE *infile, char *token) {

   trigger_type *ttr;

   if (!strcmp(token, TOKEN_TRIGGER_STR)) {
      trigger_manager.append(ttr = new trigger_type, NULL);

      get_token(infile, token); // '{'

      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         ttr->parse(infile, token);
      }

      return 1;
   }

   return sim_infobyte_type::parse(infile, token);   
}


/* *************************************************************
************************************************************* */
void sim_fail_type::preprocess(void *data) {

   sim_preprocess_type prep;
   trigger_type *ttr;

   sim_task_type::preprocess(data);

   prep.head = ((sim_preprocess_type *)data)->head;
   prep.parent = owner;

   for (ttr=(trigger_type *)trigger_manager.head; ttr; ttr = (trigger_type *)ttr->next)
      ttr->preprocess(&prep);
}


/* *************************************************************
************************************************************* */
int sim_fail_type::update() {

   trigger_type *ttr, *ptr;

   ttr = (trigger_type *)trigger_manager.head;
   while (ttr) {
      ptr = ttr;
      ttr = (trigger_type *)ttr->next;

      switch (ptr->evaluate()) {

         case 0:  // cannot fail (faulty ai)
            return 1;

         case 1:
            flags |= SIM_INFOBYTE_FLAG_SUCCESS;
            trigger_manager.dest();
            return 1;

         default: // -1
            break;
      }
   
   }
   return 1;
}


/* *************************************************************
************************************************************* */
void sim_fail_type::get_status(string_type *token) {

   token->stringcpy("");
}


/* *************************************************************
************************************************************* */
int sim_attack_type::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_TARGET_STR)) {
      get_token(infile, token);
      target_name.stringcpy(token);
      return 1;
   }

   return sim_infobyte_type::parse(infile, token);   
}


/* *************************************************************
************************************************************* */
void sim_attack_type::preprocess(void *data) {

   sim_object *sim;

   sim_task_type::preprocess(data);

   for (sim = owner; sim && sim->query_whatami() != DARKSIM_SIDE; sim = sim->parent);

   if (!sim)
      return;
   
   target = ((sim_side *)sim)->find_ob(target_name.string); 
}


/* *************************************************************
************************************************************* */
int sim_attack_type::update() {

   if (!target || !target->owner || ((gameatom *)target->owner->htree)->total_hp <= 0)
      flags |= SIM_INFOBYTE_FLAG_SUCCESS;

   return 1;
}


/* *************************************************************
************************************************************* */
void sim_attack_type::get_status(string_type *token) {

   char buffer[MAXSTRLEN];

   if (target && target->owner) {
      sprintf(buffer, "Attack %s", ((gameatom *)target->owner->htree)->full_name.string);
      token->stringcpy(buffer);
   }

   else
      token->stringcpy("");
}


/* *************************************************************
************************************************************* */
int sim_attack_type::query_specific_data(int type, void *data) {

   sub_targeting_pathway sub_target_neuron;

   switch (type) {

      case TASK_ORDERS_TARGET:
         if (!target || !target->owner)
            return 0;

         ((target_type *)data)->object = NULL;
         ((target_type *)data)->specific = NULL;
         ((target_type *)data)->specific_parent = NULL;

         sub_target_neuron.init();
         sub_target_neuron.get_next_subtarget(target->owner, (target_type *)data);
         if (((target_type *)data)->specific)
            return 1;   

         // shouldnt get here....
         return 0;

      default:
         break;
   }

   return sim_infobyte_type::query_specific_data(type, data);
}


/* *************************************************************
************************************************************* */
int sim_attack_type::set_specific_data(int type, void *data) {

   switch (type) {
      case DARKSIM_INFOFLAG_TARGET_NAME:
         target_name.stringcpy((char *)data);
         return 1;

      default:
         break;
   }

   return sim_infobyte_type::set_specific_data(type, data);
}


/* *************************************************************
************************************************************* */
sim_speech_type::~sim_speech_type() {

   if (sndfx)
      sndfx->stop();
}


/* *************************************************************
************************************************************* */
int sim_speech_type::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_WAV_STR)) {
      get_token(infile, token);
      sound_id.name.stringcpy(token);
      get_token(infile, token);
      sound_id.volume(atoi(token));
      sound_id.flags = FLAG_SOUND_WAV | FLAG_SOUND_VOICE;
      return 1;
   }

   if (!strcmp(token, TOKEN_TEXT_STR)) {
      get_token(infile, token);
      speech_name.stringcpy(token);
      return 1;
   }

   return sim_infobyte_type::parse(infile, token);   
}


/* *************************************************************
************************************************************* */
void sim_speech_type::preprocess(void *data) {

   sim_task_type::preprocess(data);

   complex->soundmanager->find(&sound_id);

   if (sndfx)
      sndfx->stop();
      
   sndfx = complex->soundmanager->play(&sound_id);

   if (sndfx)
      sndfx->flags |= FLAG_SOUND_LOCK;

   if (speech_name.string)
      speech.scan_data(speech_name.string, NULL, (char)PLATFORM_SLASH);
}


/* *************************************************************
************************************************************* */
int sim_speech_type::update() {

   if (!sndfx)
//      flags |= SIM_INFOBYTE_FLAG_FAILURE;
      flags |= SIM_INFOBYTE_FLAG_SUCCESS;
   else if (!(sndfx->flags & FLAG_SOUND_PLAYING)) {
      sndfx->flags &= ~FLAG_SOUND_LOCK;
      sndfx = NULL;
      flags |= SIM_INFOBYTE_FLAG_SUCCESS;
   }
   
   return 1;
}


/* *************************************************************
************************************************************* */
void sim_speech_type::get_status(string_type *token) {

   token->stringcpy("");
}


/* *************************************************************
************************************************************* */
void sim_speech_type::render2d(mapul *mapbuffer) {

   float rowsize;
   float colsize;
   float y;
   float x;
   char *ptr, *etr;
   char buffer[MAXSTRLEN];
   int i;

   if (!speech.data)
      return;

   rowsize = (float)(mapbuffer->maxy/64.0);
   colsize = (float)(mapbuffer->maxx/640.0);

   complex->font->set_scale(rowsize*0.85f);
   complex->font->set_color((unsigned char)196, (unsigned char)255, (unsigned char)255);

   y = mapbuffer->maxy-3.0f*rowsize;
   x = colsize*100.0f;
   ptr = (char *)speech.data;
   etr = (char *)speech.data + speech.size;
   i = 0;
   while (ptr < etr) {
      if (*ptr == '\n') {
         buffer[i] = 0;
         complex->font->print((int)x, (int)y, (unsigned char *)buffer, mapbuffer);
         y -= rowsize;
         ptr++;
         i = 0;
         continue;
      }

      buffer[i] = *ptr;
      ptr++;
      i++;
   }

   if (i) {
      buffer[i] = 0;
      complex->font->print((int)x, (int)y, (unsigned char *)buffer, mapbuffer);
   }

}


/* *************************************************************
************************************************************* */
int sim_dynamic_attack_type::query_specific_data(int type, void *data) {

   switch (type) {
      case SIM_INFOFLAG_SOURCE:
         *((sim_object **)data) = source;
         return 1;

      default:
         break;
   }

   return sim_attack_type::query_specific_data(type, data);
}


/* *************************************************************
************************************************************* */
int sim_dynamic_attack_type::set_specific_data(int type, void *data) {

   switch (type) {
      case SIM_INFOFLAG_SOURCE:
         source = (sim_object *)data;
         return 1;

      default:
         break;
   }

   return sim_attack_type::set_specific_data(type, data);
}


/* *************************************************************
************************************************************* */
int sim_dynamic_escort_type::query_specific_data(int type, void *data) {

   switch (type) {
      case SIM_INFOFLAG_SOURCE:
         *((sim_object **)data) = source;
         return 1;

      default:
         break;
   }

   return sim_escort_type::query_specific_data(type, data);
}


/* *************************************************************
************************************************************* */
int sim_dynamic_escort_type::set_specific_data(int type, void *data) {

   switch (type) {
      case SIM_INFOFLAG_SOURCE:
         source = (sim_object *)data;
         return 1;

      default:
         break;
   }

   return sim_escort_type::set_specific_data(type, data);
}


/* *************************************************************
************************************************************* */
int sim_death_type::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_TARGET_STR)) {
      get_token(infile, token);
      target_name.stringcpy(token);
      return 1;
   }

   return sim_infobyte_type::parse(infile, token);   
}


/* *************************************************************
************************************************************* */
void sim_death_type::preprocess(void *data) {

   sim_event_type::preprocess(data);

   target = (sim_platform *)((sim_sim *)((sim_preprocess_type *)data)->head)->find_ob(target_name.string);
}


/* *************************************************************
************************************************************* */
int sim_death_type::update() {

   if (target && target->owner && ((gameatom *)target->owner->htree)->total_hp <= 0)
      flags |= SIM_INFOBYTE_FLAG_SUCCESS;

   return 1;
}


