

#include <stdlib.h>

#include "darkgine.h"
#include "darkwin.h"
#include "fighter.h"


#ifdef WIN32
#define UI_TYPE dark_uio_win
#define UI_PARENT_TYPE user_io_win
#else
#define UI_TYPE dark_uio_X
#define UI_PARENT_TYPE user_io_X
#endif


/* **************************************************
************************************************** */
void dark_god::setup_equipment() {

   dbl_llist_manager *eloader;
   
   eloader = (dbl_llist_manager *)global_resource_manager->get_resource_object(RESOURCE_EQUIP_LOADER);

   if (!eloader->head) {
      printf("Warning: No \"equipment loader\" resources are registered...\n");
      return;
   }
      
   if (!quartermaster.read_data(FILENAME_DATA, eloader)) {
      printf("Warning: Cannot access object configuration \"%s\"... Aborting...\n", FILENAME_DATA);
      return;
   }

}


/* **************************************************
************************************************** */
dbl_llist *jukebox_manager::get() {

   int i;
   dbl_llist *ptr;
   
   if (!count)
      return NULL;
      
   for (ptr = head, i = rand() % count; i; ptr = ptr->next, i--);
   return ptr;
}


/* **********************************************************************
********************************************************************** */
int UI_TYPE::key2int() {

   if (complex->userinput->key_stroke(KEYSTROKE_1))
      return 1;
   
   if (complex->userinput->key_stroke(KEYSTROKE_2))
      return 2;
      
   if (complex->userinput->key_stroke(KEYSTROKE_3))
      return 3;
      
   if (complex->userinput->key_stroke(KEYSTROKE_4))
      return 4;
      
   if (complex->userinput->key_stroke(KEYSTROKE_5))
      return 5;
      
   if (complex->userinput->key_stroke(KEYSTROKE_6))
      return 6;
      
   if (complex->userinput->key_stroke(KEYSTROKE_7))
     return 7;
      
   if (complex->userinput->key_stroke(KEYSTROKE_8))
      return 8;
      
   if (complex->userinput->key_stroke(KEYSTROKE_9))
      return COMM_ABORT;

   return 0;
}
         

/* **********************************************************************
********************************************************************** */
void UI_TYPE::get_events() {

   int i;
   atom_list_type *ptr;
   object_desc *status;
   equip_targeting_computer *tc;
   comm_order_type order;
   sim_preprocess_type spt;
   sim_object *splayer;
   unsigned int enemy_mask;
   
   UI_PARENT_TYPE::get_events();

   if (mode == COMM_MODE_IDLE && complex->userinput->translate_stroke(KEYSTROKE_COMM))
      mode = COMM_MODE_TARGET;
   else if (mode == COMM_MODE_IDLE)
      return;

   splayer = sheader ? sheader->find_ob(TOKEN_SPLAYER_NAME_STR) : (sim_object *)NULL;

   if (!splayer || !global_player->query_specific_data(DATAFLAG_EQUIPMENT, &status) || !status->find_specific(EQUIP_SYSTEMS_COMPUTER)) {
      mode = COMM_MODE_IDLE;
      return;
   }

   switch (mode) {
      case COMM_MODE_TARGET:
         i = key2int();

         if (!i)
            return;

         if (i == COMM_ABORT) {
            mode = COMM_MODE_IDLE;
            return;
         }

         if (i == COMM_ALL) {
            starget = (sim_object *)0xffffffff;
            mode = COMM_MODE_ORDER;
            return;
         }    

         for (ptr = (atom_list_type *)complex->animation_manager.head; ptr; ptr = (atom_list_type *)ptr->next)
            if ((global_player->flags & ptr->htree->flags & GAMEFLAG_ALLIANCE_MASK) && ptr->htree->query_whatami() == OBJECT_NPC_FIGHTER) {
               i--;
               if (!i) {
                  starget = sheader->find_ob(ptr->htree->name.string);
	 
	          if (starget)
                     mode = COMM_MODE_ORDER;

                  return;
               }
	       
            }

         return;

      case COMM_MODE_ORDER:
         i = key2int();

         if (!i)
            return;

         if (i == COMM_ABORT) {
            mode = COMM_MODE_IDLE;
            return;
         }

         i--;
	 
         if (starget == (sim_object *)0xffffffff) {
	 
            switch (i) {
               case COMM_ESCORT:
                  tc = (equip_targeting_computer *)status->find_specific(EQUIP_TARGETING_COMPUTER);
                  if (!tc || !tc->target.object) {
                     mode = COMM_MODE_IDLE;
                     return;
                  }

                  spt.head = sheader;
                  order.type = VOICE_PILOT_DYNAMIC_DEFEND;
		  
                  enemy_mask = calc_enemy(global_player->flags);
                  if (enemy_mask & tc->target.object->htree->flags) {
                     mode = COMM_MODE_IDLE;
                     return;
                  }
		  
                  for (ptr = (atom_list_type *)complex->animation_manager.head, i=0; ptr && i<7; ptr = (atom_list_type *)ptr->next)
                     if (((gameatom *)ptr->htree)->total_hp > 0 && (global_player->flags & ptr->htree->flags & GAMEFLAG_ALLIANCE_MASK) && ptr->htree->query_whatami() == OBJECT_NPC_FIGHTER) {
                        spt.parent = sheader->find_ob(ptr->htree->name.string);
                        
                        if (ptr != tc->target.object && spt.parent) {
                           order.order = new sim_dynamic_escort_type;
                           order.order->set_specific_data(SIM_INFOFLAG_SOURCE, splayer);
                           order.order->set_specific_data(DARKSIM_INFOFLAG_TARGET_NAME, tc->target.object->htree->name.string);
                           order.order->preprocess(&spt);
                           spt.parent->set_specific_data(SIM_INFOFLAG_DYNAMIC_TASK, &order);
                        }
                        
                        i++;
                     }

                  mode = COMM_MODE_IDLE;
                  return;

               case COMM_ATTACK:
                  tc = (equip_targeting_computer *)status->find_specific(EQUIP_TARGETING_COMPUTER);
                  if (!tc || !tc->target.object) {
                     mode = COMM_MODE_IDLE;
                     return;
                  }

                  spt.head = sheader;
                  order.type = VOICE_PILOT_DYNAMIC_ATTACK;

                  enemy_mask = calc_enemy(global_player->flags);
                  if (!(enemy_mask & tc->target.object->htree->flags)) {
                     mode = COMM_MODE_IDLE;
                     return;
                  }
		  
                  for (ptr = (atom_list_type *)complex->animation_manager.head, i=0; ptr && i<7; ptr = (atom_list_type *)ptr->next)
                     if (((gameatom *)ptr->htree)->total_hp > 0 && (global_player->flags & ptr->htree->flags & GAMEFLAG_ALLIANCE_MASK) && ptr->htree->query_whatami() == OBJECT_NPC_FIGHTER) {
                        spt.parent = sheader->find_ob(ptr->htree->name.string);

                        if (spt.parent) {
                           order.order = new sim_dynamic_attack_type;
                           order.order->set_specific_data(SIM_INFOFLAG_SOURCE, splayer);
                           order.order->set_specific_data(DARKSIM_INFOFLAG_TARGET_NAME, tc->target.object->htree->name.string);
                           order.order->preprocess(&spt);
                           spt.parent->set_specific_data(SIM_INFOFLAG_DYNAMIC_TASK, &order);
                        }
                        
                        i++;
                     }

                  mode = COMM_MODE_IDLE;
                  return;

               case COMM_BODYGUARD:
                  spt.head = sheader;
                  order.type = VOICE_PILOT_DYNAMIC_WINGMAN;

                  for (ptr = (atom_list_type *)complex->animation_manager.head, i=0; ptr && i<7; ptr = (atom_list_type *)ptr->next)
                     if (((gameatom *)ptr->htree)->total_hp > 0 && (global_player->flags & ptr->htree->flags & GAMEFLAG_ALLIANCE_MASK) && ptr->htree->query_whatami() == OBJECT_NPC_FIGHTER) {
                        spt.parent = sheader->find_ob(ptr->htree->name.string);

                        if (spt.parent) {
                           order.order = new sim_dynamic_escort_type;
                           order.order->set_specific_data(SIM_INFOFLAG_SOURCE, splayer);
                           order.order->set_specific_data(DARKSIM_INFOFLAG_TARGET_NAME, TOKEN_SPLAYER_NAME_STR);
                           order.order->preprocess(&spt);
                           spt.parent->set_specific_data(SIM_INFOFLAG_DYNAMIC_TASK, &order);
                        }

                        i++;
                     }

                  mode = COMM_MODE_IDLE;
                  return;

               case COMM_FALLOUT:
                  for (ptr = (atom_list_type *)complex->animation_manager.head, i=0; ptr && i<7; ptr = (atom_list_type *)ptr->next)
                     if (((gameatom *)ptr->htree)->total_hp > 0 && (global_player->flags & ptr->htree->flags & GAMEFLAG_ALLIANCE_MASK) && ptr->htree->query_whatami() == OBJECT_NPC_FIGHTER) {
                        spt.parent = sheader->find_ob(ptr->htree->name.string);

                        if (spt.parent)
                           spt.parent->set_specific_data(SIM_INFOFLAG_RESCIND_DYNAMIC_TASKS, splayer);

                        i++;
                     }
		     
                  mode = COMM_MODE_IDLE;
                  return;

               default:
                  return;
            }

            // shouldnt get here
            return;
         }
	 
         if (((gameatom *)starget->owner)->total_hp <= 0) {
             mode = COMM_MODE_IDLE;
             return;
         }
	       
         switch (i) {
            case COMM_ESCORT:
               tc = (equip_targeting_computer *)status->find_specific(EQUIP_TARGETING_COMPUTER);
               if (!tc || !tc->target.object) {
                  mode = COMM_MODE_IDLE;
                  return;
               }

               spt.head = sheader;
               order.type = VOICE_PILOT_DYNAMIC_DEFEND;

               enemy_mask = calc_enemy(global_player->flags);
               if (enemy_mask & tc->target.object->htree->flags) {
                  mode = COMM_MODE_IDLE;
                  return;
               }

               spt.parent = starget;
               order.order = new sim_dynamic_escort_type;
               order.order->set_specific_data(SIM_INFOFLAG_SOURCE, splayer);
               order.order->set_specific_data(DARKSIM_INFOFLAG_TARGET_NAME, tc->target.object->htree->name.string);
               order.order->preprocess(&spt);
               spt.parent->set_specific_data(SIM_INFOFLAG_DYNAMIC_TASK, &order);

               mode = COMM_MODE_IDLE;
               return;

            case COMM_ATTACK:
               tc = (equip_targeting_computer *)status->find_specific(EQUIP_TARGETING_COMPUTER);
               if (!tc || !tc->target.object) {
                  mode = COMM_MODE_IDLE;
                  return;
               }

               spt.head = sheader;
               order.type = VOICE_PILOT_DYNAMIC_ATTACK;

               enemy_mask = calc_enemy(global_player->flags);
               if (!(enemy_mask & tc->target.object->htree->flags)) {
                  mode = COMM_MODE_IDLE;
                  return;
               }
		  
               spt.parent = starget;
               order.order = new sim_dynamic_attack_type;
               order.order->set_specific_data(SIM_INFOFLAG_SOURCE, splayer);
               order.order->set_specific_data(DARKSIM_INFOFLAG_TARGET_NAME, tc->target.object->htree->name.string);
               order.order->preprocess(&spt);
               spt.parent->set_specific_data(SIM_INFOFLAG_DYNAMIC_TASK, &order);

               mode = COMM_MODE_IDLE;
               return;
            
            case COMM_BODYGUARD:	       
               spt.head = sheader;
               order.type = VOICE_PILOT_DYNAMIC_WINGMAN;

               spt.parent = starget;
               order.order = new sim_dynamic_escort_type;
               order.order->set_specific_data(SIM_INFOFLAG_SOURCE, splayer);
               order.order->set_specific_data(DARKSIM_INFOFLAG_TARGET_NAME, TOKEN_SPLAYER_NAME_STR);
               order.order->preprocess(&spt);
               spt.parent->set_specific_data(SIM_INFOFLAG_DYNAMIC_TASK, &order);
	       
               mode = COMM_MODE_IDLE;
               return;

            case COMM_FALLOUT:
               starget->set_specific_data(SIM_INFOFLAG_RESCIND_DYNAMIC_TASKS, splayer);
               mode = COMM_MODE_IDLE;
               return;

            default:
               return;
         }

         // should never get here
         return;

      // case COMM_MODE_IDLE:
      default:
         return;
   }

}

