

#if !defined __DARKGINE_H
#define __DARKGINE_H

#include "gamegine.h"
#include "WIN_VIRTUAL.h"
#include "darkequp.h"

#define KEYSTROKE_STOP                  19
#define KEYSTROKE_VIEW_FORWARD          20
#define KEYSTROKE_VIEW_BACKWARD         21
#define KEYSTROKE_VIEW_CHASE            22
#define KEYSTROKE_INERTIA_TOGGLE        23
#define KEYSTROKE_THROTTLE_TOGGLE       24
#define KEYSTROKE_SUBTARGET_NEXT        25
#define KEYSTROKE_TARGET_NEXT           26
#define KEYSTROKE_TARGET_NEXT_ENEMY     27
#define KEYSTROKE_TARGET_NEAREST_ENEMY  28
#define KEYSTROKE_TARGET_CENTER         29
#define KEYSTROKE_SELECT_NEXT_PRIMARY   30
#define KEYSTROKE_SELECT_NEXT_SECONDARY 31
#define KEYSTROKE_FULL_PRIMARY          32
#define KEYSTROKE_ROUND_ROBIN_PRIMARY   33
#define KEYSTROKE_AFTERBURNER           34
#define KEYSTROKE_MATCH_SPEED           35
#define KEYSTROKE_CYCLE_STATUS          36
#define KEYSTROKE_JUMP                  37
#define KEYSTROKE_COMM                  38

#define BUTTON_DOWN 0x01
#define BUTTON_UP   0x10

#define MAX_COMM_MENU_OPTIONS 4


/* **********************************************************************
********************************************************************** */
typedef struct {

   char text[32];
   int voice_id;
} comm_menu_options;

   
/* **********************************************************************
********************************************************************** */
class dark_god : public gamegod_type {

   public:
      // equipment manager
      equip_manager quartermaster;

      void setup_equipment();

      dark_god(engine *proc) : gamegod_type(proc) {}
      virtual ~dark_god() {}
};


// gameinit.c
int parse_animate_list(dbl_llist_manager *hiearchy_manager, char *filename, string_type *backname = NULL);
sim_sim *parse_ai_list(char *filename);
void init_game(BLTwindow *win);
void dest_game();
void endgame(BLTwindow *win);

// hud.c
extern comm_menu_options comm_orders[MAX_COMM_MENU_OPTIONS];

void hud_display_primary_weapon(mapul *mapbuffer, equip_weapon *source, fighter_desc *inventory, float length);
void hud_display_secondary_weapon(mapul *mapbuffer, equip_weapon *source, int count, int maxcount);
void hud_display_systems_computer(mapul *mapbuffer, equip_systems_computer *sc);
int  hud_display_target(mapul *mapbuffer, gameatom *target, camera *cam, int target_status_flag);
void hud_display_subtarget(mapul *mapbuffer, gamequark *subtarget, camera *cam);
void hud_display_intercept(mapul *mapbuffer, gameatom *target, camera *cam, quark *source, object_desc *ob, equip_targeting_computer *tc);
void hud_display_missile_lock(mapul *mapbuffer, gameatom *target, camera *cam, quark *source, float countdown, float maxtime, object_desc *ob);

// vfx.c
void vfx_init(dbl_llist_manager *hiearchy_manager, int winx, int winy);
void vfx_dest();
void vfx_dazzle_the_crowd(dbl_llist_manager *hiearchy_manager, mapul *mapbuffer, camera *cparm);

// loopsnd.c
void sound_volume_menu(BLTwindow *win);

// loopio.c
void render_io_menu(BLTwindow *win);

// loopcred.c
void credits_menu(BLTwindow *win);

// loopgame.c
void gameloop(BLTwindow *win);

// loopmenu.c
void event_proc(BLTwindow *win);
void render_mouse(mapul *mapbuffer);
void render_main_menu(BLTwindow *win);

extern vector4i io;

// darkstrg.c
extern sim_sim *sheader;
extern world_type world_sphere;
extern dbl_llist_manager world_freelist;
extern gameatom *global_player;

#endif

